/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrEvent;
import software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrEventsCopier;
import software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ByoipCidr
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ByoipCidr> {
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ByoipCidr.getter(ByoipCidr::cidr)).setter(ByoipCidr.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ByoipCidr.getter(ByoipCidr::stateAsString)).setter(ByoipCidr.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<List<ByoipCidrEvent>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ByoipCidr.getter(ByoipCidr::events)).setter(ByoipCidr.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ByoipCidrEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD, STATE_FIELD, EVENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cidr;
    private final String state;
    private final List<ByoipCidrEvent> events;

    private ByoipCidr(BuilderImpl builder) {
        this.cidr = builder.cidr;
        this.state = builder.state;
        this.events = builder.events;
    }

    public String cidr() {
        return this.cidr;
    }

    public ByoipCidrState state() {
        return ByoipCidrState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructList);
    }

    public List<ByoipCidrEvent> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.events());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByoipCidr)) {
            return false;
        }
        ByoipCidr other = (ByoipCidr)obj;
        return Objects.equals(this.cidr(), other.cidr()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.events(), other.events());
    }

    public String toString() {
        return ToString.builder((String)"ByoipCidr").add("Cidr", (Object)this.cidr()).add("State", (Object)this.stateAsString()).add("Events", this.events()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ByoipCidr, T> g) {
        return obj -> g.apply((ByoipCidr)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cidr;
        private String state;
        private List<ByoipCidrEvent> events = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ByoipCidr model) {
            this.cidr(model.cidr);
            this.state(model.state);
            this.events(model.events);
        }

        public final String getCidr() {
            return this.cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ByoipCidrState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Collection<ByoipCidrEvent.Builder> getEvents() {
            return this.events != null ? (Collection)this.events.stream().map(ByoipCidrEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<ByoipCidrEvent> events) {
            this.events = ByoipCidrEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(ByoipCidrEvent ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<ByoipCidrEvent.Builder> ... events) {
            this.events(Stream.of(events).map(c -> (ByoipCidrEvent)((ByoipCidrEvent.Builder)ByoipCidrEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvents(Collection<ByoipCidrEvent.BuilderImpl> events) {
            this.events = ByoipCidrEventsCopier.copyFromBuilder(events);
        }

        public ByoipCidr build() {
            return new ByoipCidr(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ByoipCidr> {
        public Builder cidr(String var1);

        public Builder state(String var1);

        public Builder state(ByoipCidrState var1);

        public Builder events(Collection<ByoipCidrEvent> var1);

        public Builder events(ByoipCidrEvent ... var1);

        public Builder events(Consumer<ByoipCidrEvent.Builder> ... var1);
    }
}

