/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorClient;
import software.amazon.awssdk.services.globalaccelerator.model.AcceleratorNotDisabledException;
import software.amazon.awssdk.services.globalaccelerator.model.AcceleratorNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.AccessDeniedException;
import software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AssociatedEndpointGroupFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.AssociatedListenerFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeprovisionByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeprovisionByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointGroupAlreadyExistsException;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointGroupNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorException;
import software.amazon.awssdk.services.globalaccelerator.model.IncorrectCidrStateException;
import software.amazon.awssdk.services.globalaccelerator.model.InternalServiceErrorException;
import software.amazon.awssdk.services.globalaccelerator.model.InvalidArgumentException;
import software.amazon.awssdk.services.globalaccelerator.model.InvalidNextTokenException;
import software.amazon.awssdk.services.globalaccelerator.model.InvalidPortRangeException;
import software.amazon.awssdk.services.globalaccelerator.model.LimitExceededException;
import software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListListenersRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListenerNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.TagResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.TagResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UntagResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UntagResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.transform.AdvertiseByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeprovisionByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeAcceleratorAttributesRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListAcceleratorsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListByoipCidrsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListEndpointGroupsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListListenersRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ProvisionByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateAcceleratorAttributesRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.WithdrawByoipCidrRequestMarshaller;

@SdkInternalApi
final class DefaultGlobalAcceleratorClient
implements GlobalAcceleratorClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultGlobalAcceleratorClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "globalaccelerator";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdvertiseByoipCidrResponse advertiseByoipCidr(AdvertiseByoipCidrRequest advertiseByoipCidrRequest) throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, ByoipCidrNotFoundException, IncorrectCidrStateException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdvertiseByoipCidrResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdvertiseByoipCidr");
            AdvertiseByoipCidrResponse advertiseByoipCidrResponse = (AdvertiseByoipCidrResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdvertiseByoipCidr").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)advertiseByoipCidrRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new AdvertiseByoipCidrRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return advertiseByoipCidrResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, advertiseByoipCidrRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAcceleratorResponse createAccelerator(CreateAcceleratorRequest createAcceleratorRequest) throws InternalServiceErrorException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAcceleratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccelerator");
            CreateAcceleratorResponse createAcceleratorResponse = (CreateAcceleratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccelerator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAcceleratorRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateAcceleratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAcceleratorResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, createAcceleratorRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEndpointGroupResponse createEndpointGroup(CreateEndpointGroupRequest createEndpointGroupRequest) throws AcceleratorNotFoundException, EndpointGroupAlreadyExistsException, ListenerNotFoundException, InternalServiceErrorException, InvalidArgumentException, LimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEndpointGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEndpointGroup");
            CreateEndpointGroupResponse createEndpointGroupResponse = (CreateEndpointGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEndpointGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEndpointGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEndpointGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, createEndpointGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateListenerResponse createListener(CreateListenerRequest createListenerRequest) throws InvalidArgumentException, AcceleratorNotFoundException, InvalidPortRangeException, InternalServiceErrorException, LimitExceededException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateListenerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateListener");
            CreateListenerResponse createListenerResponse = (CreateListenerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateListener").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createListenerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateListenerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createListenerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, createListenerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAcceleratorResponse deleteAccelerator(DeleteAcceleratorRequest deleteAcceleratorRequest) throws AcceleratorNotFoundException, AcceleratorNotDisabledException, AssociatedListenerFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAcceleratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccelerator");
            DeleteAcceleratorResponse deleteAcceleratorResponse = (DeleteAcceleratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccelerator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAcceleratorRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAcceleratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAcceleratorResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, deleteAcceleratorRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEndpointGroupResponse deleteEndpointGroup(DeleteEndpointGroupRequest deleteEndpointGroupRequest) throws InvalidArgumentException, EndpointGroupNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEndpointGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEndpointGroup");
            DeleteEndpointGroupResponse deleteEndpointGroupResponse = (DeleteEndpointGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEndpointGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEndpointGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEndpointGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, deleteEndpointGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteListenerResponse deleteListener(DeleteListenerRequest deleteListenerRequest) throws InvalidArgumentException, ListenerNotFoundException, AssociatedEndpointGroupFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteListenerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteListener");
            DeleteListenerResponse deleteListenerResponse = (DeleteListenerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteListener").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteListenerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteListenerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteListenerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, deleteListenerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeprovisionByoipCidrResponse deprovisionByoipCidr(DeprovisionByoipCidrRequest deprovisionByoipCidrRequest) throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, ByoipCidrNotFoundException, IncorrectCidrStateException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeprovisionByoipCidrResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeprovisionByoipCidr");
            DeprovisionByoipCidrResponse deprovisionByoipCidrResponse = (DeprovisionByoipCidrResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeprovisionByoipCidr").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deprovisionByoipCidrRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeprovisionByoipCidrRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deprovisionByoipCidrResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, deprovisionByoipCidrRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAcceleratorResponse describeAccelerator(DescribeAcceleratorRequest describeAcceleratorRequest) throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAcceleratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccelerator");
            DescribeAcceleratorResponse describeAcceleratorResponse = (DescribeAcceleratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccelerator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAcceleratorRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAcceleratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAcceleratorResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, describeAcceleratorRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAcceleratorAttributesResponse describeAcceleratorAttributes(DescribeAcceleratorAttributesRequest describeAcceleratorAttributesRequest) throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAcceleratorAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAcceleratorAttributes");
            DescribeAcceleratorAttributesResponse describeAcceleratorAttributesResponse = (DescribeAcceleratorAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAcceleratorAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAcceleratorAttributesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAcceleratorAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAcceleratorAttributesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, describeAcceleratorAttributesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEndpointGroupResponse describeEndpointGroup(DescribeEndpointGroupRequest describeEndpointGroupRequest) throws InvalidArgumentException, EndpointGroupNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpointGroup");
            DescribeEndpointGroupResponse describeEndpointGroupResponse = (DescribeEndpointGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpointGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEndpointGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEndpointGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, describeEndpointGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeListenerResponse describeListener(DescribeListenerRequest describeListenerRequest) throws InvalidArgumentException, ListenerNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeListenerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeListener");
            DescribeListenerResponse describeListenerResponse = (DescribeListenerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeListener").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeListenerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeListenerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeListenerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, describeListenerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAcceleratorsResponse listAccelerators(ListAcceleratorsRequest listAcceleratorsRequest) throws InvalidArgumentException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAcceleratorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccelerators");
            ListAcceleratorsResponse listAcceleratorsResponse = (ListAcceleratorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccelerators").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAcceleratorsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListAcceleratorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAcceleratorsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, listAcceleratorsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListByoipCidrsResponse listByoipCidrs(ListByoipCidrsRequest listByoipCidrsRequest) throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, InvalidNextTokenException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListByoipCidrsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListByoipCidrs");
            ListByoipCidrsResponse listByoipCidrsResponse = (ListByoipCidrsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListByoipCidrs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listByoipCidrsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListByoipCidrsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listByoipCidrsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, listByoipCidrsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEndpointGroupsResponse listEndpointGroups(ListEndpointGroupsRequest listEndpointGroupsRequest) throws ListenerNotFoundException, InvalidNextTokenException, InvalidArgumentException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEndpointGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEndpointGroups");
            ListEndpointGroupsResponse listEndpointGroupsResponse = (ListEndpointGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEndpointGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEndpointGroupsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListEndpointGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEndpointGroupsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, listEndpointGroupsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListListenersResponse listListeners(ListListenersRequest listListenersRequest) throws InvalidArgumentException, AcceleratorNotFoundException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListListenersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListListeners");
            ListListenersResponse listListenersResponse = (ListListenersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListListeners").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listListenersRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListListenersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listListenersResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, listListenersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProvisionByoipCidrResponse provisionByoipCidr(ProvisionByoipCidrRequest provisionByoipCidrRequest) throws InternalServiceErrorException, InvalidArgumentException, LimitExceededException, AccessDeniedException, IncorrectCidrStateException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ProvisionByoipCidrResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ProvisionByoipCidr");
            ProvisionByoipCidrResponse provisionByoipCidrResponse = (ProvisionByoipCidrResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ProvisionByoipCidr").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)provisionByoipCidrRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ProvisionByoipCidrRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return provisionByoipCidrResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, provisionByoipCidrRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAcceleratorResponse updateAccelerator(UpdateAcceleratorRequest updateAcceleratorRequest) throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAcceleratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAccelerator");
            UpdateAcceleratorResponse updateAcceleratorResponse = (UpdateAcceleratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAccelerator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAcceleratorRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAcceleratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAcceleratorResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, updateAcceleratorRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAcceleratorAttributesResponse updateAcceleratorAttributes(UpdateAcceleratorAttributesRequest updateAcceleratorAttributesRequest) throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAcceleratorAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAcceleratorAttributes");
            UpdateAcceleratorAttributesResponse updateAcceleratorAttributesResponse = (UpdateAcceleratorAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAcceleratorAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAcceleratorAttributesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAcceleratorAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAcceleratorAttributesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, updateAcceleratorAttributesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEndpointGroupResponse updateEndpointGroup(UpdateEndpointGroupRequest updateEndpointGroupRequest) throws InvalidArgumentException, EndpointGroupNotFoundException, InternalServiceErrorException, LimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEndpointGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEndpointGroup");
            UpdateEndpointGroupResponse updateEndpointGroupResponse = (UpdateEndpointGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEndpointGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEndpointGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEndpointGroupResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, updateEndpointGroupRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateListenerResponse updateListener(UpdateListenerRequest updateListenerRequest) throws InvalidArgumentException, InvalidPortRangeException, ListenerNotFoundException, InternalServiceErrorException, LimitExceededException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateListenerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateListener");
            UpdateListenerResponse updateListenerResponse = (UpdateListenerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateListener").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateListenerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateListenerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateListenerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, updateListenerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WithdrawByoipCidrResponse withdrawByoipCidr(WithdrawByoipCidrRequest withdrawByoipCidrRequest) throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, ByoipCidrNotFoundException, IncorrectCidrStateException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, WithdrawByoipCidrResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"WithdrawByoipCidr");
            WithdrawByoipCidrResponse withdrawByoipCidrResponse = (WithdrawByoipCidrResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("WithdrawByoipCidr").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)withdrawByoipCidrRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new WithdrawByoipCidrRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return withdrawByoipCidrResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, withdrawByoipCidrRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(GlobalAcceleratorException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgumentException").exceptionBuilderSupplier(InvalidArgumentException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").exceptionBuilderSupplier(ListenerNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").exceptionBuilderSupplier(IncorrectCidrStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").exceptionBuilderSupplier(InternalServiceErrorException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").exceptionBuilderSupplier(InvalidPortRangeException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

