/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CidrAuthorizationContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CidrAuthorizationContext> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(CidrAuthorizationContext.getter(CidrAuthorizationContext::message)).setter(CidrAuthorizationContext.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Signature").getter(CidrAuthorizationContext.getter(CidrAuthorizationContext::signature)).setter(CidrAuthorizationContext.setter(Builder::signature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Signature").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, SIGNATURE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String message;
    private final String signature;

    private CidrAuthorizationContext(BuilderImpl builder) {
        this.message = builder.message;
        this.signature = builder.signature;
    }

    public String message() {
        return this.message;
    }

    public String signature() {
        return this.signature;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.signature());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CidrAuthorizationContext)) {
            return false;
        }
        CidrAuthorizationContext other = (CidrAuthorizationContext)obj;
        return Objects.equals(this.message(), other.message()) && Objects.equals(this.signature(), other.signature());
    }

    public String toString() {
        return ToString.builder((String)"CidrAuthorizationContext").add("Message", (Object)this.message()).add("Signature", (Object)this.signature()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "Signature": {
                return Optional.ofNullable(clazz.cast(this.signature()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CidrAuthorizationContext, T> g) {
        return obj -> g.apply((CidrAuthorizationContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String message;
        private String signature;

        private BuilderImpl() {
        }

        private BuilderImpl(CidrAuthorizationContext model) {
            this.message(model.message);
            this.signature(model.signature);
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getSignature() {
            return this.signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        public CidrAuthorizationContext build() {
            return new CidrAuthorizationContext(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CidrAuthorizationContext> {
        public Builder message(String var1);

        public Builder signature(String var1);
    }
}

