/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointGroup;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointGroupsCopier;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEndpointGroupsResponse
extends GlobalAcceleratorResponse
implements ToCopyableBuilder<Builder, ListEndpointGroupsResponse> {
    private static final SdkField<List<EndpointGroup>> ENDPOINT_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndpointGroups").getter(ListEndpointGroupsResponse.getter(ListEndpointGroupsResponse::endpointGroups)).setter(ListEndpointGroupsResponse.setter(Builder::endpointGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEndpointGroupsResponse.getter(ListEndpointGroupsResponse::nextToken)).setter(ListEndpointGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<EndpointGroup> endpointGroups;
    private final String nextToken;

    private ListEndpointGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.endpointGroups = builder.endpointGroups;
        this.nextToken = builder.nextToken;
    }

    public boolean hasEndpointGroups() {
        return this.endpointGroups != null && !(this.endpointGroups instanceof SdkAutoConstructList);
    }

    public List<EndpointGroup> endpointGroups() {
        return this.endpointGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpointGroups() ? this.endpointGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEndpointGroupsResponse)) {
            return false;
        }
        ListEndpointGroupsResponse other = (ListEndpointGroupsResponse)((Object)obj);
        return this.hasEndpointGroups() == other.hasEndpointGroups() && Objects.equals(this.endpointGroups(), other.endpointGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListEndpointGroupsResponse").add("EndpointGroups", this.hasEndpointGroups() ? this.endpointGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointGroups": {
                return Optional.ofNullable(clazz.cast(this.endpointGroups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEndpointGroupsResponse, T> g) {
        return obj -> g.apply((ListEndpointGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorResponse.BuilderImpl
    implements Builder {
        private List<EndpointGroup> endpointGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEndpointGroupsResponse model) {
            super(model);
            this.endpointGroups(model.endpointGroups);
            this.nextToken(model.nextToken);
        }

        public final Collection<EndpointGroup.Builder> getEndpointGroups() {
            if (this.endpointGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.endpointGroups != null ? (Collection)this.endpointGroups.stream().map(EndpointGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endpointGroups(Collection<EndpointGroup> endpointGroups) {
            this.endpointGroups = EndpointGroupsCopier.copy(endpointGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointGroups(EndpointGroup ... endpointGroups) {
            this.endpointGroups(Arrays.asList(endpointGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointGroups(Consumer<EndpointGroup.Builder> ... endpointGroups) {
            this.endpointGroups(Stream.of(endpointGroups).map(c -> (EndpointGroup)((EndpointGroup.Builder)EndpointGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndpointGroups(Collection<EndpointGroup.BuilderImpl> endpointGroups) {
            this.endpointGroups = EndpointGroupsCopier.copyFromBuilder(endpointGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEndpointGroupsResponse build() {
            return new ListEndpointGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEndpointGroupsResponse> {
        public Builder endpointGroups(Collection<EndpointGroup> var1);

        public Builder endpointGroups(EndpointGroup ... var1);

        public Builder endpointGroups(Consumer<EndpointGroup.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

