/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.ClientAffinity;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.PortRange;
import software.amazon.awssdk.services.globalaccelerator.model.PortRangesCopier;
import software.amazon.awssdk.services.globalaccelerator.model.Protocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateListenerRequest
extends GlobalAcceleratorRequest
implements ToCopyableBuilder<Builder, UpdateListenerRequest> {
    private static final SdkField<String> LISTENER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ListenerArn").getter(UpdateListenerRequest.getter(UpdateListenerRequest::listenerArn)).setter(UpdateListenerRequest.setter(Builder::listenerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerArn").build()}).build();
    private static final SdkField<List<PortRange>> PORT_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PortRanges").getter(UpdateListenerRequest.getter(UpdateListenerRequest::portRanges)).setter(UpdateListenerRequest.setter(Builder::portRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(UpdateListenerRequest.getter(UpdateListenerRequest::protocolAsString)).setter(UpdateListenerRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<String> CLIENT_AFFINITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientAffinity").getter(UpdateListenerRequest.getter(UpdateListenerRequest::clientAffinityAsString)).setter(UpdateListenerRequest.setter(Builder::clientAffinity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientAffinity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_ARN_FIELD, PORT_RANGES_FIELD, PROTOCOL_FIELD, CLIENT_AFFINITY_FIELD));
    private final String listenerArn;
    private final List<PortRange> portRanges;
    private final String protocol;
    private final String clientAffinity;

    private UpdateListenerRequest(BuilderImpl builder) {
        super(builder);
        this.listenerArn = builder.listenerArn;
        this.portRanges = builder.portRanges;
        this.protocol = builder.protocol;
        this.clientAffinity = builder.clientAffinity;
    }

    public final String listenerArn() {
        return this.listenerArn;
    }

    public final boolean hasPortRanges() {
        return this.portRanges != null && !(this.portRanges instanceof SdkAutoConstructList);
    }

    public final List<PortRange> portRanges() {
        return this.portRanges;
    }

    public final Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final ClientAffinity clientAffinity() {
        return ClientAffinity.fromValue(this.clientAffinity);
    }

    public final String clientAffinityAsString() {
        return this.clientAffinity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.listenerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPortRanges() ? this.portRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientAffinityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateListenerRequest)) {
            return false;
        }
        UpdateListenerRequest other = (UpdateListenerRequest)((Object)obj);
        return Objects.equals(this.listenerArn(), other.listenerArn()) && this.hasPortRanges() == other.hasPortRanges() && Objects.equals(this.portRanges(), other.portRanges()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.clientAffinityAsString(), other.clientAffinityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateListenerRequest").add("ListenerArn", (Object)this.listenerArn()).add("PortRanges", this.hasPortRanges() ? this.portRanges() : null).add("Protocol", (Object)this.protocolAsString()).add("ClientAffinity", (Object)this.clientAffinityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ListenerArn": {
                return Optional.ofNullable(clazz.cast(this.listenerArn()));
            }
            case "PortRanges": {
                return Optional.ofNullable(clazz.cast(this.portRanges()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "ClientAffinity": {
                return Optional.ofNullable(clazz.cast(this.clientAffinityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateListenerRequest, T> g) {
        return obj -> g.apply((UpdateListenerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorRequest.BuilderImpl
    implements Builder {
        private String listenerArn;
        private List<PortRange> portRanges = DefaultSdkAutoConstructList.getInstance();
        private String protocol;
        private String clientAffinity;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateListenerRequest model) {
            super(model);
            this.listenerArn(model.listenerArn);
            this.portRanges(model.portRanges);
            this.protocol(model.protocol);
            this.clientAffinity(model.clientAffinity);
        }

        public final String getListenerArn() {
            return this.listenerArn;
        }

        @Override
        public final Builder listenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        public final void setListenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
        }

        public final Collection<PortRange.Builder> getPortRanges() {
            if (this.portRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.portRanges != null ? (Collection)this.portRanges.stream().map(PortRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portRanges(Collection<PortRange> portRanges) {
            this.portRanges = PortRangesCopier.copy(portRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(PortRange ... portRanges) {
            this.portRanges(Arrays.asList(portRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(Consumer<PortRange.Builder> ... portRanges) {
            this.portRanges(Stream.of(portRanges).map(c -> (PortRange)((PortRange.Builder)PortRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPortRanges(Collection<PortRange.BuilderImpl> portRanges) {
            this.portRanges = PortRangesCopier.copyFromBuilder(portRanges);
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getClientAffinity() {
            return this.clientAffinity;
        }

        @Override
        public final Builder clientAffinity(String clientAffinity) {
            this.clientAffinity = clientAffinity;
            return this;
        }

        @Override
        public final Builder clientAffinity(ClientAffinity clientAffinity) {
            this.clientAffinity(clientAffinity == null ? null : clientAffinity.toString());
            return this;
        }

        public final void setClientAffinity(String clientAffinity) {
            this.clientAffinity = clientAffinity;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateListenerRequest build() {
            return new UpdateListenerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateListenerRequest> {
        public Builder listenerArn(String var1);

        public Builder portRanges(Collection<PortRange> var1);

        public Builder portRanges(PortRange ... var1);

        public Builder portRanges(Consumer<PortRange.Builder> ... var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder clientAffinity(String var1);

        public Builder clientAffinity(ClientAffinity var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

