/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomRoutingEndpointGroupRequest extends GlobalAcceleratorRequest implements
        ToCopyableBuilder<CreateCustomRoutingEndpointGroupRequest.Builder, CreateCustomRoutingEndpointGroupRequest> {
    private static final SdkField<String> LISTENER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ListenerArn").getter(getter(CreateCustomRoutingEndpointGroupRequest::listenerArn))
            .setter(setter(Builder::listenerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerArn").build()).build();

    private static final SdkField<String> ENDPOINT_GROUP_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointGroupRegion").getter(getter(CreateCustomRoutingEndpointGroupRequest::endpointGroupRegion))
            .setter(setter(Builder::endpointGroupRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupRegion").build())
            .build();

    private static final SdkField<List<CustomRoutingDestinationConfiguration>> DESTINATION_CONFIGURATIONS_FIELD = SdkField
            .<List<CustomRoutingDestinationConfiguration>> builder(MarshallingType.LIST)
            .memberName("DestinationConfigurations")
            .getter(getter(CreateCustomRoutingEndpointGroupRequest::destinationConfigurations))
            .setter(setter(Builder::destinationConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomRoutingDestinationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomRoutingDestinationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken")
            .getter(getter(CreateCustomRoutingEndpointGroupRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_ARN_FIELD,
            ENDPOINT_GROUP_REGION_FIELD, DESTINATION_CONFIGURATIONS_FIELD, IDEMPOTENCY_TOKEN_FIELD));

    private final String listenerArn;

    private final String endpointGroupRegion;

    private final List<CustomRoutingDestinationConfiguration> destinationConfigurations;

    private final String idempotencyToken;

    private CreateCustomRoutingEndpointGroupRequest(BuilderImpl builder) {
        super(builder);
        this.listenerArn = builder.listenerArn;
        this.endpointGroupRegion = builder.endpointGroupRegion;
        this.destinationConfigurations = builder.destinationConfigurations;
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the listener for a custom routing endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the listener for a custom routing endpoint.
     */
    public final String listenerArn() {
        return listenerArn;
    }

    /**
     * <p>
     * The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a specific
     * Region.
     * </p>
     * 
     * @return The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a
     *         specific Region.
     */
    public final String endpointGroupRegion() {
        return endpointGroupRegion;
    }

    /**
     * Returns true if the DestinationConfigurations property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDestinationConfigurations() {
        return destinationConfigurations != null && !(destinationConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Sets the port range and protocol for all endpoints (virtual private cloud subnets) in a custom routing endpoint
     * group to accept client traffic on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDestinationConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Sets the port range and protocol for all endpoints (virtual private cloud subnets) in a custom routing
     *         endpoint group to accept client traffic on.
     */
    public final List<CustomRoutingDestinationConfiguration> destinationConfigurations() {
        return destinationConfigurations;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the
     * request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of
     *         the request.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(listenerArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointGroupRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationConfigurations() ? destinationConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomRoutingEndpointGroupRequest)) {
            return false;
        }
        CreateCustomRoutingEndpointGroupRequest other = (CreateCustomRoutingEndpointGroupRequest) obj;
        return Objects.equals(listenerArn(), other.listenerArn())
                && Objects.equals(endpointGroupRegion(), other.endpointGroupRegion())
                && hasDestinationConfigurations() == other.hasDestinationConfigurations()
                && Objects.equals(destinationConfigurations(), other.destinationConfigurations())
                && Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomRoutingEndpointGroupRequest").add("ListenerArn", listenerArn())
                .add("EndpointGroupRegion", endpointGroupRegion())
                .add("DestinationConfigurations", hasDestinationConfigurations() ? destinationConfigurations() : null)
                .add("IdempotencyToken", idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListenerArn":
            return Optional.ofNullable(clazz.cast(listenerArn()));
        case "EndpointGroupRegion":
            return Optional.ofNullable(clazz.cast(endpointGroupRegion()));
        case "DestinationConfigurations":
            return Optional.ofNullable(clazz.cast(destinationConfigurations()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomRoutingEndpointGroupRequest, T> g) {
        return obj -> g.apply((CreateCustomRoutingEndpointGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCustomRoutingEndpointGroupRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the listener for a custom routing endpoint.
         * </p>
         * 
         * @param listenerArn
         *        The Amazon Resource Name (ARN) of the listener for a custom routing endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerArn(String listenerArn);

        /**
         * <p>
         * The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a specific
         * Region.
         * </p>
         * 
         * @param endpointGroupRegion
         *        The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a
         *        specific Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointGroupRegion(String endpointGroupRegion);

        /**
         * <p>
         * Sets the port range and protocol for all endpoints (virtual private cloud subnets) in a custom routing
         * endpoint group to accept client traffic on.
         * </p>
         * 
         * @param destinationConfigurations
         *        Sets the port range and protocol for all endpoints (virtual private cloud subnets) in a custom routing
         *        endpoint group to accept client traffic on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfigurations(Collection<CustomRoutingDestinationConfiguration> destinationConfigurations);

        /**
         * <p>
         * Sets the port range and protocol for all endpoints (virtual private cloud subnets) in a custom routing
         * endpoint group to accept client traffic on.
         * </p>
         * 
         * @param destinationConfigurations
         *        Sets the port range and protocol for all endpoints (virtual private cloud subnets) in a custom routing
         *        endpoint group to accept client traffic on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfigurations(CustomRoutingDestinationConfiguration... destinationConfigurations);

        /**
         * <p>
         * Sets the port range and protocol for all endpoints (virtual private cloud subnets) in a custom routing
         * endpoint group to accept client traffic on.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <CustomRoutingDestinationConfiguration>.Builder} avoiding the need to create one manually via {@link List
         * <CustomRoutingDestinationConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CustomRoutingDestinationConfiguration>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #destinationConfigurations(List<CustomRoutingDestinationConfiguration>)}.
         * 
         * @param destinationConfigurations
         *        a consumer that will call methods on {@link List<CustomRoutingDestinationConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfigurations(List<CustomRoutingDestinationConfiguration>)
         */
        Builder destinationConfigurations(Consumer<CustomRoutingDestinationConfiguration.Builder>... destinationConfigurations);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the
         * request.
         * </p>
         * 
         * @param idempotencyToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
         *        uniqueness—of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlobalAcceleratorRequest.BuilderImpl implements Builder {
        private String listenerArn;

        private String endpointGroupRegion;

        private List<CustomRoutingDestinationConfiguration> destinationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomRoutingEndpointGroupRequest model) {
            super(model);
            listenerArn(model.listenerArn);
            endpointGroupRegion(model.endpointGroupRegion);
            destinationConfigurations(model.destinationConfigurations);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getListenerArn() {
            return listenerArn;
        }

        @Override
        public final Builder listenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        public final void setListenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
        }

        public final String getEndpointGroupRegion() {
            return endpointGroupRegion;
        }

        @Override
        public final Builder endpointGroupRegion(String endpointGroupRegion) {
            this.endpointGroupRegion = endpointGroupRegion;
            return this;
        }

        public final void setEndpointGroupRegion(String endpointGroupRegion) {
            this.endpointGroupRegion = endpointGroupRegion;
        }

        public final List<CustomRoutingDestinationConfiguration.Builder> getDestinationConfigurations() {
            List<CustomRoutingDestinationConfiguration.Builder> result = CustomRoutingDestinationConfigurationsCopier
                    .copyToBuilder(this.destinationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder destinationConfigurations(Collection<CustomRoutingDestinationConfiguration> destinationConfigurations) {
            this.destinationConfigurations = CustomRoutingDestinationConfigurationsCopier.copy(destinationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationConfigurations(CustomRoutingDestinationConfiguration... destinationConfigurations) {
            destinationConfigurations(Arrays.asList(destinationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationConfigurations(
                Consumer<CustomRoutingDestinationConfiguration.Builder>... destinationConfigurations) {
            destinationConfigurations(Stream.of(destinationConfigurations)
                    .map(c -> CustomRoutingDestinationConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDestinationConfigurations(
                Collection<CustomRoutingDestinationConfiguration.BuilderImpl> destinationConfigurations) {
            this.destinationConfigurations = CustomRoutingDestinationConfigurationsCopier
                    .copyFromBuilder(destinationConfigurations);
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomRoutingEndpointGroupRequest build() {
            return new CreateCustomRoutingEndpointGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
