/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomRoutingListenerResponse extends GlobalAcceleratorResponse implements
        ToCopyableBuilder<CreateCustomRoutingListenerResponse.Builder, CreateCustomRoutingListenerResponse> {
    private static final SdkField<CustomRoutingListener> LISTENER_FIELD = SdkField
            .<CustomRoutingListener> builder(MarshallingType.SDK_POJO).memberName("Listener")
            .getter(getter(CreateCustomRoutingListenerResponse::listener)).setter(setter(Builder::listener))
            .constructor(CustomRoutingListener::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Listener").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_FIELD));

    private final CustomRoutingListener listener;

    private CreateCustomRoutingListenerResponse(BuilderImpl builder) {
        super(builder);
        this.listener = builder.listener;
    }

    /**
     * <p>
     * The listener that you've created for a custom routing accelerator.
     * </p>
     * 
     * @return The listener that you've created for a custom routing accelerator.
     */
    public final CustomRoutingListener listener() {
        return listener;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(listener());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomRoutingListenerResponse)) {
            return false;
        }
        CreateCustomRoutingListenerResponse other = (CreateCustomRoutingListenerResponse) obj;
        return Objects.equals(listener(), other.listener());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomRoutingListenerResponse").add("Listener", listener()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Listener":
            return Optional.ofNullable(clazz.cast(listener()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomRoutingListenerResponse, T> g) {
        return obj -> g.apply((CreateCustomRoutingListenerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCustomRoutingListenerResponse> {
        /**
         * <p>
         * The listener that you've created for a custom routing accelerator.
         * </p>
         * 
         * @param listener
         *        The listener that you've created for a custom routing accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listener(CustomRoutingListener listener);

        /**
         * <p>
         * The listener that you've created for a custom routing accelerator.
         * </p>
         * This is a convenience that creates an instance of the {@link CustomRoutingListener.Builder} avoiding the need
         * to create one manually via {@link CustomRoutingListener#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomRoutingListener.Builder#build()} is called immediately and
         * its result is passed to {@link #listener(CustomRoutingListener)}.
         * 
         * @param listener
         *        a consumer that will call methods on {@link CustomRoutingListener.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listener(CustomRoutingListener)
         */
        default Builder listener(Consumer<CustomRoutingListener.Builder> listener) {
            return listener(CustomRoutingListener.builder().applyMutation(listener).build());
        }
    }

    static final class BuilderImpl extends GlobalAcceleratorResponse.BuilderImpl implements Builder {
        private CustomRoutingListener listener;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomRoutingListenerResponse model) {
            super(model);
            listener(model.listener);
        }

        public final CustomRoutingListener.Builder getListener() {
            return listener != null ? listener.toBuilder() : null;
        }

        @Override
        public final Builder listener(CustomRoutingListener listener) {
            this.listener = listener;
            return this;
        }

        public final void setListener(CustomRoutingListener.BuilderImpl listener) {
            this.listener = listener != null ? listener.build() : null;
        }

        @Override
        public CreateCustomRoutingListenerResponse build() {
            return new CreateCustomRoutingListenerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
