/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCustomRoutingEndpointGroupResponse extends GlobalAcceleratorResponse implements
        ToCopyableBuilder<DescribeCustomRoutingEndpointGroupResponse.Builder, DescribeCustomRoutingEndpointGroupResponse> {
    private static final SdkField<CustomRoutingEndpointGroup> ENDPOINT_GROUP_FIELD = SdkField
            .<CustomRoutingEndpointGroup> builder(MarshallingType.SDK_POJO).memberName("EndpointGroup")
            .getter(getter(DescribeCustomRoutingEndpointGroupResponse::endpointGroup)).setter(setter(Builder::endpointGroup))
            .constructor(CustomRoutingEndpointGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_GROUP_FIELD));

    private final CustomRoutingEndpointGroup endpointGroup;

    private DescribeCustomRoutingEndpointGroupResponse(BuilderImpl builder) {
        super(builder);
        this.endpointGroup = builder.endpointGroup;
    }

    /**
     * <p>
     * The description of an endpoint group for a custom routing accelerator.
     * </p>
     * 
     * @return The description of an endpoint group for a custom routing accelerator.
     */
    public final CustomRoutingEndpointGroup endpointGroup() {
        return endpointGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomRoutingEndpointGroupResponse)) {
            return false;
        }
        DescribeCustomRoutingEndpointGroupResponse other = (DescribeCustomRoutingEndpointGroupResponse) obj;
        return Objects.equals(endpointGroup(), other.endpointGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCustomRoutingEndpointGroupResponse").add("EndpointGroup", endpointGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointGroup":
            return Optional.ofNullable(clazz.cast(endpointGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomRoutingEndpointGroupResponse, T> g) {
        return obj -> g.apply((DescribeCustomRoutingEndpointGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCustomRoutingEndpointGroupResponse> {
        /**
         * <p>
         * The description of an endpoint group for a custom routing accelerator.
         * </p>
         * 
         * @param endpointGroup
         *        The description of an endpoint group for a custom routing accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointGroup(CustomRoutingEndpointGroup endpointGroup);

        /**
         * <p>
         * The description of an endpoint group for a custom routing accelerator.
         * </p>
         * This is a convenience that creates an instance of the {@link CustomRoutingEndpointGroup.Builder} avoiding the
         * need to create one manually via {@link CustomRoutingEndpointGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomRoutingEndpointGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #endpointGroup(CustomRoutingEndpointGroup)}.
         * 
         * @param endpointGroup
         *        a consumer that will call methods on {@link CustomRoutingEndpointGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointGroup(CustomRoutingEndpointGroup)
         */
        default Builder endpointGroup(Consumer<CustomRoutingEndpointGroup.Builder> endpointGroup) {
            return endpointGroup(CustomRoutingEndpointGroup.builder().applyMutation(endpointGroup).build());
        }
    }

    static final class BuilderImpl extends GlobalAcceleratorResponse.BuilderImpl implements Builder {
        private CustomRoutingEndpointGroup endpointGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomRoutingEndpointGroupResponse model) {
            super(model);
            endpointGroup(model.endpointGroup);
        }

        public final CustomRoutingEndpointGroup.Builder getEndpointGroup() {
            return endpointGroup != null ? endpointGroup.toBuilder() : null;
        }

        @Override
        public final Builder endpointGroup(CustomRoutingEndpointGroup endpointGroup) {
            this.endpointGroup = endpointGroup;
            return this;
        }

        public final void setEndpointGroup(CustomRoutingEndpointGroup.BuilderImpl endpointGroup) {
            this.endpointGroup = endpointGroup != null ? endpointGroup.build() : null;
        }

        @Override
        public DescribeCustomRoutingEndpointGroupResponse build() {
            return new DescribeCustomRoutingEndpointGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
