/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationTrafficState;
import software.amazon.awssdk.services.globalaccelerator.model.IpAddressType;
import software.amazon.awssdk.services.globalaccelerator.model.SocketAddress;
import software.amazon.awssdk.services.globalaccelerator.model.SocketAddressesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DestinationPortMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DestinationPortMapping> {
    private static final SdkField<String> ACCELERATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceleratorArn").getter(DestinationPortMapping.getter(DestinationPortMapping::acceleratorArn)).setter(DestinationPortMapping.setter(Builder::acceleratorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorArn").build()}).build();
    private static final SdkField<List<SocketAddress>> ACCELERATOR_SOCKET_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AcceleratorSocketAddresses").getter(DestinationPortMapping.getter(DestinationPortMapping::acceleratorSocketAddresses)).setter(DestinationPortMapping.setter(Builder::acceleratorSocketAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorSocketAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SocketAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENDPOINT_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointGroupArn").getter(DestinationPortMapping.getter(DestinationPortMapping::endpointGroupArn)).setter(DestinationPortMapping.setter(Builder::endpointGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupArn").build()}).build();
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointId").getter(DestinationPortMapping.getter(DestinationPortMapping::endpointId)).setter(DestinationPortMapping.setter(Builder::endpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()}).build();
    private static final SdkField<String> ENDPOINT_GROUP_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointGroupRegion").getter(DestinationPortMapping.getter(DestinationPortMapping::endpointGroupRegion)).setter(DestinationPortMapping.setter(Builder::endpointGroupRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupRegion").build()}).build();
    private static final SdkField<SocketAddress> DESTINATION_SOCKET_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationSocketAddress").getter(DestinationPortMapping.getter(DestinationPortMapping::destinationSocketAddress)).setter(DestinationPortMapping.setter(Builder::destinationSocketAddress)).constructor(SocketAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationSocketAddress").build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddressType").getter(DestinationPortMapping.getter(DestinationPortMapping::ipAddressTypeAsString)).setter(DestinationPortMapping.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()}).build();
    private static final SdkField<String> DESTINATION_TRAFFIC_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationTrafficState").getter(DestinationPortMapping.getter(DestinationPortMapping::destinationTrafficStateAsString)).setter(DestinationPortMapping.setter(Builder::destinationTrafficState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationTrafficState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_ARN_FIELD, ACCELERATOR_SOCKET_ADDRESSES_FIELD, ENDPOINT_GROUP_ARN_FIELD, ENDPOINT_ID_FIELD, ENDPOINT_GROUP_REGION_FIELD, DESTINATION_SOCKET_ADDRESS_FIELD, IP_ADDRESS_TYPE_FIELD, DESTINATION_TRAFFIC_STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String acceleratorArn;
    private final List<SocketAddress> acceleratorSocketAddresses;
    private final String endpointGroupArn;
    private final String endpointId;
    private final String endpointGroupRegion;
    private final SocketAddress destinationSocketAddress;
    private final String ipAddressType;
    private final String destinationTrafficState;

    private DestinationPortMapping(BuilderImpl builder) {
        this.acceleratorArn = builder.acceleratorArn;
        this.acceleratorSocketAddresses = builder.acceleratorSocketAddresses;
        this.endpointGroupArn = builder.endpointGroupArn;
        this.endpointId = builder.endpointId;
        this.endpointGroupRegion = builder.endpointGroupRegion;
        this.destinationSocketAddress = builder.destinationSocketAddress;
        this.ipAddressType = builder.ipAddressType;
        this.destinationTrafficState = builder.destinationTrafficState;
    }

    public final String acceleratorArn() {
        return this.acceleratorArn;
    }

    public final boolean hasAcceleratorSocketAddresses() {
        return this.acceleratorSocketAddresses != null && !(this.acceleratorSocketAddresses instanceof SdkAutoConstructList);
    }

    public final List<SocketAddress> acceleratorSocketAddresses() {
        return this.acceleratorSocketAddresses;
    }

    public final String endpointGroupArn() {
        return this.endpointGroupArn;
    }

    public final String endpointId() {
        return this.endpointId;
    }

    public final String endpointGroupRegion() {
        return this.endpointGroupRegion;
    }

    public final SocketAddress destinationSocketAddress() {
        return this.destinationSocketAddress;
    }

    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final CustomRoutingDestinationTrafficState destinationTrafficState() {
        return CustomRoutingDestinationTrafficState.fromValue(this.destinationTrafficState);
    }

    public final String destinationTrafficStateAsString() {
        return this.destinationTrafficState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcceleratorSocketAddresses() ? this.acceleratorSocketAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointGroupRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSocketAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTrafficStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationPortMapping)) {
            return false;
        }
        DestinationPortMapping other = (DestinationPortMapping)obj;
        return Objects.equals(this.acceleratorArn(), other.acceleratorArn()) && this.hasAcceleratorSocketAddresses() == other.hasAcceleratorSocketAddresses() && Objects.equals(this.acceleratorSocketAddresses(), other.acceleratorSocketAddresses()) && Objects.equals(this.endpointGroupArn(), other.endpointGroupArn()) && Objects.equals(this.endpointId(), other.endpointId()) && Objects.equals(this.endpointGroupRegion(), other.endpointGroupRegion()) && Objects.equals(this.destinationSocketAddress(), other.destinationSocketAddress()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(this.destinationTrafficStateAsString(), other.destinationTrafficStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DestinationPortMapping").add("AcceleratorArn", (Object)this.acceleratorArn()).add("AcceleratorSocketAddresses", this.hasAcceleratorSocketAddresses() ? this.acceleratorSocketAddresses() : null).add("EndpointGroupArn", (Object)this.endpointGroupArn()).add("EndpointId", (Object)this.endpointId()).add("EndpointGroupRegion", (Object)this.endpointGroupRegion()).add("DestinationSocketAddress", (Object)this.destinationSocketAddress()).add("IpAddressType", (Object)this.ipAddressTypeAsString()).add("DestinationTrafficState", (Object)this.destinationTrafficStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceleratorArn": {
                return Optional.ofNullable(clazz.cast(this.acceleratorArn()));
            }
            case "AcceleratorSocketAddresses": {
                return Optional.ofNullable(clazz.cast(this.acceleratorSocketAddresses()));
            }
            case "EndpointGroupArn": {
                return Optional.ofNullable(clazz.cast(this.endpointGroupArn()));
            }
            case "EndpointId": {
                return Optional.ofNullable(clazz.cast(this.endpointId()));
            }
            case "EndpointGroupRegion": {
                return Optional.ofNullable(clazz.cast(this.endpointGroupRegion()));
            }
            case "DestinationSocketAddress": {
                return Optional.ofNullable(clazz.cast(this.destinationSocketAddress()));
            }
            case "IpAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "DestinationTrafficState": {
                return Optional.ofNullable(clazz.cast(this.destinationTrafficStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationPortMapping, T> g) {
        return obj -> g.apply((DestinationPortMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String acceleratorArn;
        private List<SocketAddress> acceleratorSocketAddresses = DefaultSdkAutoConstructList.getInstance();
        private String endpointGroupArn;
        private String endpointId;
        private String endpointGroupRegion;
        private SocketAddress destinationSocketAddress;
        private String ipAddressType;
        private String destinationTrafficState;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationPortMapping model) {
            this.acceleratorArn(model.acceleratorArn);
            this.acceleratorSocketAddresses(model.acceleratorSocketAddresses);
            this.endpointGroupArn(model.endpointGroupArn);
            this.endpointId(model.endpointId);
            this.endpointGroupRegion(model.endpointGroupRegion);
            this.destinationSocketAddress(model.destinationSocketAddress);
            this.ipAddressType(model.ipAddressType);
            this.destinationTrafficState(model.destinationTrafficState);
        }

        public final String getAcceleratorArn() {
            return this.acceleratorArn;
        }

        @Override
        public final Builder acceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
            return this;
        }

        public final void setAcceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
        }

        public final List<SocketAddress.Builder> getAcceleratorSocketAddresses() {
            List<SocketAddress.Builder> result = SocketAddressesCopier.copyToBuilder(this.acceleratorSocketAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder acceleratorSocketAddresses(Collection<SocketAddress> acceleratorSocketAddresses) {
            this.acceleratorSocketAddresses = SocketAddressesCopier.copy(acceleratorSocketAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorSocketAddresses(SocketAddress ... acceleratorSocketAddresses) {
            this.acceleratorSocketAddresses(Arrays.asList(acceleratorSocketAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorSocketAddresses(Consumer<SocketAddress.Builder> ... acceleratorSocketAddresses) {
            this.acceleratorSocketAddresses(Stream.of(acceleratorSocketAddresses).map(c -> (SocketAddress)((SocketAddress.Builder)SocketAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAcceleratorSocketAddresses(Collection<SocketAddress.BuilderImpl> acceleratorSocketAddresses) {
            this.acceleratorSocketAddresses = SocketAddressesCopier.copyFromBuilder(acceleratorSocketAddresses);
        }

        public final String getEndpointGroupArn() {
            return this.endpointGroupArn;
        }

        @Override
        public final Builder endpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
            return this;
        }

        public final void setEndpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
        }

        public final String getEndpointId() {
            return this.endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        public final String getEndpointGroupRegion() {
            return this.endpointGroupRegion;
        }

        @Override
        public final Builder endpointGroupRegion(String endpointGroupRegion) {
            this.endpointGroupRegion = endpointGroupRegion;
            return this;
        }

        public final void setEndpointGroupRegion(String endpointGroupRegion) {
            this.endpointGroupRegion = endpointGroupRegion;
        }

        public final SocketAddress.Builder getDestinationSocketAddress() {
            return this.destinationSocketAddress != null ? this.destinationSocketAddress.toBuilder() : null;
        }

        @Override
        public final Builder destinationSocketAddress(SocketAddress destinationSocketAddress) {
            this.destinationSocketAddress = destinationSocketAddress;
            return this;
        }

        public final void setDestinationSocketAddress(SocketAddress.BuilderImpl destinationSocketAddress) {
            this.destinationSocketAddress = destinationSocketAddress != null ? destinationSocketAddress.build() : null;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        public final String getDestinationTrafficState() {
            return this.destinationTrafficState;
        }

        @Override
        public final Builder destinationTrafficState(String destinationTrafficState) {
            this.destinationTrafficState = destinationTrafficState;
            return this;
        }

        @Override
        public final Builder destinationTrafficState(CustomRoutingDestinationTrafficState destinationTrafficState) {
            this.destinationTrafficState(destinationTrafficState == null ? null : destinationTrafficState.toString());
            return this;
        }

        public final void setDestinationTrafficState(String destinationTrafficState) {
            this.destinationTrafficState = destinationTrafficState;
        }

        public DestinationPortMapping build() {
            return new DestinationPortMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DestinationPortMapping> {
        public Builder acceleratorArn(String var1);

        public Builder acceleratorSocketAddresses(Collection<SocketAddress> var1);

        public Builder acceleratorSocketAddresses(SocketAddress ... var1);

        public Builder acceleratorSocketAddresses(Consumer<SocketAddress.Builder> ... var1);

        public Builder endpointGroupArn(String var1);

        public Builder endpointId(String var1);

        public Builder endpointGroupRegion(String var1);

        public Builder destinationSocketAddress(SocketAddress var1);

        default public Builder destinationSocketAddress(Consumer<SocketAddress.Builder> destinationSocketAddress) {
            return this.destinationSocketAddress((SocketAddress)((SocketAddress.Builder)SocketAddress.builder().applyMutation(destinationSocketAddress)).build());
        }

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);

        public Builder destinationTrafficState(String var1);

        public Builder destinationTrafficState(CustomRoutingDestinationTrafficState var1);
    }
}

