/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddCustomRoutingEndpointsResponse extends GlobalAcceleratorResponse implements
        ToCopyableBuilder<AddCustomRoutingEndpointsResponse.Builder, AddCustomRoutingEndpointsResponse> {
    private static final SdkField<List<CustomRoutingEndpointDescription>> ENDPOINT_DESCRIPTIONS_FIELD = SdkField
            .<List<CustomRoutingEndpointDescription>> builder(MarshallingType.LIST)
            .memberName("EndpointDescriptions")
            .getter(getter(AddCustomRoutingEndpointsResponse::endpointDescriptions))
            .setter(setter(Builder::endpointDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomRoutingEndpointDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomRoutingEndpointDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENDPOINT_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointGroupArn").getter(getter(AddCustomRoutingEndpointsResponse::endpointGroupArn))
            .setter(setter(Builder::endpointGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_DESCRIPTIONS_FIELD,
            ENDPOINT_GROUP_ARN_FIELD));

    private final List<CustomRoutingEndpointDescription> endpointDescriptions;

    private final String endpointGroupArn;

    private AddCustomRoutingEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.endpointDescriptions = builder.endpointDescriptions;
        this.endpointGroupArn = builder.endpointGroupArn;
    }

    /**
     * Returns true if the EndpointDescriptions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasEndpointDescriptions() {
        return endpointDescriptions != null && !(endpointDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The endpoint objects added to the custom routing accelerator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEndpointDescriptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The endpoint objects added to the custom routing accelerator.
     */
    public final List<CustomRoutingEndpointDescription> endpointDescriptions() {
        return endpointDescriptions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the endpoint group for the custom routing endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the endpoint group for the custom routing endpoint.
     */
    public final String endpointGroupArn() {
        return endpointGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpointDescriptions() ? endpointDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(endpointGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddCustomRoutingEndpointsResponse)) {
            return false;
        }
        AddCustomRoutingEndpointsResponse other = (AddCustomRoutingEndpointsResponse) obj;
        return hasEndpointDescriptions() == other.hasEndpointDescriptions()
                && Objects.equals(endpointDescriptions(), other.endpointDescriptions())
                && Objects.equals(endpointGroupArn(), other.endpointGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddCustomRoutingEndpointsResponse")
                .add("EndpointDescriptions", hasEndpointDescriptions() ? endpointDescriptions() : null)
                .add("EndpointGroupArn", endpointGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointDescriptions":
            return Optional.ofNullable(clazz.cast(endpointDescriptions()));
        case "EndpointGroupArn":
            return Optional.ofNullable(clazz.cast(endpointGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddCustomRoutingEndpointsResponse, T> g) {
        return obj -> g.apply((AddCustomRoutingEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AddCustomRoutingEndpointsResponse> {
        /**
         * <p>
         * The endpoint objects added to the custom routing accelerator.
         * </p>
         * 
         * @param endpointDescriptions
         *        The endpoint objects added to the custom routing accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointDescriptions(Collection<CustomRoutingEndpointDescription> endpointDescriptions);

        /**
         * <p>
         * The endpoint objects added to the custom routing accelerator.
         * </p>
         * 
         * @param endpointDescriptions
         *        The endpoint objects added to the custom routing accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointDescriptions(CustomRoutingEndpointDescription... endpointDescriptions);

        /**
         * <p>
         * The endpoint objects added to the custom routing accelerator.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CustomRoutingEndpointDescription>.Builder}
         * avoiding the need to create one manually via {@link List<CustomRoutingEndpointDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CustomRoutingEndpointDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #endpointDescriptions(List<CustomRoutingEndpointDescription>)}
         * .
         * 
         * @param endpointDescriptions
         *        a consumer that will call methods on {@link List<CustomRoutingEndpointDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointDescriptions(List<CustomRoutingEndpointDescription>)
         */
        Builder endpointDescriptions(Consumer<CustomRoutingEndpointDescription.Builder>... endpointDescriptions);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the endpoint group for the custom routing endpoint.
         * </p>
         * 
         * @param endpointGroupArn
         *        The Amazon Resource Name (ARN) of the endpoint group for the custom routing endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointGroupArn(String endpointGroupArn);
    }

    static final class BuilderImpl extends GlobalAcceleratorResponse.BuilderImpl implements Builder {
        private List<CustomRoutingEndpointDescription> endpointDescriptions = DefaultSdkAutoConstructList.getInstance();

        private String endpointGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AddCustomRoutingEndpointsResponse model) {
            super(model);
            endpointDescriptions(model.endpointDescriptions);
            endpointGroupArn(model.endpointGroupArn);
        }

        public final List<CustomRoutingEndpointDescription.Builder> getEndpointDescriptions() {
            List<CustomRoutingEndpointDescription.Builder> result = CustomRoutingEndpointDescriptionsCopier
                    .copyToBuilder(this.endpointDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder endpointDescriptions(Collection<CustomRoutingEndpointDescription> endpointDescriptions) {
            this.endpointDescriptions = CustomRoutingEndpointDescriptionsCopier.copy(endpointDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointDescriptions(CustomRoutingEndpointDescription... endpointDescriptions) {
            endpointDescriptions(Arrays.asList(endpointDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointDescriptions(Consumer<CustomRoutingEndpointDescription.Builder>... endpointDescriptions) {
            endpointDescriptions(Stream.of(endpointDescriptions)
                    .map(c -> CustomRoutingEndpointDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndpointDescriptions(Collection<CustomRoutingEndpointDescription.BuilderImpl> endpointDescriptions) {
            this.endpointDescriptions = CustomRoutingEndpointDescriptionsCopier.copyFromBuilder(endpointDescriptions);
        }

        public final String getEndpointGroupArn() {
            return endpointGroupArn;
        }

        @Override
        public final Builder endpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
            return this;
        }

        public final void setEndpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
        }

        @Override
        public AddCustomRoutingEndpointsResponse build() {
            return new AddCustomRoutingEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
