/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains a <code>Message</code> and a <code>Timestamp</code> value for changes that you make in
 * the status an IP address range that you bring to AWS Global Accelerator through bring your own IP address (BYOIP).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ByoipCidrEvent implements SdkPojo, Serializable, ToCopyableBuilder<ByoipCidrEvent.Builder, ByoipCidrEvent> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(ByoipCidrEvent::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(ByoipCidrEvent::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MESSAGE_FIELD, TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String message;

    private final Instant timestamp;

    private ByoipCidrEvent(BuilderImpl builder) {
        this.message = builder.message;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * A string that contains an <code>Event</code> message describing changes that you make in the status of an IP
     * address range that you bring to AWS Global Accelerator through bring your own IP address (BYOIP).
     * </p>
     * 
     * @return A string that contains an <code>Event</code> message describing changes that you make in the status of an
     *         IP address range that you bring to AWS Global Accelerator through bring your own IP address (BYOIP).
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * A timestamp when you make a status change for an IP address range that you bring to AWS Global Accelerator
     * through bring your own IP address (BYOIP).
     * </p>
     * 
     * @return A timestamp when you make a status change for an IP address range that you bring to AWS Global
     *         Accelerator through bring your own IP address (BYOIP).
     */
    public final Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByoipCidrEvent)) {
            return false;
        }
        ByoipCidrEvent other = (ByoipCidrEvent) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ByoipCidrEvent").add("Message", message()).add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ByoipCidrEvent, T> g) {
        return obj -> g.apply((ByoipCidrEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ByoipCidrEvent> {
        /**
         * <p>
         * A string that contains an <code>Event</code> message describing changes that you make in the status of an IP
         * address range that you bring to AWS Global Accelerator through bring your own IP address (BYOIP).
         * </p>
         * 
         * @param message
         *        A string that contains an <code>Event</code> message describing changes that you make in the status of
         *        an IP address range that you bring to AWS Global Accelerator through bring your own IP address
         *        (BYOIP).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * A timestamp when you make a status change for an IP address range that you bring to AWS Global Accelerator
         * through bring your own IP address (BYOIP).
         * </p>
         * 
         * @param timestamp
         *        A timestamp when you make a status change for an IP address range that you bring to AWS Global
         *        Accelerator through bring your own IP address (BYOIP).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ByoipCidrEvent model) {
            message(model.message);
            timestamp(model.timestamp);
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public ByoipCidrEvent build() {
            return new ByoipCidrEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
