/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Attributes of a custom routing accelerator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomRoutingAccelerator implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomRoutingAccelerator.Builder, CustomRoutingAccelerator> {
    private static final SdkField<String> ACCELERATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceleratorArn").getter(getter(CustomRoutingAccelerator::acceleratorArn))
            .setter(setter(Builder::acceleratorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CustomRoutingAccelerator::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddressType").getter(getter(CustomRoutingAccelerator::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(CustomRoutingAccelerator::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<List<IpSet>> IP_SETS_FIELD = SdkField
            .<List<IpSet>> builder(MarshallingType.LIST)
            .memberName("IpSets")
            .getter(getter(CustomRoutingAccelerator::ipSets))
            .setter(setter(Builder::ipSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DnsName").getter(getter(CustomRoutingAccelerator::dnsName)).setter(setter(Builder::dnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CustomRoutingAccelerator::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(CustomRoutingAccelerator::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(CustomRoutingAccelerator::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_ARN_FIELD,
            NAME_FIELD, IP_ADDRESS_TYPE_FIELD, ENABLED_FIELD, IP_SETS_FIELD, DNS_NAME_FIELD, STATUS_FIELD, CREATED_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String acceleratorArn;

    private final String name;

    private final String ipAddressType;

    private final Boolean enabled;

    private final List<IpSet> ipSets;

    private final String dnsName;

    private final String status;

    private final Instant createdTime;

    private final Instant lastModifiedTime;

    private CustomRoutingAccelerator(BuilderImpl builder) {
        this.acceleratorArn = builder.acceleratorArn;
        this.name = builder.name;
        this.ipAddressType = builder.ipAddressType;
        this.enabled = builder.enabled;
        this.ipSets = builder.ipSets;
        this.dnsName = builder.dnsName;
        this.status = builder.status;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom routing accelerator.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the custom routing accelerator.
     */
    public final String acceleratorArn() {
        return acceleratorArn;
    }

    /**
     * <p>
     * The name of the accelerator. The name must contain only alphanumeric characters or hyphens (-), and must not
     * begin or end with a hyphen.
     * </p>
     * 
     * @return The name of the accelerator. The name must contain only alphanumeric characters or hyphens (-), and must
     *         not begin or end with a hyphen.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The value for the address type must be IPv4.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The value for the address type must be IPv4.
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The value for the address type must be IPv4.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The value for the address type must be IPv4.
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * <p>
     * Indicates whether the accelerator is enabled. The value is true or false. The default value is true.
     * </p>
     * <p>
     * If the value is set to true, the accelerator cannot be deleted. If set to false, accelerator can be deleted.
     * </p>
     * 
     * @return Indicates whether the accelerator is enabled. The value is true or false. The default value is true. </p>
     *         <p>
     *         If the value is set to true, the accelerator cannot be deleted. If set to false, accelerator can be
     *         deleted.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * Returns true if the IpSets property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIpSets() {
        return ipSets != null && !(ipSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The static IP addresses that Global Accelerator associates with the accelerator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpSets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The static IP addresses that Global Accelerator associates with the accelerator.
     */
    public final List<IpSet> ipSets() {
        return ipSets;
    }

    /**
     * <p>
     * The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator's static IP
     * addresses.
     * </p>
     * <p>
     * The naming convention for the DNS name is the following: A lowercase letter a, followed by a 16-bit random hex
     * string, followed by .awsglobalaccelerator.com. For example: a1234567890abcdef.awsglobalaccelerator.com.
     * </p>
     * <p>
     * For more information about the default DNS name, see <a href=
     * "https://docs.aws.amazon.com/global-accelerator/latest/dg/about-accelerators.html#about-accelerators.dns-addressing"
     * > Support for DNS Addressing in Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.
     * </p>
     * 
     * @return The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator's
     *         static IP addresses. </p>
     *         <p>
     *         The naming convention for the DNS name is the following: A lowercase letter a, followed by a 16-bit
     *         random hex string, followed by .awsglobalaccelerator.com. For example:
     *         a1234567890abcdef.awsglobalaccelerator.com.
     *         </p>
     *         <p>
     *         For more information about the default DNS name, see <a href=
     *         "https://docs.aws.amazon.com/global-accelerator/latest/dg/about-accelerators.html#about-accelerators.dns-addressing"
     *         > Support for DNS Addressing in Global Accelerator</a> in the <i>AWS Global Accelerator Developer
     *         Guide</i>.
     */
    public final String dnsName() {
        return dnsName;
    }

    /**
     * <p>
     * Describes the deployment status of the accelerator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CustomRoutingAcceleratorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Describes the deployment status of the accelerator.
     * @see CustomRoutingAcceleratorStatus
     */
    public final CustomRoutingAcceleratorStatus status() {
        return CustomRoutingAcceleratorStatus.fromValue(status);
    }

    /**
     * <p>
     * Describes the deployment status of the accelerator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CustomRoutingAcceleratorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Describes the deployment status of the accelerator.
     * @see CustomRoutingAcceleratorStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time that the accelerator was created.
     * </p>
     * 
     * @return The date and time that the accelerator was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The date and time that the accelerator was last modified.
     * </p>
     * 
     * @return The date and time that the accelerator was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpSets() ? ipSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomRoutingAccelerator)) {
            return false;
        }
        CustomRoutingAccelerator other = (CustomRoutingAccelerator) obj;
        return Objects.equals(acceleratorArn(), other.acceleratorArn()) && Objects.equals(name(), other.name())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString())
                && Objects.equals(enabled(), other.enabled()) && hasIpSets() == other.hasIpSets()
                && Objects.equals(ipSets(), other.ipSets()) && Objects.equals(dnsName(), other.dnsName())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomRoutingAccelerator").add("AcceleratorArn", acceleratorArn()).add("Name", name())
                .add("IpAddressType", ipAddressTypeAsString()).add("Enabled", enabled())
                .add("IpSets", hasIpSets() ? ipSets() : null).add("DnsName", dnsName()).add("Status", statusAsString())
                .add("CreatedTime", createdTime()).add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceleratorArn":
            return Optional.ofNullable(clazz.cast(acceleratorArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "IpAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "IpSets":
            return Optional.ofNullable(clazz.cast(ipSets()));
        case "DnsName":
            return Optional.ofNullable(clazz.cast(dnsName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomRoutingAccelerator, T> g) {
        return obj -> g.apply((CustomRoutingAccelerator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomRoutingAccelerator> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom routing accelerator.
         * </p>
         * 
         * @param acceleratorArn
         *        The Amazon Resource Name (ARN) of the custom routing accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorArn(String acceleratorArn);

        /**
         * <p>
         * The name of the accelerator. The name must contain only alphanumeric characters or hyphens (-), and must not
         * begin or end with a hyphen.
         * </p>
         * 
         * @param name
         *        The name of the accelerator. The name must contain only alphanumeric characters or hyphens (-), and
         *        must not begin or end with a hyphen.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value for the address type must be IPv4.
         * </p>
         * 
         * @param ipAddressType
         *        The value for the address type must be IPv4.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The value for the address type must be IPv4.
         * </p>
         * 
         * @param ipAddressType
         *        The value for the address type must be IPv4.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        /**
         * <p>
         * Indicates whether the accelerator is enabled. The value is true or false. The default value is true.
         * </p>
         * <p>
         * If the value is set to true, the accelerator cannot be deleted. If set to false, accelerator can be deleted.
         * </p>
         * 
         * @param enabled
         *        Indicates whether the accelerator is enabled. The value is true or false. The default value is true.
         *        </p>
         *        <p>
         *        If the value is set to true, the accelerator cannot be deleted. If set to false, accelerator can be
         *        deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The static IP addresses that Global Accelerator associates with the accelerator.
         * </p>
         * 
         * @param ipSets
         *        The static IP addresses that Global Accelerator associates with the accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipSets(Collection<IpSet> ipSets);

        /**
         * <p>
         * The static IP addresses that Global Accelerator associates with the accelerator.
         * </p>
         * 
         * @param ipSets
         *        The static IP addresses that Global Accelerator associates with the accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipSets(IpSet... ipSets);

        /**
         * <p>
         * The static IP addresses that Global Accelerator associates with the accelerator.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpSet>.Builder} avoiding the need to create
         * one manually via {@link List<IpSet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpSet>.Builder#build()} is called immediately and its result
         * is passed to {@link #ipSets(List<IpSet>)}.
         * 
         * @param ipSets
         *        a consumer that will call methods on {@link List<IpSet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipSets(List<IpSet>)
         */
        Builder ipSets(Consumer<IpSet.Builder>... ipSets);

        /**
         * <p>
         * The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator's static IP
         * addresses.
         * </p>
         * <p>
         * The naming convention for the DNS name is the following: A lowercase letter a, followed by a 16-bit random
         * hex string, followed by .awsglobalaccelerator.com. For example: a1234567890abcdef.awsglobalaccelerator.com.
         * </p>
         * <p>
         * For more information about the default DNS name, see <a href=
         * "https://docs.aws.amazon.com/global-accelerator/latest/dg/about-accelerators.html#about-accelerators.dns-addressing"
         * > Support for DNS Addressing in Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.
         * </p>
         * 
         * @param dnsName
         *        The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator's
         *        static IP addresses. </p>
         *        <p>
         *        The naming convention for the DNS name is the following: A lowercase letter a, followed by a 16-bit
         *        random hex string, followed by .awsglobalaccelerator.com. For example:
         *        a1234567890abcdef.awsglobalaccelerator.com.
         *        </p>
         *        <p>
         *        For more information about the default DNS name, see <a href=
         *        "https://docs.aws.amazon.com/global-accelerator/latest/dg/about-accelerators.html#about-accelerators.dns-addressing"
         *        > Support for DNS Addressing in Global Accelerator</a> in the <i>AWS Global Accelerator Developer
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsName(String dnsName);

        /**
         * <p>
         * Describes the deployment status of the accelerator.
         * </p>
         * 
         * @param status
         *        Describes the deployment status of the accelerator.
         * @see CustomRoutingAcceleratorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomRoutingAcceleratorStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Describes the deployment status of the accelerator.
         * </p>
         * 
         * @param status
         *        Describes the deployment status of the accelerator.
         * @see CustomRoutingAcceleratorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomRoutingAcceleratorStatus
         */
        Builder status(CustomRoutingAcceleratorStatus status);

        /**
         * <p>
         * The date and time that the accelerator was created.
         * </p>
         * 
         * @param createdTime
         *        The date and time that the accelerator was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The date and time that the accelerator was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time that the accelerator was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String acceleratorArn;

        private String name;

        private String ipAddressType;

        private Boolean enabled;

        private List<IpSet> ipSets = DefaultSdkAutoConstructList.getInstance();

        private String dnsName;

        private String status;

        private Instant createdTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomRoutingAccelerator model) {
            acceleratorArn(model.acceleratorArn);
            name(model.name);
            ipAddressType(model.ipAddressType);
            enabled(model.enabled);
            ipSets(model.ipSets);
            dnsName(model.dnsName);
            status(model.status);
            createdTime(model.createdTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getAcceleratorArn() {
            return acceleratorArn;
        }

        @Override
        public final Builder acceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
            return this;
        }

        public final void setAcceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final List<IpSet.Builder> getIpSets() {
            List<IpSet.Builder> result = IpSetsCopier.copyToBuilder(this.ipSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder ipSets(Collection<IpSet> ipSets) {
            this.ipSets = IpSetsCopier.copy(ipSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipSets(IpSet... ipSets) {
            ipSets(Arrays.asList(ipSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipSets(Consumer<IpSet.Builder>... ipSets) {
            ipSets(Stream.of(ipSets).map(c -> IpSet.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpSets(Collection<IpSet.BuilderImpl> ipSets) {
            this.ipSets = IpSetsCopier.copyFromBuilder(ipSets);
        }

        public final String getDnsName() {
            return dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CustomRoutingAcceleratorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public CustomRoutingAccelerator build() {
            return new CustomRoutingAccelerator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
