/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type for a listener for a custom routing accelerator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomRoutingListener implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomRoutingListener.Builder, CustomRoutingListener> {
    private static final SdkField<String> LISTENER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ListenerArn").getter(getter(CustomRoutingListener::listenerArn)).setter(setter(Builder::listenerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerArn").build()).build();

    private static final SdkField<List<PortRange>> PORT_RANGES_FIELD = SdkField
            .<List<PortRange>> builder(MarshallingType.LIST)
            .memberName("PortRanges")
            .getter(getter(CustomRoutingListener::portRanges))
            .setter(setter(Builder::portRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PortRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_ARN_FIELD,
            PORT_RANGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String listenerArn;

    private final List<PortRange> portRanges;

    private CustomRoutingListener(BuilderImpl builder) {
        this.listenerArn = builder.listenerArn;
        this.portRanges = builder.portRanges;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the listener.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the listener.
     */
    public final String listenerArn() {
        return listenerArn;
    }

    /**
     * Returns true if the PortRanges property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPortRanges() {
        return portRanges != null && !(portRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The port range to support for connections from clients to your accelerator.
     * </p>
     * <p>
     * Separately, you set port ranges for endpoints. For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
     * endpoints for custom routing accelerators</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPortRanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The port range to support for connections from clients to your accelerator.</p>
     *         <p>
     *         Separately, you set port ranges for endpoints. For more information, see <a
     *         href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
     *         endpoints for custom routing accelerators</a>.
     */
    public final List<PortRange> portRanges() {
        return portRanges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(listenerArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasPortRanges() ? portRanges() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomRoutingListener)) {
            return false;
        }
        CustomRoutingListener other = (CustomRoutingListener) obj;
        return Objects.equals(listenerArn(), other.listenerArn()) && hasPortRanges() == other.hasPortRanges()
                && Objects.equals(portRanges(), other.portRanges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomRoutingListener").add("ListenerArn", listenerArn())
                .add("PortRanges", hasPortRanges() ? portRanges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListenerArn":
            return Optional.ofNullable(clazz.cast(listenerArn()));
        case "PortRanges":
            return Optional.ofNullable(clazz.cast(portRanges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomRoutingListener, T> g) {
        return obj -> g.apply((CustomRoutingListener) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomRoutingListener> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the listener.
         * </p>
         * 
         * @param listenerArn
         *        The Amazon Resource Name (ARN) of the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerArn(String listenerArn);

        /**
         * <p>
         * The port range to support for connections from clients to your accelerator.
         * </p>
         * <p>
         * Separately, you set port ranges for endpoints. For more information, see <a
         * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
         * endpoints for custom routing accelerators</a>.
         * </p>
         * 
         * @param portRanges
         *        The port range to support for connections from clients to your accelerator.</p>
         *        <p>
         *        Separately, you set port ranges for endpoints. For more information, see <a
         *        href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html"
         *        >About endpoints for custom routing accelerators</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRanges(Collection<PortRange> portRanges);

        /**
         * <p>
         * The port range to support for connections from clients to your accelerator.
         * </p>
         * <p>
         * Separately, you set port ranges for endpoints. For more information, see <a
         * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
         * endpoints for custom routing accelerators</a>.
         * </p>
         * 
         * @param portRanges
         *        The port range to support for connections from clients to your accelerator.</p>
         *        <p>
         *        Separately, you set port ranges for endpoints. For more information, see <a
         *        href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html"
         *        >About endpoints for custom routing accelerators</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRanges(PortRange... portRanges);

        /**
         * <p>
         * The port range to support for connections from clients to your accelerator.
         * </p>
         * <p>
         * Separately, you set port ranges for endpoints. For more information, see <a
         * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
         * endpoints for custom routing accelerators</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PortRange>.Builder} avoiding the need to
         * create one manually via {@link List<PortRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PortRange>.Builder#build()} is called immediately and its
         * result is passed to {@link #portRanges(List<PortRange>)}.
         * 
         * @param portRanges
         *        a consumer that will call methods on {@link List<PortRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portRanges(List<PortRange>)
         */
        Builder portRanges(Consumer<PortRange.Builder>... portRanges);
    }

    static final class BuilderImpl implements Builder {
        private String listenerArn;

        private List<PortRange> portRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomRoutingListener model) {
            listenerArn(model.listenerArn);
            portRanges(model.portRanges);
        }

        public final String getListenerArn() {
            return listenerArn;
        }

        @Override
        public final Builder listenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        public final void setListenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
        }

        public final List<PortRange.Builder> getPortRanges() {
            List<PortRange.Builder> result = PortRangesCopier.copyToBuilder(this.portRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder portRanges(Collection<PortRange> portRanges) {
            this.portRanges = PortRangesCopier.copy(portRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(PortRange... portRanges) {
            portRanges(Arrays.asList(portRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(Consumer<PortRange.Builder>... portRanges) {
            portRanges(Stream.of(portRanges).map(c -> PortRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPortRanges(Collection<PortRange.BuilderImpl> portRanges) {
            this.portRanges = PortRangesCopier.copyFromBuilder(portRanges);
        }

        @Override
        public CustomRoutingListener build() {
            return new CustomRoutingListener(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
