/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The port mappings for a specified endpoint IP address (destination).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationPortMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationPortMapping.Builder, DestinationPortMapping> {
    private static final SdkField<String> ACCELERATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceleratorArn").getter(getter(DestinationPortMapping::acceleratorArn))
            .setter(setter(Builder::acceleratorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorArn").build()).build();

    private static final SdkField<List<SocketAddress>> ACCELERATOR_SOCKET_ADDRESSES_FIELD = SdkField
            .<List<SocketAddress>> builder(MarshallingType.LIST)
            .memberName("AcceleratorSocketAddresses")
            .getter(getter(DestinationPortMapping::acceleratorSocketAddresses))
            .setter(setter(Builder::acceleratorSocketAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorSocketAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SocketAddress> builder(MarshallingType.SDK_POJO)
                                            .constructor(SocketAddress::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENDPOINT_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointGroupArn").getter(getter(DestinationPortMapping::endpointGroupArn))
            .setter(setter(Builder::endpointGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupArn").build()).build();

    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointId").getter(getter(DestinationPortMapping::endpointId)).setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()).build();

    private static final SdkField<String> ENDPOINT_GROUP_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointGroupRegion").getter(getter(DestinationPortMapping::endpointGroupRegion))
            .setter(setter(Builder::endpointGroupRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupRegion").build())
            .build();

    private static final SdkField<SocketAddress> DESTINATION_SOCKET_ADDRESS_FIELD = SdkField
            .<SocketAddress> builder(MarshallingType.SDK_POJO).memberName("DestinationSocketAddress")
            .getter(getter(DestinationPortMapping::destinationSocketAddress)).setter(setter(Builder::destinationSocketAddress))
            .constructor(SocketAddress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationSocketAddress").build())
            .build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddressType").getter(getter(DestinationPortMapping::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()).build();

    private static final SdkField<String> DESTINATION_TRAFFIC_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationTrafficState").getter(getter(DestinationPortMapping::destinationTrafficStateAsString))
            .setter(setter(Builder::destinationTrafficState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationTrafficState").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_ARN_FIELD,
            ACCELERATOR_SOCKET_ADDRESSES_FIELD, ENDPOINT_GROUP_ARN_FIELD, ENDPOINT_ID_FIELD, ENDPOINT_GROUP_REGION_FIELD,
            DESTINATION_SOCKET_ADDRESS_FIELD, IP_ADDRESS_TYPE_FIELD, DESTINATION_TRAFFIC_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String acceleratorArn;

    private final List<SocketAddress> acceleratorSocketAddresses;

    private final String endpointGroupArn;

    private final String endpointId;

    private final String endpointGroupRegion;

    private final SocketAddress destinationSocketAddress;

    private final String ipAddressType;

    private final String destinationTrafficState;

    private DestinationPortMapping(BuilderImpl builder) {
        this.acceleratorArn = builder.acceleratorArn;
        this.acceleratorSocketAddresses = builder.acceleratorSocketAddresses;
        this.endpointGroupArn = builder.endpointGroupArn;
        this.endpointId = builder.endpointId;
        this.endpointGroupRegion = builder.endpointGroupRegion;
        this.destinationSocketAddress = builder.destinationSocketAddress;
        this.ipAddressType = builder.ipAddressType;
        this.destinationTrafficState = builder.destinationTrafficState;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom routing accelerator that you have port mappings for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the custom routing accelerator that you have port mappings for.
     */
    public final String acceleratorArn() {
        return acceleratorArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AcceleratorSocketAddresses property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAcceleratorSocketAddresses() {
        return acceleratorSocketAddresses != null && !(acceleratorSocketAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP address/port combinations (sockets) that map to a given destination socket address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAcceleratorSocketAddresses} method.
     * </p>
     * 
     * @return The IP address/port combinations (sockets) that map to a given destination socket address.
     */
    public final List<SocketAddress> acceleratorSocketAddresses() {
        return acceleratorSocketAddresses;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the endpoint group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the endpoint group.
     */
    public final String endpointGroupArn() {
        return endpointGroupArn;
    }

    /**
     * <p>
     * The ID for the virtual private cloud (VPC) subnet.
     * </p>
     * 
     * @return The ID for the virtual private cloud (VPC) subnet.
     */
    public final String endpointId() {
        return endpointId;
    }

    /**
     * <p>
     * The AWS Region for the endpoint group.
     * </p>
     * 
     * @return The AWS Region for the endpoint group.
     */
    public final String endpointGroupRegion() {
        return endpointGroupRegion;
    }

    /**
     * <p>
     * The endpoint IP address/port combination for traffic received on the accelerator socket address.
     * </p>
     * 
     * @return The endpoint IP address/port combination for traffic received on the accelerator socket address.
     */
    public final SocketAddress destinationSocketAddress() {
        return destinationSocketAddress;
    }

    /**
     * <p>
     * The IP address type, which must be IPv4.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type, which must be IPv4.
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The IP address type, which must be IPv4.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type, which must be IPv4.
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * <p>
     * Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if traffic is
     * allowed to the destination, or DENY, if traffic is not allowed to the destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #destinationTrafficState} will return {@link CustomRoutingDestinationTrafficState#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #destinationTrafficStateAsString}.
     * </p>
     * 
     * @return Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if
     *         traffic is allowed to the destination, or DENY, if traffic is not allowed to the destination.
     * @see CustomRoutingDestinationTrafficState
     */
    public final CustomRoutingDestinationTrafficState destinationTrafficState() {
        return CustomRoutingDestinationTrafficState.fromValue(destinationTrafficState);
    }

    /**
     * <p>
     * Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if traffic is
     * allowed to the destination, or DENY, if traffic is not allowed to the destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #destinationTrafficState} will return {@link CustomRoutingDestinationTrafficState#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #destinationTrafficStateAsString}.
     * </p>
     * 
     * @return Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if
     *         traffic is allowed to the destination, or DENY, if traffic is not allowed to the destination.
     * @see CustomRoutingDestinationTrafficState
     */
    public final String destinationTrafficStateAsString() {
        return destinationTrafficState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAcceleratorSocketAddresses() ? acceleratorSocketAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(endpointGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(endpointGroupRegion());
        hashCode = 31 * hashCode + Objects.hashCode(destinationSocketAddress());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationTrafficStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationPortMapping)) {
            return false;
        }
        DestinationPortMapping other = (DestinationPortMapping) obj;
        return Objects.equals(acceleratorArn(), other.acceleratorArn())
                && hasAcceleratorSocketAddresses() == other.hasAcceleratorSocketAddresses()
                && Objects.equals(acceleratorSocketAddresses(), other.acceleratorSocketAddresses())
                && Objects.equals(endpointGroupArn(), other.endpointGroupArn())
                && Objects.equals(endpointId(), other.endpointId())
                && Objects.equals(endpointGroupRegion(), other.endpointGroupRegion())
                && Objects.equals(destinationSocketAddress(), other.destinationSocketAddress())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString())
                && Objects.equals(destinationTrafficStateAsString(), other.destinationTrafficStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationPortMapping").add("AcceleratorArn", acceleratorArn())
                .add("AcceleratorSocketAddresses", hasAcceleratorSocketAddresses() ? acceleratorSocketAddresses() : null)
                .add("EndpointGroupArn", endpointGroupArn()).add("EndpointId", endpointId())
                .add("EndpointGroupRegion", endpointGroupRegion()).add("DestinationSocketAddress", destinationSocketAddress())
                .add("IpAddressType", ipAddressTypeAsString()).add("DestinationTrafficState", destinationTrafficStateAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceleratorArn":
            return Optional.ofNullable(clazz.cast(acceleratorArn()));
        case "AcceleratorSocketAddresses":
            return Optional.ofNullable(clazz.cast(acceleratorSocketAddresses()));
        case "EndpointGroupArn":
            return Optional.ofNullable(clazz.cast(endpointGroupArn()));
        case "EndpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        case "EndpointGroupRegion":
            return Optional.ofNullable(clazz.cast(endpointGroupRegion()));
        case "DestinationSocketAddress":
            return Optional.ofNullable(clazz.cast(destinationSocketAddress()));
        case "IpAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "DestinationTrafficState":
            return Optional.ofNullable(clazz.cast(destinationTrafficStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationPortMapping, T> g) {
        return obj -> g.apply((DestinationPortMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationPortMapping> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom routing accelerator that you have port mappings for.
         * </p>
         * 
         * @param acceleratorArn
         *        The Amazon Resource Name (ARN) of the custom routing accelerator that you have port mappings for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorArn(String acceleratorArn);

        /**
         * <p>
         * The IP address/port combinations (sockets) that map to a given destination socket address.
         * </p>
         * 
         * @param acceleratorSocketAddresses
         *        The IP address/port combinations (sockets) that map to a given destination socket address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorSocketAddresses(Collection<SocketAddress> acceleratorSocketAddresses);

        /**
         * <p>
         * The IP address/port combinations (sockets) that map to a given destination socket address.
         * </p>
         * 
         * @param acceleratorSocketAddresses
         *        The IP address/port combinations (sockets) that map to a given destination socket address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorSocketAddresses(SocketAddress... acceleratorSocketAddresses);

        /**
         * <p>
         * The IP address/port combinations (sockets) that map to a given destination socket address.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SocketAddress>.Builder} avoiding the need
         * to create one manually via {@link List<SocketAddress>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SocketAddress>.Builder#build()} is called immediately and
         * its result is passed to {@link #acceleratorSocketAddresses(List<SocketAddress>)}.
         * 
         * @param acceleratorSocketAddresses
         *        a consumer that will call methods on {@link List<SocketAddress>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acceleratorSocketAddresses(List<SocketAddress>)
         */
        Builder acceleratorSocketAddresses(Consumer<SocketAddress.Builder>... acceleratorSocketAddresses);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the endpoint group.
         * </p>
         * 
         * @param endpointGroupArn
         *        The Amazon Resource Name (ARN) of the endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointGroupArn(String endpointGroupArn);

        /**
         * <p>
         * The ID for the virtual private cloud (VPC) subnet.
         * </p>
         * 
         * @param endpointId
         *        The ID for the virtual private cloud (VPC) subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        /**
         * <p>
         * The AWS Region for the endpoint group.
         * </p>
         * 
         * @param endpointGroupRegion
         *        The AWS Region for the endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointGroupRegion(String endpointGroupRegion);

        /**
         * <p>
         * The endpoint IP address/port combination for traffic received on the accelerator socket address.
         * </p>
         * 
         * @param destinationSocketAddress
         *        The endpoint IP address/port combination for traffic received on the accelerator socket address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSocketAddress(SocketAddress destinationSocketAddress);

        /**
         * <p>
         * The endpoint IP address/port combination for traffic received on the accelerator socket address.
         * </p>
         * This is a convenience that creates an instance of the {@link SocketAddress.Builder} avoiding the need to
         * create one manually via {@link SocketAddress#builder()}.
         *
         * When the {@link Consumer} completes, {@link SocketAddress.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationSocketAddress(SocketAddress)}.
         * 
         * @param destinationSocketAddress
         *        a consumer that will call methods on {@link SocketAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationSocketAddress(SocketAddress)
         */
        default Builder destinationSocketAddress(Consumer<SocketAddress.Builder> destinationSocketAddress) {
            return destinationSocketAddress(SocketAddress.builder().applyMutation(destinationSocketAddress).build());
        }

        /**
         * <p>
         * The IP address type, which must be IPv4.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type, which must be IPv4.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The IP address type, which must be IPv4.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type, which must be IPv4.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        /**
         * <p>
         * Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if
         * traffic is allowed to the destination, or DENY, if traffic is not allowed to the destination.
         * </p>
         * 
         * @param destinationTrafficState
         *        Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if
         *        traffic is allowed to the destination, or DENY, if traffic is not allowed to the destination.
         * @see CustomRoutingDestinationTrafficState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomRoutingDestinationTrafficState
         */
        Builder destinationTrafficState(String destinationTrafficState);

        /**
         * <p>
         * Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if
         * traffic is allowed to the destination, or DENY, if traffic is not allowed to the destination.
         * </p>
         * 
         * @param destinationTrafficState
         *        Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if
         *        traffic is allowed to the destination, or DENY, if traffic is not allowed to the destination.
         * @see CustomRoutingDestinationTrafficState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomRoutingDestinationTrafficState
         */
        Builder destinationTrafficState(CustomRoutingDestinationTrafficState destinationTrafficState);
    }

    static final class BuilderImpl implements Builder {
        private String acceleratorArn;

        private List<SocketAddress> acceleratorSocketAddresses = DefaultSdkAutoConstructList.getInstance();

        private String endpointGroupArn;

        private String endpointId;

        private String endpointGroupRegion;

        private SocketAddress destinationSocketAddress;

        private String ipAddressType;

        private String destinationTrafficState;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationPortMapping model) {
            acceleratorArn(model.acceleratorArn);
            acceleratorSocketAddresses(model.acceleratorSocketAddresses);
            endpointGroupArn(model.endpointGroupArn);
            endpointId(model.endpointId);
            endpointGroupRegion(model.endpointGroupRegion);
            destinationSocketAddress(model.destinationSocketAddress);
            ipAddressType(model.ipAddressType);
            destinationTrafficState(model.destinationTrafficState);
        }

        public final String getAcceleratorArn() {
            return acceleratorArn;
        }

        public final void setAcceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
        }

        @Override
        @Transient
        public final Builder acceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
            return this;
        }

        public final List<SocketAddress.Builder> getAcceleratorSocketAddresses() {
            List<SocketAddress.Builder> result = SocketAddressesCopier.copyToBuilder(this.acceleratorSocketAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAcceleratorSocketAddresses(Collection<SocketAddress.BuilderImpl> acceleratorSocketAddresses) {
            this.acceleratorSocketAddresses = SocketAddressesCopier.copyFromBuilder(acceleratorSocketAddresses);
        }

        @Override
        @Transient
        public final Builder acceleratorSocketAddresses(Collection<SocketAddress> acceleratorSocketAddresses) {
            this.acceleratorSocketAddresses = SocketAddressesCopier.copy(acceleratorSocketAddresses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder acceleratorSocketAddresses(SocketAddress... acceleratorSocketAddresses) {
            acceleratorSocketAddresses(Arrays.asList(acceleratorSocketAddresses));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder acceleratorSocketAddresses(Consumer<SocketAddress.Builder>... acceleratorSocketAddresses) {
            acceleratorSocketAddresses(Stream.of(acceleratorSocketAddresses)
                    .map(c -> SocketAddress.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEndpointGroupArn() {
            return endpointGroupArn;
        }

        public final void setEndpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
        }

        @Override
        @Transient
        public final Builder endpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
            return this;
        }

        public final String getEndpointId() {
            return endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        @Transient
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final String getEndpointGroupRegion() {
            return endpointGroupRegion;
        }

        public final void setEndpointGroupRegion(String endpointGroupRegion) {
            this.endpointGroupRegion = endpointGroupRegion;
        }

        @Override
        @Transient
        public final Builder endpointGroupRegion(String endpointGroupRegion) {
            this.endpointGroupRegion = endpointGroupRegion;
            return this;
        }

        public final SocketAddress.Builder getDestinationSocketAddress() {
            return destinationSocketAddress != null ? destinationSocketAddress.toBuilder() : null;
        }

        public final void setDestinationSocketAddress(SocketAddress.BuilderImpl destinationSocketAddress) {
            this.destinationSocketAddress = destinationSocketAddress != null ? destinationSocketAddress.build() : null;
        }

        @Override
        @Transient
        public final Builder destinationSocketAddress(SocketAddress destinationSocketAddress) {
            this.destinationSocketAddress = destinationSocketAddress;
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        @Transient
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        @Transient
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final String getDestinationTrafficState() {
            return destinationTrafficState;
        }

        public final void setDestinationTrafficState(String destinationTrafficState) {
            this.destinationTrafficState = destinationTrafficState;
        }

        @Override
        @Transient
        public final Builder destinationTrafficState(String destinationTrafficState) {
            this.destinationTrafficState = destinationTrafficState;
            return this;
        }

        @Override
        @Transient
        public final Builder destinationTrafficState(CustomRoutingDestinationTrafficState destinationTrafficState) {
            this.destinationTrafficState(destinationTrafficState == null ? null : destinationTrafficState.toString());
            return this;
        }

        @Override
        public DestinationPortMapping build() {
            return new DestinationPortMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
