/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomRoutingListenersResponse extends GlobalAcceleratorResponse implements
        ToCopyableBuilder<ListCustomRoutingListenersResponse.Builder, ListCustomRoutingListenersResponse> {
    private static final SdkField<List<CustomRoutingListener>> LISTENERS_FIELD = SdkField
            .<List<CustomRoutingListener>> builder(MarshallingType.LIST)
            .memberName("Listeners")
            .getter(getter(ListCustomRoutingListenersResponse::listeners))
            .setter(setter(Builder::listeners))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Listeners").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomRoutingListener> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomRoutingListener::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCustomRoutingListenersResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<CustomRoutingListener> listeners;

    private final String nextToken;

    private ListCustomRoutingListenersResponse(BuilderImpl builder) {
        super(builder);
        this.listeners = builder.listeners;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Listeners property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasListeners() {
        return listeners != null && !(listeners instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of listeners for a custom routing accelerator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListeners} method.
     * </p>
     * 
     * @return The list of listeners for a custom routing accelerator.
     */
    public final List<CustomRoutingListener> listeners() {
        return listeners;
    }

    /**
     * <p>
     * The token for the next set of results. You receive this token from a previous call.
     * </p>
     * 
     * @return The token for the next set of results. You receive this token from a previous call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasListeners() ? listeners() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomRoutingListenersResponse)) {
            return false;
        }
        ListCustomRoutingListenersResponse other = (ListCustomRoutingListenersResponse) obj;
        return hasListeners() == other.hasListeners() && Objects.equals(listeners(), other.listeners())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCustomRoutingListenersResponse").add("Listeners", hasListeners() ? listeners() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Listeners":
            return Optional.ofNullable(clazz.cast(listeners()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomRoutingListenersResponse, T> g) {
        return obj -> g.apply((ListCustomRoutingListenersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCustomRoutingListenersResponse> {
        /**
         * <p>
         * The list of listeners for a custom routing accelerator.
         * </p>
         * 
         * @param listeners
         *        The list of listeners for a custom routing accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listeners(Collection<CustomRoutingListener> listeners);

        /**
         * <p>
         * The list of listeners for a custom routing accelerator.
         * </p>
         * 
         * @param listeners
         *        The list of listeners for a custom routing accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listeners(CustomRoutingListener... listeners);

        /**
         * <p>
         * The list of listeners for a custom routing accelerator.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CustomRoutingListener>.Builder} avoiding
         * the need to create one manually via {@link List<CustomRoutingListener>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CustomRoutingListener>.Builder#build()} is called
         * immediately and its result is passed to {@link #listeners(List<CustomRoutingListener>)}.
         * 
         * @param listeners
         *        a consumer that will call methods on {@link List<CustomRoutingListener>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listeners(List<CustomRoutingListener>)
         */
        Builder listeners(Consumer<CustomRoutingListener.Builder>... listeners);

        /**
         * <p>
         * The token for the next set of results. You receive this token from a previous call.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. You receive this token from a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlobalAcceleratorResponse.BuilderImpl implements Builder {
        private List<CustomRoutingListener> listeners = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomRoutingListenersResponse model) {
            super(model);
            listeners(model.listeners);
            nextToken(model.nextToken);
        }

        public final List<CustomRoutingListener.Builder> getListeners() {
            List<CustomRoutingListener.Builder> result = CustomRoutingListenersCopier.copyToBuilder(this.listeners);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListeners(Collection<CustomRoutingListener.BuilderImpl> listeners) {
            this.listeners = CustomRoutingListenersCopier.copyFromBuilder(listeners);
        }

        @Override
        @Transient
        public final Builder listeners(Collection<CustomRoutingListener> listeners) {
            this.listeners = CustomRoutingListenersCopier.copy(listeners);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder listeners(CustomRoutingListener... listeners) {
            listeners(Arrays.asList(listeners));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder listeners(Consumer<CustomRoutingListener.Builder>... listeners) {
            listeners(Stream.of(listeners).map(c -> CustomRoutingListener.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCustomRoutingListenersResponse build() {
            return new ListCustomRoutingListenersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
