/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomRoutingPortMappingsByDestinationResponse extends GlobalAcceleratorResponse
        implements
        ToCopyableBuilder<ListCustomRoutingPortMappingsByDestinationResponse.Builder, ListCustomRoutingPortMappingsByDestinationResponse> {
    private static final SdkField<List<DestinationPortMapping>> DESTINATION_PORT_MAPPINGS_FIELD = SdkField
            .<List<DestinationPortMapping>> builder(MarshallingType.LIST)
            .memberName("DestinationPortMappings")
            .getter(getter(ListCustomRoutingPortMappingsByDestinationResponse::destinationPortMappings))
            .setter(setter(Builder::destinationPortMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DestinationPortMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DestinationPortMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCustomRoutingPortMappingsByDestinationResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DESTINATION_PORT_MAPPINGS_FIELD, NEXT_TOKEN_FIELD));

    private final List<DestinationPortMapping> destinationPortMappings;

    private final String nextToken;

    private ListCustomRoutingPortMappingsByDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.destinationPortMappings = builder.destinationPortMappings;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationPortMappings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDestinationPortMappings() {
        return destinationPortMappings != null && !(destinationPortMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The port mappings for the endpoint IP address that you specified in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationPortMappings} method.
     * </p>
     * 
     * @return The port mappings for the endpoint IP address that you specified in the request.
     */
    public final List<DestinationPortMapping> destinationPortMappings() {
        return destinationPortMappings;
    }

    /**
     * <p>
     * The token for the next set of results. You receive this token from a previous call.
     * </p>
     * 
     * @return The token for the next set of results. You receive this token from a previous call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationPortMappings() ? destinationPortMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomRoutingPortMappingsByDestinationResponse)) {
            return false;
        }
        ListCustomRoutingPortMappingsByDestinationResponse other = (ListCustomRoutingPortMappingsByDestinationResponse) obj;
        return hasDestinationPortMappings() == other.hasDestinationPortMappings()
                && Objects.equals(destinationPortMappings(), other.destinationPortMappings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCustomRoutingPortMappingsByDestinationResponse")
                .add("DestinationPortMappings", hasDestinationPortMappings() ? destinationPortMappings() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationPortMappings":
            return Optional.ofNullable(clazz.cast(destinationPortMappings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomRoutingPortMappingsByDestinationResponse, T> g) {
        return obj -> g.apply((ListCustomRoutingPortMappingsByDestinationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCustomRoutingPortMappingsByDestinationResponse> {
        /**
         * <p>
         * The port mappings for the endpoint IP address that you specified in the request.
         * </p>
         * 
         * @param destinationPortMappings
         *        The port mappings for the endpoint IP address that you specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPortMappings(Collection<DestinationPortMapping> destinationPortMappings);

        /**
         * <p>
         * The port mappings for the endpoint IP address that you specified in the request.
         * </p>
         * 
         * @param destinationPortMappings
         *        The port mappings for the endpoint IP address that you specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPortMappings(DestinationPortMapping... destinationPortMappings);

        /**
         * <p>
         * The port mappings for the endpoint IP address that you specified in the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DestinationPortMapping>.Builder} avoiding
         * the need to create one manually via {@link List<DestinationPortMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DestinationPortMapping>.Builder#build()} is called
         * immediately and its result is passed to {@link #destinationPortMappings(List<DestinationPortMapping>)}.
         * 
         * @param destinationPortMappings
         *        a consumer that will call methods on {@link List<DestinationPortMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationPortMappings(List<DestinationPortMapping>)
         */
        Builder destinationPortMappings(Consumer<DestinationPortMapping.Builder>... destinationPortMappings);

        /**
         * <p>
         * The token for the next set of results. You receive this token from a previous call.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. You receive this token from a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlobalAcceleratorResponse.BuilderImpl implements Builder {
        private List<DestinationPortMapping> destinationPortMappings = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomRoutingPortMappingsByDestinationResponse model) {
            super(model);
            destinationPortMappings(model.destinationPortMappings);
            nextToken(model.nextToken);
        }

        public final List<DestinationPortMapping.Builder> getDestinationPortMappings() {
            List<DestinationPortMapping.Builder> result = DestinationPortMappingsCopier
                    .copyToBuilder(this.destinationPortMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinationPortMappings(Collection<DestinationPortMapping.BuilderImpl> destinationPortMappings) {
            this.destinationPortMappings = DestinationPortMappingsCopier.copyFromBuilder(destinationPortMappings);
        }

        @Override
        @Transient
        public final Builder destinationPortMappings(Collection<DestinationPortMapping> destinationPortMappings) {
            this.destinationPortMappings = DestinationPortMappingsCopier.copy(destinationPortMappings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder destinationPortMappings(DestinationPortMapping... destinationPortMappings) {
            destinationPortMappings(Arrays.asList(destinationPortMappings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder destinationPortMappings(Consumer<DestinationPortMapping.Builder>... destinationPortMappings) {
            destinationPortMappings(Stream.of(destinationPortMappings)
                    .map(c -> DestinationPortMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCustomRoutingPortMappingsByDestinationResponse build() {
            return new ListCustomRoutingPortMappingsByDestinationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
