/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomRoutingPortMappingsResponse extends GlobalAcceleratorResponse implements
        ToCopyableBuilder<ListCustomRoutingPortMappingsResponse.Builder, ListCustomRoutingPortMappingsResponse> {
    private static final SdkField<List<PortMapping>> PORT_MAPPINGS_FIELD = SdkField
            .<List<PortMapping>> builder(MarshallingType.LIST)
            .memberName("PortMappings")
            .getter(getter(ListCustomRoutingPortMappingsResponse::portMappings))
            .setter(setter(Builder::portMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PortMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCustomRoutingPortMappingsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_MAPPINGS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PortMapping> portMappings;

    private final String nextToken;

    private ListCustomRoutingPortMappingsResponse(BuilderImpl builder) {
        super(builder);
        this.portMappings = builder.portMappings;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PortMappings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPortMappings() {
        return portMappings != null && !(portMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The port mappings for a custom routing accelerator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPortMappings} method.
     * </p>
     * 
     * @return The port mappings for a custom routing accelerator.
     */
    public final List<PortMapping> portMappings() {
        return portMappings;
    }

    /**
     * <p>
     * The token for the next set of results. You receive this token from a previous call.
     * </p>
     * 
     * @return The token for the next set of results. You receive this token from a previous call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPortMappings() ? portMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomRoutingPortMappingsResponse)) {
            return false;
        }
        ListCustomRoutingPortMappingsResponse other = (ListCustomRoutingPortMappingsResponse) obj;
        return hasPortMappings() == other.hasPortMappings() && Objects.equals(portMappings(), other.portMappings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCustomRoutingPortMappingsResponse")
                .add("PortMappings", hasPortMappings() ? portMappings() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PortMappings":
            return Optional.ofNullable(clazz.cast(portMappings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomRoutingPortMappingsResponse, T> g) {
        return obj -> g.apply((ListCustomRoutingPortMappingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCustomRoutingPortMappingsResponse> {
        /**
         * <p>
         * The port mappings for a custom routing accelerator.
         * </p>
         * 
         * @param portMappings
         *        The port mappings for a custom routing accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portMappings(Collection<PortMapping> portMappings);

        /**
         * <p>
         * The port mappings for a custom routing accelerator.
         * </p>
         * 
         * @param portMappings
         *        The port mappings for a custom routing accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portMappings(PortMapping... portMappings);

        /**
         * <p>
         * The port mappings for a custom routing accelerator.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PortMapping>.Builder} avoiding the need to
         * create one manually via {@link List<PortMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PortMapping>.Builder#build()} is called immediately and its
         * result is passed to {@link #portMappings(List<PortMapping>)}.
         * 
         * @param portMappings
         *        a consumer that will call methods on {@link List<PortMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portMappings(List<PortMapping>)
         */
        Builder portMappings(Consumer<PortMapping.Builder>... portMappings);

        /**
         * <p>
         * The token for the next set of results. You receive this token from a previous call.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. You receive this token from a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlobalAcceleratorResponse.BuilderImpl implements Builder {
        private List<PortMapping> portMappings = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomRoutingPortMappingsResponse model) {
            super(model);
            portMappings(model.portMappings);
            nextToken(model.nextToken);
        }

        public final List<PortMapping.Builder> getPortMappings() {
            List<PortMapping.Builder> result = PortMappingsCopier.copyToBuilder(this.portMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortMappings(Collection<PortMapping.BuilderImpl> portMappings) {
            this.portMappings = PortMappingsCopier.copyFromBuilder(portMappings);
        }

        @Override
        @Transient
        public final Builder portMappings(Collection<PortMapping> portMappings) {
            this.portMappings = PortMappingsCopier.copy(portMappings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder portMappings(PortMapping... portMappings) {
            portMappings(Arrays.asList(portMappings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder portMappings(Consumer<PortMapping.Builder>... portMappings) {
            portMappings(Stream.of(portMappings).map(c -> PortMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCustomRoutingPortMappingsResponse build() {
            return new ListCustomRoutingPortMappingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
