/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type for a listener.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Listener implements SdkPojo, Serializable, ToCopyableBuilder<Listener.Builder, Listener> {
    private static final SdkField<String> LISTENER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ListenerArn").getter(getter(Listener::listenerArn)).setter(setter(Builder::listenerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerArn").build()).build();

    private static final SdkField<List<PortRange>> PORT_RANGES_FIELD = SdkField
            .<List<PortRange>> builder(MarshallingType.LIST)
            .memberName("PortRanges")
            .getter(getter(Listener::portRanges))
            .setter(setter(Builder::portRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PortRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(Listener::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<String> CLIENT_AFFINITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientAffinity").getter(getter(Listener::clientAffinityAsString))
            .setter(setter(Builder::clientAffinity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientAffinity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_ARN_FIELD,
            PORT_RANGES_FIELD, PROTOCOL_FIELD, CLIENT_AFFINITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String listenerArn;

    private final List<PortRange> portRanges;

    private final String protocol;

    private final String clientAffinity;

    private Listener(BuilderImpl builder) {
        this.listenerArn = builder.listenerArn;
        this.portRanges = builder.portRanges;
        this.protocol = builder.protocol;
        this.clientAffinity = builder.clientAffinity;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the listener.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the listener.
     */
    public final String listenerArn() {
        return listenerArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the PortRanges property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPortRanges() {
        return portRanges != null && !(portRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of port ranges for the connections from clients to the accelerator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPortRanges} method.
     * </p>
     * 
     * @return The list of port ranges for the connections from clients to the accelerator.
     */
    public final List<PortRange> portRanges() {
        return portRanges;
    }

    /**
     * <p>
     * The protocol for the connections from clients to the accelerator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol for the connections from clients to the accelerator.
     * @see Protocol
     */
    public final Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol for the connections from clients to the accelerator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol for the connections from clients to the accelerator.
     * @see Protocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
     * regardless of the port and protocol of the client request. Client affinity gives you control over whether to
     * always route each client to the same specific endpoint.
     * </p>
     * <p>
     * AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection.
     * If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP
     * address, source port, destination IP address, destination port, and protocol—to select the hash value, and then
     * chooses the best endpoint. However, with this setting, if someone uses different ports to connect to Global
     * Accelerator, their connections might not be always routed to the same endpoint because the hash value changes.
     * </p>
     * <p>
     * If you want a given client to always be routed to the same endpoint, set client affinity to
     * <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the
     * "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the hash value.
     * </p>
     * <p>
     * The default value is <code>NONE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientAffinity}
     * will return {@link ClientAffinity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #clientAffinityAsString}.
     * </p>
     * 
     * @return Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful
     *         applications, regardless of the port and protocol of the client request. Client affinity gives you
     *         control over whether to always route each client to the same specific endpoint.</p>
     *         <p>
     *         AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a
     *         connection. If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple)
     *         properties—source IP address, source port, destination IP address, destination port, and protocol—to
     *         select the hash value, and then chooses the best endpoint. However, with this setting, if someone uses
     *         different ports to connect to Global Accelerator, their connections might not be always routed to the
     *         same endpoint because the hash value changes.
     *         </p>
     *         <p>
     *         If you want a given client to always be routed to the same endpoint, set client affinity to
     *         <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses
     *         the "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the
     *         hash value.
     *         </p>
     *         <p>
     *         The default value is <code>NONE</code>.
     * @see ClientAffinity
     */
    public final ClientAffinity clientAffinity() {
        return ClientAffinity.fromValue(clientAffinity);
    }

    /**
     * <p>
     * Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
     * regardless of the port and protocol of the client request. Client affinity gives you control over whether to
     * always route each client to the same specific endpoint.
     * </p>
     * <p>
     * AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection.
     * If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP
     * address, source port, destination IP address, destination port, and protocol—to select the hash value, and then
     * chooses the best endpoint. However, with this setting, if someone uses different ports to connect to Global
     * Accelerator, their connections might not be always routed to the same endpoint because the hash value changes.
     * </p>
     * <p>
     * If you want a given client to always be routed to the same endpoint, set client affinity to
     * <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the
     * "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the hash value.
     * </p>
     * <p>
     * The default value is <code>NONE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientAffinity}
     * will return {@link ClientAffinity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #clientAffinityAsString}.
     * </p>
     * 
     * @return Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful
     *         applications, regardless of the port and protocol of the client request. Client affinity gives you
     *         control over whether to always route each client to the same specific endpoint.</p>
     *         <p>
     *         AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a
     *         connection. If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple)
     *         properties—source IP address, source port, destination IP address, destination port, and protocol—to
     *         select the hash value, and then chooses the best endpoint. However, with this setting, if someone uses
     *         different ports to connect to Global Accelerator, their connections might not be always routed to the
     *         same endpoint because the hash value changes.
     *         </p>
     *         <p>
     *         If you want a given client to always be routed to the same endpoint, set client affinity to
     *         <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses
     *         the "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the
     *         hash value.
     *         </p>
     *         <p>
     *         The default value is <code>NONE</code>.
     * @see ClientAffinity
     */
    public final String clientAffinityAsString() {
        return clientAffinity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(listenerArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasPortRanges() ? portRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientAffinityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Listener)) {
            return false;
        }
        Listener other = (Listener) obj;
        return Objects.equals(listenerArn(), other.listenerArn()) && hasPortRanges() == other.hasPortRanges()
                && Objects.equals(portRanges(), other.portRanges())
                && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(clientAffinityAsString(), other.clientAffinityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Listener").add("ListenerArn", listenerArn())
                .add("PortRanges", hasPortRanges() ? portRanges() : null).add("Protocol", protocolAsString())
                .add("ClientAffinity", clientAffinityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListenerArn":
            return Optional.ofNullable(clazz.cast(listenerArn()));
        case "PortRanges":
            return Optional.ofNullable(clazz.cast(portRanges()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "ClientAffinity":
            return Optional.ofNullable(clazz.cast(clientAffinityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Listener, T> g) {
        return obj -> g.apply((Listener) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Listener> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the listener.
         * </p>
         * 
         * @param listenerArn
         *        The Amazon Resource Name (ARN) of the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerArn(String listenerArn);

        /**
         * <p>
         * The list of port ranges for the connections from clients to the accelerator.
         * </p>
         * 
         * @param portRanges
         *        The list of port ranges for the connections from clients to the accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRanges(Collection<PortRange> portRanges);

        /**
         * <p>
         * The list of port ranges for the connections from clients to the accelerator.
         * </p>
         * 
         * @param portRanges
         *        The list of port ranges for the connections from clients to the accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRanges(PortRange... portRanges);

        /**
         * <p>
         * The list of port ranges for the connections from clients to the accelerator.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PortRange>.Builder} avoiding the need to
         * create one manually via {@link List<PortRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PortRange>.Builder#build()} is called immediately and its
         * result is passed to {@link #portRanges(List<PortRange>)}.
         * 
         * @param portRanges
         *        a consumer that will call methods on {@link List<PortRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portRanges(List<PortRange>)
         */
        Builder portRanges(Consumer<PortRange.Builder>... portRanges);

        /**
         * <p>
         * The protocol for the connections from clients to the accelerator.
         * </p>
         * 
         * @param protocol
         *        The protocol for the connections from clients to the accelerator.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol for the connections from clients to the accelerator.
         * </p>
         * 
         * @param protocol
         *        The protocol for the connections from clients to the accelerator.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);

        /**
         * <p>
         * Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful
         * applications, regardless of the port and protocol of the client request. Client affinity gives you control
         * over whether to always route each client to the same specific endpoint.
         * </p>
         * <p>
         * AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a
         * connection. If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple)
         * properties—source IP address, source port, destination IP address, destination port, and protocol—to select
         * the hash value, and then chooses the best endpoint. However, with this setting, if someone uses different
         * ports to connect to Global Accelerator, their connections might not be always routed to the same endpoint
         * because the hash value changes.
         * </p>
         * <p>
         * If you want a given client to always be routed to the same endpoint, set client affinity to
         * <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the
         * "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the hash
         * value.
         * </p>
         * <p>
         * The default value is <code>NONE</code>.
         * </p>
         * 
         * @param clientAffinity
         *        Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful
         *        applications, regardless of the port and protocol of the client request. Client affinity gives you
         *        control over whether to always route each client to the same specific endpoint.</p>
         *        <p>
         *        AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a
         *        connection. If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple"
         *        (5-tuple) properties—source IP address, source port, destination IP address, destination port, and
         *        protocol—to select the hash value, and then chooses the best endpoint. However, with this setting, if
         *        someone uses different ports to connect to Global Accelerator, their connections might not be always
         *        routed to the same endpoint because the hash value changes.
         *        </p>
         *        <p>
         *        If you want a given client to always be routed to the same endpoint, set client affinity to
         *        <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator
         *        uses the "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to
         *        select the hash value.
         *        </p>
         *        <p>
         *        The default value is <code>NONE</code>.
         * @see ClientAffinity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientAffinity
         */
        Builder clientAffinity(String clientAffinity);

        /**
         * <p>
         * Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful
         * applications, regardless of the port and protocol of the client request. Client affinity gives you control
         * over whether to always route each client to the same specific endpoint.
         * </p>
         * <p>
         * AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a
         * connection. If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple)
         * properties—source IP address, source port, destination IP address, destination port, and protocol—to select
         * the hash value, and then chooses the best endpoint. However, with this setting, if someone uses different
         * ports to connect to Global Accelerator, their connections might not be always routed to the same endpoint
         * because the hash value changes.
         * </p>
         * <p>
         * If you want a given client to always be routed to the same endpoint, set client affinity to
         * <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the
         * "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the hash
         * value.
         * </p>
         * <p>
         * The default value is <code>NONE</code>.
         * </p>
         * 
         * @param clientAffinity
         *        Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful
         *        applications, regardless of the port and protocol of the client request. Client affinity gives you
         *        control over whether to always route each client to the same specific endpoint.</p>
         *        <p>
         *        AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a
         *        connection. If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple"
         *        (5-tuple) properties—source IP address, source port, destination IP address, destination port, and
         *        protocol—to select the hash value, and then chooses the best endpoint. However, with this setting, if
         *        someone uses different ports to connect to Global Accelerator, their connections might not be always
         *        routed to the same endpoint because the hash value changes.
         *        </p>
         *        <p>
         *        If you want a given client to always be routed to the same endpoint, set client affinity to
         *        <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator
         *        uses the "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to
         *        select the hash value.
         *        </p>
         *        <p>
         *        The default value is <code>NONE</code>.
         * @see ClientAffinity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientAffinity
         */
        Builder clientAffinity(ClientAffinity clientAffinity);
    }

    static final class BuilderImpl implements Builder {
        private String listenerArn;

        private List<PortRange> portRanges = DefaultSdkAutoConstructList.getInstance();

        private String protocol;

        private String clientAffinity;

        private BuilderImpl() {
        }

        private BuilderImpl(Listener model) {
            listenerArn(model.listenerArn);
            portRanges(model.portRanges);
            protocol(model.protocol);
            clientAffinity(model.clientAffinity);
        }

        public final String getListenerArn() {
            return listenerArn;
        }

        public final void setListenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
        }

        @Override
        @Transient
        public final Builder listenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        public final List<PortRange.Builder> getPortRanges() {
            List<PortRange.Builder> result = PortRangesCopier.copyToBuilder(this.portRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortRanges(Collection<PortRange.BuilderImpl> portRanges) {
            this.portRanges = PortRangesCopier.copyFromBuilder(portRanges);
        }

        @Override
        @Transient
        public final Builder portRanges(Collection<PortRange> portRanges) {
            this.portRanges = PortRangesCopier.copy(portRanges);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder portRanges(PortRange... portRanges) {
            portRanges(Arrays.asList(portRanges));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder portRanges(Consumer<PortRange.Builder>... portRanges) {
            portRanges(Stream.of(portRanges).map(c -> PortRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        @Transient
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        @Transient
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getClientAffinity() {
            return clientAffinity;
        }

        public final void setClientAffinity(String clientAffinity) {
            this.clientAffinity = clientAffinity;
        }

        @Override
        @Transient
        public final Builder clientAffinity(String clientAffinity) {
            this.clientAffinity = clientAffinity;
            return this;
        }

        @Override
        @Transient
        public final Builder clientAffinity(ClientAffinity clientAffinity) {
            this.clientAffinity(clientAffinity == null ? null : clientAffinity.toString());
            return this;
        }

        @Override
        public Listener build() {
            return new Listener(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
