/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionByoipCidrRequest extends GlobalAcceleratorRequest implements
        ToCopyableBuilder<ProvisionByoipCidrRequest.Builder, ProvisionByoipCidrRequest> {
    private static final SdkField<String> CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Cidr")
            .getter(getter(ProvisionByoipCidrRequest::cidr)).setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").build()).build();

    private static final SdkField<CidrAuthorizationContext> CIDR_AUTHORIZATION_CONTEXT_FIELD = SdkField
            .<CidrAuthorizationContext> builder(MarshallingType.SDK_POJO).memberName("CidrAuthorizationContext")
            .getter(getter(ProvisionByoipCidrRequest::cidrAuthorizationContext))
            .setter(setter(Builder::cidrAuthorizationContext)).constructor(CidrAuthorizationContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrAuthorizationContext").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD,
            CIDR_AUTHORIZATION_CONTEXT_FIELD));

    private final String cidr;

    private final CidrAuthorizationContext cidrAuthorizationContext;

    private ProvisionByoipCidrRequest(BuilderImpl builder) {
        super(builder);
        this.cidr = builder.cidr;
        this.cidrAuthorizationContext = builder.cidrAuthorizationContext;
    }

    /**
     * <p>
     * The public IPv4 address range, in CIDR notation. The most specific IP prefix that you can specify is /24. The
     * address range cannot overlap with another address range that you've brought to this or another Region.
     * </p>
     * 
     * @return The public IPv4 address range, in CIDR notation. The most specific IP prefix that you can specify is /24.
     *         The address range cannot overlap with another address range that you've brought to this or another
     *         Region.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * A signed document that proves that you are authorized to bring the specified IP address range to Amazon using
     * BYOIP.
     * </p>
     * 
     * @return A signed document that proves that you are authorized to bring the specified IP address range to Amazon
     *         using BYOIP.
     */
    public final CidrAuthorizationContext cidrAuthorizationContext() {
        return cidrAuthorizationContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(cidrAuthorizationContext());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionByoipCidrRequest)) {
            return false;
        }
        ProvisionByoipCidrRequest other = (ProvisionByoipCidrRequest) obj;
        return Objects.equals(cidr(), other.cidr())
                && Objects.equals(cidrAuthorizationContext(), other.cidrAuthorizationContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionByoipCidrRequest").add("Cidr", cidr())
                .add("CidrAuthorizationContext", cidrAuthorizationContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "CidrAuthorizationContext":
            return Optional.ofNullable(clazz.cast(cidrAuthorizationContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionByoipCidrRequest, T> g) {
        return obj -> g.apply((ProvisionByoipCidrRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ProvisionByoipCidrRequest> {
        /**
         * <p>
         * The public IPv4 address range, in CIDR notation. The most specific IP prefix that you can specify is /24. The
         * address range cannot overlap with another address range that you've brought to this or another Region.
         * </p>
         * 
         * @param cidr
         *        The public IPv4 address range, in CIDR notation. The most specific IP prefix that you can specify is
         *        /24. The address range cannot overlap with another address range that you've brought to this or
         *        another Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * A signed document that proves that you are authorized to bring the specified IP address range to Amazon using
         * BYOIP.
         * </p>
         * 
         * @param cidrAuthorizationContext
         *        A signed document that proves that you are authorized to bring the specified IP address range to
         *        Amazon using BYOIP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrAuthorizationContext(CidrAuthorizationContext cidrAuthorizationContext);

        /**
         * <p>
         * A signed document that proves that you are authorized to bring the specified IP address range to Amazon using
         * BYOIP.
         * </p>
         * This is a convenience that creates an instance of the {@link CidrAuthorizationContext.Builder} avoiding the
         * need to create one manually via {@link CidrAuthorizationContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link CidrAuthorizationContext.Builder#build()} is called immediately
         * and its result is passed to {@link #cidrAuthorizationContext(CidrAuthorizationContext)}.
         * 
         * @param cidrAuthorizationContext
         *        a consumer that will call methods on {@link CidrAuthorizationContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cidrAuthorizationContext(CidrAuthorizationContext)
         */
        default Builder cidrAuthorizationContext(Consumer<CidrAuthorizationContext.Builder> cidrAuthorizationContext) {
            return cidrAuthorizationContext(CidrAuthorizationContext.builder().applyMutation(cidrAuthorizationContext).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlobalAcceleratorRequest.BuilderImpl implements Builder {
        private String cidr;

        private CidrAuthorizationContext cidrAuthorizationContext;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionByoipCidrRequest model) {
            super(model);
            cidr(model.cidr);
            cidrAuthorizationContext(model.cidrAuthorizationContext);
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        @Transient
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final CidrAuthorizationContext.Builder getCidrAuthorizationContext() {
            return cidrAuthorizationContext != null ? cidrAuthorizationContext.toBuilder() : null;
        }

        public final void setCidrAuthorizationContext(CidrAuthorizationContext.BuilderImpl cidrAuthorizationContext) {
            this.cidrAuthorizationContext = cidrAuthorizationContext != null ? cidrAuthorizationContext.build() : null;
        }

        @Override
        @Transient
        public final Builder cidrAuthorizationContext(CidrAuthorizationContext cidrAuthorizationContext) {
            this.cidrAuthorizationContext = cidrAuthorizationContext;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ProvisionByoipCidrRequest build() {
            return new ProvisionByoipCidrRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
