/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveCustomRoutingEndpointsRequest extends GlobalAcceleratorRequest implements
        ToCopyableBuilder<RemoveCustomRoutingEndpointsRequest.Builder, RemoveCustomRoutingEndpointsRequest> {
    private static final SdkField<List<String>> ENDPOINT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EndpointIds")
            .getter(getter(RemoveCustomRoutingEndpointsRequest::endpointIds))
            .setter(setter(Builder::endpointIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENDPOINT_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointGroupArn").getter(getter(RemoveCustomRoutingEndpointsRequest::endpointGroupArn))
            .setter(setter(Builder::endpointGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_IDS_FIELD,
            ENDPOINT_GROUP_ARN_FIELD));

    private final List<String> endpointIds;

    private final String endpointGroupArn;

    private RemoveCustomRoutingEndpointsRequest(BuilderImpl builder) {
        super(builder);
        this.endpointIds = builder.endpointIds;
        this.endpointGroupArn = builder.endpointGroupArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the EndpointIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEndpointIds() {
        return endpointIds != null && !(endpointIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs for the endpoints. For custom routing accelerators, endpoint IDs are the virtual private cloud (VPC)
     * subnet IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpointIds} method.
     * </p>
     * 
     * @return The IDs for the endpoints. For custom routing accelerators, endpoint IDs are the virtual private cloud
     *         (VPC) subnet IDs.
     */
    public final List<String> endpointIds() {
        return endpointIds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the endpoint group to remove endpoints from.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the endpoint group to remove endpoints from.
     */
    public final String endpointGroupArn() {
        return endpointGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpointIds() ? endpointIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(endpointGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveCustomRoutingEndpointsRequest)) {
            return false;
        }
        RemoveCustomRoutingEndpointsRequest other = (RemoveCustomRoutingEndpointsRequest) obj;
        return hasEndpointIds() == other.hasEndpointIds() && Objects.equals(endpointIds(), other.endpointIds())
                && Objects.equals(endpointGroupArn(), other.endpointGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemoveCustomRoutingEndpointsRequest")
                .add("EndpointIds", hasEndpointIds() ? endpointIds() : null).add("EndpointGroupArn", endpointGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointIds":
            return Optional.ofNullable(clazz.cast(endpointIds()));
        case "EndpointGroupArn":
            return Optional.ofNullable(clazz.cast(endpointGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveCustomRoutingEndpointsRequest, T> g) {
        return obj -> g.apply((RemoveCustomRoutingEndpointsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RemoveCustomRoutingEndpointsRequest> {
        /**
         * <p>
         * The IDs for the endpoints. For custom routing accelerators, endpoint IDs are the virtual private cloud (VPC)
         * subnet IDs.
         * </p>
         * 
         * @param endpointIds
         *        The IDs for the endpoints. For custom routing accelerators, endpoint IDs are the virtual private cloud
         *        (VPC) subnet IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointIds(Collection<String> endpointIds);

        /**
         * <p>
         * The IDs for the endpoints. For custom routing accelerators, endpoint IDs are the virtual private cloud (VPC)
         * subnet IDs.
         * </p>
         * 
         * @param endpointIds
         *        The IDs for the endpoints. For custom routing accelerators, endpoint IDs are the virtual private cloud
         *        (VPC) subnet IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointIds(String... endpointIds);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the endpoint group to remove endpoints from.
         * </p>
         * 
         * @param endpointGroupArn
         *        The Amazon Resource Name (ARN) of the endpoint group to remove endpoints from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointGroupArn(String endpointGroupArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlobalAcceleratorRequest.BuilderImpl implements Builder {
        private List<String> endpointIds = DefaultSdkAutoConstructList.getInstance();

        private String endpointGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveCustomRoutingEndpointsRequest model) {
            super(model);
            endpointIds(model.endpointIds);
            endpointGroupArn(model.endpointGroupArn);
        }

        public final Collection<String> getEndpointIds() {
            if (endpointIds instanceof SdkAutoConstructList) {
                return null;
            }
            return endpointIds;
        }

        public final void setEndpointIds(Collection<String> endpointIds) {
            this.endpointIds = EndpointIdsCopier.copy(endpointIds);
        }

        @Override
        @Transient
        public final Builder endpointIds(Collection<String> endpointIds) {
            this.endpointIds = EndpointIdsCopier.copy(endpointIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder endpointIds(String... endpointIds) {
            endpointIds(Arrays.asList(endpointIds));
            return this;
        }

        public final String getEndpointGroupArn() {
            return endpointGroupArn;
        }

        public final void setEndpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
        }

        @Override
        @Transient
        public final Builder endpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveCustomRoutingEndpointsRequest build() {
            return new RemoveCustomRoutingEndpointsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
