/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type for the set of IP addresses for an accelerator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpSet implements SdkPojo, Serializable, ToCopyableBuilder<IpSet.Builder, IpSet> {
    private static final SdkField<String> IP_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpFamily").getter(getter(IpSet::ipFamily)).setter(setter(Builder::ipFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpFamily").build()).build();

    private static final SdkField<List<String>> IP_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IpAddresses")
            .getter(getter(IpSet::ipAddresses))
            .setter(setter(Builder::ipAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_FAMILY_FIELD,
            IP_ADDRESSES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipFamily;

    private final List<String> ipAddresses;

    private IpSet(BuilderImpl builder) {
        this.ipFamily = builder.ipFamily;
        this.ipAddresses = builder.ipAddresses;
    }

    /**
     * <p>
     * The types of IP addresses included in this IP set.
     * </p>
     * 
     * @return The types of IP addresses included in this IP set.
     */
    public final String ipFamily() {
        return ipFamily;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpAddresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpAddresses() {
        return ipAddresses != null && !(ipAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of IP addresses in the IP address set. An IP address set can have a maximum of two IP addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpAddresses} method.
     * </p>
     * 
     * @return The array of IP addresses in the IP address set. An IP address set can have a maximum of two IP
     *         addresses.
     */
    public final List<String> ipAddresses() {
        return ipAddresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipFamily());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpAddresses() ? ipAddresses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpSet)) {
            return false;
        }
        IpSet other = (IpSet) obj;
        return Objects.equals(ipFamily(), other.ipFamily()) && hasIpAddresses() == other.hasIpAddresses()
                && Objects.equals(ipAddresses(), other.ipAddresses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpSet").add("IpFamily", ipFamily()).add("IpAddresses", hasIpAddresses() ? ipAddresses() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpFamily":
            return Optional.ofNullable(clazz.cast(ipFamily()));
        case "IpAddresses":
            return Optional.ofNullable(clazz.cast(ipAddresses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpSet, T> g) {
        return obj -> g.apply((IpSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpSet> {
        /**
         * <p>
         * The types of IP addresses included in this IP set.
         * </p>
         * 
         * @param ipFamily
         *        The types of IP addresses included in this IP set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipFamily(String ipFamily);

        /**
         * <p>
         * The array of IP addresses in the IP address set. An IP address set can have a maximum of two IP addresses.
         * </p>
         * 
         * @param ipAddresses
         *        The array of IP addresses in the IP address set. An IP address set can have a maximum of two IP
         *        addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddresses(Collection<String> ipAddresses);

        /**
         * <p>
         * The array of IP addresses in the IP address set. An IP address set can have a maximum of two IP addresses.
         * </p>
         * 
         * @param ipAddresses
         *        The array of IP addresses in the IP address set. An IP address set can have a maximum of two IP
         *        addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddresses(String... ipAddresses);
    }

    static final class BuilderImpl implements Builder {
        private String ipFamily;

        private List<String> ipAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpSet model) {
            ipFamily(model.ipFamily);
            ipAddresses(model.ipAddresses);
        }

        public final String getIpFamily() {
            return ipFamily;
        }

        public final void setIpFamily(String ipFamily) {
            this.ipFamily = ipFamily;
        }

        @Override
        public final Builder ipFamily(String ipFamily) {
            this.ipFamily = ipFamily;
            return this;
        }

        public final Collection<String> getIpAddresses() {
            if (ipAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return ipAddresses;
        }

        public final void setIpAddresses(Collection<String> ipAddresses) {
            this.ipAddresses = IpAddressesCopier.copy(ipAddresses);
        }

        @Override
        public final Builder ipAddresses(Collection<String> ipAddresses) {
            this.ipAddresses = IpAddressesCopier.copy(ipAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipAddresses(String... ipAddresses) {
            ipAddresses(Arrays.asList(ipAddresses));
            return this;
        }

        @Override
        public IpSet build() {
            return new IpSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
