/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AllowCustomRoutingTrafficRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AllowCustomRoutingTrafficResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeprovisionByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeprovisionByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListListenersRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.RemoveCustomRoutingEndpointsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.RemoveCustomRoutingEndpointsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.TagResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.TagResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UntagResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UntagResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListAcceleratorsPublisher;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListByoipCidrsPublisher;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingAcceleratorsPublisher;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingEndpointGroupsPublisher;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingListenersPublisher;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsByDestinationPublisher;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsPublisher;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListEndpointGroupsPublisher;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListListenersPublisher;

/**
 * Service client for accessing AWS Global Accelerator asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>Global Accelerator</fullname>
 * <p>
 * This is the <i>Global Accelerator API Reference</i>. This guide is for developers who need detailed information about
 * Global Accelerator API actions, data types, and errors. For more information about Global Accelerator features, see
 * the <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/what-is-global-accelerator.html">Global
 * Accelerator Developer Guide</a>.
 * </p>
 * <p>
 * Global Accelerator is a service in which you create <i>accelerators</i> to improve the performance of your
 * applications for local and global users. Depending on the type of accelerator you choose, you can gain additional
 * benefits.
 * </p>
 * <ul>
 * <li>
 * <p>
 * By using a standard accelerator, you can improve availability of your internet applications that are used by a global
 * audience. With a standard accelerator, Global Accelerator directs traffic to optimal endpoints over the Amazon Web
 * Services global network.
 * </p>
 * </li>
 * <li>
 * <p>
 * For other scenarios, you might choose a custom routing accelerator. With a custom routing accelerator, you can use
 * application logic to directly map one or more users to a specific endpoint among many endpoints.
 * </p>
 * </li>
 * </ul>
 * <important>
 * <p>
 * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you must
 * specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for example,
 * specify <code>--region us-west-2</code> on AWS CLI commands.
 * </p>
 * </important>
 * <p>
 * By default, Global Accelerator provides you with static IP addresses that you associate with your accelerator. The
 * static IP addresses are anycast from the Amazon Web Services edge network. For IPv4, Global Accelerator provides two
 * static IPv4 addresses. For dual-stack, Global Accelerator provides a total of four addresses: two static IPv4
 * addresses and two static IPv6 addresses. With a standard accelerator for IPv4, instead of using the addresses that
 * Global Accelerator provides, you can configure these entry points to be IPv4 addresses from your own IP address
 * ranges that you bring toGlobal Accelerator (BYOIP).
 * </p>
 * <p>
 * For a standard accelerator, they distribute incoming application traffic across multiple endpoint resources in
 * multiple Amazon Web Services Regions , which increases the availability of your applications. Endpoints for standard
 * accelerators can be Network Load Balancers, Application Load Balancers, Amazon EC2 instances, or Elastic IP addresses
 * that are located in one Amazon Web Services Region or multiple Amazon Web Services Regions. For custom routing
 * accelerators, you map traffic that arrives to the static IP addresses to specific Amazon EC2 servers in endpoints
 * that are virtual private cloud (VPC) subnets.
 * </p>
 * <important>
 * <p>
 * The static IP addresses remain assigned to your accelerator for as long as it exists, even if you disable the
 * accelerator and it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the
 * static IP addresses that are assigned to it, so you can no longer route traffic by using them. You can use IAM
 * policies like tag-based permissions with Global Accelerator to limit the users who have permissions to delete an
 * accelerator. For more information, see <a
 * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/access-control-manage-access-tag-policies.html"
 * >Tag-based policies</a>.
 * </p>
 * </important>
 * <p>
 * For standard accelerators, Global Accelerator uses the Amazon Web Services global network to route traffic to the
 * optimal regional endpoint based on health, client location, and policies that you configure. The service reacts
 * instantly to changes in health or configuration to ensure that internet traffic from clients is always directed to
 * healthy endpoints.
 * </p>
 * <p>
 * For more information about understanding and using Global Accelerator, see the <a
 * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/what-is-global-accelerator.html">Global Accelerator
 * Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GlobalAcceleratorAsyncClient extends SdkClient {
    String SERVICE_NAME = "globalaccelerator";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "globalaccelerator";

    /**
     * Create a {@link GlobalAcceleratorAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GlobalAcceleratorAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GlobalAcceleratorAsyncClient}.
     */
    static GlobalAcceleratorAsyncClientBuilder builder() {
        return new DefaultGlobalAcceleratorAsyncClientBuilder();
    }

    /**
     * <p>
     * Associate a virtual private cloud (VPC) subnet endpoint with your custom routing accelerator.
     * </p>
     * <p>
     * The listener port range must be large enough to support the number of IP addresses that can be specified in your
     * subnet. The number of ports required is: subnet size times the number of ports per destination EC2 instances. For
     * example, a subnet defined as /24 requires a listener port range of at least 255 ports.
     * </p>
     * <p>
     * Note: You must have enough remaining listener ports available to map to the subnet ports, or the call will fail
     * with a LimitExceededException.
     * </p>
     * <p>
     * By default, all destinations in a subnet in a custom routing accelerator cannot receive traffic. To enable all
     * destinations to receive traffic, or to specify individual port mappings that can receive traffic, see the <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html">
     * AllowCustomRoutingTraffic</a> operation.
     * </p>
     *
     * @param addCustomRoutingEndpointsRequest
     * @return A Java Future containing the result of the AddCustomRoutingEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EndpointAlreadyExistsException The endpoint that you specified doesn't exist.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>ConflictException You can't use both of those options.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.AddCustomRoutingEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AddCustomRoutingEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddCustomRoutingEndpointsResponse> addCustomRoutingEndpoints(
            AddCustomRoutingEndpointsRequest addCustomRoutingEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate a virtual private cloud (VPC) subnet endpoint with your custom routing accelerator.
     * </p>
     * <p>
     * The listener port range must be large enough to support the number of IP addresses that can be specified in your
     * subnet. The number of ports required is: subnet size times the number of ports per destination EC2 instances. For
     * example, a subnet defined as /24 requires a listener port range of at least 255 ports.
     * </p>
     * <p>
     * Note: You must have enough remaining listener ports available to map to the subnet ports, or the call will fail
     * with a LimitExceededException.
     * </p>
     * <p>
     * By default, all destinations in a subnet in a custom routing accelerator cannot receive traffic. To enable all
     * destinations to receive traffic, or to specify individual port mappings that can receive traffic, see the <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html">
     * AllowCustomRoutingTraffic</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddCustomRoutingEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link AddCustomRoutingEndpointsRequest#builder()}
     * </p>
     *
     * @param addCustomRoutingEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link AddCustomRoutingEndpointsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddCustomRoutingEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EndpointAlreadyExistsException The endpoint that you specified doesn't exist.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>ConflictException You can't use both of those options.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.AddCustomRoutingEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AddCustomRoutingEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddCustomRoutingEndpointsResponse> addCustomRoutingEndpoints(
            Consumer<AddCustomRoutingEndpointsRequest.Builder> addCustomRoutingEndpointsRequest) {
        return addCustomRoutingEndpoints(AddCustomRoutingEndpointsRequest.builder()
                .applyMutation(addCustomRoutingEndpointsRequest).build());
    }

    /**
     * <p>
     * Advertises an IPv4 address range that is provisioned for use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP). It can take a few minutes before traffic to the specified addresses starts
     * routing to Amazon Web Services because of propagation delays.
     * </p>
     * <p>
     * To stop advertising the BYOIP address range, use <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html"> WithdrawByoipCidr</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param advertiseByoipCidrRequest
     * @return A Java Future containing the result of the AdvertiseByoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>ByoipCidrNotFoundException The CIDR that you specified was not found or is incorrect.</li>
     *         <li>IncorrectCidrStateException The CIDR that you specified is not valid for this action. For example,
     *         the state of the CIDR might be incorrect for this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.AdvertiseByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AdvertiseByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdvertiseByoipCidrResponse> advertiseByoipCidr(AdvertiseByoipCidrRequest advertiseByoipCidrRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Advertises an IPv4 address range that is provisioned for use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP). It can take a few minutes before traffic to the specified addresses starts
     * routing to Amazon Web Services because of propagation delays.
     * </p>
     * <p>
     * To stop advertising the BYOIP address range, use <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html"> WithdrawByoipCidr</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdvertiseByoipCidrRequest.Builder} avoiding the
     * need to create one manually via {@link AdvertiseByoipCidrRequest#builder()}
     * </p>
     *
     * @param advertiseByoipCidrRequest
     *        A {@link Consumer} that will call methods on {@link AdvertiseByoipCidrRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AdvertiseByoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>ByoipCidrNotFoundException The CIDR that you specified was not found or is incorrect.</li>
     *         <li>IncorrectCidrStateException The CIDR that you specified is not valid for this action. For example,
     *         the state of the CIDR might be incorrect for this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.AdvertiseByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AdvertiseByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdvertiseByoipCidrResponse> advertiseByoipCidr(
            Consumer<AdvertiseByoipCidrRequest.Builder> advertiseByoipCidrRequest) {
        return advertiseByoipCidr(AdvertiseByoipCidrRequest.builder().applyMutation(advertiseByoipCidrRequest).build());
    }

    /**
     * <p>
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that can receive
     * traffic for a custom routing accelerator. You can allow traffic to all destinations in the subnet endpoint, or
     * allow traffic to a specified list of destination IP addresses and ports in the subnet. Note that you cannot
     * specify IP addresses or ports outside of the range that you configured for the endpoint group.
     * </p>
     * <p>
     * After you make changes, you can verify that the updates are complete by checking the status of your accelerator:
     * the status changes from IN_PROGRESS to DEPLOYED.
     * </p>
     *
     * @param allowCustomRoutingTrafficRequest
     * @return A Java Future containing the result of the AllowCustomRoutingTraffic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.AllowCustomRoutingTraffic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AllowCustomRoutingTraffic"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AllowCustomRoutingTrafficResponse> allowCustomRoutingTraffic(
            AllowCustomRoutingTrafficRequest allowCustomRoutingTrafficRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that can receive
     * traffic for a custom routing accelerator. You can allow traffic to all destinations in the subnet endpoint, or
     * allow traffic to a specified list of destination IP addresses and ports in the subnet. Note that you cannot
     * specify IP addresses or ports outside of the range that you configured for the endpoint group.
     * </p>
     * <p>
     * After you make changes, you can verify that the updates are complete by checking the status of your accelerator:
     * the status changes from IN_PROGRESS to DEPLOYED.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AllowCustomRoutingTrafficRequest.Builder} avoiding
     * the need to create one manually via {@link AllowCustomRoutingTrafficRequest#builder()}
     * </p>
     *
     * @param allowCustomRoutingTrafficRequest
     *        A {@link Consumer} that will call methods on {@link AllowCustomRoutingTrafficRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AllowCustomRoutingTraffic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.AllowCustomRoutingTraffic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AllowCustomRoutingTraffic"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AllowCustomRoutingTrafficResponse> allowCustomRoutingTraffic(
            Consumer<AllowCustomRoutingTrafficRequest.Builder> allowCustomRoutingTrafficRequest) {
        return allowCustomRoutingTraffic(AllowCustomRoutingTrafficRequest.builder()
                .applyMutation(allowCustomRoutingTrafficRequest).build());
    }

    /**
     * <p>
     * Create an accelerator. An accelerator includes one or more listeners that process inbound connections and direct
     * traffic to one or more endpoint groups, each of which includes endpoints, such as Network Load Balancers.
     * </p>
     * <important>
     * <p>
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you
     * must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for
     * example, specify <code>--region us-west-2</code> on AWS CLI commands.
     * </p>
     * </important>
     *
     * @param createAcceleratorRequest
     * @return A Java Future containing the result of the CreateAccelerator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAcceleratorResponse> createAccelerator(CreateAcceleratorRequest createAcceleratorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an accelerator. An accelerator includes one or more listeners that process inbound connections and direct
     * traffic to one or more endpoint groups, each of which includes endpoints, such as Network Load Balancers.
     * </p>
     * <important>
     * <p>
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you
     * must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for
     * example, specify <code>--region us-west-2</code> on AWS CLI commands.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAcceleratorRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAcceleratorRequest#builder()}
     * </p>
     *
     * @param createAcceleratorRequest
     *        A {@link Consumer} that will call methods on {@link CreateAcceleratorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAccelerator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAcceleratorResponse> createAccelerator(
            Consumer<CreateAcceleratorRequest.Builder> createAcceleratorRequest) {
        return createAccelerator(CreateAcceleratorRequest.builder().applyMutation(createAcceleratorRequest).build());
    }

    /**
     * <p>
     * Create a custom routing accelerator. A custom routing accelerator directs traffic to one of possibly thousands of
     * Amazon EC2 instance destinations running in a single or multiple virtual private clouds (VPC) subnet endpoints.
     * </p>
     * <p>
     * Be aware that, by default, all destination EC2 instances in a VPC subnet endpoint cannot receive traffic. To
     * enable all destinations to receive traffic, or to specify individual port mappings that can receive traffic, see
     * the <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html">
     * AllowCustomRoutingTraffic</a> operation.
     * </p>
     * <important>
     * <p>
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you
     * must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for
     * example, specify <code>--region us-west-2</code> on AWS CLI commands.
     * </p>
     * </important>
     *
     * @param createCustomRoutingAcceleratorRequest
     * @return A Java Future containing the result of the CreateCustomRoutingAccelerator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomRoutingAcceleratorResponse> createCustomRoutingAccelerator(
            CreateCustomRoutingAcceleratorRequest createCustomRoutingAcceleratorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a custom routing accelerator. A custom routing accelerator directs traffic to one of possibly thousands of
     * Amazon EC2 instance destinations running in a single or multiple virtual private clouds (VPC) subnet endpoints.
     * </p>
     * <p>
     * Be aware that, by default, all destination EC2 instances in a VPC subnet endpoint cannot receive traffic. To
     * enable all destinations to receive traffic, or to specify individual port mappings that can receive traffic, see
     * the <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html">
     * AllowCustomRoutingTraffic</a> operation.
     * </p>
     * <important>
     * <p>
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you
     * must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for
     * example, specify <code>--region us-west-2</code> on AWS CLI commands.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomRoutingAcceleratorRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCustomRoutingAcceleratorRequest#builder()}
     * </p>
     *
     * @param createCustomRoutingAcceleratorRequest
     *        A {@link Consumer} that will call methods on {@link CreateCustomRoutingAcceleratorRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateCustomRoutingAccelerator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomRoutingAcceleratorResponse> createCustomRoutingAccelerator(
            Consumer<CreateCustomRoutingAcceleratorRequest.Builder> createCustomRoutingAcceleratorRequest) {
        return createCustomRoutingAccelerator(CreateCustomRoutingAcceleratorRequest.builder()
                .applyMutation(createCustomRoutingAcceleratorRequest).build());
    }

    /**
     * <p>
     * Create an endpoint group for the specified listener for a custom routing accelerator. An endpoint group is a
     * collection of endpoints in one Amazon Web Services Region.
     * </p>
     *
     * @param createCustomRoutingEndpointGroupRequest
     * @return A Java Future containing the result of the CreateCustomRoutingEndpointGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>EndpointGroupAlreadyExistsException The endpoint group that you specified already exists.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidPortRangeException The port numbers that you specified are not valid numbers or are not unique
     *         for this accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateCustomRoutingEndpointGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomRoutingEndpointGroupResponse> createCustomRoutingEndpointGroup(
            CreateCustomRoutingEndpointGroupRequest createCustomRoutingEndpointGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an endpoint group for the specified listener for a custom routing accelerator. An endpoint group is a
     * collection of endpoints in one Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomRoutingEndpointGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCustomRoutingEndpointGroupRequest#builder()}
     * </p>
     *
     * @param createCustomRoutingEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateCustomRoutingEndpointGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateCustomRoutingEndpointGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>EndpointGroupAlreadyExistsException The endpoint group that you specified already exists.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidPortRangeException The port numbers that you specified are not valid numbers or are not unique
     *         for this accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateCustomRoutingEndpointGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomRoutingEndpointGroupResponse> createCustomRoutingEndpointGroup(
            Consumer<CreateCustomRoutingEndpointGroupRequest.Builder> createCustomRoutingEndpointGroupRequest) {
        return createCustomRoutingEndpointGroup(CreateCustomRoutingEndpointGroupRequest.builder()
                .applyMutation(createCustomRoutingEndpointGroupRequest).build());
    }

    /**
     * <p>
     * Create a listener to process inbound connections from clients to a custom routing accelerator. Connections arrive
     * to assigned static IP addresses on the port range that you specify.
     * </p>
     *
     * @param createCustomRoutingListenerRequest
     * @return A Java Future containing the result of the CreateCustomRoutingListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InvalidPortRangeException The port numbers that you specified are not valid numbers or are not unique
     *         for this accelerator.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomRoutingListenerResponse> createCustomRoutingListener(
            CreateCustomRoutingListenerRequest createCustomRoutingListenerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a listener to process inbound connections from clients to a custom routing accelerator. Connections arrive
     * to assigned static IP addresses on the port range that you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomRoutingListenerRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCustomRoutingListenerRequest#builder()}
     * </p>
     *
     * @param createCustomRoutingListenerRequest
     *        A {@link Consumer} that will call methods on {@link CreateCustomRoutingListenerRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateCustomRoutingListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InvalidPortRangeException The port numbers that you specified are not valid numbers or are not unique
     *         for this accelerator.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomRoutingListenerResponse> createCustomRoutingListener(
            Consumer<CreateCustomRoutingListenerRequest.Builder> createCustomRoutingListenerRequest) {
        return createCustomRoutingListener(CreateCustomRoutingListenerRequest.builder()
                .applyMutation(createCustomRoutingListenerRequest).build());
    }

    /**
     * <p>
     * Create an endpoint group for the specified listener. An endpoint group is a collection of endpoints in one Amazon
     * Web Services Region. A resource must be valid and active when you add it as an endpoint.
     * </p>
     *
     * @param createEndpointGroupRequest
     * @return A Java Future containing the result of the CreateEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>EndpointGroupAlreadyExistsException The endpoint group that you specified already exists.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEndpointGroupResponse> createEndpointGroup(
            CreateEndpointGroupRequest createEndpointGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an endpoint group for the specified listener. An endpoint group is a collection of endpoints in one Amazon
     * Web Services Region. A resource must be valid and active when you add it as an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEndpointGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEndpointGroupRequest#builder()}
     * </p>
     *
     * @param createEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateEndpointGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>EndpointGroupAlreadyExistsException The endpoint group that you specified already exists.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEndpointGroupResponse> createEndpointGroup(
            Consumer<CreateEndpointGroupRequest.Builder> createEndpointGroupRequest) {
        return createEndpointGroup(CreateEndpointGroupRequest.builder().applyMutation(createEndpointGroupRequest).build());
    }

    /**
     * <p>
     * Create a listener to process inbound connections from clients to an accelerator. Connections arrive to assigned
     * static IP addresses on a port, port range, or list of port ranges that you specify.
     * </p>
     *
     * @param createListenerRequest
     * @return A Java Future containing the result of the CreateListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InvalidPortRangeException The port numbers that you specified are not valid numbers or are not unique
     *         for this accelerator.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateListenerResponse> createListener(CreateListenerRequest createListenerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a listener to process inbound connections from clients to an accelerator. Connections arrive to assigned
     * static IP addresses on a port, port range, or list of port ranges that you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateListenerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateListenerRequest#builder()}
     * </p>
     *
     * @param createListenerRequest
     *        A {@link Consumer} that will call methods on {@link CreateListenerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InvalidPortRangeException The port numbers that you specified are not valid numbers or are not unique
     *         for this accelerator.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateListenerResponse> createListener(Consumer<CreateListenerRequest.Builder> createListenerRequest) {
        return createListener(CreateListenerRequest.builder().applyMutation(createListenerRequest).build());
    }

    /**
     * <p>
     * Delete an accelerator. Before you can delete an accelerator, you must disable it and remove all dependent
     * resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set
     * <code>Enabled</code> to false.
     * </p>
     * <important>
     * <p>
     * When you create an accelerator, by default, Global Accelerator provides you with a set of two static IP
     * addresses. Alternatively, you can bring your own IP address ranges to Global Accelerator and assign IP addresses
     * from those ranges.
     * </p>
     * <p>
     * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator
     * and it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the static
     * IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best
     * practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM
     * policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Identity and access
     * management</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * </important>
     *
     * @param deleteAcceleratorRequest
     * @return A Java Future containing the result of the DeleteAccelerator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>AcceleratorNotDisabledException The accelerator that you specified could not be disabled.</li>
     *         <li>AssociatedListenerFoundException The accelerator that you specified has a listener associated with
     *         it. You must remove all dependent resources from an accelerator before you can delete it.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAcceleratorResponse> deleteAccelerator(DeleteAcceleratorRequest deleteAcceleratorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an accelerator. Before you can delete an accelerator, you must disable it and remove all dependent
     * resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set
     * <code>Enabled</code> to false.
     * </p>
     * <important>
     * <p>
     * When you create an accelerator, by default, Global Accelerator provides you with a set of two static IP
     * addresses. Alternatively, you can bring your own IP address ranges to Global Accelerator and assign IP addresses
     * from those ranges.
     * </p>
     * <p>
     * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator
     * and it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the static
     * IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best
     * practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM
     * policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Identity and access
     * management</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAcceleratorRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAcceleratorRequest#builder()}
     * </p>
     *
     * @param deleteAcceleratorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAcceleratorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAccelerator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>AcceleratorNotDisabledException The accelerator that you specified could not be disabled.</li>
     *         <li>AssociatedListenerFoundException The accelerator that you specified has a listener associated with
     *         it. You must remove all dependent resources from an accelerator before you can delete it.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAcceleratorResponse> deleteAccelerator(
            Consumer<DeleteAcceleratorRequest.Builder> deleteAcceleratorRequest) {
        return deleteAccelerator(DeleteAcceleratorRequest.builder().applyMutation(deleteAcceleratorRequest).build());
    }

    /**
     * <p>
     * Delete a custom routing accelerator. Before you can delete an accelerator, you must disable it and remove all
     * dependent resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set
     * <code>Enabled</code> to false.
     * </p>
     * <important>
     * <p>
     * When you create a custom routing accelerator, by default, Global Accelerator provides you with a set of two
     * static IP addresses.
     * </p>
     * <p>
     * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator
     * and it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the static
     * IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best
     * practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM
     * policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Identity and access
     * management</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * </important>
     *
     * @param deleteCustomRoutingAcceleratorRequest
     * @return A Java Future containing the result of the DeleteCustomRoutingAccelerator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>AcceleratorNotDisabledException The accelerator that you specified could not be disabled.</li>
     *         <li>AssociatedListenerFoundException The accelerator that you specified has a listener associated with
     *         it. You must remove all dependent resources from an accelerator before you can delete it.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomRoutingAcceleratorResponse> deleteCustomRoutingAccelerator(
            DeleteCustomRoutingAcceleratorRequest deleteCustomRoutingAcceleratorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a custom routing accelerator. Before you can delete an accelerator, you must disable it and remove all
     * dependent resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set
     * <code>Enabled</code> to false.
     * </p>
     * <important>
     * <p>
     * When you create a custom routing accelerator, by default, Global Accelerator provides you with a set of two
     * static IP addresses.
     * </p>
     * <p>
     * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator
     * and it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the static
     * IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best
     * practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM
     * policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Identity and access
     * management</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomRoutingAcceleratorRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCustomRoutingAcceleratorRequest#builder()}
     * </p>
     *
     * @param deleteCustomRoutingAcceleratorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCustomRoutingAcceleratorRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteCustomRoutingAccelerator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>AcceleratorNotDisabledException The accelerator that you specified could not be disabled.</li>
     *         <li>AssociatedListenerFoundException The accelerator that you specified has a listener associated with
     *         it. You must remove all dependent resources from an accelerator before you can delete it.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomRoutingAcceleratorResponse> deleteCustomRoutingAccelerator(
            Consumer<DeleteCustomRoutingAcceleratorRequest.Builder> deleteCustomRoutingAcceleratorRequest) {
        return deleteCustomRoutingAccelerator(DeleteCustomRoutingAcceleratorRequest.builder()
                .applyMutation(deleteCustomRoutingAcceleratorRequest).build());
    }

    /**
     * <p>
     * Delete an endpoint group from a listener for a custom routing accelerator.
     * </p>
     *
     * @param deleteCustomRoutingEndpointGroupRequest
     * @return A Java Future containing the result of the DeleteCustomRoutingEndpointGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteCustomRoutingEndpointGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomRoutingEndpointGroupResponse> deleteCustomRoutingEndpointGroup(
            DeleteCustomRoutingEndpointGroupRequest deleteCustomRoutingEndpointGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an endpoint group from a listener for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomRoutingEndpointGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCustomRoutingEndpointGroupRequest#builder()}
     * </p>
     *
     * @param deleteCustomRoutingEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCustomRoutingEndpointGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteCustomRoutingEndpointGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteCustomRoutingEndpointGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomRoutingEndpointGroupResponse> deleteCustomRoutingEndpointGroup(
            Consumer<DeleteCustomRoutingEndpointGroupRequest.Builder> deleteCustomRoutingEndpointGroupRequest) {
        return deleteCustomRoutingEndpointGroup(DeleteCustomRoutingEndpointGroupRequest.builder()
                .applyMutation(deleteCustomRoutingEndpointGroupRequest).build());
    }

    /**
     * <p>
     * Delete a listener for a custom routing accelerator.
     * </p>
     *
     * @param deleteCustomRoutingListenerRequest
     * @return A Java Future containing the result of the DeleteCustomRoutingListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>AssociatedEndpointGroupFoundException The listener that you specified has an endpoint group
     *         associated with it. You must remove all dependent resources from a listener before you can delete it.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomRoutingListenerResponse> deleteCustomRoutingListener(
            DeleteCustomRoutingListenerRequest deleteCustomRoutingListenerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a listener for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomRoutingListenerRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCustomRoutingListenerRequest#builder()}
     * </p>
     *
     * @param deleteCustomRoutingListenerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCustomRoutingListenerRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteCustomRoutingListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>AssociatedEndpointGroupFoundException The listener that you specified has an endpoint group
     *         associated with it. You must remove all dependent resources from a listener before you can delete it.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomRoutingListenerResponse> deleteCustomRoutingListener(
            Consumer<DeleteCustomRoutingListenerRequest.Builder> deleteCustomRoutingListenerRequest) {
        return deleteCustomRoutingListener(DeleteCustomRoutingListenerRequest.builder()
                .applyMutation(deleteCustomRoutingListenerRequest).build());
    }

    /**
     * <p>
     * Delete an endpoint group from a listener.
     * </p>
     *
     * @param deleteEndpointGroupRequest
     * @return A Java Future containing the result of the DeleteEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEndpointGroupResponse> deleteEndpointGroup(
            DeleteEndpointGroupRequest deleteEndpointGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an endpoint group from a listener.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEndpointGroupRequest#builder()}
     * </p>
     *
     * @param deleteEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEndpointGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEndpointGroupResponse> deleteEndpointGroup(
            Consumer<DeleteEndpointGroupRequest.Builder> deleteEndpointGroupRequest) {
        return deleteEndpointGroup(DeleteEndpointGroupRequest.builder().applyMutation(deleteEndpointGroupRequest).build());
    }

    /**
     * <p>
     * Delete a listener from an accelerator.
     * </p>
     *
     * @param deleteListenerRequest
     * @return A Java Future containing the result of the DeleteListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>AssociatedEndpointGroupFoundException The listener that you specified has an endpoint group
     *         associated with it. You must remove all dependent resources from a listener before you can delete it.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteListenerResponse> deleteListener(DeleteListenerRequest deleteListenerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a listener from an accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteListenerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteListenerRequest#builder()}
     * </p>
     *
     * @param deleteListenerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteListenerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>AssociatedEndpointGroupFoundException The listener that you specified has an endpoint group
     *         associated with it. You must remove all dependent resources from a listener before you can delete it.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteListenerResponse> deleteListener(Consumer<DeleteListenerRequest.Builder> deleteListenerRequest) {
        return deleteListener(DeleteListenerRequest.builder().applyMutation(deleteListenerRequest).build());
    }

    /**
     * <p>
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that cannot
     * receive traffic for a custom routing accelerator. You can deny traffic to all destinations in the VPC endpoint,
     * or deny traffic to a specified list of destination IP addresses and ports. Note that you cannot specify IP
     * addresses or ports outside of the range that you configured for the endpoint group.
     * </p>
     * <p>
     * After you make changes, you can verify that the updates are complete by checking the status of your accelerator:
     * the status changes from IN_PROGRESS to DEPLOYED.
     * </p>
     *
     * @param denyCustomRoutingTrafficRequest
     * @return A Java Future containing the result of the DenyCustomRoutingTraffic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DenyCustomRoutingTraffic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DenyCustomRoutingTraffic"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DenyCustomRoutingTrafficResponse> denyCustomRoutingTraffic(
            DenyCustomRoutingTrafficRequest denyCustomRoutingTrafficRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that cannot
     * receive traffic for a custom routing accelerator. You can deny traffic to all destinations in the VPC endpoint,
     * or deny traffic to a specified list of destination IP addresses and ports. Note that you cannot specify IP
     * addresses or ports outside of the range that you configured for the endpoint group.
     * </p>
     * <p>
     * After you make changes, you can verify that the updates are complete by checking the status of your accelerator:
     * the status changes from IN_PROGRESS to DEPLOYED.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DenyCustomRoutingTrafficRequest.Builder} avoiding
     * the need to create one manually via {@link DenyCustomRoutingTrafficRequest#builder()}
     * </p>
     *
     * @param denyCustomRoutingTrafficRequest
     *        A {@link Consumer} that will call methods on {@link DenyCustomRoutingTrafficRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DenyCustomRoutingTraffic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DenyCustomRoutingTraffic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DenyCustomRoutingTraffic"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DenyCustomRoutingTrafficResponse> denyCustomRoutingTraffic(
            Consumer<DenyCustomRoutingTrafficRequest.Builder> denyCustomRoutingTrafficRequest) {
        return denyCustomRoutingTraffic(DenyCustomRoutingTrafficRequest.builder().applyMutation(denyCustomRoutingTrafficRequest)
                .build());
    }

    /**
     * <p>
     * Releases the specified address range that you provisioned to use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     * </p>
     * <p>
     * Before you can release an address range, you must stop advertising it by using <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html">WithdrawByoipCidr</a> and
     * you must not have any accelerators that are using static IP addresses allocated from its address range.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param deprovisionByoipCidrRequest
     * @return A Java Future containing the result of the DeprovisionByoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>ByoipCidrNotFoundException The CIDR that you specified was not found or is incorrect.</li>
     *         <li>IncorrectCidrStateException The CIDR that you specified is not valid for this action. For example,
     *         the state of the CIDR might be incorrect for this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeprovisionByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeprovisionByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeprovisionByoipCidrResponse> deprovisionByoipCidr(
            DeprovisionByoipCidrRequest deprovisionByoipCidrRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Releases the specified address range that you provisioned to use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     * </p>
     * <p>
     * Before you can release an address range, you must stop advertising it by using <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html">WithdrawByoipCidr</a> and
     * you must not have any accelerators that are using static IP addresses allocated from its address range.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeprovisionByoipCidrRequest.Builder} avoiding the
     * need to create one manually via {@link DeprovisionByoipCidrRequest#builder()}
     * </p>
     *
     * @param deprovisionByoipCidrRequest
     *        A {@link Consumer} that will call methods on {@link DeprovisionByoipCidrRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeprovisionByoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>ByoipCidrNotFoundException The CIDR that you specified was not found or is incorrect.</li>
     *         <li>IncorrectCidrStateException The CIDR that you specified is not valid for this action. For example,
     *         the state of the CIDR might be incorrect for this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeprovisionByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeprovisionByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeprovisionByoipCidrResponse> deprovisionByoipCidr(
            Consumer<DeprovisionByoipCidrRequest.Builder> deprovisionByoipCidrRequest) {
        return deprovisionByoipCidr(DeprovisionByoipCidrRequest.builder().applyMutation(deprovisionByoipCidrRequest).build());
    }

    /**
     * <p>
     * Describe an accelerator.
     * </p>
     *
     * @param describeAcceleratorRequest
     * @return A Java Future containing the result of the DescribeAccelerator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAcceleratorResponse> describeAccelerator(
            DescribeAcceleratorRequest describeAcceleratorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe an accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAcceleratorRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAcceleratorRequest#builder()}
     * </p>
     *
     * @param describeAcceleratorRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAcceleratorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAccelerator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAcceleratorResponse> describeAccelerator(
            Consumer<DescribeAcceleratorRequest.Builder> describeAcceleratorRequest) {
        return describeAccelerator(DescribeAcceleratorRequest.builder().applyMutation(describeAcceleratorRequest).build());
    }

    /**
     * <p>
     * Describe the attributes of an accelerator.
     * </p>
     *
     * @param describeAcceleratorAttributesRequest
     * @return A Java Future containing the result of the DescribeAcceleratorAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeAcceleratorAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAcceleratorAttributesResponse> describeAcceleratorAttributes(
            DescribeAcceleratorAttributesRequest describeAcceleratorAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe the attributes of an accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAcceleratorAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAcceleratorAttributesRequest#builder()}
     * </p>
     *
     * @param describeAcceleratorAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAcceleratorAttributesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeAcceleratorAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeAcceleratorAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAcceleratorAttributesResponse> describeAcceleratorAttributes(
            Consumer<DescribeAcceleratorAttributesRequest.Builder> describeAcceleratorAttributesRequest) {
        return describeAcceleratorAttributes(DescribeAcceleratorAttributesRequest.builder()
                .applyMutation(describeAcceleratorAttributesRequest).build());
    }

    /**
     * <p>
     * Describe a custom routing accelerator.
     * </p>
     *
     * @param describeCustomRoutingAcceleratorRequest
     * @return A Java Future containing the result of the DescribeCustomRoutingAccelerator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCustomRoutingAcceleratorResponse> describeCustomRoutingAccelerator(
            DescribeCustomRoutingAcceleratorRequest describeCustomRoutingAcceleratorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCustomRoutingAcceleratorRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCustomRoutingAcceleratorRequest#builder()}
     * </p>
     *
     * @param describeCustomRoutingAcceleratorRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCustomRoutingAcceleratorRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeCustomRoutingAccelerator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCustomRoutingAcceleratorResponse> describeCustomRoutingAccelerator(
            Consumer<DescribeCustomRoutingAcceleratorRequest.Builder> describeCustomRoutingAcceleratorRequest) {
        return describeCustomRoutingAccelerator(DescribeCustomRoutingAcceleratorRequest.builder()
                .applyMutation(describeCustomRoutingAcceleratorRequest).build());
    }

    /**
     * <p>
     * Describe the attributes of a custom routing accelerator.
     * </p>
     *
     * @param describeCustomRoutingAcceleratorAttributesRequest
     * @return A Java Future containing the result of the DescribeCustomRoutingAcceleratorAttributes operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeCustomRoutingAcceleratorAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCustomRoutingAcceleratorAttributesResponse> describeCustomRoutingAcceleratorAttributes(
            DescribeCustomRoutingAcceleratorAttributesRequest describeCustomRoutingAcceleratorAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe the attributes of a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeCustomRoutingAcceleratorAttributesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeCustomRoutingAcceleratorAttributesRequest#builder()}
     * </p>
     *
     * @param describeCustomRoutingAcceleratorAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeCustomRoutingAcceleratorAttributesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeCustomRoutingAcceleratorAttributes operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeCustomRoutingAcceleratorAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCustomRoutingAcceleratorAttributesResponse> describeCustomRoutingAcceleratorAttributes(
            Consumer<DescribeCustomRoutingAcceleratorAttributesRequest.Builder> describeCustomRoutingAcceleratorAttributesRequest) {
        return describeCustomRoutingAcceleratorAttributes(DescribeCustomRoutingAcceleratorAttributesRequest.builder()
                .applyMutation(describeCustomRoutingAcceleratorAttributesRequest).build());
    }

    /**
     * <p>
     * Describe an endpoint group for a custom routing accelerator.
     * </p>
     *
     * @param describeCustomRoutingEndpointGroupRequest
     * @return A Java Future containing the result of the DescribeCustomRoutingEndpointGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeCustomRoutingEndpointGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCustomRoutingEndpointGroupResponse> describeCustomRoutingEndpointGroup(
            DescribeCustomRoutingEndpointGroupRequest describeCustomRoutingEndpointGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe an endpoint group for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCustomRoutingEndpointGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCustomRoutingEndpointGroupRequest#builder()}
     * </p>
     *
     * @param describeCustomRoutingEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCustomRoutingEndpointGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeCustomRoutingEndpointGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeCustomRoutingEndpointGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCustomRoutingEndpointGroupResponse> describeCustomRoutingEndpointGroup(
            Consumer<DescribeCustomRoutingEndpointGroupRequest.Builder> describeCustomRoutingEndpointGroupRequest) {
        return describeCustomRoutingEndpointGroup(DescribeCustomRoutingEndpointGroupRequest.builder()
                .applyMutation(describeCustomRoutingEndpointGroupRequest).build());
    }

    /**
     * <p>
     * The description of a listener for a custom routing accelerator.
     * </p>
     *
     * @param describeCustomRoutingListenerRequest
     * @return A Java Future containing the result of the DescribeCustomRoutingListener operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCustomRoutingListenerResponse> describeCustomRoutingListener(
            DescribeCustomRoutingListenerRequest describeCustomRoutingListenerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The description of a listener for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCustomRoutingListenerRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCustomRoutingListenerRequest#builder()}
     * </p>
     *
     * @param describeCustomRoutingListenerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCustomRoutingListenerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeCustomRoutingListener operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCustomRoutingListenerResponse> describeCustomRoutingListener(
            Consumer<DescribeCustomRoutingListenerRequest.Builder> describeCustomRoutingListenerRequest) {
        return describeCustomRoutingListener(DescribeCustomRoutingListenerRequest.builder()
                .applyMutation(describeCustomRoutingListenerRequest).build());
    }

    /**
     * <p>
     * Describe an endpoint group.
     * </p>
     *
     * @param describeEndpointGroupRequest
     * @return A Java Future containing the result of the DescribeEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointGroupResponse> describeEndpointGroup(
            DescribeEndpointGroupRequest describeEndpointGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe an endpoint group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEndpointGroupRequest#builder()}
     * </p>
     *
     * @param describeEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointGroupResponse> describeEndpointGroup(
            Consumer<DescribeEndpointGroupRequest.Builder> describeEndpointGroupRequest) {
        return describeEndpointGroup(DescribeEndpointGroupRequest.builder().applyMutation(describeEndpointGroupRequest).build());
    }

    /**
     * <p>
     * Describe a listener.
     * </p>
     *
     * @param describeListenerRequest
     * @return A Java Future containing the result of the DescribeListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeListenerResponse> describeListener(DescribeListenerRequest describeListenerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe a listener.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeListenerRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeListenerRequest#builder()}
     * </p>
     *
     * @param describeListenerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeListenerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeListenerResponse> describeListener(
            Consumer<DescribeListenerRequest.Builder> describeListenerRequest) {
        return describeListener(DescribeListenerRequest.builder().applyMutation(describeListenerRequest).build());
    }

    /**
     * <p>
     * List the accelerators for an Amazon Web Services account.
     * </p>
     *
     * @param listAcceleratorsRequest
     * @return A Java Future containing the result of the ListAccelerators operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAcceleratorsResponse> listAccelerators(ListAcceleratorsRequest listAcceleratorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the accelerators for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAcceleratorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAcceleratorsRequest#builder()}
     * </p>
     *
     * @param listAcceleratorsRequest
     *        A {@link Consumer} that will call methods on {@link ListAcceleratorsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAccelerators operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAcceleratorsResponse> listAccelerators(
            Consumer<ListAcceleratorsRequest.Builder> listAcceleratorsRequest) {
        return listAccelerators(ListAcceleratorsRequest.builder().applyMutation(listAcceleratorsRequest).build());
    }

    /**
     * <p>
     * List the accelerators for an Amazon Web Services account.
     * </p>
     *
     * @return A Java Future containing the result of the ListAccelerators operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAcceleratorsResponse> listAccelerators() {
        return listAccelerators(ListAcceleratorsRequest.builder().build());
    }

    /**
     * <p>
     * List the accelerators for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccelerators(software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListAcceleratorsPublisher publisher = client.listAcceleratorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListAcceleratorsPublisher publisher = client.listAcceleratorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccelerators(software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAcceleratorsPublisher listAcceleratorsPaginator() {
        return listAcceleratorsPaginator(ListAcceleratorsRequest.builder().build());
    }

    /**
     * <p>
     * List the accelerators for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccelerators(software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListAcceleratorsPublisher publisher = client.listAcceleratorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListAcceleratorsPublisher publisher = client.listAcceleratorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccelerators(software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAcceleratorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAcceleratorsPublisher listAcceleratorsPaginator(ListAcceleratorsRequest listAcceleratorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the accelerators for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccelerators(software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListAcceleratorsPublisher publisher = client.listAcceleratorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListAcceleratorsPublisher publisher = client.listAcceleratorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccelerators(software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAcceleratorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAcceleratorsRequest#builder()}
     * </p>
     *
     * @param listAcceleratorsRequest
     *        A {@link Consumer} that will call methods on {@link ListAcceleratorsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAcceleratorsPublisher listAcceleratorsPaginator(Consumer<ListAcceleratorsRequest.Builder> listAcceleratorsRequest) {
        return listAcceleratorsPaginator(ListAcceleratorsRequest.builder().applyMutation(listAcceleratorsRequest).build());
    }

    /**
     * <p>
     * Lists the IP address ranges that were specified in calls to <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html">ProvisionByoipCidr</a>,
     * including the current state and a history of state changes.
     * </p>
     *
     * @param listByoipCidrsRequest
     * @return A Java Future containing the result of the ListByoipCidrs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListByoipCidrs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListByoipCidrs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListByoipCidrsResponse> listByoipCidrs(ListByoipCidrsRequest listByoipCidrsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IP address ranges that were specified in calls to <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html">ProvisionByoipCidr</a>,
     * including the current state and a history of state changes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListByoipCidrsRequest.Builder} avoiding the need to
     * create one manually via {@link ListByoipCidrsRequest#builder()}
     * </p>
     *
     * @param listByoipCidrsRequest
     *        A {@link Consumer} that will call methods on {@link ListByoipCidrsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListByoipCidrs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListByoipCidrs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListByoipCidrs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListByoipCidrsResponse> listByoipCidrs(Consumer<ListByoipCidrsRequest.Builder> listByoipCidrsRequest) {
        return listByoipCidrs(ListByoipCidrsRequest.builder().applyMutation(listByoipCidrsRequest).build());
    }

    /**
     * <p>
     * Lists the IP address ranges that were specified in calls to <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html">ProvisionByoipCidr</a>,
     * including the current state and a history of state changes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listByoipCidrs(software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListByoipCidrsPublisher publisher = client.listByoipCidrsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListByoipCidrsPublisher publisher = client.listByoipCidrsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listByoipCidrs(software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listByoipCidrsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListByoipCidrs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListByoipCidrs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListByoipCidrsPublisher listByoipCidrsPaginator(ListByoipCidrsRequest listByoipCidrsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IP address ranges that were specified in calls to <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html">ProvisionByoipCidr</a>,
     * including the current state and a history of state changes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listByoipCidrs(software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListByoipCidrsPublisher publisher = client.listByoipCidrsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListByoipCidrsPublisher publisher = client.listByoipCidrsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listByoipCidrs(software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListByoipCidrsRequest.Builder} avoiding the need to
     * create one manually via {@link ListByoipCidrsRequest#builder()}
     * </p>
     *
     * @param listByoipCidrsRequest
     *        A {@link Consumer} that will call methods on {@link ListByoipCidrsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListByoipCidrs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListByoipCidrs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListByoipCidrsPublisher listByoipCidrsPaginator(Consumer<ListByoipCidrsRequest.Builder> listByoipCidrsRequest) {
        return listByoipCidrsPaginator(ListByoipCidrsRequest.builder().applyMutation(listByoipCidrsRequest).build());
    }

    /**
     * <p>
     * List the custom routing accelerators for an Amazon Web Services account.
     * </p>
     *
     * @param listCustomRoutingAcceleratorsRequest
     * @return A Java Future containing the result of the ListCustomRoutingAccelerators operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomRoutingAcceleratorsResponse> listCustomRoutingAccelerators(
            ListCustomRoutingAcceleratorsRequest listCustomRoutingAcceleratorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the custom routing accelerators for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomRoutingAcceleratorsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCustomRoutingAcceleratorsRequest#builder()}
     * </p>
     *
     * @param listCustomRoutingAcceleratorsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomRoutingAcceleratorsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListCustomRoutingAccelerators operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomRoutingAcceleratorsResponse> listCustomRoutingAccelerators(
            Consumer<ListCustomRoutingAcceleratorsRequest.Builder> listCustomRoutingAcceleratorsRequest) {
        return listCustomRoutingAccelerators(ListCustomRoutingAcceleratorsRequest.builder()
                .applyMutation(listCustomRoutingAcceleratorsRequest).build());
    }

    /**
     * <p>
     * List the custom routing accelerators for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomRoutingAccelerators(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingAcceleratorsPublisher publisher = client.listCustomRoutingAcceleratorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingAcceleratorsPublisher publisher = client.listCustomRoutingAcceleratorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomRoutingAccelerators(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomRoutingAcceleratorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingAcceleratorsPublisher listCustomRoutingAcceleratorsPaginator(
            ListCustomRoutingAcceleratorsRequest listCustomRoutingAcceleratorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the custom routing accelerators for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomRoutingAccelerators(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingAcceleratorsPublisher publisher = client.listCustomRoutingAcceleratorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingAcceleratorsPublisher publisher = client.listCustomRoutingAcceleratorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomRoutingAccelerators(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomRoutingAcceleratorsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCustomRoutingAcceleratorsRequest#builder()}
     * </p>
     *
     * @param listCustomRoutingAcceleratorsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomRoutingAcceleratorsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingAcceleratorsPublisher listCustomRoutingAcceleratorsPaginator(
            Consumer<ListCustomRoutingAcceleratorsRequest.Builder> listCustomRoutingAcceleratorsRequest) {
        return listCustomRoutingAcceleratorsPaginator(ListCustomRoutingAcceleratorsRequest.builder()
                .applyMutation(listCustomRoutingAcceleratorsRequest).build());
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener for a custom routing accelerator.
     * </p>
     *
     * @param listCustomRoutingEndpointGroupsRequest
     * @return A Java Future containing the result of the ListCustomRoutingEndpointGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingEndpointGroups
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomRoutingEndpointGroupsResponse> listCustomRoutingEndpointGroups(
            ListCustomRoutingEndpointGroupsRequest listCustomRoutingEndpointGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomRoutingEndpointGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCustomRoutingEndpointGroupsRequest#builder()}
     * </p>
     *
     * @param listCustomRoutingEndpointGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomRoutingEndpointGroupsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListCustomRoutingEndpointGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingEndpointGroups
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomRoutingEndpointGroupsResponse> listCustomRoutingEndpointGroups(
            Consumer<ListCustomRoutingEndpointGroupsRequest.Builder> listCustomRoutingEndpointGroupsRequest) {
        return listCustomRoutingEndpointGroups(ListCustomRoutingEndpointGroupsRequest.builder()
                .applyMutation(listCustomRoutingEndpointGroupsRequest).build());
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomRoutingEndpointGroups(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingEndpointGroupsPublisher publisher = client.listCustomRoutingEndpointGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingEndpointGroupsPublisher publisher = client.listCustomRoutingEndpointGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomRoutingEndpointGroups(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomRoutingEndpointGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingEndpointGroups
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingEndpointGroupsPublisher listCustomRoutingEndpointGroupsPaginator(
            ListCustomRoutingEndpointGroupsRequest listCustomRoutingEndpointGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomRoutingEndpointGroups(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingEndpointGroupsPublisher publisher = client.listCustomRoutingEndpointGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingEndpointGroupsPublisher publisher = client.listCustomRoutingEndpointGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomRoutingEndpointGroups(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomRoutingEndpointGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCustomRoutingEndpointGroupsRequest#builder()}
     * </p>
     *
     * @param listCustomRoutingEndpointGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomRoutingEndpointGroupsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingEndpointGroups
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingEndpointGroupsPublisher listCustomRoutingEndpointGroupsPaginator(
            Consumer<ListCustomRoutingEndpointGroupsRequest.Builder> listCustomRoutingEndpointGroupsRequest) {
        return listCustomRoutingEndpointGroupsPaginator(ListCustomRoutingEndpointGroupsRequest.builder()
                .applyMutation(listCustomRoutingEndpointGroupsRequest).build());
    }

    /**
     * <p>
     * List the listeners for a custom routing accelerator.
     * </p>
     *
     * @param listCustomRoutingListenersRequest
     * @return A Java Future containing the result of the ListCustomRoutingListeners operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomRoutingListenersResponse> listCustomRoutingListeners(
            ListCustomRoutingListenersRequest listCustomRoutingListenersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the listeners for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomRoutingListenersRequest.Builder} avoiding
     * the need to create one manually via {@link ListCustomRoutingListenersRequest#builder()}
     * </p>
     *
     * @param listCustomRoutingListenersRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomRoutingListenersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCustomRoutingListeners operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomRoutingListenersResponse> listCustomRoutingListeners(
            Consumer<ListCustomRoutingListenersRequest.Builder> listCustomRoutingListenersRequest) {
        return listCustomRoutingListeners(ListCustomRoutingListenersRequest.builder()
                .applyMutation(listCustomRoutingListenersRequest).build());
    }

    /**
     * <p>
     * List the listeners for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomRoutingListeners(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingListenersPublisher publisher = client.listCustomRoutingListenersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingListenersPublisher publisher = client.listCustomRoutingListenersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomRoutingListeners(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomRoutingListenersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingListenersPublisher listCustomRoutingListenersPaginator(
            ListCustomRoutingListenersRequest listCustomRoutingListenersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the listeners for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomRoutingListeners(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingListenersPublisher publisher = client.listCustomRoutingListenersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingListenersPublisher publisher = client.listCustomRoutingListenersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomRoutingListeners(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomRoutingListenersRequest.Builder} avoiding
     * the need to create one manually via {@link ListCustomRoutingListenersRequest#builder()}
     * </p>
     *
     * @param listCustomRoutingListenersRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomRoutingListenersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingListenersPublisher listCustomRoutingListenersPaginator(
            Consumer<ListCustomRoutingListenersRequest.Builder> listCustomRoutingListenersRequest) {
        return listCustomRoutingListenersPaginator(ListCustomRoutingListenersRequest.builder()
                .applyMutation(listCustomRoutingListenersRequest).build());
    }

    /**
     * <p>
     * Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance IP
     * addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator. For each
     * subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port
     * mappings don't change after Global Accelerator generates them, so you can retrieve and cache the full mapping on
     * your servers.
     * </p>
     * <p>
     * If you remove a subnet from your accelerator, Global Accelerator removes (reclaims) the port mappings. If you add
     * a subnet to your accelerator, Global Accelerator creates new port mappings (the existing ones don't change). If
     * you add or remove EC2 instances in your subnet, the port mappings don't change, because the mappings are created
     * when you add the subnet to Global Accelerator.
     * </p>
     * <p>
     * The mappings also include a flag for each destination denoting which destination IP addresses and ports are
     * allowed or denied traffic.
     * </p>
     *
     * @param listCustomRoutingPortMappingsRequest
     * @return A Java Future containing the result of the ListCustomRoutingPortMappings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingPortMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomRoutingPortMappingsResponse> listCustomRoutingPortMappings(
            ListCustomRoutingPortMappingsRequest listCustomRoutingPortMappingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance IP
     * addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator. For each
     * subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port
     * mappings don't change after Global Accelerator generates them, so you can retrieve and cache the full mapping on
     * your servers.
     * </p>
     * <p>
     * If you remove a subnet from your accelerator, Global Accelerator removes (reclaims) the port mappings. If you add
     * a subnet to your accelerator, Global Accelerator creates new port mappings (the existing ones don't change). If
     * you add or remove EC2 instances in your subnet, the port mappings don't change, because the mappings are created
     * when you add the subnet to Global Accelerator.
     * </p>
     * <p>
     * The mappings also include a flag for each destination denoting which destination IP addresses and ports are
     * allowed or denied traffic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomRoutingPortMappingsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCustomRoutingPortMappingsRequest#builder()}
     * </p>
     *
     * @param listCustomRoutingPortMappingsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomRoutingPortMappingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListCustomRoutingPortMappings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingPortMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomRoutingPortMappingsResponse> listCustomRoutingPortMappings(
            Consumer<ListCustomRoutingPortMappingsRequest.Builder> listCustomRoutingPortMappingsRequest) {
        return listCustomRoutingPortMappings(ListCustomRoutingPortMappingsRequest.builder()
                .applyMutation(listCustomRoutingPortMappingsRequest).build());
    }

    /**
     * <p>
     * List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint. The response is the
     * mappings for one destination IP address. This is useful when your subnet endpoint has mappings that span multiple
     * custom routing accelerators in your account, or for scenarios where you only want to list the port mappings for a
     * specific destination instance.
     * </p>
     *
     * @param listCustomRoutingPortMappingsByDestinationRequest
     * @return A Java Future containing the result of the ListCustomRoutingPortMappingsByDestination operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>EndpointNotFoundException The endpoint that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingPortMappingsByDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappingsByDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomRoutingPortMappingsByDestinationResponse> listCustomRoutingPortMappingsByDestination(
            ListCustomRoutingPortMappingsByDestinationRequest listCustomRoutingPortMappingsByDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint. The response is the
     * mappings for one destination IP address. This is useful when your subnet endpoint has mappings that span multiple
     * custom routing accelerators in your account, or for scenarios where you only want to list the port mappings for a
     * specific destination instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCustomRoutingPortMappingsByDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link ListCustomRoutingPortMappingsByDestinationRequest#builder()}
     * </p>
     *
     * @param listCustomRoutingPortMappingsByDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListCustomRoutingPortMappingsByDestinationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListCustomRoutingPortMappingsByDestination operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>EndpointNotFoundException The endpoint that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingPortMappingsByDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappingsByDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomRoutingPortMappingsByDestinationResponse> listCustomRoutingPortMappingsByDestination(
            Consumer<ListCustomRoutingPortMappingsByDestinationRequest.Builder> listCustomRoutingPortMappingsByDestinationRequest) {
        return listCustomRoutingPortMappingsByDestination(ListCustomRoutingPortMappingsByDestinationRequest.builder()
                .applyMutation(listCustomRoutingPortMappingsByDestinationRequest).build());
    }

    /**
     * <p>
     * List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint. The response is the
     * mappings for one destination IP address. This is useful when your subnet endpoint has mappings that span multiple
     * custom routing accelerators in your account, or for scenarios where you only want to list the port mappings for a
     * specific destination instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomRoutingPortMappingsByDestination(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsByDestinationPublisher publisher = client.listCustomRoutingPortMappingsByDestinationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsByDestinationPublisher publisher = client.listCustomRoutingPortMappingsByDestinationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomRoutingPortMappingsByDestination(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomRoutingPortMappingsByDestinationRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>EndpointNotFoundException The endpoint that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingPortMappingsByDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappingsByDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingPortMappingsByDestinationPublisher listCustomRoutingPortMappingsByDestinationPaginator(
            ListCustomRoutingPortMappingsByDestinationRequest listCustomRoutingPortMappingsByDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint. The response is the
     * mappings for one destination IP address. This is useful when your subnet endpoint has mappings that span multiple
     * custom routing accelerators in your account, or for scenarios where you only want to list the port mappings for a
     * specific destination instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomRoutingPortMappingsByDestination(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsByDestinationPublisher publisher = client.listCustomRoutingPortMappingsByDestinationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsByDestinationPublisher publisher = client.listCustomRoutingPortMappingsByDestinationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomRoutingPortMappingsByDestination(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCustomRoutingPortMappingsByDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link ListCustomRoutingPortMappingsByDestinationRequest#builder()}
     * </p>
     *
     * @param listCustomRoutingPortMappingsByDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListCustomRoutingPortMappingsByDestinationRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>EndpointNotFoundException The endpoint that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingPortMappingsByDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappingsByDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingPortMappingsByDestinationPublisher listCustomRoutingPortMappingsByDestinationPaginator(
            Consumer<ListCustomRoutingPortMappingsByDestinationRequest.Builder> listCustomRoutingPortMappingsByDestinationRequest) {
        return listCustomRoutingPortMappingsByDestinationPaginator(ListCustomRoutingPortMappingsByDestinationRequest.builder()
                .applyMutation(listCustomRoutingPortMappingsByDestinationRequest).build());
    }

    /**
     * <p>
     * Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance IP
     * addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator. For each
     * subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port
     * mappings don't change after Global Accelerator generates them, so you can retrieve and cache the full mapping on
     * your servers.
     * </p>
     * <p>
     * If you remove a subnet from your accelerator, Global Accelerator removes (reclaims) the port mappings. If you add
     * a subnet to your accelerator, Global Accelerator creates new port mappings (the existing ones don't change). If
     * you add or remove EC2 instances in your subnet, the port mappings don't change, because the mappings are created
     * when you add the subnet to Global Accelerator.
     * </p>
     * <p>
     * The mappings also include a flag for each destination denoting which destination IP addresses and ports are
     * allowed or denied traffic.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomRoutingPortMappings(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsPublisher publisher = client.listCustomRoutingPortMappingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsPublisher publisher = client.listCustomRoutingPortMappingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomRoutingPortMappings(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomRoutingPortMappingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingPortMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingPortMappingsPublisher listCustomRoutingPortMappingsPaginator(
            ListCustomRoutingPortMappingsRequest listCustomRoutingPortMappingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance IP
     * addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator. For each
     * subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port
     * mappings don't change after Global Accelerator generates them, so you can retrieve and cache the full mapping on
     * your servers.
     * </p>
     * <p>
     * If you remove a subnet from your accelerator, Global Accelerator removes (reclaims) the port mappings. If you add
     * a subnet to your accelerator, Global Accelerator creates new port mappings (the existing ones don't change). If
     * you add or remove EC2 instances in your subnet, the port mappings don't change, because the mappings are created
     * when you add the subnet to Global Accelerator.
     * </p>
     * <p>
     * The mappings also include a flag for each destination denoting which destination IP addresses and ports are
     * allowed or denied traffic.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomRoutingPortMappings(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsPublisher publisher = client.listCustomRoutingPortMappingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsPublisher publisher = client.listCustomRoutingPortMappingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomRoutingPortMappings(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomRoutingPortMappingsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCustomRoutingPortMappingsRequest#builder()}
     * </p>
     *
     * @param listCustomRoutingPortMappingsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomRoutingPortMappingsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingPortMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingPortMappingsPublisher listCustomRoutingPortMappingsPaginator(
            Consumer<ListCustomRoutingPortMappingsRequest.Builder> listCustomRoutingPortMappingsRequest) {
        return listCustomRoutingPortMappingsPaginator(ListCustomRoutingPortMappingsRequest.builder()
                .applyMutation(listCustomRoutingPortMappingsRequest).build());
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener.
     * </p>
     *
     * @param listEndpointGroupsRequest
     * @return A Java Future containing the result of the ListEndpointGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListEndpointGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEndpointGroupsResponse> listEndpointGroups(ListEndpointGroupsRequest listEndpointGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEndpointGroupsRequest#builder()}
     * </p>
     *
     * @param listEndpointGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListEndpointGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEndpointGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListEndpointGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEndpointGroupsResponse> listEndpointGroups(
            Consumer<ListEndpointGroupsRequest.Builder> listEndpointGroupsRequest) {
        return listEndpointGroups(ListEndpointGroupsRequest.builder().applyMutation(listEndpointGroupsRequest).build());
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEndpointGroups(software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListEndpointGroupsPublisher publisher = client.listEndpointGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListEndpointGroupsPublisher publisher = client.listEndpointGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpointGroups(software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEndpointGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListEndpointGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEndpointGroupsPublisher listEndpointGroupsPaginator(ListEndpointGroupsRequest listEndpointGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEndpointGroups(software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListEndpointGroupsPublisher publisher = client.listEndpointGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListEndpointGroupsPublisher publisher = client.listEndpointGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpointGroups(software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEndpointGroupsRequest#builder()}
     * </p>
     *
     * @param listEndpointGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListEndpointGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListEndpointGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEndpointGroupsPublisher listEndpointGroupsPaginator(
            Consumer<ListEndpointGroupsRequest.Builder> listEndpointGroupsRequest) {
        return listEndpointGroupsPaginator(ListEndpointGroupsRequest.builder().applyMutation(listEndpointGroupsRequest).build());
    }

    /**
     * <p>
     * List the listeners for an accelerator.
     * </p>
     *
     * @param listListenersRequest
     * @return A Java Future containing the result of the ListListeners operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListListenersResponse> listListeners(ListListenersRequest listListenersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the listeners for an accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListListenersRequest.Builder} avoiding the need to
     * create one manually via {@link ListListenersRequest#builder()}
     * </p>
     *
     * @param listListenersRequest
     *        A {@link Consumer} that will call methods on {@link ListListenersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListListeners operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListListenersResponse> listListeners(Consumer<ListListenersRequest.Builder> listListenersRequest) {
        return listListeners(ListListenersRequest.builder().applyMutation(listListenersRequest).build());
    }

    /**
     * <p>
     * List the listeners for an accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listListeners(software.amazon.awssdk.services.globalaccelerator.model.ListListenersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListListenersPublisher publisher = client.listListenersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListListenersPublisher publisher = client.listListenersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listListeners(software.amazon.awssdk.services.globalaccelerator.model.ListListenersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listListenersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default ListListenersPublisher listListenersPaginator(ListListenersRequest listListenersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the listeners for an accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listListeners(software.amazon.awssdk.services.globalaccelerator.model.ListListenersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListListenersPublisher publisher = client.listListenersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListListenersPublisher publisher = client.listListenersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listListeners(software.amazon.awssdk.services.globalaccelerator.model.ListListenersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListListenersRequest.Builder} avoiding the need to
     * create one manually via {@link ListListenersRequest#builder()}
     * </p>
     *
     * @param listListenersRequest
     *        A {@link Consumer} that will call methods on {@link ListListenersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default ListListenersPublisher listListenersPaginator(Consumer<ListListenersRequest.Builder> listListenersRequest) {
        return listListenersPaginator(ListListenersRequest.builder().applyMutation(listListenersRequest).build());
    }

    /**
     * <p>
     * List all tags for an accelerator.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
     * Global Accelerator</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all tags for an accelerator.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
     * Global Accelerator</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Provisions an IP address range to use with your Amazon Web Services resources through bring your own IP addresses
     * (BYOIP) and creates a corresponding address pool. After the address range is provisioned, it is ready to be
     * advertised using <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/AdvertiseByoipCidr.html">
     * AdvertiseByoipCidr</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param provisionByoipCidrRequest
     * @return A Java Future containing the result of the ProvisionByoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>IncorrectCidrStateException The CIDR that you specified is not valid for this action. For example,
     *         the state of the CIDR might be incorrect for this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ProvisionByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ProvisionByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ProvisionByoipCidrResponse> provisionByoipCidr(ProvisionByoipCidrRequest provisionByoipCidrRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provisions an IP address range to use with your Amazon Web Services resources through bring your own IP addresses
     * (BYOIP) and creates a corresponding address pool. After the address range is provisioned, it is ready to be
     * advertised using <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/AdvertiseByoipCidr.html">
     * AdvertiseByoipCidr</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ProvisionByoipCidrRequest.Builder} avoiding the
     * need to create one manually via {@link ProvisionByoipCidrRequest#builder()}
     * </p>
     *
     * @param provisionByoipCidrRequest
     *        A {@link Consumer} that will call methods on {@link ProvisionByoipCidrRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ProvisionByoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>IncorrectCidrStateException The CIDR that you specified is not valid for this action. For example,
     *         the state of the CIDR might be incorrect for this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ProvisionByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ProvisionByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ProvisionByoipCidrResponse> provisionByoipCidr(
            Consumer<ProvisionByoipCidrRequest.Builder> provisionByoipCidrRequest) {
        return provisionByoipCidr(ProvisionByoipCidrRequest.builder().applyMutation(provisionByoipCidrRequest).build());
    }

    /**
     * <p>
     * Remove endpoints from a custom routing accelerator.
     * </p>
     *
     * @param removeCustomRoutingEndpointsRequest
     * @return A Java Future containing the result of the RemoveCustomRoutingEndpoints operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>EndpointNotFoundException The endpoint that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>ConflictException You can't use both of those options.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.RemoveCustomRoutingEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/RemoveCustomRoutingEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveCustomRoutingEndpointsResponse> removeCustomRoutingEndpoints(
            RemoveCustomRoutingEndpointsRequest removeCustomRoutingEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove endpoints from a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveCustomRoutingEndpointsRequest.Builder}
     * avoiding the need to create one manually via {@link RemoveCustomRoutingEndpointsRequest#builder()}
     * </p>
     *
     * @param removeCustomRoutingEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link RemoveCustomRoutingEndpointsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RemoveCustomRoutingEndpoints operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>EndpointNotFoundException The endpoint that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>ConflictException You can't use both of those options.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.RemoveCustomRoutingEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/RemoveCustomRoutingEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveCustomRoutingEndpointsResponse> removeCustomRoutingEndpoints(
            Consumer<RemoveCustomRoutingEndpointsRequest.Builder> removeCustomRoutingEndpointsRequest) {
        return removeCustomRoutingEndpoints(RemoveCustomRoutingEndpointsRequest.builder()
                .applyMutation(removeCustomRoutingEndpointsRequest).build());
    }

    /**
     * <p>
     * Add tags to an accelerator resource.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
     * Global Accelerator</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add tags to an accelerator resource.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
     * Global Accelerator</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Remove tags from a Global Accelerator resource. When you specify a tag key, the action removes both that key and
     * its associated value. The operation succeeds even if you attempt to remove tags from an accelerator that was
     * already removed.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
     * Global Accelerator</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove tags from a Global Accelerator resource. When you specify a tag key, the action removes both that key and
     * its associated value. The operation succeeds even if you attempt to remove tags from an accelerator that was
     * already removed.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
     * Global Accelerator</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update an accelerator.
     * </p>
     * <important>
     * <p>
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you
     * must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for
     * example, specify <code>--region us-west-2</code> on AWS CLI commands.
     * </p>
     * </important>
     *
     * @param updateAcceleratorRequest
     * @return A Java Future containing the result of the UpdateAccelerator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAcceleratorResponse> updateAccelerator(UpdateAcceleratorRequest updateAcceleratorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an accelerator.
     * </p>
     * <important>
     * <p>
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you
     * must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for
     * example, specify <code>--region us-west-2</code> on AWS CLI commands.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAcceleratorRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAcceleratorRequest#builder()}
     * </p>
     *
     * @param updateAcceleratorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAcceleratorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateAccelerator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAcceleratorResponse> updateAccelerator(
            Consumer<UpdateAcceleratorRequest.Builder> updateAcceleratorRequest) {
        return updateAccelerator(UpdateAcceleratorRequest.builder().applyMutation(updateAcceleratorRequest).build());
    }

    /**
     * <p>
     * Update the attributes for an accelerator.
     * </p>
     *
     * @param updateAcceleratorAttributesRequest
     * @return A Java Future containing the result of the UpdateAcceleratorAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateAcceleratorAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAcceleratorAttributesResponse> updateAcceleratorAttributes(
            UpdateAcceleratorAttributesRequest updateAcceleratorAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the attributes for an accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAcceleratorAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAcceleratorAttributesRequest#builder()}
     * </p>
     *
     * @param updateAcceleratorAttributesRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAcceleratorAttributesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateAcceleratorAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateAcceleratorAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAcceleratorAttributesResponse> updateAcceleratorAttributes(
            Consumer<UpdateAcceleratorAttributesRequest.Builder> updateAcceleratorAttributesRequest) {
        return updateAcceleratorAttributes(UpdateAcceleratorAttributesRequest.builder()
                .applyMutation(updateAcceleratorAttributesRequest).build());
    }

    /**
     * <p>
     * Update a custom routing accelerator.
     * </p>
     *
     * @param updateCustomRoutingAcceleratorRequest
     * @return A Java Future containing the result of the UpdateCustomRoutingAccelerator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCustomRoutingAcceleratorResponse> updateCustomRoutingAccelerator(
            UpdateCustomRoutingAcceleratorRequest updateCustomRoutingAcceleratorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCustomRoutingAcceleratorRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCustomRoutingAcceleratorRequest#builder()}
     * </p>
     *
     * @param updateCustomRoutingAcceleratorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCustomRoutingAcceleratorRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateCustomRoutingAccelerator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCustomRoutingAcceleratorResponse> updateCustomRoutingAccelerator(
            Consumer<UpdateCustomRoutingAcceleratorRequest.Builder> updateCustomRoutingAcceleratorRequest) {
        return updateCustomRoutingAccelerator(UpdateCustomRoutingAcceleratorRequest.builder()
                .applyMutation(updateCustomRoutingAcceleratorRequest).build());
    }

    /**
     * <p>
     * Update the attributes for a custom routing accelerator.
     * </p>
     *
     * @param updateCustomRoutingAcceleratorAttributesRequest
     * @return A Java Future containing the result of the UpdateCustomRoutingAcceleratorAttributes operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateCustomRoutingAcceleratorAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCustomRoutingAcceleratorAttributesResponse> updateCustomRoutingAcceleratorAttributes(
            UpdateCustomRoutingAcceleratorAttributesRequest updateCustomRoutingAcceleratorAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the attributes for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateCustomRoutingAcceleratorAttributesRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateCustomRoutingAcceleratorAttributesRequest#builder()}
     * </p>
     *
     * @param updateCustomRoutingAcceleratorAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link UpdateCustomRoutingAcceleratorAttributesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateCustomRoutingAcceleratorAttributes operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateCustomRoutingAcceleratorAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCustomRoutingAcceleratorAttributesResponse> updateCustomRoutingAcceleratorAttributes(
            Consumer<UpdateCustomRoutingAcceleratorAttributesRequest.Builder> updateCustomRoutingAcceleratorAttributesRequest) {
        return updateCustomRoutingAcceleratorAttributes(UpdateCustomRoutingAcceleratorAttributesRequest.builder()
                .applyMutation(updateCustomRoutingAcceleratorAttributesRequest).build());
    }

    /**
     * <p>
     * Update a listener for a custom routing accelerator.
     * </p>
     *
     * @param updateCustomRoutingListenerRequest
     * @return A Java Future containing the result of the UpdateCustomRoutingListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidPortRangeException The port numbers that you specified are not valid numbers or are not unique
     *         for this accelerator.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCustomRoutingListenerResponse> updateCustomRoutingListener(
            UpdateCustomRoutingListenerRequest updateCustomRoutingListenerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a listener for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCustomRoutingListenerRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCustomRoutingListenerRequest#builder()}
     * </p>
     *
     * @param updateCustomRoutingListenerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCustomRoutingListenerRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateCustomRoutingListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidPortRangeException The port numbers that you specified are not valid numbers or are not unique
     *         for this accelerator.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCustomRoutingListenerResponse> updateCustomRoutingListener(
            Consumer<UpdateCustomRoutingListenerRequest.Builder> updateCustomRoutingListenerRequest) {
        return updateCustomRoutingListener(UpdateCustomRoutingListenerRequest.builder()
                .applyMutation(updateCustomRoutingListenerRequest).build());
    }

    /**
     * <p>
     * Update an endpoint group. A resource must be valid and active when you add it as an endpoint.
     * </p>
     *
     * @param updateEndpointGroupRequest
     * @return A Java Future containing the result of the UpdateEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEndpointGroupResponse> updateEndpointGroup(
            UpdateEndpointGroupRequest updateEndpointGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an endpoint group. A resource must be valid and active when you add it as an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEndpointGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEndpointGroupRequest#builder()}
     * </p>
     *
     * @param updateEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEndpointGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEndpointGroupResponse> updateEndpointGroup(
            Consumer<UpdateEndpointGroupRequest.Builder> updateEndpointGroupRequest) {
        return updateEndpointGroup(UpdateEndpointGroupRequest.builder().applyMutation(updateEndpointGroupRequest).build());
    }

    /**
     * <p>
     * Update a listener.
     * </p>
     *
     * @param updateListenerRequest
     * @return A Java Future containing the result of the UpdateListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidPortRangeException The port numbers that you specified are not valid numbers or are not unique
     *         for this accelerator.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateListenerResponse> updateListener(UpdateListenerRequest updateListenerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a listener.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateListenerRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateListenerRequest#builder()}
     * </p>
     *
     * @param updateListenerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateListenerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidPortRangeException The port numbers that you specified are not valid numbers or are not unique
     *         for this accelerator.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateListenerResponse> updateListener(Consumer<UpdateListenerRequest.Builder> updateListenerRequest) {
        return updateListener(UpdateListenerRequest.builder().applyMutation(updateListenerRequest).build());
    }

    /**
     * <p>
     * Stops advertising an address range that is provisioned as an address pool. You can perform this operation at most
     * once every 10 seconds, even if you specify different address ranges each time.
     * </p>
     * <p>
     * It can take a few minutes before traffic to the specified addresses stops routing to Amazon Web Services because
     * of propagation delays.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param withdrawByoipCidrRequest
     * @return A Java Future containing the result of the WithdrawByoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>ByoipCidrNotFoundException The CIDR that you specified was not found or is incorrect.</li>
     *         <li>IncorrectCidrStateException The CIDR that you specified is not valid for this action. For example,
     *         the state of the CIDR might be incorrect for this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.WithdrawByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/WithdrawByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<WithdrawByoipCidrResponse> withdrawByoipCidr(WithdrawByoipCidrRequest withdrawByoipCidrRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops advertising an address range that is provisioned as an address pool. You can perform this operation at most
     * once every 10 seconds, even if you specify different address ranges each time.
     * </p>
     * <p>
     * It can take a few minutes before traffic to the specified addresses stops routing to Amazon Web Services because
     * of propagation delays.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link WithdrawByoipCidrRequest.Builder} avoiding the need
     * to create one manually via {@link WithdrawByoipCidrRequest#builder()}
     * </p>
     *
     * @param withdrawByoipCidrRequest
     *        A {@link Consumer} that will call methods on {@link WithdrawByoipCidrRequest.Builder} to create a request.
     * @return A Java Future containing the result of the WithdrawByoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>ByoipCidrNotFoundException The CIDR that you specified was not found or is incorrect.</li>
     *         <li>IncorrectCidrStateException The CIDR that you specified is not valid for this action. For example,
     *         the state of the CIDR might be incorrect for this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.WithdrawByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/WithdrawByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<WithdrawByoipCidrResponse> withdrawByoipCidr(
            Consumer<WithdrawByoipCidrRequest.Builder> withdrawByoipCidrRequest) {
        return withdrawByoipCidr(WithdrawByoipCidrRequest.builder().applyMutation(withdrawByoipCidrRequest).build());
    }
}
