/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.globalaccelerator.model.AcceleratorNotDisabledException;
import software.amazon.awssdk.services.globalaccelerator.model.AcceleratorNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.AccessDeniedException;
import software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AllowCustomRoutingTrafficRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AllowCustomRoutingTrafficResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AssociatedEndpointGroupFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.AssociatedListenerFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.ConflictException;
import software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeprovisionByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeprovisionByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointAlreadyExistsException;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointGroupAlreadyExistsException;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointGroupNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorException;
import software.amazon.awssdk.services.globalaccelerator.model.IncorrectCidrStateException;
import software.amazon.awssdk.services.globalaccelerator.model.InternalServiceErrorException;
import software.amazon.awssdk.services.globalaccelerator.model.InvalidArgumentException;
import software.amazon.awssdk.services.globalaccelerator.model.InvalidNextTokenException;
import software.amazon.awssdk.services.globalaccelerator.model.InvalidPortRangeException;
import software.amazon.awssdk.services.globalaccelerator.model.LimitExceededException;
import software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListListenersRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListenerNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.RemoveCustomRoutingEndpointsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.RemoveCustomRoutingEndpointsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.TagResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.TagResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UntagResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UntagResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListAcceleratorsIterable;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListByoipCidrsIterable;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingAcceleratorsIterable;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingEndpointGroupsIterable;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingListenersIterable;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsByDestinationIterable;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsIterable;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListEndpointGroupsIterable;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListListenersIterable;

/**
 * Service client for accessing AWS Global Accelerator. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Global Accelerator</fullname>
 * <p>
 * This is the <i>Global Accelerator API Reference</i>. This guide is for developers who need detailed information about
 * Global Accelerator API actions, data types, and errors. For more information about Global Accelerator features, see
 * the <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/what-is-global-accelerator.html">Global
 * Accelerator Developer Guide</a>.
 * </p>
 * <p>
 * Global Accelerator is a service in which you create <i>accelerators</i> to improve the performance of your
 * applications for local and global users. Depending on the type of accelerator you choose, you can gain additional
 * benefits.
 * </p>
 * <ul>
 * <li>
 * <p>
 * By using a standard accelerator, you can improve availability of your internet applications that are used by a global
 * audience. With a standard accelerator, Global Accelerator directs traffic to optimal endpoints over the Amazon Web
 * Services global network.
 * </p>
 * </li>
 * <li>
 * <p>
 * For other scenarios, you might choose a custom routing accelerator. With a custom routing accelerator, you can use
 * application logic to directly map one or more users to a specific endpoint among many endpoints.
 * </p>
 * </li>
 * </ul>
 * <important>
 * <p>
 * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you must
 * specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for example,
 * specify <code>--region us-west-2</code> on AWS CLI commands.
 * </p>
 * </important>
 * <p>
 * By default, Global Accelerator provides you with static IP addresses that you associate with your accelerator. The
 * static IP addresses are anycast from the Amazon Web Services edge network. For IPv4, Global Accelerator provides two
 * static IPv4 addresses. For dual-stack, Global Accelerator provides a total of four addresses: two static IPv4
 * addresses and two static IPv6 addresses. With a standard accelerator for IPv4, instead of using the addresses that
 * Global Accelerator provides, you can configure these entry points to be IPv4 addresses from your own IP address
 * ranges that you bring toGlobal Accelerator (BYOIP).
 * </p>
 * <p>
 * For a standard accelerator, they distribute incoming application traffic across multiple endpoint resources in
 * multiple Amazon Web Services Regions , which increases the availability of your applications. Endpoints for standard
 * accelerators can be Network Load Balancers, Application Load Balancers, Amazon EC2 instances, or Elastic IP addresses
 * that are located in one Amazon Web Services Region or multiple Amazon Web Services Regions. For custom routing
 * accelerators, you map traffic that arrives to the static IP addresses to specific Amazon EC2 servers in endpoints
 * that are virtual private cloud (VPC) subnets.
 * </p>
 * <important>
 * <p>
 * The static IP addresses remain assigned to your accelerator for as long as it exists, even if you disable the
 * accelerator and it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the
 * static IP addresses that are assigned to it, so you can no longer route traffic by using them. You can use IAM
 * policies like tag-based permissions with Global Accelerator to limit the users who have permissions to delete an
 * accelerator. For more information, see <a
 * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/access-control-manage-access-tag-policies.html"
 * >Tag-based policies</a>.
 * </p>
 * </important>
 * <p>
 * For standard accelerators, Global Accelerator uses the Amazon Web Services global network to route traffic to the
 * optimal regional endpoint based on health, client location, and policies that you configure. The service reacts
 * instantly to changes in health or configuration to ensure that internet traffic from clients is always directed to
 * healthy endpoints.
 * </p>
 * <p>
 * For more information about understanding and using Global Accelerator, see the <a
 * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/what-is-global-accelerator.html">Global Accelerator
 * Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GlobalAcceleratorClient extends SdkClient {
    String SERVICE_NAME = "globalaccelerator";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "globalaccelerator";

    /**
     * Create a {@link GlobalAcceleratorClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GlobalAcceleratorClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GlobalAcceleratorClient}.
     */
    static GlobalAcceleratorClientBuilder builder() {
        return new DefaultGlobalAcceleratorClientBuilder();
    }

    /**
     * <p>
     * Associate a virtual private cloud (VPC) subnet endpoint with your custom routing accelerator.
     * </p>
     * <p>
     * The listener port range must be large enough to support the number of IP addresses that can be specified in your
     * subnet. The number of ports required is: subnet size times the number of ports per destination EC2 instances. For
     * example, a subnet defined as /24 requires a listener port range of at least 255 ports.
     * </p>
     * <p>
     * Note: You must have enough remaining listener ports available to map to the subnet ports, or the call will fail
     * with a LimitExceededException.
     * </p>
     * <p>
     * By default, all destinations in a subnet in a custom routing accelerator cannot receive traffic. To enable all
     * destinations to receive traffic, or to specify individual port mappings that can receive traffic, see the <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html">
     * AllowCustomRoutingTraffic</a> operation.
     * </p>
     *
     * @param addCustomRoutingEndpointsRequest
     * @return Result of the AddCustomRoutingEndpoints operation returned by the service.
     * @throws EndpointAlreadyExistsException
     *         The endpoint that you specified doesn't exist.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws ConflictException
     *         You can't use both of those options.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.AddCustomRoutingEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AddCustomRoutingEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default AddCustomRoutingEndpointsResponse addCustomRoutingEndpoints(
            AddCustomRoutingEndpointsRequest addCustomRoutingEndpointsRequest) throws EndpointAlreadyExistsException,
            EndpointGroupNotFoundException, InternalServiceErrorException, InvalidArgumentException, LimitExceededException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate a virtual private cloud (VPC) subnet endpoint with your custom routing accelerator.
     * </p>
     * <p>
     * The listener port range must be large enough to support the number of IP addresses that can be specified in your
     * subnet. The number of ports required is: subnet size times the number of ports per destination EC2 instances. For
     * example, a subnet defined as /24 requires a listener port range of at least 255 ports.
     * </p>
     * <p>
     * Note: You must have enough remaining listener ports available to map to the subnet ports, or the call will fail
     * with a LimitExceededException.
     * </p>
     * <p>
     * By default, all destinations in a subnet in a custom routing accelerator cannot receive traffic. To enable all
     * destinations to receive traffic, or to specify individual port mappings that can receive traffic, see the <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html">
     * AllowCustomRoutingTraffic</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddCustomRoutingEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link AddCustomRoutingEndpointsRequest#builder()}
     * </p>
     *
     * @param addCustomRoutingEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link AddCustomRoutingEndpointsRequest.Builder} to create a
     *        request.
     * @return Result of the AddCustomRoutingEndpoints operation returned by the service.
     * @throws EndpointAlreadyExistsException
     *         The endpoint that you specified doesn't exist.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws ConflictException
     *         You can't use both of those options.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.AddCustomRoutingEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AddCustomRoutingEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default AddCustomRoutingEndpointsResponse addCustomRoutingEndpoints(
            Consumer<AddCustomRoutingEndpointsRequest.Builder> addCustomRoutingEndpointsRequest)
            throws EndpointAlreadyExistsException, EndpointGroupNotFoundException, InternalServiceErrorException,
            InvalidArgumentException, LimitExceededException, AccessDeniedException, ConflictException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        return addCustomRoutingEndpoints(AddCustomRoutingEndpointsRequest.builder()
                .applyMutation(addCustomRoutingEndpointsRequest).build());
    }

    /**
     * <p>
     * Advertises an IPv4 address range that is provisioned for use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP). It can take a few minutes before traffic to the specified addresses starts
     * routing to Amazon Web Services because of propagation delays.
     * </p>
     * <p>
     * To stop advertising the BYOIP address range, use <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html"> WithdrawByoipCidr</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param advertiseByoipCidrRequest
     * @return Result of the AdvertiseByoipCidr operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws ByoipCidrNotFoundException
     *         The CIDR that you specified was not found or is incorrect.
     * @throws IncorrectCidrStateException
     *         The CIDR that you specified is not valid for this action. For example, the state of the CIDR might be
     *         incorrect for this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.AdvertiseByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AdvertiseByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    default AdvertiseByoipCidrResponse advertiseByoipCidr(AdvertiseByoipCidrRequest advertiseByoipCidrRequest)
            throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, ByoipCidrNotFoundException,
            IncorrectCidrStateException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Advertises an IPv4 address range that is provisioned for use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP). It can take a few minutes before traffic to the specified addresses starts
     * routing to Amazon Web Services because of propagation delays.
     * </p>
     * <p>
     * To stop advertising the BYOIP address range, use <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html"> WithdrawByoipCidr</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdvertiseByoipCidrRequest.Builder} avoiding the
     * need to create one manually via {@link AdvertiseByoipCidrRequest#builder()}
     * </p>
     *
     * @param advertiseByoipCidrRequest
     *        A {@link Consumer} that will call methods on {@link AdvertiseByoipCidrRequest.Builder} to create a
     *        request.
     * @return Result of the AdvertiseByoipCidr operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws ByoipCidrNotFoundException
     *         The CIDR that you specified was not found or is incorrect.
     * @throws IncorrectCidrStateException
     *         The CIDR that you specified is not valid for this action. For example, the state of the CIDR might be
     *         incorrect for this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.AdvertiseByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AdvertiseByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    default AdvertiseByoipCidrResponse advertiseByoipCidr(Consumer<AdvertiseByoipCidrRequest.Builder> advertiseByoipCidrRequest)
            throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, ByoipCidrNotFoundException,
            IncorrectCidrStateException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return advertiseByoipCidr(AdvertiseByoipCidrRequest.builder().applyMutation(advertiseByoipCidrRequest).build());
    }

    /**
     * <p>
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that can receive
     * traffic for a custom routing accelerator. You can allow traffic to all destinations in the subnet endpoint, or
     * allow traffic to a specified list of destination IP addresses and ports in the subnet. Note that you cannot
     * specify IP addresses or ports outside of the range that you configured for the endpoint group.
     * </p>
     * <p>
     * After you make changes, you can verify that the updates are complete by checking the status of your accelerator:
     * the status changes from IN_PROGRESS to DEPLOYED.
     * </p>
     *
     * @param allowCustomRoutingTrafficRequest
     * @return Result of the AllowCustomRoutingTraffic operation returned by the service.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.AllowCustomRoutingTraffic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AllowCustomRoutingTraffic"
     *      target="_top">AWS API Documentation</a>
     */
    default AllowCustomRoutingTrafficResponse allowCustomRoutingTraffic(
            AllowCustomRoutingTrafficRequest allowCustomRoutingTrafficRequest) throws EndpointGroupNotFoundException,
            InvalidArgumentException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that can receive
     * traffic for a custom routing accelerator. You can allow traffic to all destinations in the subnet endpoint, or
     * allow traffic to a specified list of destination IP addresses and ports in the subnet. Note that you cannot
     * specify IP addresses or ports outside of the range that you configured for the endpoint group.
     * </p>
     * <p>
     * After you make changes, you can verify that the updates are complete by checking the status of your accelerator:
     * the status changes from IN_PROGRESS to DEPLOYED.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AllowCustomRoutingTrafficRequest.Builder} avoiding
     * the need to create one manually via {@link AllowCustomRoutingTrafficRequest#builder()}
     * </p>
     *
     * @param allowCustomRoutingTrafficRequest
     *        A {@link Consumer} that will call methods on {@link AllowCustomRoutingTrafficRequest.Builder} to create a
     *        request.
     * @return Result of the AllowCustomRoutingTraffic operation returned by the service.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.AllowCustomRoutingTraffic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AllowCustomRoutingTraffic"
     *      target="_top">AWS API Documentation</a>
     */
    default AllowCustomRoutingTrafficResponse allowCustomRoutingTraffic(
            Consumer<AllowCustomRoutingTrafficRequest.Builder> allowCustomRoutingTrafficRequest)
            throws EndpointGroupNotFoundException, InvalidArgumentException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        return allowCustomRoutingTraffic(AllowCustomRoutingTrafficRequest.builder()
                .applyMutation(allowCustomRoutingTrafficRequest).build());
    }

    /**
     * <p>
     * Create an accelerator. An accelerator includes one or more listeners that process inbound connections and direct
     * traffic to one or more endpoint groups, each of which includes endpoints, such as Network Load Balancers.
     * </p>
     * <important>
     * <p>
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you
     * must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for
     * example, specify <code>--region us-west-2</code> on AWS CLI commands.
     * </p>
     * </important>
     *
     * @param createAcceleratorRequest
     * @return Result of the CreateAccelerator operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.CreateAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAcceleratorResponse createAccelerator(CreateAcceleratorRequest createAcceleratorRequest)
            throws InternalServiceErrorException, InvalidArgumentException, LimitExceededException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an accelerator. An accelerator includes one or more listeners that process inbound connections and direct
     * traffic to one or more endpoint groups, each of which includes endpoints, such as Network Load Balancers.
     * </p>
     * <important>
     * <p>
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you
     * must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for
     * example, specify <code>--region us-west-2</code> on AWS CLI commands.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAcceleratorRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAcceleratorRequest#builder()}
     * </p>
     *
     * @param createAcceleratorRequest
     *        A {@link Consumer} that will call methods on {@link CreateAcceleratorRequest.Builder} to create a request.
     * @return Result of the CreateAccelerator operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.CreateAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAcceleratorResponse createAccelerator(Consumer<CreateAcceleratorRequest.Builder> createAcceleratorRequest)
            throws InternalServiceErrorException, InvalidArgumentException, LimitExceededException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        return createAccelerator(CreateAcceleratorRequest.builder().applyMutation(createAcceleratorRequest).build());
    }

    /**
     * <p>
     * Create a custom routing accelerator. A custom routing accelerator directs traffic to one of possibly thousands of
     * Amazon EC2 instance destinations running in a single or multiple virtual private clouds (VPC) subnet endpoints.
     * </p>
     * <p>
     * Be aware that, by default, all destination EC2 instances in a VPC subnet endpoint cannot receive traffic. To
     * enable all destinations to receive traffic, or to specify individual port mappings that can receive traffic, see
     * the <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html">
     * AllowCustomRoutingTraffic</a> operation.
     * </p>
     * <important>
     * <p>
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you
     * must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for
     * example, specify <code>--region us-west-2</code> on AWS CLI commands.
     * </p>
     * </important>
     *
     * @param createCustomRoutingAcceleratorRequest
     * @return Result of the CreateCustomRoutingAccelerator operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.CreateCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCustomRoutingAcceleratorResponse createCustomRoutingAccelerator(
            CreateCustomRoutingAcceleratorRequest createCustomRoutingAcceleratorRequest) throws InternalServiceErrorException,
            InvalidArgumentException, LimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a custom routing accelerator. A custom routing accelerator directs traffic to one of possibly thousands of
     * Amazon EC2 instance destinations running in a single or multiple virtual private clouds (VPC) subnet endpoints.
     * </p>
     * <p>
     * Be aware that, by default, all destination EC2 instances in a VPC subnet endpoint cannot receive traffic. To
     * enable all destinations to receive traffic, or to specify individual port mappings that can receive traffic, see
     * the <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html">
     * AllowCustomRoutingTraffic</a> operation.
     * </p>
     * <important>
     * <p>
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you
     * must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for
     * example, specify <code>--region us-west-2</code> on AWS CLI commands.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomRoutingAcceleratorRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCustomRoutingAcceleratorRequest#builder()}
     * </p>
     *
     * @param createCustomRoutingAcceleratorRequest
     *        A {@link Consumer} that will call methods on {@link CreateCustomRoutingAcceleratorRequest.Builder} to
     *        create a request.
     * @return Result of the CreateCustomRoutingAccelerator operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.CreateCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCustomRoutingAcceleratorResponse createCustomRoutingAccelerator(
            Consumer<CreateCustomRoutingAcceleratorRequest.Builder> createCustomRoutingAcceleratorRequest)
            throws InternalServiceErrorException, InvalidArgumentException, LimitExceededException, AccessDeniedException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return createCustomRoutingAccelerator(CreateCustomRoutingAcceleratorRequest.builder()
                .applyMutation(createCustomRoutingAcceleratorRequest).build());
    }

    /**
     * <p>
     * Create an endpoint group for the specified listener for a custom routing accelerator. An endpoint group is a
     * collection of endpoints in one Amazon Web Services Region.
     * </p>
     *
     * @param createCustomRoutingEndpointGroupRequest
     * @return Result of the CreateCustomRoutingEndpointGroup operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws EndpointGroupAlreadyExistsException
     *         The endpoint group that you specified already exists.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidPortRangeException
     *         The port numbers that you specified are not valid numbers or are not unique for this accelerator.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.CreateCustomRoutingEndpointGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCustomRoutingEndpointGroupResponse createCustomRoutingEndpointGroup(
            CreateCustomRoutingEndpointGroupRequest createCustomRoutingEndpointGroupRequest) throws AcceleratorNotFoundException,
            EndpointGroupAlreadyExistsException, ListenerNotFoundException, InternalServiceErrorException,
            InvalidArgumentException, InvalidPortRangeException, LimitExceededException, AccessDeniedException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an endpoint group for the specified listener for a custom routing accelerator. An endpoint group is a
     * collection of endpoints in one Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomRoutingEndpointGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCustomRoutingEndpointGroupRequest#builder()}
     * </p>
     *
     * @param createCustomRoutingEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateCustomRoutingEndpointGroupRequest.Builder} to
     *        create a request.
     * @return Result of the CreateCustomRoutingEndpointGroup operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws EndpointGroupAlreadyExistsException
     *         The endpoint group that you specified already exists.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidPortRangeException
     *         The port numbers that you specified are not valid numbers or are not unique for this accelerator.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.CreateCustomRoutingEndpointGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCustomRoutingEndpointGroupResponse createCustomRoutingEndpointGroup(
            Consumer<CreateCustomRoutingEndpointGroupRequest.Builder> createCustomRoutingEndpointGroupRequest)
            throws AcceleratorNotFoundException, EndpointGroupAlreadyExistsException, ListenerNotFoundException,
            InternalServiceErrorException, InvalidArgumentException, InvalidPortRangeException, LimitExceededException,
            AccessDeniedException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return createCustomRoutingEndpointGroup(CreateCustomRoutingEndpointGroupRequest.builder()
                .applyMutation(createCustomRoutingEndpointGroupRequest).build());
    }

    /**
     * <p>
     * Create a listener to process inbound connections from clients to a custom routing accelerator. Connections arrive
     * to assigned static IP addresses on the port range that you specify.
     * </p>
     *
     * @param createCustomRoutingListenerRequest
     * @return Result of the CreateCustomRoutingListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InvalidPortRangeException
     *         The port numbers that you specified are not valid numbers or are not unique for this accelerator.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.CreateCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCustomRoutingListenerResponse createCustomRoutingListener(
            CreateCustomRoutingListenerRequest createCustomRoutingListenerRequest) throws InvalidArgumentException,
            AcceleratorNotFoundException, InvalidPortRangeException, InternalServiceErrorException, LimitExceededException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a listener to process inbound connections from clients to a custom routing accelerator. Connections arrive
     * to assigned static IP addresses on the port range that you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomRoutingListenerRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCustomRoutingListenerRequest#builder()}
     * </p>
     *
     * @param createCustomRoutingListenerRequest
     *        A {@link Consumer} that will call methods on {@link CreateCustomRoutingListenerRequest.Builder} to create
     *        a request.
     * @return Result of the CreateCustomRoutingListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InvalidPortRangeException
     *         The port numbers that you specified are not valid numbers or are not unique for this accelerator.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.CreateCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCustomRoutingListenerResponse createCustomRoutingListener(
            Consumer<CreateCustomRoutingListenerRequest.Builder> createCustomRoutingListenerRequest)
            throws InvalidArgumentException, AcceleratorNotFoundException, InvalidPortRangeException,
            InternalServiceErrorException, LimitExceededException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        return createCustomRoutingListener(CreateCustomRoutingListenerRequest.builder()
                .applyMutation(createCustomRoutingListenerRequest).build());
    }

    /**
     * <p>
     * Create an endpoint group for the specified listener. An endpoint group is a collection of endpoints in one Amazon
     * Web Services Region. A resource must be valid and active when you add it as an endpoint.
     * </p>
     *
     * @param createEndpointGroupRequest
     * @return Result of the CreateEndpointGroup operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws EndpointGroupAlreadyExistsException
     *         The endpoint group that you specified already exists.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.CreateEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEndpointGroupResponse createEndpointGroup(CreateEndpointGroupRequest createEndpointGroupRequest)
            throws AcceleratorNotFoundException, EndpointGroupAlreadyExistsException, ListenerNotFoundException,
            InternalServiceErrorException, InvalidArgumentException, LimitExceededException, AccessDeniedException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an endpoint group for the specified listener. An endpoint group is a collection of endpoints in one Amazon
     * Web Services Region. A resource must be valid and active when you add it as an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEndpointGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEndpointGroupRequest#builder()}
     * </p>
     *
     * @param createEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateEndpointGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateEndpointGroup operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws EndpointGroupAlreadyExistsException
     *         The endpoint group that you specified already exists.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.CreateEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEndpointGroupResponse createEndpointGroup(
            Consumer<CreateEndpointGroupRequest.Builder> createEndpointGroupRequest) throws AcceleratorNotFoundException,
            EndpointGroupAlreadyExistsException, ListenerNotFoundException, InternalServiceErrorException,
            InvalidArgumentException, LimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        return createEndpointGroup(CreateEndpointGroupRequest.builder().applyMutation(createEndpointGroupRequest).build());
    }

    /**
     * <p>
     * Create a listener to process inbound connections from clients to an accelerator. Connections arrive to assigned
     * static IP addresses on a port, port range, or list of port ranges that you specify.
     * </p>
     *
     * @param createListenerRequest
     * @return Result of the CreateListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InvalidPortRangeException
     *         The port numbers that you specified are not valid numbers or are not unique for this accelerator.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.CreateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateListenerResponse createListener(CreateListenerRequest createListenerRequest) throws InvalidArgumentException,
            AcceleratorNotFoundException, InvalidPortRangeException, InternalServiceErrorException, LimitExceededException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a listener to process inbound connections from clients to an accelerator. Connections arrive to assigned
     * static IP addresses on a port, port range, or list of port ranges that you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateListenerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateListenerRequest#builder()}
     * </p>
     *
     * @param createListenerRequest
     *        A {@link Consumer} that will call methods on {@link CreateListenerRequest.Builder} to create a request.
     * @return Result of the CreateListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InvalidPortRangeException
     *         The port numbers that you specified are not valid numbers or are not unique for this accelerator.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.CreateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateListener"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateListenerResponse createListener(Consumer<CreateListenerRequest.Builder> createListenerRequest)
            throws InvalidArgumentException, AcceleratorNotFoundException, InvalidPortRangeException,
            InternalServiceErrorException, LimitExceededException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        return createListener(CreateListenerRequest.builder().applyMutation(createListenerRequest).build());
    }

    /**
     * <p>
     * Delete an accelerator. Before you can delete an accelerator, you must disable it and remove all dependent
     * resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set
     * <code>Enabled</code> to false.
     * </p>
     * <important>
     * <p>
     * When you create an accelerator, by default, Global Accelerator provides you with a set of two static IP
     * addresses. Alternatively, you can bring your own IP address ranges to Global Accelerator and assign IP addresses
     * from those ranges.
     * </p>
     * <p>
     * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator
     * and it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the static
     * IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best
     * practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM
     * policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Identity and access
     * management</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * </important>
     *
     * @param deleteAcceleratorRequest
     * @return Result of the DeleteAccelerator operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws AcceleratorNotDisabledException
     *         The accelerator that you specified could not be disabled.
     * @throws AssociatedListenerFoundException
     *         The accelerator that you specified has a listener associated with it. You must remove all dependent
     *         resources from an accelerator before you can delete it.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeleteAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAcceleratorResponse deleteAccelerator(DeleteAcceleratorRequest deleteAcceleratorRequest)
            throws AcceleratorNotFoundException, AcceleratorNotDisabledException, AssociatedListenerFoundException,
            InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an accelerator. Before you can delete an accelerator, you must disable it and remove all dependent
     * resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set
     * <code>Enabled</code> to false.
     * </p>
     * <important>
     * <p>
     * When you create an accelerator, by default, Global Accelerator provides you with a set of two static IP
     * addresses. Alternatively, you can bring your own IP address ranges to Global Accelerator and assign IP addresses
     * from those ranges.
     * </p>
     * <p>
     * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator
     * and it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the static
     * IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best
     * practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM
     * policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Identity and access
     * management</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAcceleratorRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAcceleratorRequest#builder()}
     * </p>
     *
     * @param deleteAcceleratorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAcceleratorRequest.Builder} to create a request.
     * @return Result of the DeleteAccelerator operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws AcceleratorNotDisabledException
     *         The accelerator that you specified could not be disabled.
     * @throws AssociatedListenerFoundException
     *         The accelerator that you specified has a listener associated with it. You must remove all dependent
     *         resources from an accelerator before you can delete it.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeleteAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAcceleratorResponse deleteAccelerator(Consumer<DeleteAcceleratorRequest.Builder> deleteAcceleratorRequest)
            throws AcceleratorNotFoundException, AcceleratorNotDisabledException, AssociatedListenerFoundException,
            InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        return deleteAccelerator(DeleteAcceleratorRequest.builder().applyMutation(deleteAcceleratorRequest).build());
    }

    /**
     * <p>
     * Delete a custom routing accelerator. Before you can delete an accelerator, you must disable it and remove all
     * dependent resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set
     * <code>Enabled</code> to false.
     * </p>
     * <important>
     * <p>
     * When you create a custom routing accelerator, by default, Global Accelerator provides you with a set of two
     * static IP addresses.
     * </p>
     * <p>
     * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator
     * and it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the static
     * IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best
     * practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM
     * policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Identity and access
     * management</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * </important>
     *
     * @param deleteCustomRoutingAcceleratorRequest
     * @return Result of the DeleteCustomRoutingAccelerator operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws AcceleratorNotDisabledException
     *         The accelerator that you specified could not be disabled.
     * @throws AssociatedListenerFoundException
     *         The accelerator that you specified has a listener associated with it. You must remove all dependent
     *         resources from an accelerator before you can delete it.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeleteCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomRoutingAcceleratorResponse deleteCustomRoutingAccelerator(
            DeleteCustomRoutingAcceleratorRequest deleteCustomRoutingAcceleratorRequest) throws AcceleratorNotFoundException,
            AcceleratorNotDisabledException, AssociatedListenerFoundException, InternalServiceErrorException,
            InvalidArgumentException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a custom routing accelerator. Before you can delete an accelerator, you must disable it and remove all
     * dependent resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set
     * <code>Enabled</code> to false.
     * </p>
     * <important>
     * <p>
     * When you create a custom routing accelerator, by default, Global Accelerator provides you with a set of two
     * static IP addresses.
     * </p>
     * <p>
     * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator
     * and it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the static
     * IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best
     * practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM
     * policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Identity and access
     * management</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomRoutingAcceleratorRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCustomRoutingAcceleratorRequest#builder()}
     * </p>
     *
     * @param deleteCustomRoutingAcceleratorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCustomRoutingAcceleratorRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteCustomRoutingAccelerator operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws AcceleratorNotDisabledException
     *         The accelerator that you specified could not be disabled.
     * @throws AssociatedListenerFoundException
     *         The accelerator that you specified has a listener associated with it. You must remove all dependent
     *         resources from an accelerator before you can delete it.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeleteCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomRoutingAcceleratorResponse deleteCustomRoutingAccelerator(
            Consumer<DeleteCustomRoutingAcceleratorRequest.Builder> deleteCustomRoutingAcceleratorRequest)
            throws AcceleratorNotFoundException, AcceleratorNotDisabledException, AssociatedListenerFoundException,
            InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        return deleteCustomRoutingAccelerator(DeleteCustomRoutingAcceleratorRequest.builder()
                .applyMutation(deleteCustomRoutingAcceleratorRequest).build());
    }

    /**
     * <p>
     * Delete an endpoint group from a listener for a custom routing accelerator.
     * </p>
     *
     * @param deleteCustomRoutingEndpointGroupRequest
     * @return Result of the DeleteCustomRoutingEndpointGroup operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeleteCustomRoutingEndpointGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomRoutingEndpointGroupResponse deleteCustomRoutingEndpointGroup(
            DeleteCustomRoutingEndpointGroupRequest deleteCustomRoutingEndpointGroupRequest) throws InvalidArgumentException,
            EndpointGroupNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an endpoint group from a listener for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomRoutingEndpointGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCustomRoutingEndpointGroupRequest#builder()}
     * </p>
     *
     * @param deleteCustomRoutingEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCustomRoutingEndpointGroupRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteCustomRoutingEndpointGroup operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeleteCustomRoutingEndpointGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomRoutingEndpointGroupResponse deleteCustomRoutingEndpointGroup(
            Consumer<DeleteCustomRoutingEndpointGroupRequest.Builder> deleteCustomRoutingEndpointGroupRequest)
            throws InvalidArgumentException, EndpointGroupNotFoundException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        return deleteCustomRoutingEndpointGroup(DeleteCustomRoutingEndpointGroupRequest.builder()
                .applyMutation(deleteCustomRoutingEndpointGroupRequest).build());
    }

    /**
     * <p>
     * Delete a listener for a custom routing accelerator.
     * </p>
     *
     * @param deleteCustomRoutingListenerRequest
     * @return Result of the DeleteCustomRoutingListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws AssociatedEndpointGroupFoundException
     *         The listener that you specified has an endpoint group associated with it. You must remove all dependent
     *         resources from a listener before you can delete it.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeleteCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomRoutingListenerResponse deleteCustomRoutingListener(
            DeleteCustomRoutingListenerRequest deleteCustomRoutingListenerRequest) throws InvalidArgumentException,
            ListenerNotFoundException, AssociatedEndpointGroupFoundException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a listener for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomRoutingListenerRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCustomRoutingListenerRequest#builder()}
     * </p>
     *
     * @param deleteCustomRoutingListenerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCustomRoutingListenerRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteCustomRoutingListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws AssociatedEndpointGroupFoundException
     *         The listener that you specified has an endpoint group associated with it. You must remove all dependent
     *         resources from a listener before you can delete it.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeleteCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomRoutingListenerResponse deleteCustomRoutingListener(
            Consumer<DeleteCustomRoutingListenerRequest.Builder> deleteCustomRoutingListenerRequest)
            throws InvalidArgumentException, ListenerNotFoundException, AssociatedEndpointGroupFoundException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return deleteCustomRoutingListener(DeleteCustomRoutingListenerRequest.builder()
                .applyMutation(deleteCustomRoutingListenerRequest).build());
    }

    /**
     * <p>
     * Delete an endpoint group from a listener.
     * </p>
     *
     * @param deleteEndpointGroupRequest
     * @return Result of the DeleteEndpointGroup operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeleteEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEndpointGroupResponse deleteEndpointGroup(DeleteEndpointGroupRequest deleteEndpointGroupRequest)
            throws InvalidArgumentException, EndpointGroupNotFoundException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an endpoint group from a listener.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEndpointGroupRequest#builder()}
     * </p>
     *
     * @param deleteEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEndpointGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteEndpointGroup operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeleteEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEndpointGroupResponse deleteEndpointGroup(
            Consumer<DeleteEndpointGroupRequest.Builder> deleteEndpointGroupRequest) throws InvalidArgumentException,
            EndpointGroupNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        return deleteEndpointGroup(DeleteEndpointGroupRequest.builder().applyMutation(deleteEndpointGroupRequest).build());
    }

    /**
     * <p>
     * Delete a listener from an accelerator.
     * </p>
     *
     * @param deleteListenerRequest
     * @return Result of the DeleteListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws AssociatedEndpointGroupFoundException
     *         The listener that you specified has an endpoint group associated with it. You must remove all dependent
     *         resources from a listener before you can delete it.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeleteListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteListener"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteListenerResponse deleteListener(DeleteListenerRequest deleteListenerRequest) throws InvalidArgumentException,
            ListenerNotFoundException, AssociatedEndpointGroupFoundException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a listener from an accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteListenerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteListenerRequest#builder()}
     * </p>
     *
     * @param deleteListenerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteListenerRequest.Builder} to create a request.
     * @return Result of the DeleteListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws AssociatedEndpointGroupFoundException
     *         The listener that you specified has an endpoint group associated with it. You must remove all dependent
     *         resources from a listener before you can delete it.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeleteListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteListener"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteListenerResponse deleteListener(Consumer<DeleteListenerRequest.Builder> deleteListenerRequest)
            throws InvalidArgumentException, ListenerNotFoundException, AssociatedEndpointGroupFoundException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return deleteListener(DeleteListenerRequest.builder().applyMutation(deleteListenerRequest).build());
    }

    /**
     * <p>
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that cannot
     * receive traffic for a custom routing accelerator. You can deny traffic to all destinations in the VPC endpoint,
     * or deny traffic to a specified list of destination IP addresses and ports. Note that you cannot specify IP
     * addresses or ports outside of the range that you configured for the endpoint group.
     * </p>
     * <p>
     * After you make changes, you can verify that the updates are complete by checking the status of your accelerator:
     * the status changes from IN_PROGRESS to DEPLOYED.
     * </p>
     *
     * @param denyCustomRoutingTrafficRequest
     * @return Result of the DenyCustomRoutingTraffic operation returned by the service.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DenyCustomRoutingTraffic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DenyCustomRoutingTraffic"
     *      target="_top">AWS API Documentation</a>
     */
    default DenyCustomRoutingTrafficResponse denyCustomRoutingTraffic(
            DenyCustomRoutingTrafficRequest denyCustomRoutingTrafficRequest) throws EndpointGroupNotFoundException,
            InvalidArgumentException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that cannot
     * receive traffic for a custom routing accelerator. You can deny traffic to all destinations in the VPC endpoint,
     * or deny traffic to a specified list of destination IP addresses and ports. Note that you cannot specify IP
     * addresses or ports outside of the range that you configured for the endpoint group.
     * </p>
     * <p>
     * After you make changes, you can verify that the updates are complete by checking the status of your accelerator:
     * the status changes from IN_PROGRESS to DEPLOYED.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DenyCustomRoutingTrafficRequest.Builder} avoiding
     * the need to create one manually via {@link DenyCustomRoutingTrafficRequest#builder()}
     * </p>
     *
     * @param denyCustomRoutingTrafficRequest
     *        A {@link Consumer} that will call methods on {@link DenyCustomRoutingTrafficRequest.Builder} to create a
     *        request.
     * @return Result of the DenyCustomRoutingTraffic operation returned by the service.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DenyCustomRoutingTraffic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DenyCustomRoutingTraffic"
     *      target="_top">AWS API Documentation</a>
     */
    default DenyCustomRoutingTrafficResponse denyCustomRoutingTraffic(
            Consumer<DenyCustomRoutingTrafficRequest.Builder> denyCustomRoutingTrafficRequest)
            throws EndpointGroupNotFoundException, InvalidArgumentException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        return denyCustomRoutingTraffic(DenyCustomRoutingTrafficRequest.builder().applyMutation(denyCustomRoutingTrafficRequest)
                .build());
    }

    /**
     * <p>
     * Releases the specified address range that you provisioned to use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     * </p>
     * <p>
     * Before you can release an address range, you must stop advertising it by using <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html">WithdrawByoipCidr</a> and
     * you must not have any accelerators that are using static IP addresses allocated from its address range.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param deprovisionByoipCidrRequest
     * @return Result of the DeprovisionByoipCidr operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws ByoipCidrNotFoundException
     *         The CIDR that you specified was not found or is incorrect.
     * @throws IncorrectCidrStateException
     *         The CIDR that you specified is not valid for this action. For example, the state of the CIDR might be
     *         incorrect for this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeprovisionByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeprovisionByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    default DeprovisionByoipCidrResponse deprovisionByoipCidr(DeprovisionByoipCidrRequest deprovisionByoipCidrRequest)
            throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, ByoipCidrNotFoundException,
            IncorrectCidrStateException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Releases the specified address range that you provisioned to use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     * </p>
     * <p>
     * Before you can release an address range, you must stop advertising it by using <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html">WithdrawByoipCidr</a> and
     * you must not have any accelerators that are using static IP addresses allocated from its address range.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeprovisionByoipCidrRequest.Builder} avoiding the
     * need to create one manually via {@link DeprovisionByoipCidrRequest#builder()}
     * </p>
     *
     * @param deprovisionByoipCidrRequest
     *        A {@link Consumer} that will call methods on {@link DeprovisionByoipCidrRequest.Builder} to create a
     *        request.
     * @return Result of the DeprovisionByoipCidr operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws ByoipCidrNotFoundException
     *         The CIDR that you specified was not found or is incorrect.
     * @throws IncorrectCidrStateException
     *         The CIDR that you specified is not valid for this action. For example, the state of the CIDR might be
     *         incorrect for this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeprovisionByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeprovisionByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    default DeprovisionByoipCidrResponse deprovisionByoipCidr(
            Consumer<DeprovisionByoipCidrRequest.Builder> deprovisionByoipCidrRequest) throws InternalServiceErrorException,
            InvalidArgumentException, AccessDeniedException, ByoipCidrNotFoundException, IncorrectCidrStateException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return deprovisionByoipCidr(DeprovisionByoipCidrRequest.builder().applyMutation(deprovisionByoipCidrRequest).build());
    }

    /**
     * <p>
     * Describe an accelerator.
     * </p>
     *
     * @param describeAcceleratorRequest
     * @return Result of the DescribeAccelerator operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAcceleratorResponse describeAccelerator(DescribeAcceleratorRequest describeAcceleratorRequest)
            throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe an accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAcceleratorRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAcceleratorRequest#builder()}
     * </p>
     *
     * @param describeAcceleratorRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAcceleratorRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAccelerator operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAcceleratorResponse describeAccelerator(
            Consumer<DescribeAcceleratorRequest.Builder> describeAcceleratorRequest) throws AcceleratorNotFoundException,
            InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        return describeAccelerator(DescribeAcceleratorRequest.builder().applyMutation(describeAcceleratorRequest).build());
    }

    /**
     * <p>
     * Describe the attributes of an accelerator.
     * </p>
     *
     * @param describeAcceleratorAttributesRequest
     * @return Result of the DescribeAcceleratorAttributes operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeAcceleratorAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAcceleratorAttributesResponse describeAcceleratorAttributes(
            DescribeAcceleratorAttributesRequest describeAcceleratorAttributesRequest) throws AcceleratorNotFoundException,
            InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe the attributes of an accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAcceleratorAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAcceleratorAttributesRequest#builder()}
     * </p>
     *
     * @param describeAcceleratorAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAcceleratorAttributesRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeAcceleratorAttributes operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeAcceleratorAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAcceleratorAttributesResponse describeAcceleratorAttributes(
            Consumer<DescribeAcceleratorAttributesRequest.Builder> describeAcceleratorAttributesRequest)
            throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        return describeAcceleratorAttributes(DescribeAcceleratorAttributesRequest.builder()
                .applyMutation(describeAcceleratorAttributesRequest).build());
    }

    /**
     * <p>
     * Describe a custom routing accelerator.
     * </p>
     *
     * @param describeCustomRoutingAcceleratorRequest
     * @return Result of the DescribeCustomRoutingAccelerator operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCustomRoutingAcceleratorResponse describeCustomRoutingAccelerator(
            DescribeCustomRoutingAcceleratorRequest describeCustomRoutingAcceleratorRequest) throws AcceleratorNotFoundException,
            InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCustomRoutingAcceleratorRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCustomRoutingAcceleratorRequest#builder()}
     * </p>
     *
     * @param describeCustomRoutingAcceleratorRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCustomRoutingAcceleratorRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeCustomRoutingAccelerator operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCustomRoutingAcceleratorResponse describeCustomRoutingAccelerator(
            Consumer<DescribeCustomRoutingAcceleratorRequest.Builder> describeCustomRoutingAcceleratorRequest)
            throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        return describeCustomRoutingAccelerator(DescribeCustomRoutingAcceleratorRequest.builder()
                .applyMutation(describeCustomRoutingAcceleratorRequest).build());
    }

    /**
     * <p>
     * Describe the attributes of a custom routing accelerator.
     * </p>
     *
     * @param describeCustomRoutingAcceleratorAttributesRequest
     * @return Result of the DescribeCustomRoutingAcceleratorAttributes operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeCustomRoutingAcceleratorAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCustomRoutingAcceleratorAttributesResponse describeCustomRoutingAcceleratorAttributes(
            DescribeCustomRoutingAcceleratorAttributesRequest describeCustomRoutingAcceleratorAttributesRequest)
            throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe the attributes of a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeCustomRoutingAcceleratorAttributesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeCustomRoutingAcceleratorAttributesRequest#builder()}
     * </p>
     *
     * @param describeCustomRoutingAcceleratorAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeCustomRoutingAcceleratorAttributesRequest.Builder} to create a request.
     * @return Result of the DescribeCustomRoutingAcceleratorAttributes operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeCustomRoutingAcceleratorAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCustomRoutingAcceleratorAttributesResponse describeCustomRoutingAcceleratorAttributes(
            Consumer<DescribeCustomRoutingAcceleratorAttributesRequest.Builder> describeCustomRoutingAcceleratorAttributesRequest)
            throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        return describeCustomRoutingAcceleratorAttributes(DescribeCustomRoutingAcceleratorAttributesRequest.builder()
                .applyMutation(describeCustomRoutingAcceleratorAttributesRequest).build());
    }

    /**
     * <p>
     * Describe an endpoint group for a custom routing accelerator.
     * </p>
     *
     * @param describeCustomRoutingEndpointGroupRequest
     * @return Result of the DescribeCustomRoutingEndpointGroup operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeCustomRoutingEndpointGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCustomRoutingEndpointGroupResponse describeCustomRoutingEndpointGroup(
            DescribeCustomRoutingEndpointGroupRequest describeCustomRoutingEndpointGroupRequest) throws InvalidArgumentException,
            EndpointGroupNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe an endpoint group for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCustomRoutingEndpointGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCustomRoutingEndpointGroupRequest#builder()}
     * </p>
     *
     * @param describeCustomRoutingEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCustomRoutingEndpointGroupRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeCustomRoutingEndpointGroup operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeCustomRoutingEndpointGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCustomRoutingEndpointGroupResponse describeCustomRoutingEndpointGroup(
            Consumer<DescribeCustomRoutingEndpointGroupRequest.Builder> describeCustomRoutingEndpointGroupRequest)
            throws InvalidArgumentException, EndpointGroupNotFoundException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        return describeCustomRoutingEndpointGroup(DescribeCustomRoutingEndpointGroupRequest.builder()
                .applyMutation(describeCustomRoutingEndpointGroupRequest).build());
    }

    /**
     * <p>
     * The description of a listener for a custom routing accelerator.
     * </p>
     *
     * @param describeCustomRoutingListenerRequest
     * @return Result of the DescribeCustomRoutingListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCustomRoutingListenerResponse describeCustomRoutingListener(
            DescribeCustomRoutingListenerRequest describeCustomRoutingListenerRequest) throws InvalidArgumentException,
            ListenerNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The description of a listener for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCustomRoutingListenerRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCustomRoutingListenerRequest#builder()}
     * </p>
     *
     * @param describeCustomRoutingListenerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCustomRoutingListenerRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeCustomRoutingListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCustomRoutingListenerResponse describeCustomRoutingListener(
            Consumer<DescribeCustomRoutingListenerRequest.Builder> describeCustomRoutingListenerRequest)
            throws InvalidArgumentException, ListenerNotFoundException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        return describeCustomRoutingListener(DescribeCustomRoutingListenerRequest.builder()
                .applyMutation(describeCustomRoutingListenerRequest).build());
    }

    /**
     * <p>
     * Describe an endpoint group.
     * </p>
     *
     * @param describeEndpointGroupRequest
     * @return Result of the DescribeEndpointGroup operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEndpointGroupResponse describeEndpointGroup(DescribeEndpointGroupRequest describeEndpointGroupRequest)
            throws InvalidArgumentException, EndpointGroupNotFoundException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe an endpoint group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEndpointGroupRequest#builder()}
     * </p>
     *
     * @param describeEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeEndpointGroup operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEndpointGroupResponse describeEndpointGroup(
            Consumer<DescribeEndpointGroupRequest.Builder> describeEndpointGroupRequest) throws InvalidArgumentException,
            EndpointGroupNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        return describeEndpointGroup(DescribeEndpointGroupRequest.builder().applyMutation(describeEndpointGroupRequest).build());
    }

    /**
     * <p>
     * Describe a listener.
     * </p>
     *
     * @param describeListenerRequest
     * @return Result of the DescribeListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeListener"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeListenerResponse describeListener(DescribeListenerRequest describeListenerRequest)
            throws InvalidArgumentException, ListenerNotFoundException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe a listener.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeListenerRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeListenerRequest#builder()}
     * </p>
     *
     * @param describeListenerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeListenerRequest.Builder} to create a request.
     * @return Result of the DescribeListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeListener"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeListenerResponse describeListener(Consumer<DescribeListenerRequest.Builder> describeListenerRequest)
            throws InvalidArgumentException, ListenerNotFoundException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        return describeListener(DescribeListenerRequest.builder().applyMutation(describeListenerRequest).build());
    }

    /**
     * <p>
     * List the accelerators for an Amazon Web Services account.
     * </p>
     *
     * @return Result of the ListAccelerators operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListAccelerators
     * @see #listAccelerators(ListAcceleratorsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAcceleratorsResponse listAccelerators() throws InvalidArgumentException, InvalidNextTokenException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return listAccelerators(ListAcceleratorsRequest.builder().build());
    }

    /**
     * <p>
     * List the accelerators for an Amazon Web Services account.
     * </p>
     *
     * @param listAcceleratorsRequest
     * @return Result of the ListAccelerators operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAcceleratorsResponse listAccelerators(ListAcceleratorsRequest listAcceleratorsRequest)
            throws InvalidArgumentException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the accelerators for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAcceleratorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAcceleratorsRequest#builder()}
     * </p>
     *
     * @param listAcceleratorsRequest
     *        A {@link Consumer} that will call methods on {@link ListAcceleratorsRequest.Builder} to create a request.
     * @return Result of the ListAccelerators operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAcceleratorsResponse listAccelerators(Consumer<ListAcceleratorsRequest.Builder> listAcceleratorsRequest)
            throws InvalidArgumentException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        return listAccelerators(ListAcceleratorsRequest.builder().applyMutation(listAcceleratorsRequest).build());
    }

    /**
     * <p>
     * List the accelerators for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccelerators(software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListAcceleratorsIterable responses = client.listAcceleratorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.globalaccelerator.paginators.ListAcceleratorsIterable responses = client
     *             .listAcceleratorsPaginator(request);
     *     for (software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListAcceleratorsIterable responses = client.listAcceleratorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccelerators(software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListAccelerators
     * @see #listAcceleratorsPaginator(ListAcceleratorsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAcceleratorsIterable listAcceleratorsPaginator() throws InvalidArgumentException, InvalidNextTokenException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return listAcceleratorsPaginator(ListAcceleratorsRequest.builder().build());
    }

    /**
     * <p>
     * List the accelerators for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccelerators(software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListAcceleratorsIterable responses = client.listAcceleratorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.globalaccelerator.paginators.ListAcceleratorsIterable responses = client
     *             .listAcceleratorsPaginator(request);
     *     for (software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListAcceleratorsIterable responses = client.listAcceleratorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccelerators(software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAcceleratorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAcceleratorsIterable listAcceleratorsPaginator(ListAcceleratorsRequest listAcceleratorsRequest)
            throws InvalidArgumentException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the accelerators for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccelerators(software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListAcceleratorsIterable responses = client.listAcceleratorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.globalaccelerator.paginators.ListAcceleratorsIterable responses = client
     *             .listAcceleratorsPaginator(request);
     *     for (software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListAcceleratorsIterable responses = client.listAcceleratorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccelerators(software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAcceleratorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAcceleratorsRequest#builder()}
     * </p>
     *
     * @param listAcceleratorsRequest
     *        A {@link Consumer} that will call methods on {@link ListAcceleratorsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAcceleratorsIterable listAcceleratorsPaginator(Consumer<ListAcceleratorsRequest.Builder> listAcceleratorsRequest)
            throws InvalidArgumentException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        return listAcceleratorsPaginator(ListAcceleratorsRequest.builder().applyMutation(listAcceleratorsRequest).build());
    }

    /**
     * <p>
     * Lists the IP address ranges that were specified in calls to <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html">ProvisionByoipCidr</a>,
     * including the current state and a history of state changes.
     * </p>
     *
     * @param listByoipCidrsRequest
     * @return Result of the ListByoipCidrs operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListByoipCidrs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListByoipCidrs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListByoipCidrsResponse listByoipCidrs(ListByoipCidrsRequest listByoipCidrsRequest)
            throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IP address ranges that were specified in calls to <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html">ProvisionByoipCidr</a>,
     * including the current state and a history of state changes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListByoipCidrsRequest.Builder} avoiding the need to
     * create one manually via {@link ListByoipCidrsRequest#builder()}
     * </p>
     *
     * @param listByoipCidrsRequest
     *        A {@link Consumer} that will call methods on {@link ListByoipCidrsRequest.Builder} to create a request.
     * @return Result of the ListByoipCidrs operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListByoipCidrs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListByoipCidrs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListByoipCidrsResponse listByoipCidrs(Consumer<ListByoipCidrsRequest.Builder> listByoipCidrsRequest)
            throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return listByoipCidrs(ListByoipCidrsRequest.builder().applyMutation(listByoipCidrsRequest).build());
    }

    /**
     * <p>
     * Lists the IP address ranges that were specified in calls to <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html">ProvisionByoipCidr</a>,
     * including the current state and a history of state changes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listByoipCidrs(software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListByoipCidrsIterable responses = client.listByoipCidrsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.globalaccelerator.paginators.ListByoipCidrsIterable responses = client
     *             .listByoipCidrsPaginator(request);
     *     for (software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListByoipCidrsIterable responses = client.listByoipCidrsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listByoipCidrs(software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listByoipCidrsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListByoipCidrs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListByoipCidrs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListByoipCidrsIterable listByoipCidrsPaginator(ListByoipCidrsRequest listByoipCidrsRequest)
            throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IP address ranges that were specified in calls to <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html">ProvisionByoipCidr</a>,
     * including the current state and a history of state changes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listByoipCidrs(software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListByoipCidrsIterable responses = client.listByoipCidrsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.globalaccelerator.paginators.ListByoipCidrsIterable responses = client
     *             .listByoipCidrsPaginator(request);
     *     for (software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListByoipCidrsIterable responses = client.listByoipCidrsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listByoipCidrs(software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListByoipCidrsRequest.Builder} avoiding the need to
     * create one manually via {@link ListByoipCidrsRequest#builder()}
     * </p>
     *
     * @param listByoipCidrsRequest
     *        A {@link Consumer} that will call methods on {@link ListByoipCidrsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListByoipCidrs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListByoipCidrs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListByoipCidrsIterable listByoipCidrsPaginator(Consumer<ListByoipCidrsRequest.Builder> listByoipCidrsRequest)
            throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return listByoipCidrsPaginator(ListByoipCidrsRequest.builder().applyMutation(listByoipCidrsRequest).build());
    }

    /**
     * <p>
     * List the custom routing accelerators for an Amazon Web Services account.
     * </p>
     *
     * @param listCustomRoutingAcceleratorsRequest
     * @return Result of the ListCustomRoutingAccelerators operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingAcceleratorsResponse listCustomRoutingAccelerators(
            ListCustomRoutingAcceleratorsRequest listCustomRoutingAcceleratorsRequest) throws InvalidArgumentException,
            InvalidNextTokenException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the custom routing accelerators for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomRoutingAcceleratorsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCustomRoutingAcceleratorsRequest#builder()}
     * </p>
     *
     * @param listCustomRoutingAcceleratorsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomRoutingAcceleratorsRequest.Builder} to
     *        create a request.
     * @return Result of the ListCustomRoutingAccelerators operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingAcceleratorsResponse listCustomRoutingAccelerators(
            Consumer<ListCustomRoutingAcceleratorsRequest.Builder> listCustomRoutingAcceleratorsRequest)
            throws InvalidArgumentException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        return listCustomRoutingAccelerators(ListCustomRoutingAcceleratorsRequest.builder()
                .applyMutation(listCustomRoutingAcceleratorsRequest).build());
    }

    /**
     * <p>
     * List the custom routing accelerators for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomRoutingAccelerators(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingAcceleratorsIterable responses = client.listCustomRoutingAcceleratorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingAcceleratorsIterable responses = client
     *             .listCustomRoutingAcceleratorsPaginator(request);
     *     for (software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingAcceleratorsIterable responses = client.listCustomRoutingAcceleratorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomRoutingAccelerators(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomRoutingAcceleratorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingAcceleratorsIterable listCustomRoutingAcceleratorsPaginator(
            ListCustomRoutingAcceleratorsRequest listCustomRoutingAcceleratorsRequest) throws InvalidArgumentException,
            InvalidNextTokenException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the custom routing accelerators for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomRoutingAccelerators(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingAcceleratorsIterable responses = client.listCustomRoutingAcceleratorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingAcceleratorsIterable responses = client
     *             .listCustomRoutingAcceleratorsPaginator(request);
     *     for (software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingAcceleratorsIterable responses = client.listCustomRoutingAcceleratorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomRoutingAccelerators(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomRoutingAcceleratorsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCustomRoutingAcceleratorsRequest#builder()}
     * </p>
     *
     * @param listCustomRoutingAcceleratorsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomRoutingAcceleratorsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingAcceleratorsIterable listCustomRoutingAcceleratorsPaginator(
            Consumer<ListCustomRoutingAcceleratorsRequest.Builder> listCustomRoutingAcceleratorsRequest)
            throws InvalidArgumentException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        return listCustomRoutingAcceleratorsPaginator(ListCustomRoutingAcceleratorsRequest.builder()
                .applyMutation(listCustomRoutingAcceleratorsRequest).build());
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener for a custom routing accelerator.
     * </p>
     *
     * @param listCustomRoutingEndpointGroupsRequest
     * @return Result of the ListCustomRoutingEndpointGroups operation returned by the service.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingEndpointGroups
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingEndpointGroupsResponse listCustomRoutingEndpointGroups(
            ListCustomRoutingEndpointGroupsRequest listCustomRoutingEndpointGroupsRequest) throws ListenerNotFoundException,
            InvalidNextTokenException, InvalidArgumentException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomRoutingEndpointGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCustomRoutingEndpointGroupsRequest#builder()}
     * </p>
     *
     * @param listCustomRoutingEndpointGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomRoutingEndpointGroupsRequest.Builder} to
     *        create a request.
     * @return Result of the ListCustomRoutingEndpointGroups operation returned by the service.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingEndpointGroups
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingEndpointGroupsResponse listCustomRoutingEndpointGroups(
            Consumer<ListCustomRoutingEndpointGroupsRequest.Builder> listCustomRoutingEndpointGroupsRequest)
            throws ListenerNotFoundException, InvalidNextTokenException, InvalidArgumentException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return listCustomRoutingEndpointGroups(ListCustomRoutingEndpointGroupsRequest.builder()
                .applyMutation(listCustomRoutingEndpointGroupsRequest).build());
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomRoutingEndpointGroups(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingEndpointGroupsIterable responses = client.listCustomRoutingEndpointGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingEndpointGroupsIterable responses = client
     *             .listCustomRoutingEndpointGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingEndpointGroupsIterable responses = client.listCustomRoutingEndpointGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomRoutingEndpointGroups(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomRoutingEndpointGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingEndpointGroups
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingEndpointGroupsIterable listCustomRoutingEndpointGroupsPaginator(
            ListCustomRoutingEndpointGroupsRequest listCustomRoutingEndpointGroupsRequest) throws ListenerNotFoundException,
            InvalidNextTokenException, InvalidArgumentException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomRoutingEndpointGroups(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingEndpointGroupsIterable responses = client.listCustomRoutingEndpointGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingEndpointGroupsIterable responses = client
     *             .listCustomRoutingEndpointGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingEndpointGroupsIterable responses = client.listCustomRoutingEndpointGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomRoutingEndpointGroups(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomRoutingEndpointGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCustomRoutingEndpointGroupsRequest#builder()}
     * </p>
     *
     * @param listCustomRoutingEndpointGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomRoutingEndpointGroupsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingEndpointGroups
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingEndpointGroupsIterable listCustomRoutingEndpointGroupsPaginator(
            Consumer<ListCustomRoutingEndpointGroupsRequest.Builder> listCustomRoutingEndpointGroupsRequest)
            throws ListenerNotFoundException, InvalidNextTokenException, InvalidArgumentException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return listCustomRoutingEndpointGroupsPaginator(ListCustomRoutingEndpointGroupsRequest.builder()
                .applyMutation(listCustomRoutingEndpointGroupsRequest).build());
    }

    /**
     * <p>
     * List the listeners for a custom routing accelerator.
     * </p>
     *
     * @param listCustomRoutingListenersRequest
     * @return Result of the ListCustomRoutingListeners operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingListenersResponse listCustomRoutingListeners(
            ListCustomRoutingListenersRequest listCustomRoutingListenersRequest) throws InvalidArgumentException,
            AcceleratorNotFoundException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the listeners for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomRoutingListenersRequest.Builder} avoiding
     * the need to create one manually via {@link ListCustomRoutingListenersRequest#builder()}
     * </p>
     *
     * @param listCustomRoutingListenersRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomRoutingListenersRequest.Builder} to create a
     *        request.
     * @return Result of the ListCustomRoutingListeners operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingListenersResponse listCustomRoutingListeners(
            Consumer<ListCustomRoutingListenersRequest.Builder> listCustomRoutingListenersRequest)
            throws InvalidArgumentException, AcceleratorNotFoundException, InvalidNextTokenException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return listCustomRoutingListeners(ListCustomRoutingListenersRequest.builder()
                .applyMutation(listCustomRoutingListenersRequest).build());
    }

    /**
     * <p>
     * List the listeners for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomRoutingListeners(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingListenersIterable responses = client.listCustomRoutingListenersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingListenersIterable responses = client
     *             .listCustomRoutingListenersPaginator(request);
     *     for (software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingListenersIterable responses = client.listCustomRoutingListenersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomRoutingListeners(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomRoutingListenersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingListenersIterable listCustomRoutingListenersPaginator(
            ListCustomRoutingListenersRequest listCustomRoutingListenersRequest) throws InvalidArgumentException,
            AcceleratorNotFoundException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the listeners for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomRoutingListeners(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingListenersIterable responses = client.listCustomRoutingListenersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingListenersIterable responses = client
     *             .listCustomRoutingListenersPaginator(request);
     *     for (software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingListenersIterable responses = client.listCustomRoutingListenersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomRoutingListeners(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomRoutingListenersRequest.Builder} avoiding
     * the need to create one manually via {@link ListCustomRoutingListenersRequest#builder()}
     * </p>
     *
     * @param listCustomRoutingListenersRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomRoutingListenersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingListenersIterable listCustomRoutingListenersPaginator(
            Consumer<ListCustomRoutingListenersRequest.Builder> listCustomRoutingListenersRequest)
            throws InvalidArgumentException, AcceleratorNotFoundException, InvalidNextTokenException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return listCustomRoutingListenersPaginator(ListCustomRoutingListenersRequest.builder()
                .applyMutation(listCustomRoutingListenersRequest).build());
    }

    /**
     * <p>
     * Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance IP
     * addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator. For each
     * subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port
     * mappings don't change after Global Accelerator generates them, so you can retrieve and cache the full mapping on
     * your servers.
     * </p>
     * <p>
     * If you remove a subnet from your accelerator, Global Accelerator removes (reclaims) the port mappings. If you add
     * a subnet to your accelerator, Global Accelerator creates new port mappings (the existing ones don't change). If
     * you add or remove EC2 instances in your subnet, the port mappings don't change, because the mappings are created
     * when you add the subnet to Global Accelerator.
     * </p>
     * <p>
     * The mappings also include a flag for each destination denoting which destination IP addresses and ports are
     * allowed or denied traffic.
     * </p>
     *
     * @param listCustomRoutingPortMappingsRequest
     * @return Result of the ListCustomRoutingPortMappings operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingPortMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingPortMappingsResponse listCustomRoutingPortMappings(
            ListCustomRoutingPortMappingsRequest listCustomRoutingPortMappingsRequest) throws InvalidArgumentException,
            InvalidNextTokenException, EndpointGroupNotFoundException, AcceleratorNotFoundException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance IP
     * addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator. For each
     * subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port
     * mappings don't change after Global Accelerator generates them, so you can retrieve and cache the full mapping on
     * your servers.
     * </p>
     * <p>
     * If you remove a subnet from your accelerator, Global Accelerator removes (reclaims) the port mappings. If you add
     * a subnet to your accelerator, Global Accelerator creates new port mappings (the existing ones don't change). If
     * you add or remove EC2 instances in your subnet, the port mappings don't change, because the mappings are created
     * when you add the subnet to Global Accelerator.
     * </p>
     * <p>
     * The mappings also include a flag for each destination denoting which destination IP addresses and ports are
     * allowed or denied traffic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomRoutingPortMappingsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCustomRoutingPortMappingsRequest#builder()}
     * </p>
     *
     * @param listCustomRoutingPortMappingsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomRoutingPortMappingsRequest.Builder} to
     *        create a request.
     * @return Result of the ListCustomRoutingPortMappings operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingPortMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingPortMappingsResponse listCustomRoutingPortMappings(
            Consumer<ListCustomRoutingPortMappingsRequest.Builder> listCustomRoutingPortMappingsRequest)
            throws InvalidArgumentException, InvalidNextTokenException, EndpointGroupNotFoundException,
            AcceleratorNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        return listCustomRoutingPortMappings(ListCustomRoutingPortMappingsRequest.builder()
                .applyMutation(listCustomRoutingPortMappingsRequest).build());
    }

    /**
     * <p>
     * Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance IP
     * addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator. For each
     * subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port
     * mappings don't change after Global Accelerator generates them, so you can retrieve and cache the full mapping on
     * your servers.
     * </p>
     * <p>
     * If you remove a subnet from your accelerator, Global Accelerator removes (reclaims) the port mappings. If you add
     * a subnet to your accelerator, Global Accelerator creates new port mappings (the existing ones don't change). If
     * you add or remove EC2 instances in your subnet, the port mappings don't change, because the mappings are created
     * when you add the subnet to Global Accelerator.
     * </p>
     * <p>
     * The mappings also include a flag for each destination denoting which destination IP addresses and ports are
     * allowed or denied traffic.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomRoutingPortMappings(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsIterable responses = client.listCustomRoutingPortMappingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsIterable responses = client
     *             .listCustomRoutingPortMappingsPaginator(request);
     *     for (software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsIterable responses = client.listCustomRoutingPortMappingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomRoutingPortMappings(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomRoutingPortMappingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingPortMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingPortMappingsIterable listCustomRoutingPortMappingsPaginator(
            ListCustomRoutingPortMappingsRequest listCustomRoutingPortMappingsRequest) throws InvalidArgumentException,
            InvalidNextTokenException, EndpointGroupNotFoundException, AcceleratorNotFoundException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance IP
     * addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator. For each
     * subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port
     * mappings don't change after Global Accelerator generates them, so you can retrieve and cache the full mapping on
     * your servers.
     * </p>
     * <p>
     * If you remove a subnet from your accelerator, Global Accelerator removes (reclaims) the port mappings. If you add
     * a subnet to your accelerator, Global Accelerator creates new port mappings (the existing ones don't change). If
     * you add or remove EC2 instances in your subnet, the port mappings don't change, because the mappings are created
     * when you add the subnet to Global Accelerator.
     * </p>
     * <p>
     * The mappings also include a flag for each destination denoting which destination IP addresses and ports are
     * allowed or denied traffic.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomRoutingPortMappings(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsIterable responses = client.listCustomRoutingPortMappingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsIterable responses = client
     *             .listCustomRoutingPortMappingsPaginator(request);
     *     for (software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsIterable responses = client.listCustomRoutingPortMappingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomRoutingPortMappings(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomRoutingPortMappingsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCustomRoutingPortMappingsRequest#builder()}
     * </p>
     *
     * @param listCustomRoutingPortMappingsRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomRoutingPortMappingsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingPortMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingPortMappingsIterable listCustomRoutingPortMappingsPaginator(
            Consumer<ListCustomRoutingPortMappingsRequest.Builder> listCustomRoutingPortMappingsRequest)
            throws InvalidArgumentException, InvalidNextTokenException, EndpointGroupNotFoundException,
            AcceleratorNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        return listCustomRoutingPortMappingsPaginator(ListCustomRoutingPortMappingsRequest.builder()
                .applyMutation(listCustomRoutingPortMappingsRequest).build());
    }

    /**
     * <p>
     * List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint. The response is the
     * mappings for one destination IP address. This is useful when your subnet endpoint has mappings that span multiple
     * custom routing accelerators in your account, or for scenarios where you only want to list the port mappings for a
     * specific destination instance.
     * </p>
     *
     * @param listCustomRoutingPortMappingsByDestinationRequest
     * @return Result of the ListCustomRoutingPortMappingsByDestination operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws EndpointNotFoundException
     *         The endpoint that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingPortMappingsByDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappingsByDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingPortMappingsByDestinationResponse listCustomRoutingPortMappingsByDestination(
            ListCustomRoutingPortMappingsByDestinationRequest listCustomRoutingPortMappingsByDestinationRequest)
            throws InvalidArgumentException, InvalidNextTokenException, EndpointNotFoundException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint. The response is the
     * mappings for one destination IP address. This is useful when your subnet endpoint has mappings that span multiple
     * custom routing accelerators in your account, or for scenarios where you only want to list the port mappings for a
     * specific destination instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCustomRoutingPortMappingsByDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link ListCustomRoutingPortMappingsByDestinationRequest#builder()}
     * </p>
     *
     * @param listCustomRoutingPortMappingsByDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListCustomRoutingPortMappingsByDestinationRequest.Builder} to create a request.
     * @return Result of the ListCustomRoutingPortMappingsByDestination operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws EndpointNotFoundException
     *         The endpoint that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingPortMappingsByDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappingsByDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingPortMappingsByDestinationResponse listCustomRoutingPortMappingsByDestination(
            Consumer<ListCustomRoutingPortMappingsByDestinationRequest.Builder> listCustomRoutingPortMappingsByDestinationRequest)
            throws InvalidArgumentException, InvalidNextTokenException, EndpointNotFoundException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return listCustomRoutingPortMappingsByDestination(ListCustomRoutingPortMappingsByDestinationRequest.builder()
                .applyMutation(listCustomRoutingPortMappingsByDestinationRequest).build());
    }

    /**
     * <p>
     * List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint. The response is the
     * mappings for one destination IP address. This is useful when your subnet endpoint has mappings that span multiple
     * custom routing accelerators in your account, or for scenarios where you only want to list the port mappings for a
     * specific destination instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomRoutingPortMappingsByDestination(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsByDestinationIterable responses = client.listCustomRoutingPortMappingsByDestinationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsByDestinationIterable responses = client
     *             .listCustomRoutingPortMappingsByDestinationPaginator(request);
     *     for (software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsByDestinationIterable responses = client.listCustomRoutingPortMappingsByDestinationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomRoutingPortMappingsByDestination(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomRoutingPortMappingsByDestinationRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws EndpointNotFoundException
     *         The endpoint that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingPortMappingsByDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappingsByDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingPortMappingsByDestinationIterable listCustomRoutingPortMappingsByDestinationPaginator(
            ListCustomRoutingPortMappingsByDestinationRequest listCustomRoutingPortMappingsByDestinationRequest)
            throws InvalidArgumentException, InvalidNextTokenException, EndpointNotFoundException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint. The response is the
     * mappings for one destination IP address. This is useful when your subnet endpoint has mappings that span multiple
     * custom routing accelerators in your account, or for scenarios where you only want to list the port mappings for a
     * specific destination instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomRoutingPortMappingsByDestination(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsByDestinationIterable responses = client.listCustomRoutingPortMappingsByDestinationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsByDestinationIterable responses = client
     *             .listCustomRoutingPortMappingsByDestinationPaginator(request);
     *     for (software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsByDestinationIterable responses = client.listCustomRoutingPortMappingsByDestinationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomRoutingPortMappingsByDestination(software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCustomRoutingPortMappingsByDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link ListCustomRoutingPortMappingsByDestinationRequest#builder()}
     * </p>
     *
     * @param listCustomRoutingPortMappingsByDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListCustomRoutingPortMappingsByDestinationRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws EndpointNotFoundException
     *         The endpoint that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingPortMappingsByDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappingsByDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomRoutingPortMappingsByDestinationIterable listCustomRoutingPortMappingsByDestinationPaginator(
            Consumer<ListCustomRoutingPortMappingsByDestinationRequest.Builder> listCustomRoutingPortMappingsByDestinationRequest)
            throws InvalidArgumentException, InvalidNextTokenException, EndpointNotFoundException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return listCustomRoutingPortMappingsByDestinationPaginator(ListCustomRoutingPortMappingsByDestinationRequest.builder()
                .applyMutation(listCustomRoutingPortMappingsByDestinationRequest).build());
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener.
     * </p>
     *
     * @param listEndpointGroupsRequest
     * @return Result of the ListEndpointGroups operation returned by the service.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListEndpointGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEndpointGroupsResponse listEndpointGroups(ListEndpointGroupsRequest listEndpointGroupsRequest)
            throws ListenerNotFoundException, InvalidNextTokenException, InvalidArgumentException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEndpointGroupsRequest#builder()}
     * </p>
     *
     * @param listEndpointGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListEndpointGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the ListEndpointGroups operation returned by the service.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListEndpointGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEndpointGroupsResponse listEndpointGroups(Consumer<ListEndpointGroupsRequest.Builder> listEndpointGroupsRequest)
            throws ListenerNotFoundException, InvalidNextTokenException, InvalidArgumentException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return listEndpointGroups(ListEndpointGroupsRequest.builder().applyMutation(listEndpointGroupsRequest).build());
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEndpointGroups(software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListEndpointGroupsIterable responses = client.listEndpointGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.globalaccelerator.paginators.ListEndpointGroupsIterable responses = client
     *             .listEndpointGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListEndpointGroupsIterable responses = client.listEndpointGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpointGroups(software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEndpointGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListEndpointGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEndpointGroupsIterable listEndpointGroupsPaginator(ListEndpointGroupsRequest listEndpointGroupsRequest)
            throws ListenerNotFoundException, InvalidNextTokenException, InvalidArgumentException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEndpointGroups(software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListEndpointGroupsIterable responses = client.listEndpointGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.globalaccelerator.paginators.ListEndpointGroupsIterable responses = client
     *             .listEndpointGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListEndpointGroupsIterable responses = client.listEndpointGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpointGroups(software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEndpointGroupsRequest#builder()}
     * </p>
     *
     * @param listEndpointGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListEndpointGroupsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListEndpointGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEndpointGroupsIterable listEndpointGroupsPaginator(
            Consumer<ListEndpointGroupsRequest.Builder> listEndpointGroupsRequest) throws ListenerNotFoundException,
            InvalidNextTokenException, InvalidArgumentException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        return listEndpointGroupsPaginator(ListEndpointGroupsRequest.builder().applyMutation(listEndpointGroupsRequest).build());
    }

    /**
     * <p>
     * List the listeners for an accelerator.
     * </p>
     *
     * @param listListenersRequest
     * @return Result of the ListListeners operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default ListListenersResponse listListeners(ListListenersRequest listListenersRequest) throws InvalidArgumentException,
            AcceleratorNotFoundException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the listeners for an accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListListenersRequest.Builder} avoiding the need to
     * create one manually via {@link ListListenersRequest#builder()}
     * </p>
     *
     * @param listListenersRequest
     *        A {@link Consumer} that will call methods on {@link ListListenersRequest.Builder} to create a request.
     * @return Result of the ListListeners operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default ListListenersResponse listListeners(Consumer<ListListenersRequest.Builder> listListenersRequest)
            throws InvalidArgumentException, AcceleratorNotFoundException, InvalidNextTokenException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return listListeners(ListListenersRequest.builder().applyMutation(listListenersRequest).build());
    }

    /**
     * <p>
     * List the listeners for an accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listListeners(software.amazon.awssdk.services.globalaccelerator.model.ListListenersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListListenersIterable responses = client.listListenersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.globalaccelerator.paginators.ListListenersIterable responses = client
     *             .listListenersPaginator(request);
     *     for (software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListListenersIterable responses = client.listListenersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listListeners(software.amazon.awssdk.services.globalaccelerator.model.ListListenersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listListenersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default ListListenersIterable listListenersPaginator(ListListenersRequest listListenersRequest)
            throws InvalidArgumentException, AcceleratorNotFoundException, InvalidNextTokenException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the listeners for an accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listListeners(software.amazon.awssdk.services.globalaccelerator.model.ListListenersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListListenersIterable responses = client.listListenersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.globalaccelerator.paginators.ListListenersIterable responses = client
     *             .listListenersPaginator(request);
     *     for (software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.globalaccelerator.paginators.ListListenersIterable responses = client.listListenersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listListeners(software.amazon.awssdk.services.globalaccelerator.model.ListListenersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListListenersRequest.Builder} avoiding the need to
     * create one manually via {@link ListListenersRequest#builder()}
     * </p>
     *
     * @param listListenersRequest
     *        A {@link Consumer} that will call methods on {@link ListListenersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListListeners"
     *      target="_top">AWS API Documentation</a>
     */
    default ListListenersIterable listListenersPaginator(Consumer<ListListenersRequest.Builder> listListenersRequest)
            throws InvalidArgumentException, AcceleratorNotFoundException, InvalidNextTokenException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return listListenersPaginator(ListListenersRequest.builder().applyMutation(listListenersRequest).build());
    }

    /**
     * <p>
     * List all tags for an accelerator.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
     * Global Accelerator</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all tags for an accelerator.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
     * Global Accelerator</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws AcceleratorNotFoundException,
            InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Provisions an IP address range to use with your Amazon Web Services resources through bring your own IP addresses
     * (BYOIP) and creates a corresponding address pool. After the address range is provisioned, it is ready to be
     * advertised using <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/AdvertiseByoipCidr.html">
     * AdvertiseByoipCidr</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param provisionByoipCidrRequest
     * @return Result of the ProvisionByoipCidr operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws IncorrectCidrStateException
     *         The CIDR that you specified is not valid for this action. For example, the state of the CIDR might be
     *         incorrect for this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ProvisionByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ProvisionByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    default ProvisionByoipCidrResponse provisionByoipCidr(ProvisionByoipCidrRequest provisionByoipCidrRequest)
            throws InternalServiceErrorException, InvalidArgumentException, LimitExceededException, AccessDeniedException,
            IncorrectCidrStateException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provisions an IP address range to use with your Amazon Web Services resources through bring your own IP addresses
     * (BYOIP) and creates a corresponding address pool. After the address range is provisioned, it is ready to be
     * advertised using <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/AdvertiseByoipCidr.html">
     * AdvertiseByoipCidr</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ProvisionByoipCidrRequest.Builder} avoiding the
     * need to create one manually via {@link ProvisionByoipCidrRequest#builder()}
     * </p>
     *
     * @param provisionByoipCidrRequest
     *        A {@link Consumer} that will call methods on {@link ProvisionByoipCidrRequest.Builder} to create a
     *        request.
     * @return Result of the ProvisionByoipCidr operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws IncorrectCidrStateException
     *         The CIDR that you specified is not valid for this action. For example, the state of the CIDR might be
     *         incorrect for this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ProvisionByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ProvisionByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    default ProvisionByoipCidrResponse provisionByoipCidr(Consumer<ProvisionByoipCidrRequest.Builder> provisionByoipCidrRequest)
            throws InternalServiceErrorException, InvalidArgumentException, LimitExceededException, AccessDeniedException,
            IncorrectCidrStateException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return provisionByoipCidr(ProvisionByoipCidrRequest.builder().applyMutation(provisionByoipCidrRequest).build());
    }

    /**
     * <p>
     * Remove endpoints from a custom routing accelerator.
     * </p>
     *
     * @param removeCustomRoutingEndpointsRequest
     * @return Result of the RemoveCustomRoutingEndpoints operation returned by the service.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws EndpointNotFoundException
     *         The endpoint that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws ConflictException
     *         You can't use both of those options.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.RemoveCustomRoutingEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/RemoveCustomRoutingEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveCustomRoutingEndpointsResponse removeCustomRoutingEndpoints(
            RemoveCustomRoutingEndpointsRequest removeCustomRoutingEndpointsRequest) throws EndpointGroupNotFoundException,
            EndpointNotFoundException, InternalServiceErrorException, InvalidArgumentException, AccessDeniedException,
            ConflictException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove endpoints from a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveCustomRoutingEndpointsRequest.Builder}
     * avoiding the need to create one manually via {@link RemoveCustomRoutingEndpointsRequest#builder()}
     * </p>
     *
     * @param removeCustomRoutingEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link RemoveCustomRoutingEndpointsRequest.Builder} to create
     *        a request.
     * @return Result of the RemoveCustomRoutingEndpoints operation returned by the service.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws EndpointNotFoundException
     *         The endpoint that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws ConflictException
     *         You can't use both of those options.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.RemoveCustomRoutingEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/RemoveCustomRoutingEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveCustomRoutingEndpointsResponse removeCustomRoutingEndpoints(
            Consumer<RemoveCustomRoutingEndpointsRequest.Builder> removeCustomRoutingEndpointsRequest)
            throws EndpointGroupNotFoundException, EndpointNotFoundException, InternalServiceErrorException,
            InvalidArgumentException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        return removeCustomRoutingEndpoints(RemoveCustomRoutingEndpointsRequest.builder()
                .applyMutation(removeCustomRoutingEndpointsRequest).build());
    }

    /**
     * <p>
     * Add tags to an accelerator resource.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
     * Global Accelerator</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AcceleratorNotFoundException,
            InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add tags to an accelerator resource.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
     * Global Accelerator</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Remove tags from a Global Accelerator resource. When you specify a tag key, the action removes both that key and
     * its associated value. The operation succeeds even if you attempt to remove tags from an accelerator that was
     * already removed.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
     * Global Accelerator</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AcceleratorNotFoundException,
            InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove tags from a Global Accelerator resource. When you specify a tag key, the action removes both that key and
     * its associated value. The operation succeeds even if you attempt to remove tags from an accelerator that was
     * already removed.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
     * Global Accelerator</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update an accelerator.
     * </p>
     * <important>
     * <p>
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you
     * must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for
     * example, specify <code>--region us-west-2</code> on AWS CLI commands.
     * </p>
     * </important>
     *
     * @param updateAcceleratorRequest
     * @return Result of the UpdateAccelerator operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAcceleratorResponse updateAccelerator(UpdateAcceleratorRequest updateAcceleratorRequest)
            throws AcceleratorNotFoundException, AccessDeniedException, InternalServiceErrorException, InvalidArgumentException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an accelerator.
     * </p>
     * <important>
     * <p>
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you
     * must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for
     * example, specify <code>--region us-west-2</code> on AWS CLI commands.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAcceleratorRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAcceleratorRequest#builder()}
     * </p>
     *
     * @param updateAcceleratorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAcceleratorRequest.Builder} to create a request.
     * @return Result of the UpdateAccelerator operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAcceleratorResponse updateAccelerator(Consumer<UpdateAcceleratorRequest.Builder> updateAcceleratorRequest)
            throws AcceleratorNotFoundException, AccessDeniedException, InternalServiceErrorException, InvalidArgumentException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return updateAccelerator(UpdateAcceleratorRequest.builder().applyMutation(updateAcceleratorRequest).build());
    }

    /**
     * <p>
     * Update the attributes for an accelerator.
     * </p>
     *
     * @param updateAcceleratorAttributesRequest
     * @return Result of the UpdateAcceleratorAttributes operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateAcceleratorAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAcceleratorAttributesResponse updateAcceleratorAttributes(
            UpdateAcceleratorAttributesRequest updateAcceleratorAttributesRequest) throws AcceleratorNotFoundException,
            InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the attributes for an accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAcceleratorAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAcceleratorAttributesRequest#builder()}
     * </p>
     *
     * @param updateAcceleratorAttributesRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAcceleratorAttributesRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateAcceleratorAttributes operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateAcceleratorAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAcceleratorAttributesResponse updateAcceleratorAttributes(
            Consumer<UpdateAcceleratorAttributesRequest.Builder> updateAcceleratorAttributesRequest)
            throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AccessDeniedException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return updateAcceleratorAttributes(UpdateAcceleratorAttributesRequest.builder()
                .applyMutation(updateAcceleratorAttributesRequest).build());
    }

    /**
     * <p>
     * Update a custom routing accelerator.
     * </p>
     *
     * @param updateCustomRoutingAcceleratorRequest
     * @return Result of the UpdateCustomRoutingAccelerator operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCustomRoutingAcceleratorResponse updateCustomRoutingAccelerator(
            UpdateCustomRoutingAcceleratorRequest updateCustomRoutingAcceleratorRequest) throws AcceleratorNotFoundException,
            InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCustomRoutingAcceleratorRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCustomRoutingAcceleratorRequest#builder()}
     * </p>
     *
     * @param updateCustomRoutingAcceleratorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCustomRoutingAcceleratorRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateCustomRoutingAccelerator operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCustomRoutingAcceleratorResponse updateCustomRoutingAccelerator(
            Consumer<UpdateCustomRoutingAcceleratorRequest.Builder> updateCustomRoutingAcceleratorRequest)
            throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        return updateCustomRoutingAccelerator(UpdateCustomRoutingAcceleratorRequest.builder()
                .applyMutation(updateCustomRoutingAcceleratorRequest).build());
    }

    /**
     * <p>
     * Update the attributes for a custom routing accelerator.
     * </p>
     *
     * @param updateCustomRoutingAcceleratorAttributesRequest
     * @return Result of the UpdateCustomRoutingAcceleratorAttributes operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateCustomRoutingAcceleratorAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCustomRoutingAcceleratorAttributesResponse updateCustomRoutingAcceleratorAttributes(
            UpdateCustomRoutingAcceleratorAttributesRequest updateCustomRoutingAcceleratorAttributesRequest)
            throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AccessDeniedException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the attributes for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateCustomRoutingAcceleratorAttributesRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateCustomRoutingAcceleratorAttributesRequest#builder()}
     * </p>
     *
     * @param updateCustomRoutingAcceleratorAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link UpdateCustomRoutingAcceleratorAttributesRequest.Builder} to create a request.
     * @return Result of the UpdateCustomRoutingAcceleratorAttributes operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateCustomRoutingAcceleratorAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCustomRoutingAcceleratorAttributesResponse updateCustomRoutingAcceleratorAttributes(
            Consumer<UpdateCustomRoutingAcceleratorAttributesRequest.Builder> updateCustomRoutingAcceleratorAttributesRequest)
            throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AccessDeniedException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return updateCustomRoutingAcceleratorAttributes(UpdateCustomRoutingAcceleratorAttributesRequest.builder()
                .applyMutation(updateCustomRoutingAcceleratorAttributesRequest).build());
    }

    /**
     * <p>
     * Update a listener for a custom routing accelerator.
     * </p>
     *
     * @param updateCustomRoutingListenerRequest
     * @return Result of the UpdateCustomRoutingListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidPortRangeException
     *         The port numbers that you specified are not valid numbers or are not unique for this accelerator.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCustomRoutingListenerResponse updateCustomRoutingListener(
            UpdateCustomRoutingListenerRequest updateCustomRoutingListenerRequest) throws InvalidArgumentException,
            InvalidPortRangeException, ListenerNotFoundException, InternalServiceErrorException, LimitExceededException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a listener for a custom routing accelerator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCustomRoutingListenerRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCustomRoutingListenerRequest#builder()}
     * </p>
     *
     * @param updateCustomRoutingListenerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCustomRoutingListenerRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateCustomRoutingListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidPortRangeException
     *         The port numbers that you specified are not valid numbers or are not unique for this accelerator.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCustomRoutingListenerResponse updateCustomRoutingListener(
            Consumer<UpdateCustomRoutingListenerRequest.Builder> updateCustomRoutingListenerRequest)
            throws InvalidArgumentException, InvalidPortRangeException, ListenerNotFoundException, InternalServiceErrorException,
            LimitExceededException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return updateCustomRoutingListener(UpdateCustomRoutingListenerRequest.builder()
                .applyMutation(updateCustomRoutingListenerRequest).build());
    }

    /**
     * <p>
     * Update an endpoint group. A resource must be valid and active when you add it as an endpoint.
     * </p>
     *
     * @param updateEndpointGroupRequest
     * @return Result of the UpdateEndpointGroup operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEndpointGroupResponse updateEndpointGroup(UpdateEndpointGroupRequest updateEndpointGroupRequest)
            throws InvalidArgumentException, EndpointGroupNotFoundException, InternalServiceErrorException,
            LimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an endpoint group. A resource must be valid and active when you add it as an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEndpointGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEndpointGroupRequest#builder()}
     * </p>
     *
     * @param updateEndpointGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEndpointGroupRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateEndpointGroup operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEndpointGroupResponse updateEndpointGroup(
            Consumer<UpdateEndpointGroupRequest.Builder> updateEndpointGroupRequest) throws InvalidArgumentException,
            EndpointGroupNotFoundException, InternalServiceErrorException, LimitExceededException, AccessDeniedException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return updateEndpointGroup(UpdateEndpointGroupRequest.builder().applyMutation(updateEndpointGroupRequest).build());
    }

    /**
     * <p>
     * Update a listener.
     * </p>
     *
     * @param updateListenerRequest
     * @return Result of the UpdateListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidPortRangeException
     *         The port numbers that you specified are not valid numbers or are not unique for this accelerator.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateListener"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateListenerResponse updateListener(UpdateListenerRequest updateListenerRequest) throws InvalidArgumentException,
            InvalidPortRangeException, ListenerNotFoundException, InternalServiceErrorException, LimitExceededException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a listener.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateListenerRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateListenerRequest#builder()}
     * </p>
     *
     * @param updateListenerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateListenerRequest.Builder} to create a request.
     * @return Result of the UpdateListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidPortRangeException
     *         The port numbers that you specified are not valid numbers or are not unique for this accelerator.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateListener"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateListenerResponse updateListener(Consumer<UpdateListenerRequest.Builder> updateListenerRequest)
            throws InvalidArgumentException, InvalidPortRangeException, ListenerNotFoundException, InternalServiceErrorException,
            LimitExceededException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return updateListener(UpdateListenerRequest.builder().applyMutation(updateListenerRequest).build());
    }

    /**
     * <p>
     * Stops advertising an address range that is provisioned as an address pool. You can perform this operation at most
     * once every 10 seconds, even if you specify different address ranges each time.
     * </p>
     * <p>
     * It can take a few minutes before traffic to the specified addresses stops routing to Amazon Web Services because
     * of propagation delays.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param withdrawByoipCidrRequest
     * @return Result of the WithdrawByoipCidr operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws ByoipCidrNotFoundException
     *         The CIDR that you specified was not found or is incorrect.
     * @throws IncorrectCidrStateException
     *         The CIDR that you specified is not valid for this action. For example, the state of the CIDR might be
     *         incorrect for this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.WithdrawByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/WithdrawByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    default WithdrawByoipCidrResponse withdrawByoipCidr(WithdrawByoipCidrRequest withdrawByoipCidrRequest)
            throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, ByoipCidrNotFoundException,
            IncorrectCidrStateException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops advertising an address range that is provisioned as an address pool. You can perform this operation at most
     * once every 10 seconds, even if you specify different address ranges each time.
     * </p>
     * <p>
     * It can take a few minutes before traffic to the specified addresses stops routing to Amazon Web Services because
     * of propagation delays.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link WithdrawByoipCidrRequest.Builder} avoiding the need
     * to create one manually via {@link WithdrawByoipCidrRequest#builder()}
     * </p>
     *
     * @param withdrawByoipCidrRequest
     *        A {@link Consumer} that will call methods on {@link WithdrawByoipCidrRequest.Builder} to create a request.
     * @return Result of the WithdrawByoipCidr operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws ByoipCidrNotFoundException
     *         The CIDR that you specified was not found or is incorrect.
     * @throws IncorrectCidrStateException
     *         The CIDR that you specified is not valid for this action. For example, the state of the CIDR might be
     *         incorrect for this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.WithdrawByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/WithdrawByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    default WithdrawByoipCidrResponse withdrawByoipCidr(Consumer<WithdrawByoipCidrRequest.Builder> withdrawByoipCidrRequest)
            throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, ByoipCidrNotFoundException,
            IncorrectCidrStateException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return withdrawByoipCidr(WithdrawByoipCidrRequest.builder().applyMutation(withdrawByoipCidrRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
