/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorAsyncClient;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointGroup;
import software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse;

public class ListEndpointGroupsPublisher
implements SdkPublisher<ListEndpointGroupsResponse> {
    private final GlobalAcceleratorAsyncClient client;
    private final ListEndpointGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEndpointGroupsPublisher(GlobalAcceleratorAsyncClient client, ListEndpointGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEndpointGroupsPublisher(GlobalAcceleratorAsyncClient client, ListEndpointGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEndpointGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEndpointGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EndpointGroup> endpointGroups() {
        Function<ListEndpointGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.endpointGroups() != null) {
                return response.endpointGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEndpointGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEndpointGroupsResponseFetcher
    implements AsyncPageFetcher<ListEndpointGroupsResponse> {
        private ListEndpointGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListEndpointGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEndpointGroupsResponse> nextPage(ListEndpointGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListEndpointGroupsPublisher.this.client.listEndpointGroups(ListEndpointGroupsPublisher.this.firstRequest);
            }
            return ListEndpointGroupsPublisher.this.client.listEndpointGroups((ListEndpointGroupsRequest)((Object)ListEndpointGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

