/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorClient;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingAccelerator;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse;

public class ListCustomRoutingAcceleratorsIterable
implements SdkIterable<ListCustomRoutingAcceleratorsResponse> {
    private final GlobalAcceleratorClient client;
    private final ListCustomRoutingAcceleratorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCustomRoutingAcceleratorsIterable(GlobalAcceleratorClient client, ListCustomRoutingAcceleratorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCustomRoutingAcceleratorsResponseFetcher();
    }

    public Iterator<ListCustomRoutingAcceleratorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CustomRoutingAccelerator> accelerators() {
        Function<ListCustomRoutingAcceleratorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accelerators() != null) {
                return response.accelerators().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCustomRoutingAcceleratorsResponseFetcher
    implements SyncPageFetcher<ListCustomRoutingAcceleratorsResponse> {
        private ListCustomRoutingAcceleratorsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomRoutingAcceleratorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCustomRoutingAcceleratorsResponse nextPage(ListCustomRoutingAcceleratorsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomRoutingAcceleratorsIterable.this.client.listCustomRoutingAccelerators(ListCustomRoutingAcceleratorsIterable.this.firstRequest);
            }
            return ListCustomRoutingAcceleratorsIterable.this.client.listCustomRoutingAccelerators((ListCustomRoutingAcceleratorsRequest)((Object)ListCustomRoutingAcceleratorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

