/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCrossAccountAttachmentResponse extends GlobalAcceleratorResponse implements
        ToCopyableBuilder<DescribeCrossAccountAttachmentResponse.Builder, DescribeCrossAccountAttachmentResponse> {
    private static final SdkField<Attachment> CROSS_ACCOUNT_ATTACHMENT_FIELD = SdkField
            .<Attachment> builder(MarshallingType.SDK_POJO).memberName("CrossAccountAttachment")
            .getter(getter(DescribeCrossAccountAttachmentResponse::crossAccountAttachment))
            .setter(setter(Builder::crossAccountAttachment)).constructor(Attachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossAccountAttachment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CROSS_ACCOUNT_ATTACHMENT_FIELD));

    private final Attachment crossAccountAttachment;

    private DescribeCrossAccountAttachmentResponse(BuilderImpl builder) {
        super(builder);
        this.crossAccountAttachment = builder.crossAccountAttachment;
    }

    /**
     * <p>
     * Information about the cross-account attachment.
     * </p>
     * 
     * @return Information about the cross-account attachment.
     */
    public final Attachment crossAccountAttachment() {
        return crossAccountAttachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(crossAccountAttachment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCrossAccountAttachmentResponse)) {
            return false;
        }
        DescribeCrossAccountAttachmentResponse other = (DescribeCrossAccountAttachmentResponse) obj;
        return Objects.equals(crossAccountAttachment(), other.crossAccountAttachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCrossAccountAttachmentResponse").add("CrossAccountAttachment", crossAccountAttachment())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CrossAccountAttachment":
            return Optional.ofNullable(clazz.cast(crossAccountAttachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCrossAccountAttachmentResponse, T> g) {
        return obj -> g.apply((DescribeCrossAccountAttachmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCrossAccountAttachmentResponse> {
        /**
         * <p>
         * Information about the cross-account attachment.
         * </p>
         * 
         * @param crossAccountAttachment
         *        Information about the cross-account attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccountAttachment(Attachment crossAccountAttachment);

        /**
         * <p>
         * Information about the cross-account attachment.
         * </p>
         * This is a convenience method that creates an instance of the {@link Attachment.Builder} avoiding the need to
         * create one manually via {@link Attachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Attachment.Builder#build()} is called immediately and its result
         * is passed to {@link #crossAccountAttachment(Attachment)}.
         * 
         * @param crossAccountAttachment
         *        a consumer that will call methods on {@link Attachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crossAccountAttachment(Attachment)
         */
        default Builder crossAccountAttachment(Consumer<Attachment.Builder> crossAccountAttachment) {
            return crossAccountAttachment(Attachment.builder().applyMutation(crossAccountAttachment).build());
        }
    }

    static final class BuilderImpl extends GlobalAcceleratorResponse.BuilderImpl implements Builder {
        private Attachment crossAccountAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCrossAccountAttachmentResponse model) {
            super(model);
            crossAccountAttachment(model.crossAccountAttachment);
        }

        public final Attachment.Builder getCrossAccountAttachment() {
            return crossAccountAttachment != null ? crossAccountAttachment.toBuilder() : null;
        }

        public final void setCrossAccountAttachment(Attachment.BuilderImpl crossAccountAttachment) {
            this.crossAccountAttachment = crossAccountAttachment != null ? crossAccountAttachment.build() : null;
        }

        @Override
        public final Builder crossAccountAttachment(Attachment crossAccountAttachment) {
            this.crossAccountAttachment = crossAccountAttachment;
            return this;
        }

        @Override
        public DescribeCrossAccountAttachmentResponse build() {
            return new DescribeCrossAccountAttachmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
