/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An endpoint (Amazon Web Services resource) that is listed in a cross-account attachment and can be added to an
 * accelerator by specified principals, that are also listed in the attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CrossAccountResource implements SdkPojo, Serializable,
        ToCopyableBuilder<CrossAccountResource.Builder, CrossAccountResource> {
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointId").getter(getter(CrossAccountResource::endpointId)).setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()).build();

    private static final SdkField<String> ATTACHMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachmentArn").getter(getter(CrossAccountResource::attachmentArn))
            .setter(setter(Builder::attachmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ID_FIELD,
            ATTACHMENT_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endpointId;

    private final String attachmentArn;

    private CrossAccountResource(BuilderImpl builder) {
        this.endpointId = builder.endpointId;
        this.attachmentArn = builder.attachmentArn;
    }

    /**
     * <p>
     * The endpoint ID for the endpoint that is listed in a cross-account attachment and can be added to an accelerator
     * by specified principals.
     * </p>
     * 
     * @return The endpoint ID for the endpoint that is listed in a cross-account attachment and can be added to an
     *         accelerator by specified principals.
     */
    public final String endpointId() {
        return endpointId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the cross-account attachment that specifies the endpoints (resources) that can
     * be added to accelerators and principals that have permission to add the endpoints to accelerators.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the cross-account attachment that specifies the endpoints (resources)
     *         that can be added to accelerators and principals that have permission to add the endpoints to
     *         accelerators.
     */
    public final String attachmentArn() {
        return attachmentArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrossAccountResource)) {
            return false;
        }
        CrossAccountResource other = (CrossAccountResource) obj;
        return Objects.equals(endpointId(), other.endpointId()) && Objects.equals(attachmentArn(), other.attachmentArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CrossAccountResource").add("EndpointId", endpointId()).add("AttachmentArn", attachmentArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        case "AttachmentArn":
            return Optional.ofNullable(clazz.cast(attachmentArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CrossAccountResource, T> g) {
        return obj -> g.apply((CrossAccountResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CrossAccountResource> {
        /**
         * <p>
         * The endpoint ID for the endpoint that is listed in a cross-account attachment and can be added to an
         * accelerator by specified principals.
         * </p>
         * 
         * @param endpointId
         *        The endpoint ID for the endpoint that is listed in a cross-account attachment and can be added to an
         *        accelerator by specified principals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the cross-account attachment that specifies the endpoints (resources) that
         * can be added to accelerators and principals that have permission to add the endpoints to accelerators.
         * </p>
         * 
         * @param attachmentArn
         *        The Amazon Resource Name (ARN) of the cross-account attachment that specifies the endpoints
         *        (resources) that can be added to accelerators and principals that have permission to add the endpoints
         *        to accelerators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentArn(String attachmentArn);
    }

    static final class BuilderImpl implements Builder {
        private String endpointId;

        private String attachmentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CrossAccountResource model) {
            endpointId(model.endpointId);
            attachmentArn(model.attachmentArn);
        }

        public final String getEndpointId() {
            return endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final String getAttachmentArn() {
            return attachmentArn;
        }

        public final void setAttachmentArn(String attachmentArn) {
            this.attachmentArn = attachmentArn;
        }

        @Override
        public final Builder attachmentArn(String attachmentArn) {
            this.attachmentArn = attachmentArn;
            return this;
        }

        @Override
        public CrossAccountResource build() {
            return new CrossAccountResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
