/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.globalaccelerator.internal.GlobalAcceleratorServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.globalaccelerator.model.AcceleratorNotDisabledException;
import software.amazon.awssdk.services.globalaccelerator.model.AcceleratorNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.AccessDeniedException;
import software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AddEndpointsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AddEndpointsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AllowCustomRoutingTrafficRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AllowCustomRoutingTrafficResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AssociatedEndpointGroupFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.AssociatedListenerFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.AttachmentNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.ConflictException;
import software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCrossAccountAttachmentRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCrossAccountAttachmentResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCrossAccountAttachmentRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCrossAccountAttachmentResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeprovisionByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeprovisionByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCrossAccountAttachmentRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCrossAccountAttachmentResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointAlreadyExistsException;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointGroupAlreadyExistsException;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointGroupNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorException;
import software.amazon.awssdk.services.globalaccelerator.model.IncorrectCidrStateException;
import software.amazon.awssdk.services.globalaccelerator.model.InternalServiceErrorException;
import software.amazon.awssdk.services.globalaccelerator.model.InvalidArgumentException;
import software.amazon.awssdk.services.globalaccelerator.model.InvalidNextTokenException;
import software.amazon.awssdk.services.globalaccelerator.model.InvalidPortRangeException;
import software.amazon.awssdk.services.globalaccelerator.model.LimitExceededException;
import software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountAttachmentsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountAttachmentsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourceAccountsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourceAccountsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourcesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourcesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListListenersRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListenerNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.RemoveCustomRoutingEndpointsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.RemoveCustomRoutingEndpointsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.RemoveEndpointsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.RemoveEndpointsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.TagResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.TagResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.TransactionInProgressException;
import software.amazon.awssdk.services.globalaccelerator.model.UntagResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UntagResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCrossAccountAttachmentRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCrossAccountAttachmentResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.transform.AddCustomRoutingEndpointsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.AddEndpointsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.AdvertiseByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.AllowCustomRoutingTrafficRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateCrossAccountAttachmentRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateCustomRoutingAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateCustomRoutingEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateCustomRoutingListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteCrossAccountAttachmentRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteCustomRoutingAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteCustomRoutingEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteCustomRoutingListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DenyCustomRoutingTrafficRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeprovisionByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeAcceleratorAttributesRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeCrossAccountAttachmentRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeCustomRoutingAcceleratorAttributesRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeCustomRoutingAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeCustomRoutingEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeCustomRoutingListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListAcceleratorsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListByoipCidrsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCrossAccountAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCrossAccountResourceAccountsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCrossAccountResourcesRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCustomRoutingAcceleratorsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCustomRoutingEndpointGroupsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCustomRoutingListenersRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCustomRoutingPortMappingsByDestinationRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCustomRoutingPortMappingsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListEndpointGroupsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListListenersRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ProvisionByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.RemoveCustomRoutingEndpointsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.RemoveEndpointsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateAcceleratorAttributesRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateCrossAccountAttachmentRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateCustomRoutingAcceleratorAttributesRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateCustomRoutingAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateCustomRoutingListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.WithdrawByoipCidrRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link GlobalAcceleratorAsyncClient}.
 *
 * @see GlobalAcceleratorAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultGlobalAcceleratorAsyncClient implements GlobalAcceleratorAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultGlobalAcceleratorAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultGlobalAcceleratorAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Associate a virtual private cloud (VPC) subnet endpoint with your custom routing accelerator.
     * </p>
     * <p>
     * The listener port range must be large enough to support the number of IP addresses that can be specified in your
     * subnet. The number of ports required is: subnet size times the number of ports per destination EC2 instances. For
     * example, a subnet defined as /24 requires a listener port range of at least 255 ports.
     * </p>
     * <p>
     * Note: You must have enough remaining listener ports available to map to the subnet ports, or the call will fail
     * with a LimitExceededException.
     * </p>
     * <p>
     * By default, all destinations in a subnet in a custom routing accelerator cannot receive traffic. To enable all
     * destinations to receive traffic, or to specify individual port mappings that can receive traffic, see the <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html">
     * AllowCustomRoutingTraffic</a> operation.
     * </p>
     *
     * @param addCustomRoutingEndpointsRequest
     * @return A Java Future containing the result of the AddCustomRoutingEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EndpointAlreadyExistsException The endpoint that you specified doesn't exist.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>ConflictException You can't use both of those options.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.AddCustomRoutingEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AddCustomRoutingEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddCustomRoutingEndpointsResponse> addCustomRoutingEndpoints(
            AddCustomRoutingEndpointsRequest addCustomRoutingEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addCustomRoutingEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addCustomRoutingEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddCustomRoutingEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddCustomRoutingEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddCustomRoutingEndpointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddCustomRoutingEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddCustomRoutingEndpointsRequest, AddCustomRoutingEndpointsResponse>()
                            .withOperationName("AddCustomRoutingEndpoints").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddCustomRoutingEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addCustomRoutingEndpointsRequest));
            CompletableFuture<AddCustomRoutingEndpointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Add endpoints to an endpoint group. The <code>AddEndpoints</code> API operation is the recommended option for
     * adding endpoints. The alternative options are to add endpoints when you create an endpoint group (with the <a
     * href
     * ="https://docs.aws.amazon.com/global-accelerator/latest/api/API_CreateEndpointGroup.html">CreateEndpointGroup</a>
     * API) or when you update an endpoint group (with the <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateEndpointGroup.html"
     * >UpdateEndpointGroup</a> API).
     * </p>
     * <p>
     * There are two advantages to using <code>AddEndpoints</code> to add endpoints in Global Accelerator:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It's faster, because Global Accelerator only has to resolve the new endpoints that you're adding, rather than
     * resolving new and existing endpoints.
     * </p>
     * </li>
     * <li>
     * <p>
     * It's more convenient, because you don't need to specify the current endpoints that are already in the endpoint
     * group, in addition to the new endpoints that you want to add.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about endpoint types and requirements for endpoints that you can add to Global Accelerator, see
     * <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints.html"> Endpoints for standard
     * accelerators</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param addEndpointsRequest
     * @return A Java Future containing the result of the AddEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TransactionInProgressException There's already a transaction in progress. Another transaction can't
     *         be processed.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.AddEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AddEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddEndpointsResponse> addEndpoints(AddEndpointsRequest addEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AddEndpointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddEndpointsRequest, AddEndpointsResponse>()
                            .withOperationName("AddEndpoints").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addEndpointsRequest));
            CompletableFuture<AddEndpointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Advertises an IPv4 address range that is provisioned for use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP). It can take a few minutes before traffic to the specified addresses starts
     * routing to Amazon Web Services because of propagation delays.
     * </p>
     * <p>
     * To stop advertising the BYOIP address range, use <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html"> WithdrawByoipCidr</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param advertiseByoipCidrRequest
     * @return A Java Future containing the result of the AdvertiseByoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>ByoipCidrNotFoundException The CIDR that you specified was not found or is incorrect.</li>
     *         <li>IncorrectCidrStateException The CIDR that you specified is not valid for this action. For example,
     *         the state of the CIDR might be incorrect for this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.AdvertiseByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AdvertiseByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdvertiseByoipCidrResponse> advertiseByoipCidr(AdvertiseByoipCidrRequest advertiseByoipCidrRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(advertiseByoipCidrRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, advertiseByoipCidrRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdvertiseByoipCidr");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdvertiseByoipCidrResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdvertiseByoipCidrResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdvertiseByoipCidrResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdvertiseByoipCidrRequest, AdvertiseByoipCidrResponse>()
                            .withOperationName("AdvertiseByoipCidr").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdvertiseByoipCidrRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(advertiseByoipCidrRequest));
            CompletableFuture<AdvertiseByoipCidrResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that can receive
     * traffic for a custom routing accelerator. You can allow traffic to all destinations in the subnet endpoint, or
     * allow traffic to a specified list of destination IP addresses and ports in the subnet. Note that you cannot
     * specify IP addresses or ports outside of the range that you configured for the endpoint group.
     * </p>
     * <p>
     * After you make changes, you can verify that the updates are complete by checking the status of your accelerator:
     * the status changes from IN_PROGRESS to DEPLOYED.
     * </p>
     *
     * @param allowCustomRoutingTrafficRequest
     * @return A Java Future containing the result of the AllowCustomRoutingTraffic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.AllowCustomRoutingTraffic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AllowCustomRoutingTraffic"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AllowCustomRoutingTrafficResponse> allowCustomRoutingTraffic(
            AllowCustomRoutingTrafficRequest allowCustomRoutingTrafficRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(allowCustomRoutingTrafficRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, allowCustomRoutingTrafficRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AllowCustomRoutingTraffic");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AllowCustomRoutingTrafficResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AllowCustomRoutingTrafficResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AllowCustomRoutingTrafficResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AllowCustomRoutingTrafficRequest, AllowCustomRoutingTrafficResponse>()
                            .withOperationName("AllowCustomRoutingTraffic").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AllowCustomRoutingTrafficRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(allowCustomRoutingTrafficRequest));
            CompletableFuture<AllowCustomRoutingTrafficResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create an accelerator. An accelerator includes one or more listeners that process inbound connections and direct
     * traffic to one or more endpoint groups, each of which includes endpoints, such as Network Load Balancers.
     * </p>
     * <important>
     * <p>
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you
     * must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for
     * example, specify <code>--region us-west-2</code> on Amazon Web Services CLI commands.
     * </p>
     * </important>
     *
     * @param createAcceleratorRequest
     * @return A Java Future containing the result of the CreateAccelerator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAcceleratorResponse> createAccelerator(CreateAcceleratorRequest createAcceleratorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAcceleratorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAcceleratorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccelerator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAcceleratorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAcceleratorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAcceleratorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAcceleratorRequest, CreateAcceleratorResponse>()
                            .withOperationName("CreateAccelerator").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAcceleratorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAcceleratorRequest));
            CompletableFuture<CreateAcceleratorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a cross-account attachment in Global Accelerator. You create a cross-account attachment to specify the
     * <i>principals</i> who have permission to work with <i>resources</i> in accelerators in their own account. You
     * specify, in the same attachment, the resources that are shared.
     * </p>
     * <p>
     * A principal can be an Amazon Web Services account number or the Amazon Resource Name (ARN) for an accelerator.
     * For account numbers that are listed as principals, to work with a resource listed in the attachment, you must
     * sign in to an account specified as a principal. Then, you can work with resources that are listed, with any of
     * your accelerators. If an accelerator ARN is listed in the cross-account attachment as a principal, anyone with
     * permission to make updates to the accelerator can work with resources that are listed in the attachment.
     * </p>
     * <p>
     * Specify each principal and resource separately. To specify two CIDR address pools, list them individually under
     * <code>Resources</code>, and so on. For a command line operation, for example, you might use a statement like the
     * following:
     * </p>
     * <p>
     * <code> "Resources": [{"Cidr": "169.254.60.0/24"},{"Cidr": "169.254.59.0/24"}]</code>
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/cross-account-resources.html"> Working with
     * cross-account attachments and resources in Global Accelerator</a> in the <i> Global Accelerator Developer
     * Guide</i>.
     * </p>
     *
     * @param createCrossAccountAttachmentRequest
     * @return A Java Future containing the result of the CreateCrossAccountAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>TransactionInProgressException There's already a transaction in progress. Another transaction can't
     *         be processed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateCrossAccountAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCrossAccountAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCrossAccountAttachmentResponse> createCrossAccountAttachment(
            CreateCrossAccountAttachmentRequest createCrossAccountAttachmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCrossAccountAttachmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCrossAccountAttachmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCrossAccountAttachment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCrossAccountAttachmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCrossAccountAttachmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCrossAccountAttachmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCrossAccountAttachmentRequest, CreateCrossAccountAttachmentResponse>()
                            .withOperationName("CreateCrossAccountAttachment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCrossAccountAttachmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCrossAccountAttachmentRequest));
            CompletableFuture<CreateCrossAccountAttachmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a custom routing accelerator. A custom routing accelerator directs traffic to one of possibly thousands of
     * Amazon EC2 instance destinations running in a single or multiple virtual private clouds (VPC) subnet endpoints.
     * </p>
     * <p>
     * Be aware that, by default, all destination EC2 instances in a VPC subnet endpoint cannot receive traffic. To
     * enable all destinations to receive traffic, or to specify individual port mappings that can receive traffic, see
     * the <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html">
     * AllowCustomRoutingTraffic</a> operation.
     * </p>
     * <important>
     * <p>
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you
     * must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for
     * example, specify <code>--region us-west-2</code> on Amazon Web Services CLI commands.
     * </p>
     * </important>
     *
     * @param createCustomRoutingAcceleratorRequest
     * @return A Java Future containing the result of the CreateCustomRoutingAccelerator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCustomRoutingAcceleratorResponse> createCustomRoutingAccelerator(
            CreateCustomRoutingAcceleratorRequest createCustomRoutingAcceleratorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCustomRoutingAcceleratorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCustomRoutingAcceleratorRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomRoutingAccelerator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCustomRoutingAcceleratorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCustomRoutingAcceleratorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCustomRoutingAcceleratorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCustomRoutingAcceleratorRequest, CreateCustomRoutingAcceleratorResponse>()
                            .withOperationName("CreateCustomRoutingAccelerator").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCustomRoutingAcceleratorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCustomRoutingAcceleratorRequest));
            CompletableFuture<CreateCustomRoutingAcceleratorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create an endpoint group for the specified listener for a custom routing accelerator. An endpoint group is a
     * collection of endpoints in one Amazon Web Services Region.
     * </p>
     *
     * @param createCustomRoutingEndpointGroupRequest
     * @return A Java Future containing the result of the CreateCustomRoutingEndpointGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>EndpointGroupAlreadyExistsException The endpoint group that you specified already exists.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidPortRangeException The port numbers that you specified are not valid numbers or are not unique
     *         for this accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateCustomRoutingEndpointGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCustomRoutingEndpointGroupResponse> createCustomRoutingEndpointGroup(
            CreateCustomRoutingEndpointGroupRequest createCustomRoutingEndpointGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCustomRoutingEndpointGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCustomRoutingEndpointGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomRoutingEndpointGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCustomRoutingEndpointGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateCustomRoutingEndpointGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCustomRoutingEndpointGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCustomRoutingEndpointGroupRequest, CreateCustomRoutingEndpointGroupResponse>()
                            .withOperationName("CreateCustomRoutingEndpointGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCustomRoutingEndpointGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCustomRoutingEndpointGroupRequest));
            CompletableFuture<CreateCustomRoutingEndpointGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a listener to process inbound connections from clients to a custom routing accelerator. Connections arrive
     * to assigned static IP addresses on the port range that you specify.
     * </p>
     *
     * @param createCustomRoutingListenerRequest
     * @return A Java Future containing the result of the CreateCustomRoutingListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InvalidPortRangeException The port numbers that you specified are not valid numbers or are not unique
     *         for this accelerator.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCustomRoutingListenerResponse> createCustomRoutingListener(
            CreateCustomRoutingListenerRequest createCustomRoutingListenerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCustomRoutingListenerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCustomRoutingListenerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomRoutingListener");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCustomRoutingListenerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCustomRoutingListenerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCustomRoutingListenerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCustomRoutingListenerRequest, CreateCustomRoutingListenerResponse>()
                            .withOperationName("CreateCustomRoutingListener").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCustomRoutingListenerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCustomRoutingListenerRequest));
            CompletableFuture<CreateCustomRoutingListenerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create an endpoint group for the specified listener. An endpoint group is a collection of endpoints in one Amazon
     * Web Services Region. A resource must be valid and active when you add it as an endpoint.
     * </p>
     * <p>
     * For more information about endpoint types and requirements for endpoints that you can add to Global Accelerator,
     * see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints.html"> Endpoints for
     * standard accelerators</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param createEndpointGroupRequest
     * @return A Java Future containing the result of the CreateEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>EndpointGroupAlreadyExistsException The endpoint group that you specified already exists.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEndpointGroupResponse> createEndpointGroup(
            CreateEndpointGroupRequest createEndpointGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEndpointGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEndpointGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEndpointGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEndpointGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEndpointGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEndpointGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEndpointGroupRequest, CreateEndpointGroupResponse>()
                            .withOperationName("CreateEndpointGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEndpointGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEndpointGroupRequest));
            CompletableFuture<CreateEndpointGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a listener to process inbound connections from clients to an accelerator. Connections arrive to assigned
     * static IP addresses on a port, port range, or list of port ranges that you specify.
     * </p>
     *
     * @param createListenerRequest
     * @return A Java Future containing the result of the CreateListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InvalidPortRangeException The port numbers that you specified are not valid numbers or are not unique
     *         for this accelerator.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.CreateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateListenerResponse> createListener(CreateListenerRequest createListenerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createListenerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createListenerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateListener");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateListenerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateListenerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateListenerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateListenerRequest, CreateListenerResponse>()
                            .withOperationName("CreateListener").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateListenerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createListenerRequest));
            CompletableFuture<CreateListenerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete an accelerator. Before you can delete an accelerator, you must disable it and remove all dependent
     * resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set
     * <code>Enabled</code> to false.
     * </p>
     * <important>
     * <p>
     * When you create an accelerator, by default, Global Accelerator provides you with a set of two static IP
     * addresses. Alternatively, you can bring your own IP address ranges to Global Accelerator and assign IP addresses
     * from those ranges.
     * </p>
     * <p>
     * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator
     * and it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the static
     * IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best
     * practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM
     * policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Identity and access
     * management</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * </important>
     *
     * @param deleteAcceleratorRequest
     * @return A Java Future containing the result of the DeleteAccelerator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>AcceleratorNotDisabledException The accelerator that you specified could not be disabled.</li>
     *         <li>AssociatedListenerFoundException The accelerator that you specified has a listener associated with
     *         it. You must remove all dependent resources from an accelerator before you can delete it.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAcceleratorResponse> deleteAccelerator(DeleteAcceleratorRequest deleteAcceleratorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAcceleratorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAcceleratorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccelerator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAcceleratorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAcceleratorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAcceleratorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAcceleratorRequest, DeleteAcceleratorResponse>()
                            .withOperationName("DeleteAccelerator").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAcceleratorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAcceleratorRequest));
            CompletableFuture<DeleteAcceleratorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a cross-account attachment. When you delete an attachment, Global Accelerator revokes the permission to
     * use the resources in the attachment from all principals in the list of principals. Global Accelerator revokes the
     * permission for specific resources.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/cross-account-resources.html"> Working with
     * cross-account attachments and resources in Global Accelerator</a> in the <i> Global Accelerator Developer
     * Guide</i>.
     * </p>
     *
     * @param deleteCrossAccountAttachmentRequest
     * @return A Java Future containing the result of the DeleteCrossAccountAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AttachmentNotFoundException No cross-account attachment was found.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>TransactionInProgressException There's already a transaction in progress. Another transaction can't
     *         be processed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteCrossAccountAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCrossAccountAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCrossAccountAttachmentResponse> deleteCrossAccountAttachment(
            DeleteCrossAccountAttachmentRequest deleteCrossAccountAttachmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCrossAccountAttachmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCrossAccountAttachmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCrossAccountAttachment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCrossAccountAttachmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCrossAccountAttachmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCrossAccountAttachmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCrossAccountAttachmentRequest, DeleteCrossAccountAttachmentResponse>()
                            .withOperationName("DeleteCrossAccountAttachment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCrossAccountAttachmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCrossAccountAttachmentRequest));
            CompletableFuture<DeleteCrossAccountAttachmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a custom routing accelerator. Before you can delete an accelerator, you must disable it and remove all
     * dependent resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set
     * <code>Enabled</code> to false.
     * </p>
     * <important>
     * <p>
     * When you create a custom routing accelerator, by default, Global Accelerator provides you with a set of two
     * static IP addresses.
     * </p>
     * <p>
     * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator
     * and it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the static
     * IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best
     * practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM
     * policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Identity and access
     * management</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * </important>
     *
     * @param deleteCustomRoutingAcceleratorRequest
     * @return A Java Future containing the result of the DeleteCustomRoutingAccelerator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>AcceleratorNotDisabledException The accelerator that you specified could not be disabled.</li>
     *         <li>AssociatedListenerFoundException The accelerator that you specified has a listener associated with
     *         it. You must remove all dependent resources from an accelerator before you can delete it.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCustomRoutingAcceleratorResponse> deleteCustomRoutingAccelerator(
            DeleteCustomRoutingAcceleratorRequest deleteCustomRoutingAcceleratorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCustomRoutingAcceleratorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCustomRoutingAcceleratorRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomRoutingAccelerator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCustomRoutingAcceleratorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCustomRoutingAcceleratorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCustomRoutingAcceleratorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCustomRoutingAcceleratorRequest, DeleteCustomRoutingAcceleratorResponse>()
                            .withOperationName("DeleteCustomRoutingAccelerator").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCustomRoutingAcceleratorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCustomRoutingAcceleratorRequest));
            CompletableFuture<DeleteCustomRoutingAcceleratorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete an endpoint group from a listener for a custom routing accelerator.
     * </p>
     *
     * @param deleteCustomRoutingEndpointGroupRequest
     * @return A Java Future containing the result of the DeleteCustomRoutingEndpointGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteCustomRoutingEndpointGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCustomRoutingEndpointGroupResponse> deleteCustomRoutingEndpointGroup(
            DeleteCustomRoutingEndpointGroupRequest deleteCustomRoutingEndpointGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCustomRoutingEndpointGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCustomRoutingEndpointGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomRoutingEndpointGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCustomRoutingEndpointGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteCustomRoutingEndpointGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCustomRoutingEndpointGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCustomRoutingEndpointGroupRequest, DeleteCustomRoutingEndpointGroupResponse>()
                            .withOperationName("DeleteCustomRoutingEndpointGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCustomRoutingEndpointGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCustomRoutingEndpointGroupRequest));
            CompletableFuture<DeleteCustomRoutingEndpointGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a listener for a custom routing accelerator.
     * </p>
     *
     * @param deleteCustomRoutingListenerRequest
     * @return A Java Future containing the result of the DeleteCustomRoutingListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>AssociatedEndpointGroupFoundException The listener that you specified has an endpoint group
     *         associated with it. You must remove all dependent resources from a listener before you can delete it.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCustomRoutingListenerResponse> deleteCustomRoutingListener(
            DeleteCustomRoutingListenerRequest deleteCustomRoutingListenerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCustomRoutingListenerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCustomRoutingListenerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomRoutingListener");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCustomRoutingListenerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCustomRoutingListenerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCustomRoutingListenerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCustomRoutingListenerRequest, DeleteCustomRoutingListenerResponse>()
                            .withOperationName("DeleteCustomRoutingListener").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCustomRoutingListenerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCustomRoutingListenerRequest));
            CompletableFuture<DeleteCustomRoutingListenerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete an endpoint group from a listener.
     * </p>
     *
     * @param deleteEndpointGroupRequest
     * @return A Java Future containing the result of the DeleteEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEndpointGroupResponse> deleteEndpointGroup(
            DeleteEndpointGroupRequest deleteEndpointGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEndpointGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEndpointGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEndpointGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEndpointGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEndpointGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEndpointGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEndpointGroupRequest, DeleteEndpointGroupResponse>()
                            .withOperationName("DeleteEndpointGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEndpointGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEndpointGroupRequest));
            CompletableFuture<DeleteEndpointGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a listener from an accelerator.
     * </p>
     *
     * @param deleteListenerRequest
     * @return A Java Future containing the result of the DeleteListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>AssociatedEndpointGroupFoundException The listener that you specified has an endpoint group
     *         associated with it. You must remove all dependent resources from a listener before you can delete it.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeleteListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteListenerResponse> deleteListener(DeleteListenerRequest deleteListenerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteListenerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteListenerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteListener");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteListenerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteListenerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteListenerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteListenerRequest, DeleteListenerResponse>()
                            .withOperationName("DeleteListener").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteListenerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteListenerRequest));
            CompletableFuture<DeleteListenerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that cannot
     * receive traffic for a custom routing accelerator. You can deny traffic to all destinations in the VPC endpoint,
     * or deny traffic to a specified list of destination IP addresses and ports. Note that you cannot specify IP
     * addresses or ports outside of the range that you configured for the endpoint group.
     * </p>
     * <p>
     * After you make changes, you can verify that the updates are complete by checking the status of your accelerator:
     * the status changes from IN_PROGRESS to DEPLOYED.
     * </p>
     *
     * @param denyCustomRoutingTrafficRequest
     * @return A Java Future containing the result of the DenyCustomRoutingTraffic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DenyCustomRoutingTraffic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DenyCustomRoutingTraffic"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DenyCustomRoutingTrafficResponse> denyCustomRoutingTraffic(
            DenyCustomRoutingTrafficRequest denyCustomRoutingTrafficRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(denyCustomRoutingTrafficRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, denyCustomRoutingTrafficRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DenyCustomRoutingTraffic");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DenyCustomRoutingTrafficResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DenyCustomRoutingTrafficResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DenyCustomRoutingTrafficResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DenyCustomRoutingTrafficRequest, DenyCustomRoutingTrafficResponse>()
                            .withOperationName("DenyCustomRoutingTraffic").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DenyCustomRoutingTrafficRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(denyCustomRoutingTrafficRequest));
            CompletableFuture<DenyCustomRoutingTrafficResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Releases the specified address range that you provisioned to use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     * </p>
     * <p>
     * Before you can release an address range, you must stop advertising it by using <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html">WithdrawByoipCidr</a> and
     * you must not have any accelerators that are using static IP addresses allocated from its address range.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param deprovisionByoipCidrRequest
     * @return A Java Future containing the result of the DeprovisionByoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>ByoipCidrNotFoundException The CIDR that you specified was not found or is incorrect.</li>
     *         <li>IncorrectCidrStateException The CIDR that you specified is not valid for this action. For example,
     *         the state of the CIDR might be incorrect for this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DeprovisionByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeprovisionByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeprovisionByoipCidrResponse> deprovisionByoipCidr(
            DeprovisionByoipCidrRequest deprovisionByoipCidrRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deprovisionByoipCidrRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deprovisionByoipCidrRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeprovisionByoipCidr");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeprovisionByoipCidrResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeprovisionByoipCidrResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeprovisionByoipCidrResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeprovisionByoipCidrRequest, DeprovisionByoipCidrResponse>()
                            .withOperationName("DeprovisionByoipCidr").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeprovisionByoipCidrRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deprovisionByoipCidrRequest));
            CompletableFuture<DeprovisionByoipCidrResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe an accelerator.
     * </p>
     *
     * @param describeAcceleratorRequest
     * @return A Java Future containing the result of the DescribeAccelerator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAcceleratorResponse> describeAccelerator(
            DescribeAcceleratorRequest describeAcceleratorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAcceleratorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAcceleratorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccelerator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAcceleratorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAcceleratorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAcceleratorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAcceleratorRequest, DescribeAcceleratorResponse>()
                            .withOperationName("DescribeAccelerator").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAcceleratorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAcceleratorRequest));
            CompletableFuture<DescribeAcceleratorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe the attributes of an accelerator.
     * </p>
     *
     * @param describeAcceleratorAttributesRequest
     * @return A Java Future containing the result of the DescribeAcceleratorAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeAcceleratorAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAcceleratorAttributesResponse> describeAcceleratorAttributes(
            DescribeAcceleratorAttributesRequest describeAcceleratorAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAcceleratorAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAcceleratorAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAcceleratorAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAcceleratorAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAcceleratorAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAcceleratorAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAcceleratorAttributesRequest, DescribeAcceleratorAttributesResponse>()
                            .withOperationName("DescribeAcceleratorAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAcceleratorAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAcceleratorAttributesRequest));
            CompletableFuture<DescribeAcceleratorAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets configuration information about a cross-account attachment.
     * </p>
     *
     * @param describeCrossAccountAttachmentRequest
     * @return A Java Future containing the result of the DescribeCrossAccountAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AttachmentNotFoundException No cross-account attachment was found.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeCrossAccountAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCrossAccountAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCrossAccountAttachmentResponse> describeCrossAccountAttachment(
            DescribeCrossAccountAttachmentRequest describeCrossAccountAttachmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCrossAccountAttachmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeCrossAccountAttachmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCrossAccountAttachment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCrossAccountAttachmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCrossAccountAttachmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeCrossAccountAttachmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCrossAccountAttachmentRequest, DescribeCrossAccountAttachmentResponse>()
                            .withOperationName("DescribeCrossAccountAttachment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeCrossAccountAttachmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeCrossAccountAttachmentRequest));
            CompletableFuture<DescribeCrossAccountAttachmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe a custom routing accelerator.
     * </p>
     *
     * @param describeCustomRoutingAcceleratorRequest
     * @return A Java Future containing the result of the DescribeCustomRoutingAccelerator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCustomRoutingAcceleratorResponse> describeCustomRoutingAccelerator(
            DescribeCustomRoutingAcceleratorRequest describeCustomRoutingAcceleratorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCustomRoutingAcceleratorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeCustomRoutingAcceleratorRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCustomRoutingAccelerator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCustomRoutingAcceleratorResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeCustomRoutingAcceleratorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeCustomRoutingAcceleratorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCustomRoutingAcceleratorRequest, DescribeCustomRoutingAcceleratorResponse>()
                            .withOperationName("DescribeCustomRoutingAccelerator").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeCustomRoutingAcceleratorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeCustomRoutingAcceleratorRequest));
            CompletableFuture<DescribeCustomRoutingAcceleratorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe the attributes of a custom routing accelerator.
     * </p>
     *
     * @param describeCustomRoutingAcceleratorAttributesRequest
     * @return A Java Future containing the result of the DescribeCustomRoutingAcceleratorAttributes operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeCustomRoutingAcceleratorAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCustomRoutingAcceleratorAttributesResponse> describeCustomRoutingAcceleratorAttributes(
            DescribeCustomRoutingAcceleratorAttributesRequest describeCustomRoutingAcceleratorAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                describeCustomRoutingAcceleratorAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeCustomRoutingAcceleratorAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCustomRoutingAcceleratorAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCustomRoutingAcceleratorAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeCustomRoutingAcceleratorAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeCustomRoutingAcceleratorAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCustomRoutingAcceleratorAttributesRequest, DescribeCustomRoutingAcceleratorAttributesResponse>()
                            .withOperationName("DescribeCustomRoutingAcceleratorAttributes")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeCustomRoutingAcceleratorAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeCustomRoutingAcceleratorAttributesRequest));
            CompletableFuture<DescribeCustomRoutingAcceleratorAttributesResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe an endpoint group for a custom routing accelerator.
     * </p>
     *
     * @param describeCustomRoutingEndpointGroupRequest
     * @return A Java Future containing the result of the DescribeCustomRoutingEndpointGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeCustomRoutingEndpointGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCustomRoutingEndpointGroupResponse> describeCustomRoutingEndpointGroup(
            DescribeCustomRoutingEndpointGroupRequest describeCustomRoutingEndpointGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCustomRoutingEndpointGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeCustomRoutingEndpointGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCustomRoutingEndpointGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCustomRoutingEndpointGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeCustomRoutingEndpointGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeCustomRoutingEndpointGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCustomRoutingEndpointGroupRequest, DescribeCustomRoutingEndpointGroupResponse>()
                            .withOperationName("DescribeCustomRoutingEndpointGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeCustomRoutingEndpointGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeCustomRoutingEndpointGroupRequest));
            CompletableFuture<DescribeCustomRoutingEndpointGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The description of a listener for a custom routing accelerator.
     * </p>
     *
     * @param describeCustomRoutingListenerRequest
     * @return A Java Future containing the result of the DescribeCustomRoutingListener operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCustomRoutingListenerResponse> describeCustomRoutingListener(
            DescribeCustomRoutingListenerRequest describeCustomRoutingListenerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCustomRoutingListenerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeCustomRoutingListenerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCustomRoutingListener");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCustomRoutingListenerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCustomRoutingListenerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeCustomRoutingListenerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCustomRoutingListenerRequest, DescribeCustomRoutingListenerResponse>()
                            .withOperationName("DescribeCustomRoutingListener").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeCustomRoutingListenerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeCustomRoutingListenerRequest));
            CompletableFuture<DescribeCustomRoutingListenerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe an endpoint group.
     * </p>
     *
     * @param describeEndpointGroupRequest
     * @return A Java Future containing the result of the DescribeEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEndpointGroupResponse> describeEndpointGroup(
            DescribeEndpointGroupRequest describeEndpointGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEndpointGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEndpointGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEndpointGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEndpointGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEndpointGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeEndpointGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEndpointGroupRequest, DescribeEndpointGroupResponse>()
                            .withOperationName("DescribeEndpointGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEndpointGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEndpointGroupRequest));
            CompletableFuture<DescribeEndpointGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe a listener.
     * </p>
     *
     * @param describeListenerRequest
     * @return A Java Future containing the result of the DescribeListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.DescribeListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeListenerResponse> describeListener(DescribeListenerRequest describeListenerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeListenerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeListenerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeListener");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeListenerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeListenerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeListenerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeListenerRequest, DescribeListenerResponse>()
                            .withOperationName("DescribeListener").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeListenerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeListenerRequest));
            CompletableFuture<DescribeListenerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the accelerators for an Amazon Web Services account.
     * </p>
     *
     * @param listAcceleratorsRequest
     * @return A Java Future containing the result of the ListAccelerators operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAcceleratorsResponse> listAccelerators(ListAcceleratorsRequest listAcceleratorsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAcceleratorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAcceleratorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccelerators");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAcceleratorsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAcceleratorsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAcceleratorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAcceleratorsRequest, ListAcceleratorsResponse>()
                            .withOperationName("ListAccelerators").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAcceleratorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAcceleratorsRequest));
            CompletableFuture<ListAcceleratorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the IP address ranges that were specified in calls to <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html">ProvisionByoipCidr</a>,
     * including the current state and a history of state changes.
     * </p>
     *
     * @param listByoipCidrsRequest
     * @return A Java Future containing the result of the ListByoipCidrs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListByoipCidrs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListByoipCidrs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListByoipCidrsResponse> listByoipCidrs(ListByoipCidrsRequest listByoipCidrsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listByoipCidrsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listByoipCidrsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListByoipCidrs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListByoipCidrsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListByoipCidrsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListByoipCidrsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListByoipCidrsRequest, ListByoipCidrsResponse>()
                            .withOperationName("ListByoipCidrs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListByoipCidrsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listByoipCidrsRequest));
            CompletableFuture<ListByoipCidrsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the cross-account attachments that have been created in Global Accelerator.
     * </p>
     *
     * @param listCrossAccountAttachmentsRequest
     * @return A Java Future containing the result of the ListCrossAccountAttachments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCrossAccountAttachments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCrossAccountAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCrossAccountAttachmentsResponse> listCrossAccountAttachments(
            ListCrossAccountAttachmentsRequest listCrossAccountAttachmentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCrossAccountAttachmentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCrossAccountAttachmentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCrossAccountAttachments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCrossAccountAttachmentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCrossAccountAttachmentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCrossAccountAttachmentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCrossAccountAttachmentsRequest, ListCrossAccountAttachmentsResponse>()
                            .withOperationName("ListCrossAccountAttachments").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCrossAccountAttachmentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCrossAccountAttachmentsRequest));
            CompletableFuture<ListCrossAccountAttachmentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the accounts that have cross-account resources.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/cross-account-resources.html"> Working with
     * cross-account attachments and resources in Global Accelerator</a> in the <i> Global Accelerator Developer
     * Guide</i>.
     * </p>
     *
     * @param listCrossAccountResourceAccountsRequest
     * @return A Java Future containing the result of the ListCrossAccountResourceAccounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCrossAccountResourceAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCrossAccountResourceAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCrossAccountResourceAccountsResponse> listCrossAccountResourceAccounts(
            ListCrossAccountResourceAccountsRequest listCrossAccountResourceAccountsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCrossAccountResourceAccountsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCrossAccountResourceAccountsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCrossAccountResourceAccounts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCrossAccountResourceAccountsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListCrossAccountResourceAccountsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCrossAccountResourceAccountsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCrossAccountResourceAccountsRequest, ListCrossAccountResourceAccountsResponse>()
                            .withOperationName("ListCrossAccountResourceAccounts").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCrossAccountResourceAccountsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCrossAccountResourceAccountsRequest));
            CompletableFuture<ListCrossAccountResourceAccountsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the cross-account resources available to work with.
     * </p>
     *
     * @param listCrossAccountResourcesRequest
     * @return A Java Future containing the result of the ListCrossAccountResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCrossAccountResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCrossAccountResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCrossAccountResourcesResponse> listCrossAccountResources(
            ListCrossAccountResourcesRequest listCrossAccountResourcesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCrossAccountResourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCrossAccountResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCrossAccountResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCrossAccountResourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCrossAccountResourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCrossAccountResourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCrossAccountResourcesRequest, ListCrossAccountResourcesResponse>()
                            .withOperationName("ListCrossAccountResources").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCrossAccountResourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCrossAccountResourcesRequest));
            CompletableFuture<ListCrossAccountResourcesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the custom routing accelerators for an Amazon Web Services account.
     * </p>
     *
     * @param listCustomRoutingAcceleratorsRequest
     * @return A Java Future containing the result of the ListCustomRoutingAccelerators operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCustomRoutingAcceleratorsResponse> listCustomRoutingAccelerators(
            ListCustomRoutingAcceleratorsRequest listCustomRoutingAcceleratorsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCustomRoutingAcceleratorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCustomRoutingAcceleratorsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomRoutingAccelerators");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCustomRoutingAcceleratorsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCustomRoutingAcceleratorsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCustomRoutingAcceleratorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCustomRoutingAcceleratorsRequest, ListCustomRoutingAcceleratorsResponse>()
                            .withOperationName("ListCustomRoutingAccelerators").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCustomRoutingAcceleratorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCustomRoutingAcceleratorsRequest));
            CompletableFuture<ListCustomRoutingAcceleratorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener for a custom routing accelerator.
     * </p>
     *
     * @param listCustomRoutingEndpointGroupsRequest
     * @return A Java Future containing the result of the ListCustomRoutingEndpointGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingEndpointGroups
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCustomRoutingEndpointGroupsResponse> listCustomRoutingEndpointGroups(
            ListCustomRoutingEndpointGroupsRequest listCustomRoutingEndpointGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCustomRoutingEndpointGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCustomRoutingEndpointGroupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomRoutingEndpointGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCustomRoutingEndpointGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCustomRoutingEndpointGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCustomRoutingEndpointGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCustomRoutingEndpointGroupsRequest, ListCustomRoutingEndpointGroupsResponse>()
                            .withOperationName("ListCustomRoutingEndpointGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCustomRoutingEndpointGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCustomRoutingEndpointGroupsRequest));
            CompletableFuture<ListCustomRoutingEndpointGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the listeners for a custom routing accelerator.
     * </p>
     *
     * @param listCustomRoutingListenersRequest
     * @return A Java Future containing the result of the ListCustomRoutingListeners operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingListeners"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCustomRoutingListenersResponse> listCustomRoutingListeners(
            ListCustomRoutingListenersRequest listCustomRoutingListenersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCustomRoutingListenersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCustomRoutingListenersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomRoutingListeners");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCustomRoutingListenersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCustomRoutingListenersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCustomRoutingListenersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCustomRoutingListenersRequest, ListCustomRoutingListenersResponse>()
                            .withOperationName("ListCustomRoutingListeners").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCustomRoutingListenersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCustomRoutingListenersRequest));
            CompletableFuture<ListCustomRoutingListenersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance IP
     * addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator. For each
     * subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port
     * mappings don't change after Global Accelerator generates them, so you can retrieve and cache the full mapping on
     * your servers.
     * </p>
     * <p>
     * If you remove a subnet from your accelerator, Global Accelerator removes (reclaims) the port mappings. If you add
     * a subnet to your accelerator, Global Accelerator creates new port mappings (the existing ones don't change). If
     * you add or remove EC2 instances in your subnet, the port mappings don't change, because the mappings are created
     * when you add the subnet to Global Accelerator.
     * </p>
     * <p>
     * The mappings also include a flag for each destination denoting which destination IP addresses and ports are
     * allowed or denied traffic.
     * </p>
     *
     * @param listCustomRoutingPortMappingsRequest
     * @return A Java Future containing the result of the ListCustomRoutingPortMappings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingPortMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCustomRoutingPortMappingsResponse> listCustomRoutingPortMappings(
            ListCustomRoutingPortMappingsRequest listCustomRoutingPortMappingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCustomRoutingPortMappingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCustomRoutingPortMappingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomRoutingPortMappings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCustomRoutingPortMappingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCustomRoutingPortMappingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCustomRoutingPortMappingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCustomRoutingPortMappingsRequest, ListCustomRoutingPortMappingsResponse>()
                            .withOperationName("ListCustomRoutingPortMappings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCustomRoutingPortMappingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCustomRoutingPortMappingsRequest));
            CompletableFuture<ListCustomRoutingPortMappingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint. The response is the
     * mappings for one destination IP address. This is useful when your subnet endpoint has mappings that span multiple
     * custom routing accelerators in your account, or for scenarios where you only want to list the port mappings for a
     * specific destination instance.
     * </p>
     *
     * @param listCustomRoutingPortMappingsByDestinationRequest
     * @return A Java Future containing the result of the ListCustomRoutingPortMappingsByDestination operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>EndpointNotFoundException The endpoint that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListCustomRoutingPortMappingsByDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappingsByDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCustomRoutingPortMappingsByDestinationResponse> listCustomRoutingPortMappingsByDestination(
            ListCustomRoutingPortMappingsByDestinationRequest listCustomRoutingPortMappingsByDestinationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                listCustomRoutingPortMappingsByDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCustomRoutingPortMappingsByDestinationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomRoutingPortMappingsByDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCustomRoutingPortMappingsByDestinationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListCustomRoutingPortMappingsByDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCustomRoutingPortMappingsByDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCustomRoutingPortMappingsByDestinationRequest, ListCustomRoutingPortMappingsByDestinationResponse>()
                            .withOperationName("ListCustomRoutingPortMappingsByDestination")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCustomRoutingPortMappingsByDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCustomRoutingPortMappingsByDestinationRequest));
            CompletableFuture<ListCustomRoutingPortMappingsByDestinationResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener.
     * </p>
     *
     * @param listEndpointGroupsRequest
     * @return A Java Future containing the result of the ListEndpointGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListEndpointGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEndpointGroupsResponse> listEndpointGroups(ListEndpointGroupsRequest listEndpointGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEndpointGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEndpointGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEndpointGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEndpointGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEndpointGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEndpointGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEndpointGroupsRequest, ListEndpointGroupsResponse>()
                            .withOperationName("ListEndpointGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEndpointGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEndpointGroupsRequest));
            CompletableFuture<ListEndpointGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the listeners for an accelerator.
     * </p>
     *
     * @param listListenersRequest
     * @return A Java Future containing the result of the ListListeners operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InvalidNextTokenException There isn't another item to return.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListListeners"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListListenersResponse> listListeners(ListListenersRequest listListenersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listListenersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listListenersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListListeners");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListListenersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListListenersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListListenersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListListenersRequest, ListListenersResponse>()
                            .withOperationName("ListListeners").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListListenersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listListenersRequest));
            CompletableFuture<ListListenersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List all tags for an accelerator.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
     * Global Accelerator</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provisions an IP address range to use with your Amazon Web Services resources through bring your own IP addresses
     * (BYOIP) and creates a corresponding address pool. After the address range is provisioned, it is ready to be
     * advertised using <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/AdvertiseByoipCidr.html">
     * AdvertiseByoipCidr</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param provisionByoipCidrRequest
     * @return A Java Future containing the result of the ProvisionByoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>IncorrectCidrStateException The CIDR that you specified is not valid for this action. For example,
     *         the state of the CIDR might be incorrect for this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.ProvisionByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ProvisionByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ProvisionByoipCidrResponse> provisionByoipCidr(ProvisionByoipCidrRequest provisionByoipCidrRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(provisionByoipCidrRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, provisionByoipCidrRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ProvisionByoipCidr");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ProvisionByoipCidrResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ProvisionByoipCidrResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ProvisionByoipCidrResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ProvisionByoipCidrRequest, ProvisionByoipCidrResponse>()
                            .withOperationName("ProvisionByoipCidr").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ProvisionByoipCidrRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(provisionByoipCidrRequest));
            CompletableFuture<ProvisionByoipCidrResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Remove endpoints from a custom routing accelerator.
     * </p>
     *
     * @param removeCustomRoutingEndpointsRequest
     * @return A Java Future containing the result of the RemoveCustomRoutingEndpoints operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>EndpointNotFoundException The endpoint that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>ConflictException You can't use both of those options.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.RemoveCustomRoutingEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/RemoveCustomRoutingEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveCustomRoutingEndpointsResponse> removeCustomRoutingEndpoints(
            RemoveCustomRoutingEndpointsRequest removeCustomRoutingEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeCustomRoutingEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeCustomRoutingEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveCustomRoutingEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveCustomRoutingEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemoveCustomRoutingEndpointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RemoveCustomRoutingEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveCustomRoutingEndpointsRequest, RemoveCustomRoutingEndpointsResponse>()
                            .withOperationName("RemoveCustomRoutingEndpoints").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveCustomRoutingEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeCustomRoutingEndpointsRequest));
            CompletableFuture<RemoveCustomRoutingEndpointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Remove endpoints from an endpoint group.
     * </p>
     * <p>
     * The <code>RemoveEndpoints</code> API operation is the recommended option for removing endpoints. The alternative
     * is to remove endpoints by updating an endpoint group by using the <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateEndpointGroup.html"
     * >UpdateEndpointGroup</a> API operation. There are two advantages to using <code>AddEndpoints</code> to remove
     * endpoints instead:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It's more convenient, because you only need to specify the endpoints that you want to remove. With the
     * <code>UpdateEndpointGroup</code> API operation, you must specify all of the endpoints in the endpoint group
     * except the ones that you want to remove from the group.
     * </p>
     * </li>
     * <li>
     * <p>
     * It's faster, because Global Accelerator doesn't need to resolve any endpoints. With the
     * <code>UpdateEndpointGroup</code> API operation, Global Accelerator must resolve all of the endpoints that remain
     * in the group.
     * </p>
     * </li>
     * </ul>
     *
     * @param removeEndpointsRequest
     * @return A Java Future containing the result of the RemoveEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>TransactionInProgressException There's already a transaction in progress. Another transaction can't
     *         be processed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.RemoveEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/RemoveEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveEndpointsResponse> removeEndpoints(RemoveEndpointsRequest removeEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemoveEndpointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RemoveEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveEndpointsRequest, RemoveEndpointsResponse>()
                            .withOperationName("RemoveEndpoints").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeEndpointsRequest));
            CompletableFuture<RemoveEndpointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Add tags to an accelerator resource.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
     * Global Accelerator</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Remove tags from a Global Accelerator resource. When you specify a tag key, the action removes both that key and
     * its associated value. The operation succeeds even if you attempt to remove tags from an accelerator that was
     * already removed.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
     * Global Accelerator</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update an accelerator to make changes, such as the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Change the name of the accelerator.
     * </p>
     * </li>
     * <li>
     * <p>
     * Disable the accelerator so that it no longer accepts or routes traffic, or so that you can delete it.
     * </p>
     * </li>
     * <li>
     * <p>
     * Enable the accelerator, if it is disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change the IP address type to dual-stack if it is IPv4, or change the IP address type to IPv4 if it's dual-stack.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Be aware that static IP addresses remain assigned to your accelerator for as long as it exists, even if you
     * disable the accelerator and it no longer accepts or routes traffic. However, when you delete the accelerator, you
     * lose the static IP addresses that are assigned to it, so you can no longer route traffic by using them.
     * </p>
     * <important>
     * <p>
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you
     * must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for
     * example, specify <code>--region us-west-2</code> on Amazon Web Services CLI commands.
     * </p>
     * </important>
     *
     * @param updateAcceleratorRequest
     * @return A Java Future containing the result of the UpdateAccelerator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAcceleratorResponse> updateAccelerator(UpdateAcceleratorRequest updateAcceleratorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAcceleratorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAcceleratorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccelerator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAcceleratorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAcceleratorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAcceleratorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAcceleratorRequest, UpdateAcceleratorResponse>()
                            .withOperationName("UpdateAccelerator").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAcceleratorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAcceleratorRequest));
            CompletableFuture<UpdateAcceleratorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update the attributes for an accelerator.
     * </p>
     *
     * @param updateAcceleratorAttributesRequest
     * @return A Java Future containing the result of the UpdateAcceleratorAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateAcceleratorAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAcceleratorAttributesResponse> updateAcceleratorAttributes(
            UpdateAcceleratorAttributesRequest updateAcceleratorAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAcceleratorAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAcceleratorAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAcceleratorAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAcceleratorAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAcceleratorAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAcceleratorAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAcceleratorAttributesRequest, UpdateAcceleratorAttributesResponse>()
                            .withOperationName("UpdateAcceleratorAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAcceleratorAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAcceleratorAttributesRequest));
            CompletableFuture<UpdateAcceleratorAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update a cross-account attachment to add or remove principals or resources. When you update an attachment to
     * remove a principal (account ID or accelerator) or a resource, Global Accelerator revokes the permission for
     * specific resources.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/cross-account-resources.html"> Working with
     * cross-account attachments and resources in Global Accelerator</a> in the <i> Global Accelerator Developer
     * Guide</i>.
     * </p>
     *
     * @param updateCrossAccountAttachmentRequest
     * @return A Java Future containing the result of the UpdateCrossAccountAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AttachmentNotFoundException No cross-account attachment was found.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>TransactionInProgressException There's already a transaction in progress. Another transaction can't
     *         be processed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateCrossAccountAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCrossAccountAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCrossAccountAttachmentResponse> updateCrossAccountAttachment(
            UpdateCrossAccountAttachmentRequest updateCrossAccountAttachmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCrossAccountAttachmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCrossAccountAttachmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCrossAccountAttachment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCrossAccountAttachmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateCrossAccountAttachmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCrossAccountAttachmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCrossAccountAttachmentRequest, UpdateCrossAccountAttachmentResponse>()
                            .withOperationName("UpdateCrossAccountAttachment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateCrossAccountAttachmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCrossAccountAttachmentRequest));
            CompletableFuture<UpdateCrossAccountAttachmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update a custom routing accelerator.
     * </p>
     *
     * @param updateCustomRoutingAcceleratorRequest
     * @return A Java Future containing the result of the UpdateCustomRoutingAccelerator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCustomRoutingAcceleratorResponse> updateCustomRoutingAccelerator(
            UpdateCustomRoutingAcceleratorRequest updateCustomRoutingAcceleratorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCustomRoutingAcceleratorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateCustomRoutingAcceleratorRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCustomRoutingAccelerator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCustomRoutingAcceleratorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateCustomRoutingAcceleratorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCustomRoutingAcceleratorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCustomRoutingAcceleratorRequest, UpdateCustomRoutingAcceleratorResponse>()
                            .withOperationName("UpdateCustomRoutingAccelerator").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateCustomRoutingAcceleratorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCustomRoutingAcceleratorRequest));
            CompletableFuture<UpdateCustomRoutingAcceleratorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update the attributes for a custom routing accelerator.
     * </p>
     *
     * @param updateCustomRoutingAcceleratorAttributesRequest
     * @return A Java Future containing the result of the UpdateCustomRoutingAcceleratorAttributes operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AcceleratorNotFoundException The accelerator that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateCustomRoutingAcceleratorAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCustomRoutingAcceleratorAttributesResponse> updateCustomRoutingAcceleratorAttributes(
            UpdateCustomRoutingAcceleratorAttributesRequest updateCustomRoutingAcceleratorAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                updateCustomRoutingAcceleratorAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateCustomRoutingAcceleratorAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCustomRoutingAcceleratorAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCustomRoutingAcceleratorAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateCustomRoutingAcceleratorAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCustomRoutingAcceleratorAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCustomRoutingAcceleratorAttributesRequest, UpdateCustomRoutingAcceleratorAttributesResponse>()
                            .withOperationName("UpdateCustomRoutingAcceleratorAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateCustomRoutingAcceleratorAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCustomRoutingAcceleratorAttributesRequest));
            CompletableFuture<UpdateCustomRoutingAcceleratorAttributesResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update a listener for a custom routing accelerator.
     * </p>
     *
     * @param updateCustomRoutingListenerRequest
     * @return A Java Future containing the result of the UpdateCustomRoutingListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidPortRangeException The port numbers that you specified are not valid numbers or are not unique
     *         for this accelerator.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCustomRoutingListenerResponse> updateCustomRoutingListener(
            UpdateCustomRoutingListenerRequest updateCustomRoutingListenerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCustomRoutingListenerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCustomRoutingListenerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCustomRoutingListener");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCustomRoutingListenerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateCustomRoutingListenerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCustomRoutingListenerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCustomRoutingListenerRequest, UpdateCustomRoutingListenerResponse>()
                            .withOperationName("UpdateCustomRoutingListener").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateCustomRoutingListenerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCustomRoutingListenerRequest));
            CompletableFuture<UpdateCustomRoutingListenerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update an endpoint group. A resource must be valid and active when you add it as an endpoint.
     * </p>
     *
     * @param updateEndpointGroupRequest
     * @return A Java Future containing the result of the UpdateEndpointGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>EndpointGroupNotFoundException The endpoint group that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEndpointGroupResponse> updateEndpointGroup(
            UpdateEndpointGroupRequest updateEndpointGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEndpointGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEndpointGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEndpointGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEndpointGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEndpointGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEndpointGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEndpointGroupRequest, UpdateEndpointGroupResponse>()
                            .withOperationName("UpdateEndpointGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateEndpointGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateEndpointGroupRequest));
            CompletableFuture<UpdateEndpointGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update a listener.
     * </p>
     *
     * @param updateListenerRequest
     * @return A Java Future containing the result of the UpdateListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>InvalidPortRangeException The port numbers that you specified are not valid numbers or are not unique
     *         for this accelerator.</li>
     *         <li>ListenerNotFoundException The listener that you specified doesn't exist.</li>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>LimitExceededException Processing your request would cause you to exceed an Global Accelerator limit.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.UpdateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateListenerResponse> updateListener(UpdateListenerRequest updateListenerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateListenerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateListenerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateListener");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateListenerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateListenerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateListenerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateListenerRequest, UpdateListenerResponse>()
                            .withOperationName("UpdateListener").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateListenerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateListenerRequest));
            CompletableFuture<UpdateListenerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops advertising an address range that is provisioned as an address pool. You can perform this operation at most
     * once every 10 seconds, even if you specify different address ranges each time.
     * </p>
     * <p>
     * It can take a few minutes before traffic to the specified addresses stops routing to Amazon Web Services because
     * of propagation delays.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param withdrawByoipCidrRequest
     * @return A Java Future containing the result of the WithdrawByoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceErrorException There was an internal error for Global Accelerator.</li>
     *         <li>InvalidArgumentException An argument that you specified is invalid.</li>
     *         <li>AccessDeniedException You don't have access permission.</li>
     *         <li>ByoipCidrNotFoundException The CIDR that you specified was not found or is incorrect.</li>
     *         <li>IncorrectCidrStateException The CIDR that you specified is not valid for this action. For example,
     *         the state of the CIDR might be incorrect for this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlobalAcceleratorException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample GlobalAcceleratorAsyncClient.WithdrawByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/WithdrawByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<WithdrawByoipCidrResponse> withdrawByoipCidr(WithdrawByoipCidrRequest withdrawByoipCidrRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(withdrawByoipCidrRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, withdrawByoipCidrRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "WithdrawByoipCidr");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<WithdrawByoipCidrResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, WithdrawByoipCidrResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<WithdrawByoipCidrResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<WithdrawByoipCidrRequest, WithdrawByoipCidrResponse>()
                            .withOperationName("WithdrawByoipCidr").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new WithdrawByoipCidrRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(withdrawByoipCidrRequest));
            CompletableFuture<WithdrawByoipCidrResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final GlobalAcceleratorServiceClientConfiguration serviceClientConfiguration() {
        return new GlobalAcceleratorServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(GlobalAcceleratorException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EndpointNotFoundException")
                                .exceptionBuilderSupplier(EndpointNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException")
                                .exceptionBuilderSupplier(AssociatedListenerFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException")
                                .exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNextTokenException")
                                .exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException")
                                .exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPortRangeException")
                                .exceptionBuilderSupplier(InvalidPortRangeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException")
                                .exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AttachmentNotFoundException")
                                .exceptionBuilderSupplier(AttachmentNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidArgumentException")
                                .exceptionBuilderSupplier(InvalidArgumentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ListenerNotFoundException")
                                .exceptionBuilderSupplier(ListenerNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException")
                                .exceptionBuilderSupplier(AcceleratorNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IncorrectCidrStateException")
                                .exceptionBuilderSupplier(IncorrectCidrStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TransactionInProgressException")
                                .exceptionBuilderSupplier(TransactionInProgressException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException")
                                .exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServiceErrorException")
                                .exceptionBuilderSupplier(InternalServiceErrorException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException")
                                .exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException")
                                .exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        GlobalAcceleratorServiceClientConfigurationBuilder serviceConfigBuilder = new GlobalAcceleratorServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
