/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Override specific listener ports used to route traffic to endpoints that are part of an endpoint group. For example,
 * you can create a port override in which the listener receives user traffic on ports 80 and 443, but your accelerator
 * routes that traffic to ports 1080 and 1443, respectively, on the endpoints.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html"> Overriding
 * listener ports</a> in the <i>Global Accelerator Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PortOverride implements SdkPojo, Serializable, ToCopyableBuilder<PortOverride.Builder, PortOverride> {
    private static final SdkField<Integer> LISTENER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ListenerPort").getter(getter(PortOverride::listenerPort)).setter(setter(Builder::listenerPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerPort").build()).build();

    private static final SdkField<Integer> ENDPOINT_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndpointPort").getter(getter(PortOverride::endpointPort)).setter(setter(Builder::endpointPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointPort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_PORT_FIELD,
            ENDPOINT_PORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer listenerPort;

    private final Integer endpointPort;

    private PortOverride(BuilderImpl builder) {
        this.listenerPort = builder.listenerPort;
        this.endpointPort = builder.endpointPort;
    }

    /**
     * <p>
     * The listener port that you want to map to a specific endpoint port. This is the port that user traffic arrives to
     * the Global Accelerator on.
     * </p>
     * 
     * @return The listener port that you want to map to a specific endpoint port. This is the port that user traffic
     *         arrives to the Global Accelerator on.
     */
    public final Integer listenerPort() {
        return listenerPort;
    }

    /**
     * <p>
     * The endpoint port that you want a listener port to be mapped to. This is the port on the endpoint, such as the
     * Application Load Balancer or Amazon EC2 instance.
     * </p>
     * 
     * @return The endpoint port that you want a listener port to be mapped to. This is the port on the endpoint, such
     *         as the Application Load Balancer or Amazon EC2 instance.
     */
    public final Integer endpointPort() {
        return endpointPort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(listenerPort());
        hashCode = 31 * hashCode + Objects.hashCode(endpointPort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortOverride)) {
            return false;
        }
        PortOverride other = (PortOverride) obj;
        return Objects.equals(listenerPort(), other.listenerPort()) && Objects.equals(endpointPort(), other.endpointPort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PortOverride").add("ListenerPort", listenerPort()).add("EndpointPort", endpointPort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListenerPort":
            return Optional.ofNullable(clazz.cast(listenerPort()));
        case "EndpointPort":
            return Optional.ofNullable(clazz.cast(endpointPort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PortOverride, T> g) {
        return obj -> g.apply((PortOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PortOverride> {
        /**
         * <p>
         * The listener port that you want to map to a specific endpoint port. This is the port that user traffic
         * arrives to the Global Accelerator on.
         * </p>
         * 
         * @param listenerPort
         *        The listener port that you want to map to a specific endpoint port. This is the port that user traffic
         *        arrives to the Global Accelerator on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerPort(Integer listenerPort);

        /**
         * <p>
         * The endpoint port that you want a listener port to be mapped to. This is the port on the endpoint, such as
         * the Application Load Balancer or Amazon EC2 instance.
         * </p>
         * 
         * @param endpointPort
         *        The endpoint port that you want a listener port to be mapped to. This is the port on the endpoint,
         *        such as the Application Load Balancer or Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointPort(Integer endpointPort);
    }

    static final class BuilderImpl implements Builder {
        private Integer listenerPort;

        private Integer endpointPort;

        private BuilderImpl() {
        }

        private BuilderImpl(PortOverride model) {
            listenerPort(model.listenerPort);
            endpointPort(model.endpointPort);
        }

        public final Integer getListenerPort() {
            return listenerPort;
        }

        public final void setListenerPort(Integer listenerPort) {
            this.listenerPort = listenerPort;
        }

        @Override
        public final Builder listenerPort(Integer listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        public final Integer getEndpointPort() {
            return endpointPort;
        }

        public final void setEndpointPort(Integer endpointPort) {
            this.endpointPort = endpointPort;
        }

        @Override
        public final Builder endpointPort(Integer endpointPort) {
            this.endpointPort = endpointPort;
            return this;
        }

        @Override
        public PortOverride build() {
            return new PortOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
