/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCrossAccountAttachmentRequest extends GlobalAcceleratorRequest implements
        ToCopyableBuilder<DeleteCrossAccountAttachmentRequest.Builder, DeleteCrossAccountAttachmentRequest> {
    private static final SdkField<String> ATTACHMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachmentArn").getter(getter(DeleteCrossAccountAttachmentRequest::attachmentArn))
            .setter(setter(Builder::attachmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ARN_FIELD));

    private final String attachmentArn;

    private DeleteCrossAccountAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.attachmentArn = builder.attachmentArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the cross-account attachment to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the cross-account attachment to delete.
     */
    public final String attachmentArn() {
        return attachmentArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attachmentArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCrossAccountAttachmentRequest)) {
            return false;
        }
        DeleteCrossAccountAttachmentRequest other = (DeleteCrossAccountAttachmentRequest) obj;
        return Objects.equals(attachmentArn(), other.attachmentArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteCrossAccountAttachmentRequest").add("AttachmentArn", attachmentArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachmentArn":
            return Optional.ofNullable(clazz.cast(attachmentArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteCrossAccountAttachmentRequest, T> g) {
        return obj -> g.apply((DeleteCrossAccountAttachmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteCrossAccountAttachmentRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the cross-account attachment to delete.
         * </p>
         * 
         * @param attachmentArn
         *        The Amazon Resource Name (ARN) for the cross-account attachment to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentArn(String attachmentArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlobalAcceleratorRequest.BuilderImpl implements Builder {
        private String attachmentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCrossAccountAttachmentRequest model) {
            super(model);
            attachmentArn(model.attachmentArn);
        }

        public final String getAttachmentArn() {
            return attachmentArn;
        }

        public final void setAttachmentArn(String attachmentArn) {
            this.attachmentArn = attachmentArn;
        }

        @Override
        public final Builder attachmentArn(String attachmentArn) {
            this.attachmentArn = attachmentArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCrossAccountAttachmentRequest build() {
            return new DeleteCrossAccountAttachmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
