/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAcceleratorRequest extends GlobalAcceleratorRequest implements
        ToCopyableBuilder<UpdateAcceleratorRequest.Builder, UpdateAcceleratorRequest> {
    private static final SdkField<String> ACCELERATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceleratorArn").getter(getter(UpdateAcceleratorRequest::acceleratorArn))
            .setter(setter(Builder::acceleratorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateAcceleratorRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddressType").getter(getter(UpdateAcceleratorRequest::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()).build();

    private static final SdkField<List<String>> IP_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IpAddresses")
            .getter(getter(UpdateAcceleratorRequest::ipAddresses))
            .setter(setter(Builder::ipAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(UpdateAcceleratorRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_ARN_FIELD,
            NAME_FIELD, IP_ADDRESS_TYPE_FIELD, IP_ADDRESSES_FIELD, ENABLED_FIELD));

    private final String acceleratorArn;

    private final String name;

    private final String ipAddressType;

    private final List<String> ipAddresses;

    private final Boolean enabled;

    private UpdateAcceleratorRequest(BuilderImpl builder) {
        super(builder);
        this.acceleratorArn = builder.acceleratorArn;
        this.name = builder.name;
        this.ipAddressType = builder.ipAddressType;
        this.ipAddresses = builder.ipAddresses;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the accelerator to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the accelerator to update.
     */
    public final String acceleratorArn() {
        return acceleratorArn;
    }

    /**
     * <p>
     * The name of the accelerator. The name can have a maximum of 64 characters, must contain only alphanumeric
     * characters, periods (.), or hyphens (-), and must not begin or end with a hyphen or period.
     * </p>
     * 
     * @return The name of the accelerator. The name can have a maximum of 64 characters, must contain only alphanumeric
     *         characters, periods (.), or hyphens (-), and must not begin or end with a hyphen or period.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The IP address type that an accelerator supports. For a standard accelerator, the value can be IPV4 or
     * DUAL_STACK.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type that an accelerator supports. For a standard accelerator, the value can be IPV4 or
     *         DUAL_STACK.
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The IP address type that an accelerator supports. For a standard accelerator, the value can be IPV4 or
     * DUAL_STACK.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type that an accelerator supports. For a standard accelerator, the value can be IPV4 or
     *         DUAL_STACK.
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpAddresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpAddresses() {
        return ipAddresses != null && !(ipAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP addresses for an accelerator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpAddresses} method.
     * </p>
     * 
     * @return The IP addresses for an accelerator.
     */
    public final List<String> ipAddresses() {
        return ipAddresses;
    }

    /**
     * <p>
     * Indicates whether an accelerator is enabled. The value is true or false. The default value is true.
     * </p>
     * <p>
     * If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.
     * </p>
     * 
     * @return Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
     *         <p>
     *         If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be
     *         deleted.
     */
    public final Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpAddresses() ? ipAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAcceleratorRequest)) {
            return false;
        }
        UpdateAcceleratorRequest other = (UpdateAcceleratorRequest) obj;
        return Objects.equals(acceleratorArn(), other.acceleratorArn()) && Objects.equals(name(), other.name())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString())
                && hasIpAddresses() == other.hasIpAddresses() && Objects.equals(ipAddresses(), other.ipAddresses())
                && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAcceleratorRequest").add("AcceleratorArn", acceleratorArn()).add("Name", name())
                .add("IpAddressType", ipAddressTypeAsString()).add("IpAddresses", hasIpAddresses() ? ipAddresses() : null)
                .add("Enabled", enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceleratorArn":
            return Optional.ofNullable(clazz.cast(acceleratorArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "IpAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "IpAddresses":
            return Optional.ofNullable(clazz.cast(ipAddresses()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAcceleratorRequest, T> g) {
        return obj -> g.apply((UpdateAcceleratorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAcceleratorRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the accelerator to update.
         * </p>
         * 
         * @param acceleratorArn
         *        The Amazon Resource Name (ARN) of the accelerator to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorArn(String acceleratorArn);

        /**
         * <p>
         * The name of the accelerator. The name can have a maximum of 64 characters, must contain only alphanumeric
         * characters, periods (.), or hyphens (-), and must not begin or end with a hyphen or period.
         * </p>
         * 
         * @param name
         *        The name of the accelerator. The name can have a maximum of 64 characters, must contain only
         *        alphanumeric characters, periods (.), or hyphens (-), and must not begin or end with a hyphen or
         *        period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The IP address type that an accelerator supports. For a standard accelerator, the value can be IPV4 or
         * DUAL_STACK.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type that an accelerator supports. For a standard accelerator, the value can be IPV4 or
         *        DUAL_STACK.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The IP address type that an accelerator supports. For a standard accelerator, the value can be IPV4 or
         * DUAL_STACK.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type that an accelerator supports. For a standard accelerator, the value can be IPV4 or
         *        DUAL_STACK.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        /**
         * <p>
         * The IP addresses for an accelerator.
         * </p>
         * 
         * @param ipAddresses
         *        The IP addresses for an accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddresses(Collection<String> ipAddresses);

        /**
         * <p>
         * The IP addresses for an accelerator.
         * </p>
         * 
         * @param ipAddresses
         *        The IP addresses for an accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddresses(String... ipAddresses);

        /**
         * <p>
         * Indicates whether an accelerator is enabled. The value is true or false. The default value is true.
         * </p>
         * <p>
         * If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be
         * deleted.
         * </p>
         * 
         * @param enabled
         *        Indicates whether an accelerator is enabled. The value is true or false. The default value is true.
         *        </p>
         *        <p>
         *        If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can
         *        be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlobalAcceleratorRequest.BuilderImpl implements Builder {
        private String acceleratorArn;

        private String name;

        private String ipAddressType;

        private List<String> ipAddresses = DefaultSdkAutoConstructList.getInstance();

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAcceleratorRequest model) {
            super(model);
            acceleratorArn(model.acceleratorArn);
            name(model.name);
            ipAddressType(model.ipAddressType);
            ipAddresses(model.ipAddresses);
            enabled(model.enabled);
        }

        public final String getAcceleratorArn() {
            return acceleratorArn;
        }

        public final void setAcceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
        }

        @Override
        public final Builder acceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final Collection<String> getIpAddresses() {
            if (ipAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return ipAddresses;
        }

        public final void setIpAddresses(Collection<String> ipAddresses) {
            this.ipAddresses = IpAddressesCopier.copy(ipAddresses);
        }

        @Override
        public final Builder ipAddresses(Collection<String> ipAddresses) {
            this.ipAddresses = IpAddressesCopier.copy(ipAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipAddresses(String... ipAddresses) {
            ipAddresses(Arrays.asList(ipAddresses));
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAcceleratorRequest build() {
            return new UpdateAcceleratorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
