/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingListener;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingListenersCopier;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCustomRoutingListenersResponse
extends GlobalAcceleratorResponse
implements ToCopyableBuilder<Builder, ListCustomRoutingListenersResponse> {
    private static final SdkField<List<CustomRoutingListener>> LISTENERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Listeners").getter(ListCustomRoutingListenersResponse.getter(ListCustomRoutingListenersResponse::listeners)).setter(ListCustomRoutingListenersResponse.setter(Builder::listeners)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Listeners").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomRoutingListener::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCustomRoutingListenersResponse.getter(ListCustomRoutingListenersResponse::nextToken)).setter(ListCustomRoutingListenersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Listeners", LISTENERS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<CustomRoutingListener> listeners;
    private final String nextToken;

    private ListCustomRoutingListenersResponse(BuilderImpl builder) {
        super(builder);
        this.listeners = builder.listeners;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasListeners() {
        return this.listeners != null && !(this.listeners instanceof SdkAutoConstructList);
    }

    public final List<CustomRoutingListener> listeners() {
        return this.listeners;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListeners() ? this.listeners() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomRoutingListenersResponse)) {
            return false;
        }
        ListCustomRoutingListenersResponse other = (ListCustomRoutingListenersResponse)((Object)obj);
        return this.hasListeners() == other.hasListeners() && Objects.equals(this.listeners(), other.listeners()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCustomRoutingListenersResponse").add("Listeners", this.hasListeners() ? this.listeners() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Listeners": {
                return Optional.ofNullable(clazz.cast(this.listeners()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomRoutingListenersResponse, T> g) {
        return obj -> g.apply((ListCustomRoutingListenersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorResponse.BuilderImpl
    implements Builder {
        private List<CustomRoutingListener> listeners = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomRoutingListenersResponse model) {
            super(model);
            this.listeners(model.listeners);
            this.nextToken(model.nextToken);
        }

        public final List<CustomRoutingListener.Builder> getListeners() {
            List<CustomRoutingListener.Builder> result = CustomRoutingListenersCopier.copyToBuilder(this.listeners);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListeners(Collection<CustomRoutingListener.BuilderImpl> listeners) {
            this.listeners = CustomRoutingListenersCopier.copyFromBuilder(listeners);
        }

        @Override
        public final Builder listeners(Collection<CustomRoutingListener> listeners) {
            this.listeners = CustomRoutingListenersCopier.copy(listeners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(CustomRoutingListener ... listeners) {
            this.listeners(Arrays.asList(listeners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Consumer<CustomRoutingListener.Builder> ... listeners) {
            this.listeners(Stream.of(listeners).map(c -> (CustomRoutingListener)((CustomRoutingListener.Builder)CustomRoutingListener.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCustomRoutingListenersResponse build() {
            return new ListCustomRoutingListenersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCustomRoutingListenersResponse> {
        public Builder listeners(Collection<CustomRoutingListener> var1);

        public Builder listeners(CustomRoutingListener ... var1);

        public Builder listeners(Consumer<CustomRoutingListener.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

