/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationConfiguration;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationConfigurationsCopier;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCustomRoutingEndpointGroupRequest
extends GlobalAcceleratorRequest
implements ToCopyableBuilder<Builder, CreateCustomRoutingEndpointGroupRequest> {
    private static final SdkField<String> LISTENER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ListenerArn").getter(CreateCustomRoutingEndpointGroupRequest.getter(CreateCustomRoutingEndpointGroupRequest::listenerArn)).setter(CreateCustomRoutingEndpointGroupRequest.setter(Builder::listenerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerArn").build()}).build();
    private static final SdkField<String> ENDPOINT_GROUP_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointGroupRegion").getter(CreateCustomRoutingEndpointGroupRequest.getter(CreateCustomRoutingEndpointGroupRequest::endpointGroupRegion)).setter(CreateCustomRoutingEndpointGroupRequest.setter(Builder::endpointGroupRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupRegion").build()}).build();
    private static final SdkField<List<CustomRoutingDestinationConfiguration>> DESTINATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationConfigurations").getter(CreateCustomRoutingEndpointGroupRequest.getter(CreateCustomRoutingEndpointGroupRequest::destinationConfigurations)).setter(CreateCustomRoutingEndpointGroupRequest.setter(Builder::destinationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomRoutingDestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(CreateCustomRoutingEndpointGroupRequest.getter(CreateCustomRoutingEndpointGroupRequest::idempotencyToken)).setter(CreateCustomRoutingEndpointGroupRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_ARN_FIELD, ENDPOINT_GROUP_REGION_FIELD, DESTINATION_CONFIGURATIONS_FIELD, IDEMPOTENCY_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ListenerArn", LISTENER_ARN_FIELD);
            this.put("EndpointGroupRegion", ENDPOINT_GROUP_REGION_FIELD);
            this.put("DestinationConfigurations", DESTINATION_CONFIGURATIONS_FIELD);
            this.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        }
    });
    private final String listenerArn;
    private final String endpointGroupRegion;
    private final List<CustomRoutingDestinationConfiguration> destinationConfigurations;
    private final String idempotencyToken;

    private CreateCustomRoutingEndpointGroupRequest(BuilderImpl builder) {
        super(builder);
        this.listenerArn = builder.listenerArn;
        this.endpointGroupRegion = builder.endpointGroupRegion;
        this.destinationConfigurations = builder.destinationConfigurations;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public final String listenerArn() {
        return this.listenerArn;
    }

    public final String endpointGroupRegion() {
        return this.endpointGroupRegion;
    }

    public final boolean hasDestinationConfigurations() {
        return this.destinationConfigurations != null && !(this.destinationConfigurations instanceof SdkAutoConstructList);
    }

    public final List<CustomRoutingDestinationConfiguration> destinationConfigurations() {
        return this.destinationConfigurations;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.listenerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointGroupRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationConfigurations() ? this.destinationConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomRoutingEndpointGroupRequest)) {
            return false;
        }
        CreateCustomRoutingEndpointGroupRequest other = (CreateCustomRoutingEndpointGroupRequest)((Object)obj);
        return Objects.equals(this.listenerArn(), other.listenerArn()) && Objects.equals(this.endpointGroupRegion(), other.endpointGroupRegion()) && this.hasDestinationConfigurations() == other.hasDestinationConfigurations() && Objects.equals(this.destinationConfigurations(), other.destinationConfigurations()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCustomRoutingEndpointGroupRequest").add("ListenerArn", (Object)this.listenerArn()).add("EndpointGroupRegion", (Object)this.endpointGroupRegion()).add("DestinationConfigurations", this.hasDestinationConfigurations() ? this.destinationConfigurations() : null).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ListenerArn": {
                return Optional.ofNullable(clazz.cast(this.listenerArn()));
            }
            case "EndpointGroupRegion": {
                return Optional.ofNullable(clazz.cast(this.endpointGroupRegion()));
            }
            case "DestinationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.destinationConfigurations()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomRoutingEndpointGroupRequest, T> g) {
        return obj -> g.apply((CreateCustomRoutingEndpointGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorRequest.BuilderImpl
    implements Builder {
        private String listenerArn;
        private String endpointGroupRegion;
        private List<CustomRoutingDestinationConfiguration> destinationConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomRoutingEndpointGroupRequest model) {
            super(model);
            this.listenerArn(model.listenerArn);
            this.endpointGroupRegion(model.endpointGroupRegion);
            this.destinationConfigurations(model.destinationConfigurations);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final String getListenerArn() {
            return this.listenerArn;
        }

        public final void setListenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
        }

        @Override
        public final Builder listenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        public final String getEndpointGroupRegion() {
            return this.endpointGroupRegion;
        }

        public final void setEndpointGroupRegion(String endpointGroupRegion) {
            this.endpointGroupRegion = endpointGroupRegion;
        }

        @Override
        public final Builder endpointGroupRegion(String endpointGroupRegion) {
            this.endpointGroupRegion = endpointGroupRegion;
            return this;
        }

        public final List<CustomRoutingDestinationConfiguration.Builder> getDestinationConfigurations() {
            List<CustomRoutingDestinationConfiguration.Builder> result = CustomRoutingDestinationConfigurationsCopier.copyToBuilder(this.destinationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinationConfigurations(Collection<CustomRoutingDestinationConfiguration.BuilderImpl> destinationConfigurations) {
            this.destinationConfigurations = CustomRoutingDestinationConfigurationsCopier.copyFromBuilder(destinationConfigurations);
        }

        @Override
        public final Builder destinationConfigurations(Collection<CustomRoutingDestinationConfiguration> destinationConfigurations) {
            this.destinationConfigurations = CustomRoutingDestinationConfigurationsCopier.copy(destinationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationConfigurations(CustomRoutingDestinationConfiguration ... destinationConfigurations) {
            this.destinationConfigurations(Arrays.asList(destinationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationConfigurations(Consumer<CustomRoutingDestinationConfiguration.Builder> ... destinationConfigurations) {
            this.destinationConfigurations(Stream.of(destinationConfigurations).map(c -> (CustomRoutingDestinationConfiguration)((CustomRoutingDestinationConfiguration.Builder)CustomRoutingDestinationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomRoutingEndpointGroupRequest build() {
            return new CreateCustomRoutingEndpointGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCustomRoutingEndpointGroupRequest> {
        public Builder listenerArn(String var1);

        public Builder endpointGroupRegion(String var1);

        public Builder destinationConfigurations(Collection<CustomRoutingDestinationConfiguration> var1);

        public Builder destinationConfigurations(CustomRoutingDestinationConfiguration ... var1);

        public Builder destinationConfigurations(Consumer<CustomRoutingDestinationConfiguration.Builder> ... var1);

        public Builder idempotencyToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

