/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAcceleratorAttributesRequest
extends GlobalAcceleratorRequest
implements ToCopyableBuilder<Builder, UpdateAcceleratorAttributesRequest> {
    private static final SdkField<String> ACCELERATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceleratorArn").getter(UpdateAcceleratorAttributesRequest.getter(UpdateAcceleratorAttributesRequest::acceleratorArn)).setter(UpdateAcceleratorAttributesRequest.setter(Builder::acceleratorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorArn").build()}).build();
    private static final SdkField<Boolean> FLOW_LOGS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FlowLogsEnabled").getter(UpdateAcceleratorAttributesRequest.getter(UpdateAcceleratorAttributesRequest::flowLogsEnabled)).setter(UpdateAcceleratorAttributesRequest.setter(Builder::flowLogsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowLogsEnabled").build()}).build();
    private static final SdkField<String> FLOW_LOGS_S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowLogsS3Bucket").getter(UpdateAcceleratorAttributesRequest.getter(UpdateAcceleratorAttributesRequest::flowLogsS3Bucket)).setter(UpdateAcceleratorAttributesRequest.setter(Builder::flowLogsS3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowLogsS3Bucket").build()}).build();
    private static final SdkField<String> FLOW_LOGS_S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowLogsS3Prefix").getter(UpdateAcceleratorAttributesRequest.getter(UpdateAcceleratorAttributesRequest::flowLogsS3Prefix)).setter(UpdateAcceleratorAttributesRequest.setter(Builder::flowLogsS3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowLogsS3Prefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_ARN_FIELD, FLOW_LOGS_ENABLED_FIELD, FLOW_LOGS_S3_BUCKET_FIELD, FLOW_LOGS_S3_PREFIX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AcceleratorArn", ACCELERATOR_ARN_FIELD);
            this.put("FlowLogsEnabled", FLOW_LOGS_ENABLED_FIELD);
            this.put("FlowLogsS3Bucket", FLOW_LOGS_S3_BUCKET_FIELD);
            this.put("FlowLogsS3Prefix", FLOW_LOGS_S3_PREFIX_FIELD);
        }
    });
    private final String acceleratorArn;
    private final Boolean flowLogsEnabled;
    private final String flowLogsS3Bucket;
    private final String flowLogsS3Prefix;

    private UpdateAcceleratorAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.acceleratorArn = builder.acceleratorArn;
        this.flowLogsEnabled = builder.flowLogsEnabled;
        this.flowLogsS3Bucket = builder.flowLogsS3Bucket;
        this.flowLogsS3Prefix = builder.flowLogsS3Prefix;
    }

    public final String acceleratorArn() {
        return this.acceleratorArn;
    }

    public final Boolean flowLogsEnabled() {
        return this.flowLogsEnabled;
    }

    public final String flowLogsS3Bucket() {
        return this.flowLogsS3Bucket;
    }

    public final String flowLogsS3Prefix() {
        return this.flowLogsS3Prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowLogsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowLogsS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowLogsS3Prefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAcceleratorAttributesRequest)) {
            return false;
        }
        UpdateAcceleratorAttributesRequest other = (UpdateAcceleratorAttributesRequest)((Object)obj);
        return Objects.equals(this.acceleratorArn(), other.acceleratorArn()) && Objects.equals(this.flowLogsEnabled(), other.flowLogsEnabled()) && Objects.equals(this.flowLogsS3Bucket(), other.flowLogsS3Bucket()) && Objects.equals(this.flowLogsS3Prefix(), other.flowLogsS3Prefix());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAcceleratorAttributesRequest").add("AcceleratorArn", (Object)this.acceleratorArn()).add("FlowLogsEnabled", (Object)this.flowLogsEnabled()).add("FlowLogsS3Bucket", (Object)this.flowLogsS3Bucket()).add("FlowLogsS3Prefix", (Object)this.flowLogsS3Prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceleratorArn": {
                return Optional.ofNullable(clazz.cast(this.acceleratorArn()));
            }
            case "FlowLogsEnabled": {
                return Optional.ofNullable(clazz.cast(this.flowLogsEnabled()));
            }
            case "FlowLogsS3Bucket": {
                return Optional.ofNullable(clazz.cast(this.flowLogsS3Bucket()));
            }
            case "FlowLogsS3Prefix": {
                return Optional.ofNullable(clazz.cast(this.flowLogsS3Prefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAcceleratorAttributesRequest, T> g) {
        return obj -> g.apply((UpdateAcceleratorAttributesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorRequest.BuilderImpl
    implements Builder {
        private String acceleratorArn;
        private Boolean flowLogsEnabled;
        private String flowLogsS3Bucket;
        private String flowLogsS3Prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAcceleratorAttributesRequest model) {
            super(model);
            this.acceleratorArn(model.acceleratorArn);
            this.flowLogsEnabled(model.flowLogsEnabled);
            this.flowLogsS3Bucket(model.flowLogsS3Bucket);
            this.flowLogsS3Prefix(model.flowLogsS3Prefix);
        }

        public final String getAcceleratorArn() {
            return this.acceleratorArn;
        }

        public final void setAcceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
        }

        @Override
        public final Builder acceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
            return this;
        }

        public final Boolean getFlowLogsEnabled() {
            return this.flowLogsEnabled;
        }

        public final void setFlowLogsEnabled(Boolean flowLogsEnabled) {
            this.flowLogsEnabled = flowLogsEnabled;
        }

        @Override
        public final Builder flowLogsEnabled(Boolean flowLogsEnabled) {
            this.flowLogsEnabled = flowLogsEnabled;
            return this;
        }

        public final String getFlowLogsS3Bucket() {
            return this.flowLogsS3Bucket;
        }

        public final void setFlowLogsS3Bucket(String flowLogsS3Bucket) {
            this.flowLogsS3Bucket = flowLogsS3Bucket;
        }

        @Override
        public final Builder flowLogsS3Bucket(String flowLogsS3Bucket) {
            this.flowLogsS3Bucket = flowLogsS3Bucket;
            return this;
        }

        public final String getFlowLogsS3Prefix() {
            return this.flowLogsS3Prefix;
        }

        public final void setFlowLogsS3Prefix(String flowLogsS3Prefix) {
            this.flowLogsS3Prefix = flowLogsS3Prefix;
        }

        @Override
        public final Builder flowLogsS3Prefix(String flowLogsS3Prefix) {
            this.flowLogsS3Prefix = flowLogsS3Prefix;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAcceleratorAttributesRequest build() {
            return new UpdateAcceleratorAttributesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAcceleratorAttributesRequest> {
        public Builder acceleratorArn(String var1);

        public Builder flowLogsEnabled(Boolean var1);

        public Builder flowLogsS3Bucket(String var1);

        public Builder flowLogsS3Prefix(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

