/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DenyCustomRoutingTrafficRequest extends GlobalAcceleratorRequest implements
        ToCopyableBuilder<DenyCustomRoutingTrafficRequest.Builder, DenyCustomRoutingTrafficRequest> {
    private static final SdkField<String> ENDPOINT_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointGroupArn").getter(getter(DenyCustomRoutingTrafficRequest::endpointGroupArn))
            .setter(setter(Builder::endpointGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupArn").build()).build();

    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointId").getter(getter(DenyCustomRoutingTrafficRequest::endpointId))
            .setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()).build();

    private static final SdkField<List<String>> DESTINATION_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DestinationAddresses")
            .getter(getter(DenyCustomRoutingTrafficRequest::destinationAddresses))
            .setter(setter(Builder::destinationAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Integer>> DESTINATION_PORTS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("DestinationPorts")
            .getter(getter(DenyCustomRoutingTrafficRequest::destinationPorts))
            .setter(setter(Builder::destinationPorts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPorts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DENY_ALL_TRAFFIC_TO_ENDPOINT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DenyAllTrafficToEndpoint")
            .getter(getter(DenyCustomRoutingTrafficRequest::denyAllTrafficToEndpoint))
            .setter(setter(Builder::denyAllTrafficToEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DenyAllTrafficToEndpoint").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_GROUP_ARN_FIELD,
            ENDPOINT_ID_FIELD, DESTINATION_ADDRESSES_FIELD, DESTINATION_PORTS_FIELD, DENY_ALL_TRAFFIC_TO_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String endpointGroupArn;

    private final String endpointId;

    private final List<String> destinationAddresses;

    private final List<Integer> destinationPorts;

    private final Boolean denyAllTrafficToEndpoint;

    private DenyCustomRoutingTrafficRequest(BuilderImpl builder) {
        super(builder);
        this.endpointGroupArn = builder.endpointGroupArn;
        this.endpointId = builder.endpointId;
        this.destinationAddresses = builder.destinationAddresses;
        this.destinationPorts = builder.destinationPorts;
        this.denyAllTrafficToEndpoint = builder.denyAllTrafficToEndpoint;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the endpoint group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the endpoint group.
     */
    public final String endpointGroupArn() {
        return endpointGroupArn;
    }

    /**
     * <p>
     * An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.
     * </p>
     * 
     * @return An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet
     *         ID.
     */
    public final String endpointId() {
        return endpointId;
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationAddresses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinationAddresses() {
        return destinationAddresses != null && !(destinationAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to prevent
     * from receiving traffic. The IP addresses must be a subset of the IP addresses allowed for the VPC subnet
     * associated with the endpoint group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationAddresses} method.
     * </p>
     * 
     * @return A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to
     *         prevent from receiving traffic. The IP addresses must be a subset of the IP addresses allowed for the VPC
     *         subnet associated with the endpoint group.
     */
    public final List<String> destinationAddresses() {
        return destinationAddresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationPorts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinationPorts() {
        return destinationPorts != null && !(destinationPorts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of specific Amazon EC2 instance ports (destination ports) in a subnet endpoint that you want to prevent
     * from receiving traffic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationPorts} method.
     * </p>
     * 
     * @return A list of specific Amazon EC2 instance ports (destination ports) in a subnet endpoint that you want to
     *         prevent from receiving traffic.
     */
    public final List<Integer> destinationPorts() {
        return destinationPorts;
    }

    /**
     * <p>
     * Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint <i>cannot</i>
     * receive traffic from a custom routing accelerator. The value is TRUE or FALSE.
     * </p>
     * <p>
     * When set to TRUE, <i>no</i> destinations in the custom routing VPC subnet can receive traffic. Note that you
     * cannot specify destination IP addresses and ports when the value is set to TRUE.
     * </p>
     * <p>
     * When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that cannot
     * receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept
     * traffic is the same as the ports configured for the endpoint group.
     * </p>
     * <p>
     * The default value is FALSE.
     * </p>
     * 
     * @return Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint
     *         <i>cannot</i> receive traffic from a custom routing accelerator. The value is TRUE or FALSE. </p>
     *         <p>
     *         When set to TRUE, <i>no</i> destinations in the custom routing VPC subnet can receive traffic. Note that
     *         you cannot specify destination IP addresses and ports when the value is set to TRUE.
     *         </p>
     *         <p>
     *         When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that
     *         cannot receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that
     *         can accept traffic is the same as the ports configured for the endpoint group.
     *         </p>
     *         <p>
     *         The default value is FALSE.
     */
    public final Boolean denyAllTrafficToEndpoint() {
        return denyAllTrafficToEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationAddresses() ? destinationAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationPorts() ? destinationPorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(denyAllTrafficToEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DenyCustomRoutingTrafficRequest)) {
            return false;
        }
        DenyCustomRoutingTrafficRequest other = (DenyCustomRoutingTrafficRequest) obj;
        return Objects.equals(endpointGroupArn(), other.endpointGroupArn()) && Objects.equals(endpointId(), other.endpointId())
                && hasDestinationAddresses() == other.hasDestinationAddresses()
                && Objects.equals(destinationAddresses(), other.destinationAddresses())
                && hasDestinationPorts() == other.hasDestinationPorts()
                && Objects.equals(destinationPorts(), other.destinationPorts())
                && Objects.equals(denyAllTrafficToEndpoint(), other.denyAllTrafficToEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DenyCustomRoutingTrafficRequest").add("EndpointGroupArn", endpointGroupArn())
                .add("EndpointId", endpointId())
                .add("DestinationAddresses", hasDestinationAddresses() ? destinationAddresses() : null)
                .add("DestinationPorts", hasDestinationPorts() ? destinationPorts() : null)
                .add("DenyAllTrafficToEndpoint", denyAllTrafficToEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointGroupArn":
            return Optional.ofNullable(clazz.cast(endpointGroupArn()));
        case "EndpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        case "DestinationAddresses":
            return Optional.ofNullable(clazz.cast(destinationAddresses()));
        case "DestinationPorts":
            return Optional.ofNullable(clazz.cast(destinationPorts()));
        case "DenyAllTrafficToEndpoint":
            return Optional.ofNullable(clazz.cast(denyAllTrafficToEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EndpointGroupArn", ENDPOINT_GROUP_ARN_FIELD);
        map.put("EndpointId", ENDPOINT_ID_FIELD);
        map.put("DestinationAddresses", DESTINATION_ADDRESSES_FIELD);
        map.put("DestinationPorts", DESTINATION_PORTS_FIELD);
        map.put("DenyAllTrafficToEndpoint", DENY_ALL_TRAFFIC_TO_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DenyCustomRoutingTrafficRequest, T> g) {
        return obj -> g.apply((DenyCustomRoutingTrafficRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DenyCustomRoutingTrafficRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the endpoint group.
         * </p>
         * 
         * @param endpointGroupArn
         *        The Amazon Resource Name (ARN) of the endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointGroupArn(String endpointGroupArn);

        /**
         * <p>
         * An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.
         * </p>
         * 
         * @param endpointId
         *        An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC)
         *        subnet ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        /**
         * <p>
         * A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to
         * prevent from receiving traffic. The IP addresses must be a subset of the IP addresses allowed for the VPC
         * subnet associated with the endpoint group.
         * </p>
         * 
         * @param destinationAddresses
         *        A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want
         *        to prevent from receiving traffic. The IP addresses must be a subset of the IP addresses allowed for
         *        the VPC subnet associated with the endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationAddresses(Collection<String> destinationAddresses);

        /**
         * <p>
         * A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to
         * prevent from receiving traffic. The IP addresses must be a subset of the IP addresses allowed for the VPC
         * subnet associated with the endpoint group.
         * </p>
         * 
         * @param destinationAddresses
         *        A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want
         *        to prevent from receiving traffic. The IP addresses must be a subset of the IP addresses allowed for
         *        the VPC subnet associated with the endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationAddresses(String... destinationAddresses);

        /**
         * <p>
         * A list of specific Amazon EC2 instance ports (destination ports) in a subnet endpoint that you want to
         * prevent from receiving traffic.
         * </p>
         * 
         * @param destinationPorts
         *        A list of specific Amazon EC2 instance ports (destination ports) in a subnet endpoint that you want to
         *        prevent from receiving traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPorts(Collection<Integer> destinationPorts);

        /**
         * <p>
         * A list of specific Amazon EC2 instance ports (destination ports) in a subnet endpoint that you want to
         * prevent from receiving traffic.
         * </p>
         * 
         * @param destinationPorts
         *        A list of specific Amazon EC2 instance ports (destination ports) in a subnet endpoint that you want to
         *        prevent from receiving traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPorts(Integer... destinationPorts);

        /**
         * <p>
         * Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint <i>cannot</i>
         * receive traffic from a custom routing accelerator. The value is TRUE or FALSE.
         * </p>
         * <p>
         * When set to TRUE, <i>no</i> destinations in the custom routing VPC subnet can receive traffic. Note that you
         * cannot specify destination IP addresses and ports when the value is set to TRUE.
         * </p>
         * <p>
         * When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that cannot
         * receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept
         * traffic is the same as the ports configured for the endpoint group.
         * </p>
         * <p>
         * The default value is FALSE.
         * </p>
         * 
         * @param denyAllTrafficToEndpoint
         *        Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint
         *        <i>cannot</i> receive traffic from a custom routing accelerator. The value is TRUE or FALSE. </p>
         *        <p>
         *        When set to TRUE, <i>no</i> destinations in the custom routing VPC subnet can receive traffic. Note
         *        that you cannot specify destination IP addresses and ports when the value is set to TRUE.
         *        </p>
         *        <p>
         *        When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that
         *        cannot receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports
         *        that can accept traffic is the same as the ports configured for the endpoint group.
         *        </p>
         *        <p>
         *        The default value is FALSE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder denyAllTrafficToEndpoint(Boolean denyAllTrafficToEndpoint);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlobalAcceleratorRequest.BuilderImpl implements Builder {
        private String endpointGroupArn;

        private String endpointId;

        private List<String> destinationAddresses = DefaultSdkAutoConstructList.getInstance();

        private List<Integer> destinationPorts = DefaultSdkAutoConstructList.getInstance();

        private Boolean denyAllTrafficToEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(DenyCustomRoutingTrafficRequest model) {
            super(model);
            endpointGroupArn(model.endpointGroupArn);
            endpointId(model.endpointId);
            destinationAddresses(model.destinationAddresses);
            destinationPorts(model.destinationPorts);
            denyAllTrafficToEndpoint(model.denyAllTrafficToEndpoint);
        }

        public final String getEndpointGroupArn() {
            return endpointGroupArn;
        }

        public final void setEndpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
        }

        @Override
        public final Builder endpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
            return this;
        }

        public final String getEndpointId() {
            return endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final Collection<String> getDestinationAddresses() {
            if (destinationAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return destinationAddresses;
        }

        public final void setDestinationAddresses(Collection<String> destinationAddresses) {
            this.destinationAddresses = DestinationAddressesCopier.copy(destinationAddresses);
        }

        @Override
        public final Builder destinationAddresses(Collection<String> destinationAddresses) {
            this.destinationAddresses = DestinationAddressesCopier.copy(destinationAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationAddresses(String... destinationAddresses) {
            destinationAddresses(Arrays.asList(destinationAddresses));
            return this;
        }

        public final Collection<Integer> getDestinationPorts() {
            if (destinationPorts instanceof SdkAutoConstructList) {
                return null;
            }
            return destinationPorts;
        }

        public final void setDestinationPorts(Collection<Integer> destinationPorts) {
            this.destinationPorts = DestinationPortsCopier.copy(destinationPorts);
        }

        @Override
        public final Builder destinationPorts(Collection<Integer> destinationPorts) {
            this.destinationPorts = DestinationPortsCopier.copy(destinationPorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPorts(Integer... destinationPorts) {
            destinationPorts(Arrays.asList(destinationPorts));
            return this;
        }

        public final Boolean getDenyAllTrafficToEndpoint() {
            return denyAllTrafficToEndpoint;
        }

        public final void setDenyAllTrafficToEndpoint(Boolean denyAllTrafficToEndpoint) {
            this.denyAllTrafficToEndpoint = denyAllTrafficToEndpoint;
        }

        @Override
        public final Builder denyAllTrafficToEndpoint(Boolean denyAllTrafficToEndpoint) {
            this.denyAllTrafficToEndpoint = denyAllTrafficToEndpoint;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DenyCustomRoutingTrafficRequest build() {
            return new DenyCustomRoutingTrafficRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
