/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type for an endpoint. Specifies information about the endpoint to remove from the endpoint group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<EndpointIdentifier.Builder, EndpointIdentifier> {
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointId").getter(getter(EndpointIdentifier::endpointId)).setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()).build();

    private static final SdkField<Boolean> CLIENT_IP_PRESERVATION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ClientIPPreservationEnabled")
            .getter(getter(EndpointIdentifier::clientIPPreservationEnabled))
            .setter(setter(Builder::clientIPPreservationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientIPPreservationEnabled")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ID_FIELD,
            CLIENT_IP_PRESERVATION_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String endpointId;

    private final Boolean clientIPPreservationEnabled;

    private EndpointIdentifier(BuilderImpl builder) {
        this.endpointId = builder.endpointId;
        this.clientIPPreservationEnabled = builder.clientIPPreservationEnabled;
    }

    /**
     * <p>
     * An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the
     * Amazon Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP
     * address allocation ID. For Amazon EC2 instances, this is the EC2 instance ID.
     * </p>
     * <p>
     * An Application Load Balancer can be either internal or internet-facing.
     * </p>
     * 
     * @return An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is
     *         the Amazon Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the
     *         Elastic IP address allocation ID. For Amazon EC2 instances, this is the EC2 instance ID. </p>
     *         <p>
     *         An Application Load Balancer can be either internal or internet-facing.
     */
    public final String endpointId() {
        return endpointId;
    }

    /**
     * <p>
     * Indicates whether client IP address preservation is enabled for an endpoint. The value is true or false.
     * </p>
     * <p>
     * If the value is set to true, the client's IP address is preserved in the <code>X-Forwarded-For</code> request
     * header as traffic travels to applications on the endpoint fronted by the accelerator.
     * </p>
     * 
     * @return Indicates whether client IP address preservation is enabled for an endpoint. The value is true or false.
     *         </p>
     *         <p>
     *         If the value is set to true, the client's IP address is preserved in the <code>X-Forwarded-For</code>
     *         request header as traffic travels to applications on the endpoint fronted by the accelerator.
     */
    public final Boolean clientIPPreservationEnabled() {
        return clientIPPreservationEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(clientIPPreservationEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointIdentifier)) {
            return false;
        }
        EndpointIdentifier other = (EndpointIdentifier) obj;
        return Objects.equals(endpointId(), other.endpointId())
                && Objects.equals(clientIPPreservationEnabled(), other.clientIPPreservationEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointIdentifier").add("EndpointId", endpointId())
                .add("ClientIPPreservationEnabled", clientIPPreservationEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        case "ClientIPPreservationEnabled":
            return Optional.ofNullable(clazz.cast(clientIPPreservationEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EndpointId", ENDPOINT_ID_FIELD);
        map.put("ClientIPPreservationEnabled", CLIENT_IP_PRESERVATION_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EndpointIdentifier, T> g) {
        return obj -> g.apply((EndpointIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointIdentifier> {
        /**
         * <p>
         * An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the
         * Amazon Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP
         * address allocation ID. For Amazon EC2 instances, this is the EC2 instance ID.
         * </p>
         * <p>
         * An Application Load Balancer can be either internal or internet-facing.
         * </p>
         * 
         * @param endpointId
         *        An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this
         *        is the Amazon Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is
         *        the Elastic IP address allocation ID. For Amazon EC2 instances, this is the EC2 instance ID. </p>
         *        <p>
         *        An Application Load Balancer can be either internal or internet-facing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        /**
         * <p>
         * Indicates whether client IP address preservation is enabled for an endpoint. The value is true or false.
         * </p>
         * <p>
         * If the value is set to true, the client's IP address is preserved in the <code>X-Forwarded-For</code> request
         * header as traffic travels to applications on the endpoint fronted by the accelerator.
         * </p>
         * 
         * @param clientIPPreservationEnabled
         *        Indicates whether client IP address preservation is enabled for an endpoint. The value is true or
         *        false. </p>
         *        <p>
         *        If the value is set to true, the client's IP address is preserved in the <code>X-Forwarded-For</code>
         *        request header as traffic travels to applications on the endpoint fronted by the accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientIPPreservationEnabled(Boolean clientIPPreservationEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String endpointId;

        private Boolean clientIPPreservationEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointIdentifier model) {
            endpointId(model.endpointId);
            clientIPPreservationEnabled(model.clientIPPreservationEnabled);
        }

        public final String getEndpointId() {
            return endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final Boolean getClientIPPreservationEnabled() {
            return clientIPPreservationEnabled;
        }

        public final void setClientIPPreservationEnabled(Boolean clientIPPreservationEnabled) {
            this.clientIPPreservationEnabled = clientIPPreservationEnabled;
        }

        @Override
        public final Builder clientIPPreservationEnabled(Boolean clientIPPreservationEnabled) {
            this.clientIPPreservationEnabled = clientIPPreservationEnabled;
            return this;
        }

        @Override
        public EndpointIdentifier build() {
            return new EndpointIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
