/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomRoutingEndpointGroupsResponse extends GlobalAcceleratorResponse implements
        ToCopyableBuilder<ListCustomRoutingEndpointGroupsResponse.Builder, ListCustomRoutingEndpointGroupsResponse> {
    private static final SdkField<List<CustomRoutingEndpointGroup>> ENDPOINT_GROUPS_FIELD = SdkField
            .<List<CustomRoutingEndpointGroup>> builder(MarshallingType.LIST)
            .memberName("EndpointGroups")
            .getter(getter(ListCustomRoutingEndpointGroupsResponse::endpointGroups))
            .setter(setter(Builder::endpointGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomRoutingEndpointGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomRoutingEndpointGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCustomRoutingEndpointGroupsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_GROUPS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CustomRoutingEndpointGroup> endpointGroups;

    private final String nextToken;

    private ListCustomRoutingEndpointGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.endpointGroups = builder.endpointGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EndpointGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEndpointGroups() {
        return endpointGroups != null && !(endpointGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of the endpoint groups associated with a listener for a custom routing accelerator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpointGroups} method.
     * </p>
     * 
     * @return The list of the endpoint groups associated with a listener for a custom routing accelerator.
     */
    public final List<CustomRoutingEndpointGroup> endpointGroups() {
        return endpointGroups;
    }

    /**
     * <p>
     * The token for the next set of results. You receive this token from a previous call.
     * </p>
     * 
     * @return The token for the next set of results. You receive this token from a previous call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpointGroups() ? endpointGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomRoutingEndpointGroupsResponse)) {
            return false;
        }
        ListCustomRoutingEndpointGroupsResponse other = (ListCustomRoutingEndpointGroupsResponse) obj;
        return hasEndpointGroups() == other.hasEndpointGroups() && Objects.equals(endpointGroups(), other.endpointGroups())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCustomRoutingEndpointGroupsResponse")
                .add("EndpointGroups", hasEndpointGroups() ? endpointGroups() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointGroups":
            return Optional.ofNullable(clazz.cast(endpointGroups()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EndpointGroups", ENDPOINT_GROUPS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCustomRoutingEndpointGroupsResponse, T> g) {
        return obj -> g.apply((ListCustomRoutingEndpointGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCustomRoutingEndpointGroupsResponse> {
        /**
         * <p>
         * The list of the endpoint groups associated with a listener for a custom routing accelerator.
         * </p>
         * 
         * @param endpointGroups
         *        The list of the endpoint groups associated with a listener for a custom routing accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointGroups(Collection<CustomRoutingEndpointGroup> endpointGroups);

        /**
         * <p>
         * The list of the endpoint groups associated with a listener for a custom routing accelerator.
         * </p>
         * 
         * @param endpointGroups
         *        The list of the endpoint groups associated with a listener for a custom routing accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointGroups(CustomRoutingEndpointGroup... endpointGroups);

        /**
         * <p>
         * The list of the endpoint groups associated with a listener for a custom routing accelerator.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointGroup.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointGroup.Builder#build()} is
         * called immediately and its result is passed to {@link #endpointGroups(List<CustomRoutingEndpointGroup>)}.
         * 
         * @param endpointGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointGroups(java.util.Collection<CustomRoutingEndpointGroup>)
         */
        Builder endpointGroups(Consumer<CustomRoutingEndpointGroup.Builder>... endpointGroups);

        /**
         * <p>
         * The token for the next set of results. You receive this token from a previous call.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. You receive this token from a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlobalAcceleratorResponse.BuilderImpl implements Builder {
        private List<CustomRoutingEndpointGroup> endpointGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomRoutingEndpointGroupsResponse model) {
            super(model);
            endpointGroups(model.endpointGroups);
            nextToken(model.nextToken);
        }

        public final List<CustomRoutingEndpointGroup.Builder> getEndpointGroups() {
            List<CustomRoutingEndpointGroup.Builder> result = CustomRoutingEndpointGroupsCopier
                    .copyToBuilder(this.endpointGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpointGroups(Collection<CustomRoutingEndpointGroup.BuilderImpl> endpointGroups) {
            this.endpointGroups = CustomRoutingEndpointGroupsCopier.copyFromBuilder(endpointGroups);
        }

        @Override
        public final Builder endpointGroups(Collection<CustomRoutingEndpointGroup> endpointGroups) {
            this.endpointGroups = CustomRoutingEndpointGroupsCopier.copy(endpointGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointGroups(CustomRoutingEndpointGroup... endpointGroups) {
            endpointGroups(Arrays.asList(endpointGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointGroups(Consumer<CustomRoutingEndpointGroup.Builder>... endpointGroups) {
            endpointGroups(Stream.of(endpointGroups).map(c -> CustomRoutingEndpointGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCustomRoutingEndpointGroupsResponse build() {
            return new ListCustomRoutingEndpointGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
