/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A resource is one of the following: the ARN for an Amazon Web Services resource that is supported by Global
 * Accelerator to be added as an endpoint, or a CIDR range that specifies a bring your own IP (BYOIP) address pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Resource implements SdkPojo, Serializable, ToCopyableBuilder<Resource.Builder, Resource> {
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointId").getter(getter(Resource::endpointId)).setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()).build();

    private static final SdkField<String> CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Cidr")
            .getter(getter(Resource::cidr)).setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(Resource::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ID_FIELD, CIDR_FIELD,
            REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String endpointId;

    private final String cidr;

    private final String region;

    private Resource(BuilderImpl builder) {
        this.endpointId = builder.endpointId;
        this.cidr = builder.cidr;
        this.region = builder.region;
    }

    /**
     * <p>
     * The endpoint ID for the endpoint that is specified as a Amazon Web Services resource.
     * </p>
     * <p>
     * An endpoint ID for the cross-account feature is the ARN of an Amazon Web Services resource, such as a Network
     * Load Balancer, that Global Accelerator supports as an endpoint for an accelerator.
     * </p>
     * 
     * @return The endpoint ID for the endpoint that is specified as a Amazon Web Services resource. </p>
     *         <p>
     *         An endpoint ID for the cross-account feature is the ARN of an Amazon Web Services resource, such as a
     *         Network Load Balancer, that Global Accelerator supports as an endpoint for an accelerator.
     */
    public final String endpointId() {
        return endpointId;
    }

    /**
     * <p>
     * An IP address range, in CIDR format, that is specified as resource. The address must be provisioned and
     * advertised in Global Accelerator by following the bring your own IP address (BYOIP) process for Global
     * Accelerator
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the Global Accelerator Developer Guide.
     * </p>
     * 
     * @return An IP address range, in CIDR format, that is specified as resource. The address must be provisioned and
     *         advertised in Global Accelerator by following the bring your own IP address (BYOIP) process for Global
     *         Accelerator</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP
     *         addresses (BYOIP)</a> in the Global Accelerator Developer Guide.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * The Amazon Web Services Region where a shared endpoint resource is located.
     * </p>
     * 
     * @return The Amazon Web Services Region where a shared endpoint resource is located.
     */
    public final String region() {
        return region;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource) obj;
        return Objects.equals(endpointId(), other.endpointId()) && Objects.equals(cidr(), other.cidr())
                && Objects.equals(region(), other.region());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Resource").add("EndpointId", endpointId()).add("Cidr", cidr()).add("Region", region()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EndpointId", ENDPOINT_ID_FIELD);
        map.put("Cidr", CIDR_FIELD);
        map.put("Region", REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Resource> {
        /**
         * <p>
         * The endpoint ID for the endpoint that is specified as a Amazon Web Services resource.
         * </p>
         * <p>
         * An endpoint ID for the cross-account feature is the ARN of an Amazon Web Services resource, such as a Network
         * Load Balancer, that Global Accelerator supports as an endpoint for an accelerator.
         * </p>
         * 
         * @param endpointId
         *        The endpoint ID for the endpoint that is specified as a Amazon Web Services resource. </p>
         *        <p>
         *        An endpoint ID for the cross-account feature is the ARN of an Amazon Web Services resource, such as a
         *        Network Load Balancer, that Global Accelerator supports as an endpoint for an accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        /**
         * <p>
         * An IP address range, in CIDR format, that is specified as resource. The address must be provisioned and
         * advertised in Global Accelerator by following the bring your own IP address (BYOIP) process for Global
         * Accelerator
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
         * (BYOIP)</a> in the Global Accelerator Developer Guide.
         * </p>
         * 
         * @param cidr
         *        An IP address range, in CIDR format, that is specified as resource. The address must be provisioned
         *        and advertised in Global Accelerator by following the bring your own IP address (BYOIP) process for
         *        Global Accelerator</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP
         *        addresses (BYOIP)</a> in the Global Accelerator Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * The Amazon Web Services Region where a shared endpoint resource is located.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region where a shared endpoint resource is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);
    }

    static final class BuilderImpl implements Builder {
        private String endpointId;

        private String cidr;

        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            endpointId(model.endpointId);
            cidr(model.cidr);
            region(model.region);
        }

        public final String getEndpointId() {
            return endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public Resource build() {
            return new Resource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
