/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.PrincipalsCopier;
import software.amazon.awssdk.services.globalaccelerator.model.Resource;
import software.amazon.awssdk.services.globalaccelerator.model.ResourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Attachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Attachment> {
    private static final SdkField<String> ATTACHMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentArn").getter(Attachment.getter(Attachment::attachmentArn)).setter(Attachment.setter(Builder::attachmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Attachment.getter(Attachment::name)).setter(Attachment.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Principals").getter(Attachment.getter(Attachment::principals)).setter(Attachment.setter(Builder::principals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Resource>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(Attachment.getter(Attachment::resources)).setter(Attachment.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(Attachment.getter(Attachment::lastModifiedTime)).setter(Attachment.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(Attachment.getter(Attachment::createdTime)).setter(Attachment.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ARN_FIELD, NAME_FIELD, PRINCIPALS_FIELD, RESOURCES_FIELD, LAST_MODIFIED_TIME_FIELD, CREATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Attachment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attachmentArn;
    private final String name;
    private final List<String> principals;
    private final List<Resource> resources;
    private final Instant lastModifiedTime;
    private final Instant createdTime;

    private Attachment(BuilderImpl builder) {
        this.attachmentArn = builder.attachmentArn;
        this.name = builder.name;
        this.principals = builder.principals;
        this.resources = builder.resources;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.createdTime = builder.createdTime;
    }

    public final String attachmentArn() {
        return this.attachmentArn;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasPrincipals() {
        return this.principals != null && !(this.principals instanceof SdkAutoConstructList);
    }

    public final List<String> principals() {
        return this.principals;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<Resource> resources() {
        return this.resources;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipals() ? this.principals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment)obj;
        return Objects.equals(this.attachmentArn(), other.attachmentArn()) && Objects.equals(this.name(), other.name()) && this.hasPrincipals() == other.hasPrincipals() && Objects.equals(this.principals(), other.principals()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.createdTime(), other.createdTime());
    }

    public final String toString() {
        return ToString.builder((String)"Attachment").add("AttachmentArn", (Object)this.attachmentArn()).add("Name", (Object)this.name()).add("Principals", this.hasPrincipals() ? this.principals() : null).add("Resources", this.hasResources() ? this.resources() : null).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("CreatedTime", (Object)this.createdTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachmentArn": {
                return Optional.ofNullable(clazz.cast(this.attachmentArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Principals": {
                return Optional.ofNullable(clazz.cast(this.principals()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AttachmentArn", ATTACHMENT_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Principals", PRINCIPALS_FIELD);
        map.put("Resources", RESOURCES_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Attachment, T> g) {
        return obj -> g.apply((Attachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attachmentArn;
        private String name;
        private List<String> principals = DefaultSdkAutoConstructList.getInstance();
        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();
        private Instant lastModifiedTime;
        private Instant createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Attachment model) {
            this.attachmentArn(model.attachmentArn);
            this.name(model.name);
            this.principals(model.principals);
            this.resources(model.resources);
            this.lastModifiedTime(model.lastModifiedTime);
            this.createdTime(model.createdTime);
        }

        public final String getAttachmentArn() {
            return this.attachmentArn;
        }

        public final void setAttachmentArn(String attachmentArn) {
            this.attachmentArn = attachmentArn;
        }

        @Override
        public final Builder attachmentArn(String attachmentArn) {
            this.attachmentArn = attachmentArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getPrincipals() {
            if (this.principals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.principals;
        }

        public final void setPrincipals(Collection<String> principals) {
            this.principals = PrincipalsCopier.copy(principals);
        }

        @Override
        public final Builder principals(Collection<String> principals) {
            this.principals = PrincipalsCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(String ... principals) {
            this.principals(Arrays.asList(principals));
            return this;
        }

        public final List<Resource.Builder> getResources() {
            List<Resource.Builder> result = ResourcesCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ResourcesCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ResourcesCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public Attachment build() {
            return new Attachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Attachment> {
        public Builder attachmentArn(String var1);

        public Builder name(String var1);

        public Builder principals(Collection<String> var1);

        public Builder principals(String ... var1);

        public Builder resources(Collection<Resource> var1);

        public Builder resources(Resource ... var1);

        public Builder resources(Consumer<Resource.Builder> ... var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder createdTime(Instant var1);
    }
}

