/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorAsyncClient;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorServiceClientConfiguration;
import software.amazon.awssdk.services.globalaccelerator.internal.GlobalAcceleratorServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.globalaccelerator.model.AcceleratorNotDisabledException;
import software.amazon.awssdk.services.globalaccelerator.model.AcceleratorNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.AccessDeniedException;
import software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AddEndpointsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AddEndpointsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AllowCustomRoutingTrafficRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AllowCustomRoutingTrafficResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AssociatedEndpointGroupFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.AssociatedListenerFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.AttachmentNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.ConflictException;
import software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCrossAccountAttachmentRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCrossAccountAttachmentResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCrossAccountAttachmentRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCrossAccountAttachmentResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeprovisionByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeprovisionByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCrossAccountAttachmentRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCrossAccountAttachmentResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointAlreadyExistsException;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointGroupAlreadyExistsException;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointGroupNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorException;
import software.amazon.awssdk.services.globalaccelerator.model.IncorrectCidrStateException;
import software.amazon.awssdk.services.globalaccelerator.model.InternalServiceErrorException;
import software.amazon.awssdk.services.globalaccelerator.model.InvalidArgumentException;
import software.amazon.awssdk.services.globalaccelerator.model.InvalidNextTokenException;
import software.amazon.awssdk.services.globalaccelerator.model.InvalidPortRangeException;
import software.amazon.awssdk.services.globalaccelerator.model.LimitExceededException;
import software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountAttachmentsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountAttachmentsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourceAccountsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourceAccountsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourcesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourcesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListListenersRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListenerNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.RemoveCustomRoutingEndpointsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.RemoveCustomRoutingEndpointsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.RemoveEndpointsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.RemoveEndpointsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.TagResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.TagResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.TransactionInProgressException;
import software.amazon.awssdk.services.globalaccelerator.model.UntagResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UntagResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCrossAccountAttachmentRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCrossAccountAttachmentResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.transform.AddCustomRoutingEndpointsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.AddEndpointsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.AdvertiseByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.AllowCustomRoutingTrafficRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateCrossAccountAttachmentRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateCustomRoutingAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateCustomRoutingEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateCustomRoutingListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteCrossAccountAttachmentRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteCustomRoutingAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteCustomRoutingEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteCustomRoutingListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DenyCustomRoutingTrafficRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeprovisionByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeAcceleratorAttributesRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeCrossAccountAttachmentRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeCustomRoutingAcceleratorAttributesRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeCustomRoutingAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeCustomRoutingEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeCustomRoutingListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListAcceleratorsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListByoipCidrsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCrossAccountAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCrossAccountResourceAccountsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCrossAccountResourcesRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCustomRoutingAcceleratorsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCustomRoutingEndpointGroupsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCustomRoutingListenersRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCustomRoutingPortMappingsByDestinationRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCustomRoutingPortMappingsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListEndpointGroupsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListListenersRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ProvisionByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.RemoveCustomRoutingEndpointsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.RemoveEndpointsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateAcceleratorAttributesRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateCrossAccountAttachmentRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateCustomRoutingAcceleratorAttributesRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateCustomRoutingAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateCustomRoutingListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.WithdrawByoipCidrRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultGlobalAcceleratorAsyncClient
implements GlobalAcceleratorAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultGlobalAcceleratorAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultGlobalAcceleratorAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Global_Accelerator#2.32.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AddCustomRoutingEndpointsResponse> addCustomRoutingEndpoints(AddCustomRoutingEndpointsRequest addCustomRoutingEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addCustomRoutingEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, addCustomRoutingEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddCustomRoutingEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddCustomRoutingEndpointsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddCustomRoutingEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddCustomRoutingEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addCustomRoutingEndpointsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$addCustomRoutingEndpoints$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$addCustomRoutingEndpoints$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddEndpointsResponse> addEndpoints(AddEndpointsRequest addEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, addEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddEndpointsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addEndpointsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$addEndpoints$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$addEndpoints$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AdvertiseByoipCidrResponse> advertiseByoipCidr(AdvertiseByoipCidrRequest advertiseByoipCidrRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)advertiseByoipCidrRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, advertiseByoipCidrRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdvertiseByoipCidr");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdvertiseByoipCidrResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdvertiseByoipCidr").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AdvertiseByoipCidrRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)advertiseByoipCidrRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$advertiseByoipCidr$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$advertiseByoipCidr$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AllowCustomRoutingTrafficResponse> allowCustomRoutingTraffic(AllowCustomRoutingTrafficRequest allowCustomRoutingTrafficRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)allowCustomRoutingTrafficRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, allowCustomRoutingTrafficRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AllowCustomRoutingTraffic");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AllowCustomRoutingTrafficResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AllowCustomRoutingTraffic").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AllowCustomRoutingTrafficRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)allowCustomRoutingTrafficRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$allowCustomRoutingTraffic$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$allowCustomRoutingTraffic$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAcceleratorResponse> createAccelerator(CreateAcceleratorRequest createAcceleratorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAcceleratorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, createAcceleratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccelerator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAcceleratorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccelerator").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateAcceleratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createAcceleratorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$createAccelerator$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$createAccelerator$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCrossAccountAttachmentResponse> createCrossAccountAttachment(CreateCrossAccountAttachmentRequest createCrossAccountAttachmentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCrossAccountAttachmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, createCrossAccountAttachmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCrossAccountAttachment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCrossAccountAttachmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCrossAccountAttachment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateCrossAccountAttachmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCrossAccountAttachmentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$createCrossAccountAttachment$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$createCrossAccountAttachment$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCustomRoutingAcceleratorResponse> createCustomRoutingAccelerator(CreateCustomRoutingAcceleratorRequest createCustomRoutingAcceleratorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCustomRoutingAcceleratorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, createCustomRoutingAcceleratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomRoutingAccelerator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomRoutingAcceleratorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomRoutingAccelerator").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateCustomRoutingAcceleratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCustomRoutingAcceleratorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$createCustomRoutingAccelerator$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$createCustomRoutingAccelerator$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCustomRoutingEndpointGroupResponse> createCustomRoutingEndpointGroup(CreateCustomRoutingEndpointGroupRequest createCustomRoutingEndpointGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCustomRoutingEndpointGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, createCustomRoutingEndpointGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomRoutingEndpointGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomRoutingEndpointGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomRoutingEndpointGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateCustomRoutingEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCustomRoutingEndpointGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$createCustomRoutingEndpointGroup$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$createCustomRoutingEndpointGroup$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCustomRoutingListenerResponse> createCustomRoutingListener(CreateCustomRoutingListenerRequest createCustomRoutingListenerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCustomRoutingListenerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, createCustomRoutingListenerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomRoutingListener");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomRoutingListenerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomRoutingListener").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateCustomRoutingListenerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCustomRoutingListenerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$createCustomRoutingListener$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$createCustomRoutingListener$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateEndpointGroupResponse> createEndpointGroup(CreateEndpointGroupRequest createEndpointGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEndpointGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, createEndpointGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEndpointGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEndpointGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEndpointGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createEndpointGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$createEndpointGroup$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$createEndpointGroup$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateListenerResponse> createListener(CreateListenerRequest createListenerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createListenerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, createListenerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateListener");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateListenerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateListener").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateListenerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createListenerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$createListener$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$createListener$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAcceleratorResponse> deleteAccelerator(DeleteAcceleratorRequest deleteAcceleratorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAcceleratorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAcceleratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccelerator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAcceleratorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccelerator").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAcceleratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAcceleratorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$deleteAccelerator$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$deleteAccelerator$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCrossAccountAttachmentResponse> deleteCrossAccountAttachment(DeleteCrossAccountAttachmentRequest deleteCrossAccountAttachmentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCrossAccountAttachmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, deleteCrossAccountAttachmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCrossAccountAttachment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCrossAccountAttachmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCrossAccountAttachment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteCrossAccountAttachmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCrossAccountAttachmentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$deleteCrossAccountAttachment$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$deleteCrossAccountAttachment$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCustomRoutingAcceleratorResponse> deleteCustomRoutingAccelerator(DeleteCustomRoutingAcceleratorRequest deleteCustomRoutingAcceleratorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCustomRoutingAcceleratorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, deleteCustomRoutingAcceleratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomRoutingAccelerator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomRoutingAcceleratorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomRoutingAccelerator").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteCustomRoutingAcceleratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCustomRoutingAcceleratorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$deleteCustomRoutingAccelerator$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$deleteCustomRoutingAccelerator$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCustomRoutingEndpointGroupResponse> deleteCustomRoutingEndpointGroup(DeleteCustomRoutingEndpointGroupRequest deleteCustomRoutingEndpointGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCustomRoutingEndpointGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, deleteCustomRoutingEndpointGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomRoutingEndpointGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomRoutingEndpointGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomRoutingEndpointGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteCustomRoutingEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCustomRoutingEndpointGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$deleteCustomRoutingEndpointGroup$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$deleteCustomRoutingEndpointGroup$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCustomRoutingListenerResponse> deleteCustomRoutingListener(DeleteCustomRoutingListenerRequest deleteCustomRoutingListenerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCustomRoutingListenerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, deleteCustomRoutingListenerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomRoutingListener");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomRoutingListenerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomRoutingListener").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteCustomRoutingListenerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCustomRoutingListenerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$deleteCustomRoutingListener$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$deleteCustomRoutingListener$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEndpointGroupResponse> deleteEndpointGroup(DeleteEndpointGroupRequest deleteEndpointGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEndpointGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, deleteEndpointGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEndpointGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEndpointGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEndpointGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteEndpointGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$deleteEndpointGroup$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$deleteEndpointGroup$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteListenerResponse> deleteListener(DeleteListenerRequest deleteListenerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteListenerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, deleteListenerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteListener");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteListenerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteListener").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteListenerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteListenerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$deleteListener$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$deleteListener$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DenyCustomRoutingTrafficResponse> denyCustomRoutingTraffic(DenyCustomRoutingTrafficRequest denyCustomRoutingTrafficRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)denyCustomRoutingTrafficRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, denyCustomRoutingTrafficRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DenyCustomRoutingTraffic");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DenyCustomRoutingTrafficResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DenyCustomRoutingTraffic").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DenyCustomRoutingTrafficRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)denyCustomRoutingTrafficRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$denyCustomRoutingTraffic$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$denyCustomRoutingTraffic$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeprovisionByoipCidrResponse> deprovisionByoipCidr(DeprovisionByoipCidrRequest deprovisionByoipCidrRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deprovisionByoipCidrRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, deprovisionByoipCidrRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeprovisionByoipCidr");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeprovisionByoipCidrResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeprovisionByoipCidr").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeprovisionByoipCidrRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deprovisionByoipCidrRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$deprovisionByoipCidr$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$deprovisionByoipCidr$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAcceleratorResponse> describeAccelerator(DescribeAcceleratorRequest describeAcceleratorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAcceleratorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, describeAcceleratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccelerator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAcceleratorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccelerator").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeAcceleratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAcceleratorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$describeAccelerator$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$describeAccelerator$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAcceleratorAttributesResponse> describeAcceleratorAttributes(DescribeAcceleratorAttributesRequest describeAcceleratorAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAcceleratorAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, describeAcceleratorAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAcceleratorAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAcceleratorAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAcceleratorAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeAcceleratorAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAcceleratorAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$describeAcceleratorAttributes$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$describeAcceleratorAttributes$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCrossAccountAttachmentResponse> describeCrossAccountAttachment(DescribeCrossAccountAttachmentRequest describeCrossAccountAttachmentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCrossAccountAttachmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, describeCrossAccountAttachmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCrossAccountAttachment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCrossAccountAttachmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCrossAccountAttachment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCrossAccountAttachmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCrossAccountAttachmentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$describeCrossAccountAttachment$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$describeCrossAccountAttachment$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCustomRoutingAcceleratorResponse> describeCustomRoutingAccelerator(DescribeCustomRoutingAcceleratorRequest describeCustomRoutingAcceleratorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCustomRoutingAcceleratorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, describeCustomRoutingAcceleratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCustomRoutingAccelerator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCustomRoutingAcceleratorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCustomRoutingAccelerator").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCustomRoutingAcceleratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCustomRoutingAcceleratorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$describeCustomRoutingAccelerator$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$describeCustomRoutingAccelerator$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCustomRoutingAcceleratorAttributesResponse> describeCustomRoutingAcceleratorAttributes(DescribeCustomRoutingAcceleratorAttributesRequest describeCustomRoutingAcceleratorAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCustomRoutingAcceleratorAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, describeCustomRoutingAcceleratorAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCustomRoutingAcceleratorAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCustomRoutingAcceleratorAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCustomRoutingAcceleratorAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCustomRoutingAcceleratorAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCustomRoutingAcceleratorAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$describeCustomRoutingAcceleratorAttributes$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$describeCustomRoutingAcceleratorAttributes$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCustomRoutingEndpointGroupResponse> describeCustomRoutingEndpointGroup(DescribeCustomRoutingEndpointGroupRequest describeCustomRoutingEndpointGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCustomRoutingEndpointGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, describeCustomRoutingEndpointGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCustomRoutingEndpointGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCustomRoutingEndpointGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCustomRoutingEndpointGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCustomRoutingEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCustomRoutingEndpointGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$describeCustomRoutingEndpointGroup$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$describeCustomRoutingEndpointGroup$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCustomRoutingListenerResponse> describeCustomRoutingListener(DescribeCustomRoutingListenerRequest describeCustomRoutingListenerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCustomRoutingListenerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, describeCustomRoutingListenerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCustomRoutingListener");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCustomRoutingListenerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCustomRoutingListener").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCustomRoutingListenerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCustomRoutingListenerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$describeCustomRoutingListener$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$describeCustomRoutingListener$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEndpointGroupResponse> describeEndpointGroup(DescribeEndpointGroupRequest describeEndpointGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEndpointGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, describeEndpointGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpointGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpointGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEndpointGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$describeEndpointGroup$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$describeEndpointGroup$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeListenerResponse> describeListener(DescribeListenerRequest describeListenerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeListenerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, describeListenerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeListener");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeListenerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeListener").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeListenerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeListenerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$describeListener$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$describeListener$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAcceleratorsResponse> listAccelerators(ListAcceleratorsRequest listAcceleratorsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAcceleratorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, listAcceleratorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccelerators");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAcceleratorsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccelerators").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListAcceleratorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAcceleratorsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$listAccelerators$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$listAccelerators$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListByoipCidrsResponse> listByoipCidrs(ListByoipCidrsRequest listByoipCidrsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listByoipCidrsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, listByoipCidrsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListByoipCidrs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListByoipCidrsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListByoipCidrs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListByoipCidrsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listByoipCidrsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$listByoipCidrs$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$listByoipCidrs$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCrossAccountAttachmentsResponse> listCrossAccountAttachments(ListCrossAccountAttachmentsRequest listCrossAccountAttachmentsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCrossAccountAttachmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, listCrossAccountAttachmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCrossAccountAttachments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCrossAccountAttachmentsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCrossAccountAttachments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListCrossAccountAttachmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCrossAccountAttachmentsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$listCrossAccountAttachments$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$listCrossAccountAttachments$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCrossAccountResourceAccountsResponse> listCrossAccountResourceAccounts(ListCrossAccountResourceAccountsRequest listCrossAccountResourceAccountsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCrossAccountResourceAccountsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, listCrossAccountResourceAccountsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCrossAccountResourceAccounts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCrossAccountResourceAccountsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCrossAccountResourceAccounts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListCrossAccountResourceAccountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCrossAccountResourceAccountsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$listCrossAccountResourceAccounts$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$listCrossAccountResourceAccounts$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCrossAccountResourcesResponse> listCrossAccountResources(ListCrossAccountResourcesRequest listCrossAccountResourcesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCrossAccountResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, listCrossAccountResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCrossAccountResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCrossAccountResourcesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCrossAccountResources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListCrossAccountResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCrossAccountResourcesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$listCrossAccountResources$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$listCrossAccountResources$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCustomRoutingAcceleratorsResponse> listCustomRoutingAccelerators(ListCustomRoutingAcceleratorsRequest listCustomRoutingAcceleratorsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCustomRoutingAcceleratorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, listCustomRoutingAcceleratorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCustomRoutingAccelerators");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCustomRoutingAcceleratorsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCustomRoutingAccelerators").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListCustomRoutingAcceleratorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCustomRoutingAcceleratorsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$listCustomRoutingAccelerators$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$listCustomRoutingAccelerators$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCustomRoutingEndpointGroupsResponse> listCustomRoutingEndpointGroups(ListCustomRoutingEndpointGroupsRequest listCustomRoutingEndpointGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCustomRoutingEndpointGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, listCustomRoutingEndpointGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCustomRoutingEndpointGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCustomRoutingEndpointGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCustomRoutingEndpointGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListCustomRoutingEndpointGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCustomRoutingEndpointGroupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$listCustomRoutingEndpointGroups$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$listCustomRoutingEndpointGroups$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCustomRoutingListenersResponse> listCustomRoutingListeners(ListCustomRoutingListenersRequest listCustomRoutingListenersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCustomRoutingListenersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, listCustomRoutingListenersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCustomRoutingListeners");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCustomRoutingListenersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCustomRoutingListeners").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListCustomRoutingListenersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCustomRoutingListenersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$listCustomRoutingListeners$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$listCustomRoutingListeners$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCustomRoutingPortMappingsResponse> listCustomRoutingPortMappings(ListCustomRoutingPortMappingsRequest listCustomRoutingPortMappingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCustomRoutingPortMappingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, listCustomRoutingPortMappingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCustomRoutingPortMappings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCustomRoutingPortMappingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCustomRoutingPortMappings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListCustomRoutingPortMappingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCustomRoutingPortMappingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$listCustomRoutingPortMappings$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$listCustomRoutingPortMappings$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCustomRoutingPortMappingsByDestinationResponse> listCustomRoutingPortMappingsByDestination(ListCustomRoutingPortMappingsByDestinationRequest listCustomRoutingPortMappingsByDestinationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCustomRoutingPortMappingsByDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, listCustomRoutingPortMappingsByDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCustomRoutingPortMappingsByDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCustomRoutingPortMappingsByDestinationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCustomRoutingPortMappingsByDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListCustomRoutingPortMappingsByDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCustomRoutingPortMappingsByDestinationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$listCustomRoutingPortMappingsByDestination$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$listCustomRoutingPortMappingsByDestination$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListEndpointGroupsResponse> listEndpointGroups(ListEndpointGroupsRequest listEndpointGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEndpointGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, listEndpointGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEndpointGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEndpointGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEndpointGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListEndpointGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listEndpointGroupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$listEndpointGroups$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$listEndpointGroups$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListListenersResponse> listListeners(ListListenersRequest listListenersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listListenersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, listListenersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListListeners");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListListenersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListListeners").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListListenersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listListenersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$listListeners$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$listListeners$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$listTagsForResource$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$listTagsForResource$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ProvisionByoipCidrResponse> provisionByoipCidr(ProvisionByoipCidrRequest provisionByoipCidrRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)provisionByoipCidrRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, provisionByoipCidrRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ProvisionByoipCidr");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ProvisionByoipCidrResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ProvisionByoipCidr").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ProvisionByoipCidrRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)provisionByoipCidrRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$provisionByoipCidr$170(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$provisionByoipCidr$171((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveCustomRoutingEndpointsResponse> removeCustomRoutingEndpoints(RemoveCustomRoutingEndpointsRequest removeCustomRoutingEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeCustomRoutingEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, removeCustomRoutingEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveCustomRoutingEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveCustomRoutingEndpointsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveCustomRoutingEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RemoveCustomRoutingEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)removeCustomRoutingEndpointsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$removeCustomRoutingEndpoints$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$removeCustomRoutingEndpoints$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveEndpointsResponse> removeEndpoints(RemoveEndpointsRequest removeEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, removeEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveEndpointsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RemoveEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)removeEndpointsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$removeEndpoints$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$removeEndpoints$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$tagResource$182(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$tagResource$183((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$untagResource$186(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$untagResource$187((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateAcceleratorResponse> updateAccelerator(UpdateAcceleratorRequest updateAcceleratorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAcceleratorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, updateAcceleratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAccelerator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAcceleratorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAccelerator").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateAcceleratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateAcceleratorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$updateAccelerator$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$updateAccelerator$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateAcceleratorAttributesResponse> updateAcceleratorAttributes(UpdateAcceleratorAttributesRequest updateAcceleratorAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAcceleratorAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, updateAcceleratorAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAcceleratorAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAcceleratorAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAcceleratorAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateAcceleratorAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateAcceleratorAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$updateAcceleratorAttributes$194(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$updateAcceleratorAttributes$195((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateCrossAccountAttachmentResponse> updateCrossAccountAttachment(UpdateCrossAccountAttachmentRequest updateCrossAccountAttachmentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateCrossAccountAttachmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, updateCrossAccountAttachmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCrossAccountAttachment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCrossAccountAttachmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCrossAccountAttachment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateCrossAccountAttachmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateCrossAccountAttachmentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$updateCrossAccountAttachment$198(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$updateCrossAccountAttachment$199((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateCustomRoutingAcceleratorResponse> updateCustomRoutingAccelerator(UpdateCustomRoutingAcceleratorRequest updateCustomRoutingAcceleratorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateCustomRoutingAcceleratorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, updateCustomRoutingAcceleratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCustomRoutingAccelerator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCustomRoutingAcceleratorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCustomRoutingAccelerator").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateCustomRoutingAcceleratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateCustomRoutingAcceleratorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$updateCustomRoutingAccelerator$202(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$updateCustomRoutingAccelerator$203((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateCustomRoutingAcceleratorAttributesResponse> updateCustomRoutingAcceleratorAttributes(UpdateCustomRoutingAcceleratorAttributesRequest updateCustomRoutingAcceleratorAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateCustomRoutingAcceleratorAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, updateCustomRoutingAcceleratorAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCustomRoutingAcceleratorAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCustomRoutingAcceleratorAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCustomRoutingAcceleratorAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateCustomRoutingAcceleratorAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateCustomRoutingAcceleratorAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$updateCustomRoutingAcceleratorAttributes$206(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$updateCustomRoutingAcceleratorAttributes$207((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateCustomRoutingListenerResponse> updateCustomRoutingListener(UpdateCustomRoutingListenerRequest updateCustomRoutingListenerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateCustomRoutingListenerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, updateCustomRoutingListenerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCustomRoutingListener");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCustomRoutingListenerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCustomRoutingListener").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateCustomRoutingListenerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateCustomRoutingListenerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$updateCustomRoutingListener$210(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$updateCustomRoutingListener$211((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateEndpointGroupResponse> updateEndpointGroup(UpdateEndpointGroupRequest updateEndpointGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateEndpointGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, updateEndpointGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEndpointGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEndpointGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEndpointGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateEndpointGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$updateEndpointGroup$214(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$updateEndpointGroup$215((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateListenerResponse> updateListener(UpdateListenerRequest updateListenerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateListenerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, updateListenerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateListener");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateListenerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateListener").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateListenerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateListenerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$updateListener$218(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$updateListener$219((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<WithdrawByoipCidrResponse> withdrawByoipCidr(WithdrawByoipCidrRequest withdrawByoipCidrRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)withdrawByoipCidrRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorAsyncClient.resolveMetricPublishers(clientConfiguration, withdrawByoipCidrRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"WithdrawByoipCidr");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, WithdrawByoipCidrResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "EndpointNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointNotFoundException::builder).build());
                    }
                    case "AssociatedListenerFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build());
                    }
                    case "AssociatedEndpointGroupFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "EndpointGroupAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build());
                    }
                    case "InvalidPortRangeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPortRangeException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "EndpointAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "AttachmentNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AttachmentNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AttachmentNotFoundException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ListenerNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ListenerNotFoundException::builder).build());
                    }
                    case "AcceleratorNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build());
                    }
                    case "IncorrectCidrStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectCidrStateException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "ByoipCidrNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "EndpointGroupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build());
                    }
                    case "AcceleratorNotDisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("WithdrawByoipCidr").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new WithdrawByoipCidrRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)withdrawByoipCidrRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlobalAcceleratorAsyncClient.lambda$withdrawByoipCidr$222(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorAsyncClient.lambda$withdrawByoipCidr$223((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final GlobalAcceleratorServiceClientConfiguration serviceClientConfiguration() {
        return new GlobalAcceleratorServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "globalaccelerator";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(GlobalAcceleratorException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        GlobalAcceleratorServiceClientConfigurationBuilder serviceConfigBuilder = new GlobalAcceleratorServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$withdrawByoipCidr$223(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$withdrawByoipCidr$222(List metricPublishers, MetricCollector apiCallMetricCollector, WithdrawByoipCidrResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateListener$219(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateListener$218(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateListenerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateEndpointGroup$215(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEndpointGroup$214(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateEndpointGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateCustomRoutingListener$211(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCustomRoutingListener$210(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateCustomRoutingListenerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateCustomRoutingAcceleratorAttributes$207(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCustomRoutingAcceleratorAttributes$206(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateCustomRoutingAcceleratorAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateCustomRoutingAccelerator$203(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCustomRoutingAccelerator$202(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateCustomRoutingAcceleratorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateCrossAccountAttachment$199(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCrossAccountAttachment$198(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateCrossAccountAttachmentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateAcceleratorAttributes$195(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAcceleratorAttributes$194(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateAcceleratorAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateAccelerator$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAccelerator$190(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateAcceleratorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$187(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$186(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$183(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$182(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$removeEndpoints$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeEndpoints$178(List metricPublishers, MetricCollector apiCallMetricCollector, RemoveEndpointsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$removeCustomRoutingEndpoints$175(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeCustomRoutingEndpoints$174(List metricPublishers, MetricCollector apiCallMetricCollector, RemoveCustomRoutingEndpointsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$provisionByoipCidr$171(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$provisionByoipCidr$170(List metricPublishers, MetricCollector apiCallMetricCollector, ProvisionByoipCidrResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$166(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listListeners$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listListeners$162(List metricPublishers, MetricCollector apiCallMetricCollector, ListListenersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listEndpointGroups$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEndpointGroups$158(List metricPublishers, MetricCollector apiCallMetricCollector, ListEndpointGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCustomRoutingPortMappingsByDestination$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCustomRoutingPortMappingsByDestination$154(List metricPublishers, MetricCollector apiCallMetricCollector, ListCustomRoutingPortMappingsByDestinationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCustomRoutingPortMappings$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCustomRoutingPortMappings$150(List metricPublishers, MetricCollector apiCallMetricCollector, ListCustomRoutingPortMappingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCustomRoutingListeners$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCustomRoutingListeners$146(List metricPublishers, MetricCollector apiCallMetricCollector, ListCustomRoutingListenersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCustomRoutingEndpointGroups$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCustomRoutingEndpointGroups$142(List metricPublishers, MetricCollector apiCallMetricCollector, ListCustomRoutingEndpointGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCustomRoutingAccelerators$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCustomRoutingAccelerators$138(List metricPublishers, MetricCollector apiCallMetricCollector, ListCustomRoutingAcceleratorsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCrossAccountResources$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCrossAccountResources$134(List metricPublishers, MetricCollector apiCallMetricCollector, ListCrossAccountResourcesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCrossAccountResourceAccounts$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCrossAccountResourceAccounts$130(List metricPublishers, MetricCollector apiCallMetricCollector, ListCrossAccountResourceAccountsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCrossAccountAttachments$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCrossAccountAttachments$126(List metricPublishers, MetricCollector apiCallMetricCollector, ListCrossAccountAttachmentsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listByoipCidrs$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listByoipCidrs$122(List metricPublishers, MetricCollector apiCallMetricCollector, ListByoipCidrsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAccelerators$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccelerators$118(List metricPublishers, MetricCollector apiCallMetricCollector, ListAcceleratorsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeListener$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeListener$114(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeListenerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeEndpointGroup$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEndpointGroup$110(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeEndpointGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCustomRoutingListener$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCustomRoutingListener$106(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCustomRoutingListenerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCustomRoutingEndpointGroup$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCustomRoutingEndpointGroup$102(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCustomRoutingEndpointGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCustomRoutingAcceleratorAttributes$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCustomRoutingAcceleratorAttributes$98(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCustomRoutingAcceleratorAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCustomRoutingAccelerator$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCustomRoutingAccelerator$94(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCustomRoutingAcceleratorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCrossAccountAttachment$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCrossAccountAttachment$90(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCrossAccountAttachmentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeAcceleratorAttributes$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAcceleratorAttributes$86(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeAcceleratorAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeAccelerator$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccelerator$82(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeAcceleratorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deprovisionByoipCidr$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deprovisionByoipCidr$78(List metricPublishers, MetricCollector apiCallMetricCollector, DeprovisionByoipCidrResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$denyCustomRoutingTraffic$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$denyCustomRoutingTraffic$74(List metricPublishers, MetricCollector apiCallMetricCollector, DenyCustomRoutingTrafficResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteListener$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteListener$70(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteListenerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteEndpointGroup$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEndpointGroup$66(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteEndpointGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCustomRoutingListener$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCustomRoutingListener$62(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCustomRoutingListenerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCustomRoutingEndpointGroup$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCustomRoutingEndpointGroup$58(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCustomRoutingEndpointGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCustomRoutingAccelerator$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCustomRoutingAccelerator$54(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCustomRoutingAcceleratorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCrossAccountAttachment$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCrossAccountAttachment$50(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCrossAccountAttachmentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAccelerator$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccelerator$46(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAcceleratorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createListener$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createListener$42(List metricPublishers, MetricCollector apiCallMetricCollector, CreateListenerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createEndpointGroup$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEndpointGroup$38(List metricPublishers, MetricCollector apiCallMetricCollector, CreateEndpointGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCustomRoutingListener$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCustomRoutingListener$34(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCustomRoutingListenerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCustomRoutingEndpointGroup$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCustomRoutingEndpointGroup$30(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCustomRoutingEndpointGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCustomRoutingAccelerator$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCustomRoutingAccelerator$26(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCustomRoutingAcceleratorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCrossAccountAttachment$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCrossAccountAttachment$22(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCrossAccountAttachmentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createAccelerator$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAccelerator$18(List metricPublishers, MetricCollector apiCallMetricCollector, CreateAcceleratorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$allowCustomRoutingTraffic$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$allowCustomRoutingTraffic$14(List metricPublishers, MetricCollector apiCallMetricCollector, AllowCustomRoutingTrafficResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$advertiseByoipCidr$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$advertiseByoipCidr$10(List metricPublishers, MetricCollector apiCallMetricCollector, AdvertiseByoipCidrResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addEndpoints$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addEndpoints$6(List metricPublishers, MetricCollector apiCallMetricCollector, AddEndpointsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addCustomRoutingEndpoints$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addCustomRoutingEndpoints$2(List metricPublishers, MetricCollector apiCallMetricCollector, AddCustomRoutingEndpointsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

