/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ColumnStatisticsError;
import software.amazon.awssdk.services.glue.model.ColumnStatisticsErrorsCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateColumnStatisticsForTableResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, UpdateColumnStatisticsForTableResponse> {
    private static final SdkField<List<ColumnStatisticsError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateColumnStatisticsForTableResponse.getter(UpdateColumnStatisticsForTableResponse::errors)).setter(UpdateColumnStatisticsForTableResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnStatisticsError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD));
    private final List<ColumnStatisticsError> errors;

    private UpdateColumnStatisticsForTableResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
    }

    public boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public List<ColumnStatisticsError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.errors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateColumnStatisticsForTableResponse)) {
            return false;
        }
        UpdateColumnStatisticsForTableResponse other = (UpdateColumnStatisticsForTableResponse)((Object)obj);
        return Objects.equals(this.errors(), other.errors());
    }

    public String toString() {
        return ToString.builder((String)"UpdateColumnStatisticsForTableResponse").add("Errors", this.errors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateColumnStatisticsForTableResponse, T> g) {
        return obj -> g.apply((UpdateColumnStatisticsForTableResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<ColumnStatisticsError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateColumnStatisticsForTableResponse model) {
            super(model);
            this.errors(model.errors);
        }

        public final Collection<ColumnStatisticsError.Builder> getErrors() {
            return this.errors != null ? (Collection)this.errors.stream().map(ColumnStatisticsError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<ColumnStatisticsError> errors) {
            this.errors = ColumnStatisticsErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(ColumnStatisticsError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<ColumnStatisticsError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (ColumnStatisticsError)((ColumnStatisticsError.Builder)ColumnStatisticsError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<ColumnStatisticsError.BuilderImpl> errors) {
            this.errors = ColumnStatisticsErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public UpdateColumnStatisticsForTableResponse build() {
            return new UpdateColumnStatisticsForTableResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateColumnStatisticsForTableResponse> {
        public Builder errors(Collection<ColumnStatisticsError> var1);

        public Builder errors(ColumnStatisticsError ... var1);

        public Builder errors(Consumer<ColumnStatisticsError.Builder> ... var1);
    }
}

