/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.BoundedPartitionValueListCopier;
import software.amazon.awssdk.services.glue.model.ErrorDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdatePartitionFailureEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchUpdatePartitionFailureEntry> {
    private static final SdkField<List<String>> PARTITION_VALUE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartitionValueList").getter(BatchUpdatePartitionFailureEntry.getter(BatchUpdatePartitionFailureEntry::partitionValueList)).setter(BatchUpdatePartitionFailureEntry.setter(Builder::partitionValueList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionValueList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ErrorDetail> ERROR_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ErrorDetail").getter(BatchUpdatePartitionFailureEntry.getter(BatchUpdatePartitionFailureEntry::errorDetail)).setter(BatchUpdatePartitionFailureEntry.setter(Builder::errorDetail)).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITION_VALUE_LIST_FIELD, ERROR_DETAIL_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> partitionValueList;
    private final ErrorDetail errorDetail;

    private BatchUpdatePartitionFailureEntry(BuilderImpl builder) {
        this.partitionValueList = builder.partitionValueList;
        this.errorDetail = builder.errorDetail;
    }

    public boolean hasPartitionValueList() {
        return this.partitionValueList != null && !(this.partitionValueList instanceof SdkAutoConstructList);
    }

    public List<String> partitionValueList() {
        return this.partitionValueList;
    }

    public ErrorDetail errorDetail() {
        return this.errorDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionValueList() ? this.partitionValueList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetail());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdatePartitionFailureEntry)) {
            return false;
        }
        BatchUpdatePartitionFailureEntry other = (BatchUpdatePartitionFailureEntry)obj;
        return this.hasPartitionValueList() == other.hasPartitionValueList() && Objects.equals(this.partitionValueList(), other.partitionValueList()) && Objects.equals(this.errorDetail(), other.errorDetail());
    }

    public String toString() {
        return ToString.builder((String)"BatchUpdatePartitionFailureEntry").add("PartitionValueList", this.hasPartitionValueList() ? this.partitionValueList() : null).add("ErrorDetail", (Object)this.errorDetail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PartitionValueList": {
                return Optional.ofNullable(clazz.cast(this.partitionValueList()));
            }
            case "ErrorDetail": {
                return Optional.ofNullable(clazz.cast(this.errorDetail()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdatePartitionFailureEntry, T> g) {
        return obj -> g.apply((BatchUpdatePartitionFailureEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> partitionValueList = DefaultSdkAutoConstructList.getInstance();
        private ErrorDetail errorDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdatePartitionFailureEntry model) {
            this.partitionValueList(model.partitionValueList);
            this.errorDetail(model.errorDetail);
        }

        public final Collection<String> getPartitionValueList() {
            if (this.partitionValueList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.partitionValueList;
        }

        @Override
        public final Builder partitionValueList(Collection<String> partitionValueList) {
            this.partitionValueList = BoundedPartitionValueListCopier.copy(partitionValueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionValueList(String ... partitionValueList) {
            this.partitionValueList(Arrays.asList(partitionValueList));
            return this;
        }

        public final void setPartitionValueList(Collection<String> partitionValueList) {
            this.partitionValueList = BoundedPartitionValueListCopier.copy(partitionValueList);
        }

        public final ErrorDetail.Builder getErrorDetail() {
            return this.errorDetail != null ? this.errorDetail.toBuilder() : null;
        }

        @Override
        public final Builder errorDetail(ErrorDetail errorDetail) {
            this.errorDetail = errorDetail;
            return this;
        }

        public final void setErrorDetail(ErrorDetail.BuilderImpl errorDetail) {
            this.errorDetail = errorDetail != null ? errorDetail.build() : null;
        }

        public BatchUpdatePartitionFailureEntry build() {
            return new BatchUpdatePartitionFailureEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchUpdatePartitionFailureEntry> {
        public Builder partitionValueList(Collection<String> var1);

        public Builder partitionValueList(String ... var1);

        public Builder errorDetail(ErrorDetail var1);

        default public Builder errorDetail(Consumer<ErrorDetail.Builder> errorDetail) {
            return this.errorDetail((ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation(errorDetail)).build());
        }
    }
}

