/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.CatalogEncryptionMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptionAtRest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EncryptionAtRest> {
    private static final SdkField<String> CATALOG_ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogEncryptionMode").getter(EncryptionAtRest.getter(EncryptionAtRest::catalogEncryptionModeAsString)).setter(EncryptionAtRest.setter(Builder::catalogEncryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogEncryptionMode").build()}).build();
    private static final SdkField<String> SSE_AWS_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SseAwsKmsKeyId").getter(EncryptionAtRest.getter(EncryptionAtRest::sseAwsKmsKeyId)).setter(EncryptionAtRest.setter(Builder::sseAwsKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseAwsKmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ENCRYPTION_MODE_FIELD, SSE_AWS_KMS_KEY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String catalogEncryptionMode;
    private final String sseAwsKmsKeyId;

    private EncryptionAtRest(BuilderImpl builder) {
        this.catalogEncryptionMode = builder.catalogEncryptionMode;
        this.sseAwsKmsKeyId = builder.sseAwsKmsKeyId;
    }

    public CatalogEncryptionMode catalogEncryptionMode() {
        return CatalogEncryptionMode.fromValue(this.catalogEncryptionMode);
    }

    public String catalogEncryptionModeAsString() {
        return this.catalogEncryptionMode;
    }

    public String sseAwsKmsKeyId() {
        return this.sseAwsKmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseAwsKmsKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionAtRest)) {
            return false;
        }
        EncryptionAtRest other = (EncryptionAtRest)obj;
        return Objects.equals(this.catalogEncryptionModeAsString(), other.catalogEncryptionModeAsString()) && Objects.equals(this.sseAwsKmsKeyId(), other.sseAwsKmsKeyId());
    }

    public String toString() {
        return ToString.builder((String)"EncryptionAtRest").add("CatalogEncryptionMode", (Object)this.catalogEncryptionModeAsString()).add("SseAwsKmsKeyId", (Object)this.sseAwsKmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogEncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.catalogEncryptionModeAsString()));
            }
            case "SseAwsKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.sseAwsKmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionAtRest, T> g) {
        return obj -> g.apply((EncryptionAtRest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogEncryptionMode;
        private String sseAwsKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionAtRest model) {
            this.catalogEncryptionMode(model.catalogEncryptionMode);
            this.sseAwsKmsKeyId(model.sseAwsKmsKeyId);
        }

        public final String getCatalogEncryptionMode() {
            return this.catalogEncryptionMode;
        }

        @Override
        public final Builder catalogEncryptionMode(String catalogEncryptionMode) {
            this.catalogEncryptionMode = catalogEncryptionMode;
            return this;
        }

        @Override
        public final Builder catalogEncryptionMode(CatalogEncryptionMode catalogEncryptionMode) {
            this.catalogEncryptionMode(catalogEncryptionMode == null ? null : catalogEncryptionMode.toString());
            return this;
        }

        public final void setCatalogEncryptionMode(String catalogEncryptionMode) {
            this.catalogEncryptionMode = catalogEncryptionMode;
        }

        public final String getSseAwsKmsKeyId() {
            return this.sseAwsKmsKeyId;
        }

        @Override
        public final Builder sseAwsKmsKeyId(String sseAwsKmsKeyId) {
            this.sseAwsKmsKeyId = sseAwsKmsKeyId;
            return this;
        }

        public final void setSseAwsKmsKeyId(String sseAwsKmsKeyId) {
            this.sseAwsKmsKeyId = sseAwsKmsKeyId;
        }

        public EncryptionAtRest build() {
            return new EncryptionAtRest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EncryptionAtRest> {
        public Builder catalogEncryptionMode(String var1);

        public Builder catalogEncryptionMode(CatalogEncryptionMode var1);

        public Builder sseAwsKmsKeyId(String var1);
    }
}

