/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.WorkflowRunPropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorkflowRunPropertiesResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetWorkflowRunPropertiesResponse> {
    private static final SdkField<Map<String, String>> RUN_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RunProperties").getter(GetWorkflowRunPropertiesResponse.getter(GetWorkflowRunPropertiesResponse::runProperties)).setter(GetWorkflowRunPropertiesResponse.setter(Builder::runProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_PROPERTIES_FIELD));
    private final Map<String, String> runProperties;

    private GetWorkflowRunPropertiesResponse(BuilderImpl builder) {
        super(builder);
        this.runProperties = builder.runProperties;
    }

    public boolean hasRunProperties() {
        return this.runProperties != null && !(this.runProperties instanceof SdkAutoConstructMap);
    }

    public Map<String, String> runProperties() {
        return this.runProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRunProperties() ? this.runProperties() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowRunPropertiesResponse)) {
            return false;
        }
        GetWorkflowRunPropertiesResponse other = (GetWorkflowRunPropertiesResponse)((Object)obj);
        return this.hasRunProperties() == other.hasRunProperties() && Objects.equals(this.runProperties(), other.runProperties());
    }

    public String toString() {
        return ToString.builder((String)"GetWorkflowRunPropertiesResponse").add("RunProperties", this.hasRunProperties() ? this.runProperties() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RunProperties": {
                return Optional.ofNullable(clazz.cast(this.runProperties()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowRunPropertiesResponse, T> g) {
        return obj -> g.apply((GetWorkflowRunPropertiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private Map<String, String> runProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowRunPropertiesResponse model) {
            super(model);
            this.runProperties(model.runProperties);
        }

        public final Map<String, String> getRunProperties() {
            if (this.runProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.runProperties;
        }

        @Override
        public final Builder runProperties(Map<String, String> runProperties) {
            this.runProperties = WorkflowRunPropertiesCopier.copy(runProperties);
            return this;
        }

        public final void setRunProperties(Map<String, String> runProperties) {
            this.runProperties = WorkflowRunPropertiesCopier.copy(runProperties);
        }

        @Override
        public GetWorkflowRunPropertiesResponse build() {
            return new GetWorkflowRunPropertiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorkflowRunPropertiesResponse> {
        public Builder runProperties(Map<String, String> var1);
    }
}

