/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.SchemaVersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchemaVersionListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchemaVersionListItem> {
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaArn").getter(SchemaVersionListItem.getter(SchemaVersionListItem::schemaArn)).setter(SchemaVersionListItem.setter(Builder::schemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArn").build()}).build();
    private static final SdkField<String> SCHEMA_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaVersionId").getter(SchemaVersionListItem.getter(SchemaVersionListItem::schemaVersionId)).setter(SchemaVersionListItem.setter(Builder::schemaVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionId").build()}).build();
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VersionNumber").getter(SchemaVersionListItem.getter(SchemaVersionListItem::versionNumber)).setter(SchemaVersionListItem.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SchemaVersionListItem.getter(SchemaVersionListItem::statusAsString)).setter(SchemaVersionListItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedTime").getter(SchemaVersionListItem.getter(SchemaVersionListItem::createdTime)).setter(SchemaVersionListItem.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ARN_FIELD, SCHEMA_VERSION_ID_FIELD, VERSION_NUMBER_FIELD, STATUS_FIELD, CREATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String schemaArn;
    private final String schemaVersionId;
    private final Long versionNumber;
    private final String status;
    private final String createdTime;

    private SchemaVersionListItem(BuilderImpl builder) {
        this.schemaArn = builder.schemaArn;
        this.schemaVersionId = builder.schemaVersionId;
        this.versionNumber = builder.versionNumber;
        this.status = builder.status;
        this.createdTime = builder.createdTime;
    }

    public String schemaArn() {
        return this.schemaArn;
    }

    public String schemaVersionId() {
        return this.schemaVersionId;
    }

    public Long versionNumber() {
        return this.versionNumber;
    }

    public SchemaVersionStatus status() {
        return SchemaVersionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String createdTime() {
        return this.createdTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaVersionListItem)) {
            return false;
        }
        SchemaVersionListItem other = (SchemaVersionListItem)obj;
        return Objects.equals(this.schemaArn(), other.schemaArn()) && Objects.equals(this.schemaVersionId(), other.schemaVersionId()) && Objects.equals(this.versionNumber(), other.versionNumber()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdTime(), other.createdTime());
    }

    public String toString() {
        return ToString.builder((String)"SchemaVersionListItem").add("SchemaArn", (Object)this.schemaArn()).add("SchemaVersionId", (Object)this.schemaVersionId()).add("VersionNumber", (Object)this.versionNumber()).add("Status", (Object)this.statusAsString()).add("CreatedTime", (Object)this.createdTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaArn": {
                return Optional.ofNullable(clazz.cast(this.schemaArn()));
            }
            case "SchemaVersionId": {
                return Optional.ofNullable(clazz.cast(this.schemaVersionId()));
            }
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaVersionListItem, T> g) {
        return obj -> g.apply((SchemaVersionListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String schemaArn;
        private String schemaVersionId;
        private Long versionNumber;
        private String status;
        private String createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaVersionListItem model) {
            this.schemaArn(model.schemaArn);
            this.schemaVersionId(model.schemaVersionId);
            this.versionNumber(model.versionNumber);
            this.status(model.status);
            this.createdTime(model.createdTime);
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final String getSchemaVersionId() {
            return this.schemaVersionId;
        }

        @Override
        public final Builder schemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
            return this;
        }

        public final void setSchemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SchemaVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public SchemaVersionListItem build() {
            return new SchemaVersionListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchemaVersionListItem> {
        public Builder schemaArn(String var1);

        public Builder schemaVersionId(String var1);

        public Builder versionNumber(Long var1);

        public Builder status(String var1);

        public Builder status(SchemaVersionStatus var1);

        public Builder createdTime(String var1);
    }
}

