/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeletePartitionResponse extends GlueResponse implements
        ToCopyableBuilder<BatchDeletePartitionResponse.Builder, BatchDeletePartitionResponse> {
    private static final SdkField<List<PartitionError>> ERRORS_FIELD = SdkField
            .<List<PartitionError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BatchDeletePartitionResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PartitionError> builder(MarshallingType.SDK_POJO)
                                            .constructor(PartitionError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD));

    private final List<PartitionError> errors;

    private BatchDeletePartitionResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The errors encountered when trying to delete the requested partitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The errors encountered when trying to delete the requested partitions.
     */
    public final List<PartitionError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeletePartitionResponse)) {
            return false;
        }
        BatchDeletePartitionResponse other = (BatchDeletePartitionResponse) obj;
        return hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeletePartitionResponse").add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeletePartitionResponse, T> g) {
        return obj -> g.apply((BatchDeletePartitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchDeletePartitionResponse> {
        /**
         * <p>
         * The errors encountered when trying to delete the requested partitions.
         * </p>
         * 
         * @param errors
         *        The errors encountered when trying to delete the requested partitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<PartitionError> errors);

        /**
         * <p>
         * The errors encountered when trying to delete the requested partitions.
         * </p>
         * 
         * @param errors
         *        The errors encountered when trying to delete the requested partitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(PartitionError... errors);

        /**
         * <p>
         * The errors encountered when trying to delete the requested partitions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PartitionError>.Builder} avoiding the need
         * to create one manually via {@link List<PartitionError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PartitionError>.Builder#build()} is called immediately and
         * its result is passed to {@link #errors(List<PartitionError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<PartitionError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<PartitionError>)
         */
        Builder errors(Consumer<PartitionError.Builder>... errors);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<PartitionError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeletePartitionResponse model) {
            super(model);
            errors(model.errors);
        }

        public final List<PartitionError.Builder> getErrors() {
            List<PartitionError.Builder> result = PartitionErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder errors(Collection<PartitionError> errors) {
            this.errors = PartitionErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(PartitionError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<PartitionError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> PartitionError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<PartitionError.BuilderImpl> errors) {
            this.errors = PartitionErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchDeletePartitionResponse build() {
            return new BatchDeletePartitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
