/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCrawlerRequest extends GlueRequest implements
        ToCopyableBuilder<CreateCrawlerRequest.Builder, CreateCrawlerRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateCrawlerRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(CreateCrawlerRequest::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(CreateCrawlerRequest::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateCrawlerRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<CrawlerTargets> TARGETS_FIELD = SdkField.<CrawlerTargets> builder(MarshallingType.SDK_POJO)
            .memberName("Targets").getter(getter(CreateCrawlerRequest::targets)).setter(setter(Builder::targets))
            .constructor(CrawlerTargets::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build()).build();

    private static final SdkField<String> SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Schedule").getter(getter(CreateCrawlerRequest::schedule)).setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<List<String>> CLASSIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Classifiers")
            .getter(getter(CreateCrawlerRequest::classifiers))
            .setter(setter(Builder::classifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TABLE_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TablePrefix").getter(getter(CreateCrawlerRequest::tablePrefix)).setter(setter(Builder::tablePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablePrefix").build()).build();

    private static final SdkField<SchemaChangePolicy> SCHEMA_CHANGE_POLICY_FIELD = SdkField
            .<SchemaChangePolicy> builder(MarshallingType.SDK_POJO).memberName("SchemaChangePolicy")
            .getter(getter(CreateCrawlerRequest::schemaChangePolicy)).setter(setter(Builder::schemaChangePolicy))
            .constructor(SchemaChangePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaChangePolicy").build())
            .build();

    private static final SdkField<RecrawlPolicy> RECRAWL_POLICY_FIELD = SdkField
            .<RecrawlPolicy> builder(MarshallingType.SDK_POJO).memberName("RecrawlPolicy")
            .getter(getter(CreateCrawlerRequest::recrawlPolicy)).setter(setter(Builder::recrawlPolicy))
            .constructor(RecrawlPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecrawlPolicy").build()).build();

    private static final SdkField<LineageConfiguration> LINEAGE_CONFIGURATION_FIELD = SdkField
            .<LineageConfiguration> builder(MarshallingType.SDK_POJO).memberName("LineageConfiguration")
            .getter(getter(CreateCrawlerRequest::lineageConfiguration)).setter(setter(Builder::lineageConfiguration))
            .constructor(LineageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineageConfiguration").build())
            .build();

    private static final SdkField<String> CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Configuration").getter(getter(CreateCrawlerRequest::configuration))
            .setter(setter(Builder::configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<String> CRAWLER_SECURITY_CONFIGURATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CrawlerSecurityConfiguration")
            .getter(getter(CreateCrawlerRequest::crawlerSecurityConfiguration))
            .setter(setter(Builder::crawlerSecurityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerSecurityConfiguration")
                    .build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateCrawlerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ROLE_FIELD,
            DATABASE_NAME_FIELD, DESCRIPTION_FIELD, TARGETS_FIELD, SCHEDULE_FIELD, CLASSIFIERS_FIELD, TABLE_PREFIX_FIELD,
            SCHEMA_CHANGE_POLICY_FIELD, RECRAWL_POLICY_FIELD, LINEAGE_CONFIGURATION_FIELD, CONFIGURATION_FIELD,
            CRAWLER_SECURITY_CONFIGURATION_FIELD, TAGS_FIELD));

    private final String name;

    private final String role;

    private final String databaseName;

    private final String description;

    private final CrawlerTargets targets;

    private final String schedule;

    private final List<String> classifiers;

    private final String tablePrefix;

    private final SchemaChangePolicy schemaChangePolicy;

    private final RecrawlPolicy recrawlPolicy;

    private final LineageConfiguration lineageConfiguration;

    private final String configuration;

    private final String crawlerSecurityConfiguration;

    private final Map<String, String> tags;

    private CreateCrawlerRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.role = builder.role;
        this.databaseName = builder.databaseName;
        this.description = builder.description;
        this.targets = builder.targets;
        this.schedule = builder.schedule;
        this.classifiers = builder.classifiers;
        this.tablePrefix = builder.tablePrefix;
        this.schemaChangePolicy = builder.schemaChangePolicy;
        this.recrawlPolicy = builder.recrawlPolicy;
        this.lineageConfiguration = builder.lineageConfiguration;
        this.configuration = builder.configuration;
        this.crawlerSecurityConfiguration = builder.crawlerSecurityConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Name of the new crawler.
     * </p>
     * 
     * @return Name of the new crawler.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The IAM role or Amazon Resource Name (ARN) of an IAM role used by the new crawler to access customer resources.
     * </p>
     * 
     * @return The IAM role or Amazon Resource Name (ARN) of an IAM role used by the new crawler to access customer
     *         resources.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * The AWS Glue database where results are written, such as:
     * <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.
     * </p>
     * 
     * @return The AWS Glue database where results are written, such as:
     *         <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * A description of the new crawler.
     * </p>
     * 
     * @return A description of the new crawler.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A list of collection of targets to crawl.
     * </p>
     * 
     * @return A list of collection of targets to crawl.
     */
    public final CrawlerTargets targets() {
        return targets;
    }

    /**
     * <p>
     * A <code>cron</code> expression used to specify the schedule (see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for
     * Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would specify:
     * <code>cron(15 12 * * ? *)</code>.
     * </p>
     * 
     * @return A <code>cron</code> expression used to specify the schedule (see <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based
     *         Schedules for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would
     *         specify: <code>cron(15 12 * * ? *)</code>.
     */
    public final String schedule() {
        return schedule;
    }

    /**
     * Returns true if the Classifiers property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasClassifiers() {
        return classifiers != null && !(classifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of custom classifiers that the user has registered. By default, all built-in classifiers are included in a
     * crawl, but these custom classifiers always override the default classifiers for a given classification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasClassifiers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of custom classifiers that the user has registered. By default, all built-in classifiers are
     *         included in a crawl, but these custom classifiers always override the default classifiers for a given
     *         classification.
     */
    public final List<String> classifiers() {
        return classifiers;
    }

    /**
     * <p>
     * The table prefix used for catalog tables that are created.
     * </p>
     * 
     * @return The table prefix used for catalog tables that are created.
     */
    public final String tablePrefix() {
        return tablePrefix;
    }

    /**
     * <p>
     * The policy for the crawler's update and deletion behavior.
     * </p>
     * 
     * @return The policy for the crawler's update and deletion behavior.
     */
    public final SchemaChangePolicy schemaChangePolicy() {
        return schemaChangePolicy;
    }

    /**
     * <p>
     * A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since
     * the last crawler run.
     * </p>
     * 
     * @return A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were
     *         added since the last crawler run.
     */
    public final RecrawlPolicy recrawlPolicy() {
        return recrawlPolicy;
    }

    /**
     * <p>
     * Specifies data lineage configuration settings for the crawler.
     * </p>
     * 
     * @return Specifies data lineage configuration settings for the crawler.
     */
    public final LineageConfiguration lineageConfiguration() {
        return lineageConfiguration;
    }

    /**
     * <p>
     * Crawler configuration information. This versioned JSON string allows users to specify aspects of a crawler's
     * behavior. For more information, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html">Configuring a Crawler</a>.
     * </p>
     * 
     * @return Crawler configuration information. This versioned JSON string allows users to specify aspects of a
     *         crawler's behavior. For more information, see <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html">Configuring a Crawler</a>.
     */
    public final String configuration() {
        return configuration;
    }

    /**
     * <p>
     * The name of the <code>SecurityConfiguration</code> structure to be used by this crawler.
     * </p>
     * 
     * @return The name of the <code>SecurityConfiguration</code> structure to be used by this crawler.
     */
    public final String crawlerSecurityConfiguration() {
        return crawlerSecurityConfiguration;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to use with this crawler request. You may use tags to limit access to the crawler. For more information
     * about tags in AWS Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in
     * AWS Glue</a> in the developer guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to use with this crawler request. You may use tags to limit access to the crawler. For more
     *         information about tags in AWS Glue, see <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a> in the
     *         developer guide.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(targets());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(hasClassifiers() ? classifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tablePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(schemaChangePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(recrawlPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(lineageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(crawlerSecurityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCrawlerRequest)) {
            return false;
        }
        CreateCrawlerRequest other = (CreateCrawlerRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(role(), other.role())
                && Objects.equals(databaseName(), other.databaseName()) && Objects.equals(description(), other.description())
                && Objects.equals(targets(), other.targets()) && Objects.equals(schedule(), other.schedule())
                && hasClassifiers() == other.hasClassifiers() && Objects.equals(classifiers(), other.classifiers())
                && Objects.equals(tablePrefix(), other.tablePrefix())
                && Objects.equals(schemaChangePolicy(), other.schemaChangePolicy())
                && Objects.equals(recrawlPolicy(), other.recrawlPolicy())
                && Objects.equals(lineageConfiguration(), other.lineageConfiguration())
                && Objects.equals(configuration(), other.configuration())
                && Objects.equals(crawlerSecurityConfiguration(), other.crawlerSecurityConfiguration())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCrawlerRequest").add("Name", name()).add("Role", role())
                .add("DatabaseName", databaseName()).add("Description", description()).add("Targets", targets())
                .add("Schedule", schedule()).add("Classifiers", hasClassifiers() ? classifiers() : null)
                .add("TablePrefix", tablePrefix()).add("SchemaChangePolicy", schemaChangePolicy())
                .add("RecrawlPolicy", recrawlPolicy()).add("LineageConfiguration", lineageConfiguration())
                .add("Configuration", configuration()).add("CrawlerSecurityConfiguration", crawlerSecurityConfiguration())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "Classifiers":
            return Optional.ofNullable(clazz.cast(classifiers()));
        case "TablePrefix":
            return Optional.ofNullable(clazz.cast(tablePrefix()));
        case "SchemaChangePolicy":
            return Optional.ofNullable(clazz.cast(schemaChangePolicy()));
        case "RecrawlPolicy":
            return Optional.ofNullable(clazz.cast(recrawlPolicy()));
        case "LineageConfiguration":
            return Optional.ofNullable(clazz.cast(lineageConfiguration()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "CrawlerSecurityConfiguration":
            return Optional.ofNullable(clazz.cast(crawlerSecurityConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCrawlerRequest, T> g) {
        return obj -> g.apply((CreateCrawlerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCrawlerRequest> {
        /**
         * <p>
         * Name of the new crawler.
         * </p>
         * 
         * @param name
         *        Name of the new crawler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The IAM role or Amazon Resource Name (ARN) of an IAM role used by the new crawler to access customer
         * resources.
         * </p>
         * 
         * @param role
         *        The IAM role or Amazon Resource Name (ARN) of an IAM role used by the new crawler to access customer
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * The AWS Glue database where results are written, such as:
         * <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.
         * </p>
         * 
         * @param databaseName
         *        The AWS Glue database where results are written, such as:
         *        <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * A description of the new crawler.
         * </p>
         * 
         * @param description
         *        A description of the new crawler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of collection of targets to crawl.
         * </p>
         * 
         * @param targets
         *        A list of collection of targets to crawl.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(CrawlerTargets targets);

        /**
         * <p>
         * A list of collection of targets to crawl.
         * </p>
         * This is a convenience that creates an instance of the {@link CrawlerTargets.Builder} avoiding the need to
         * create one manually via {@link CrawlerTargets#builder()}.
         *
         * When the {@link Consumer} completes, {@link CrawlerTargets.Builder#build()} is called immediately and its
         * result is passed to {@link #targets(CrawlerTargets)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link CrawlerTargets.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(CrawlerTargets)
         */
        default Builder targets(Consumer<CrawlerTargets.Builder> targets) {
            return targets(CrawlerTargets.builder().applyMutation(targets).build());
        }

        /**
         * <p>
         * A <code>cron</code> expression used to specify the schedule (see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules
         * for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would specify:
         * <code>cron(15 12 * * ? *)</code>.
         * </p>
         * 
         * @param schedule
         *        A <code>cron</code> expression used to specify the schedule (see <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based
         *        Schedules for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would
         *        specify: <code>cron(15 12 * * ? *)</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * A list of custom classifiers that the user has registered. By default, all built-in classifiers are included
         * in a crawl, but these custom classifiers always override the default classifiers for a given classification.
         * </p>
         * 
         * @param classifiers
         *        A list of custom classifiers that the user has registered. By default, all built-in classifiers are
         *        included in a crawl, but these custom classifiers always override the default classifiers for a given
         *        classification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classifiers(Collection<String> classifiers);

        /**
         * <p>
         * A list of custom classifiers that the user has registered. By default, all built-in classifiers are included
         * in a crawl, but these custom classifiers always override the default classifiers for a given classification.
         * </p>
         * 
         * @param classifiers
         *        A list of custom classifiers that the user has registered. By default, all built-in classifiers are
         *        included in a crawl, but these custom classifiers always override the default classifiers for a given
         *        classification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classifiers(String... classifiers);

        /**
         * <p>
         * The table prefix used for catalog tables that are created.
         * </p>
         * 
         * @param tablePrefix
         *        The table prefix used for catalog tables that are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablePrefix(String tablePrefix);

        /**
         * <p>
         * The policy for the crawler's update and deletion behavior.
         * </p>
         * 
         * @param schemaChangePolicy
         *        The policy for the crawler's update and deletion behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaChangePolicy(SchemaChangePolicy schemaChangePolicy);

        /**
         * <p>
         * The policy for the crawler's update and deletion behavior.
         * </p>
         * This is a convenience that creates an instance of the {@link SchemaChangePolicy.Builder} avoiding the need to
         * create one manually via {@link SchemaChangePolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link SchemaChangePolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #schemaChangePolicy(SchemaChangePolicy)}.
         * 
         * @param schemaChangePolicy
         *        a consumer that will call methods on {@link SchemaChangePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaChangePolicy(SchemaChangePolicy)
         */
        default Builder schemaChangePolicy(Consumer<SchemaChangePolicy.Builder> schemaChangePolicy) {
            return schemaChangePolicy(SchemaChangePolicy.builder().applyMutation(schemaChangePolicy).build());
        }

        /**
         * <p>
         * A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added
         * since the last crawler run.
         * </p>
         * 
         * @param recrawlPolicy
         *        A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were
         *        added since the last crawler run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recrawlPolicy(RecrawlPolicy recrawlPolicy);

        /**
         * <p>
         * A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added
         * since the last crawler run.
         * </p>
         * This is a convenience that creates an instance of the {@link RecrawlPolicy.Builder} avoiding the need to
         * create one manually via {@link RecrawlPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecrawlPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #recrawlPolicy(RecrawlPolicy)}.
         * 
         * @param recrawlPolicy
         *        a consumer that will call methods on {@link RecrawlPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recrawlPolicy(RecrawlPolicy)
         */
        default Builder recrawlPolicy(Consumer<RecrawlPolicy.Builder> recrawlPolicy) {
            return recrawlPolicy(RecrawlPolicy.builder().applyMutation(recrawlPolicy).build());
        }

        /**
         * <p>
         * Specifies data lineage configuration settings for the crawler.
         * </p>
         * 
         * @param lineageConfiguration
         *        Specifies data lineage configuration settings for the crawler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineageConfiguration(LineageConfiguration lineageConfiguration);

        /**
         * <p>
         * Specifies data lineage configuration settings for the crawler.
         * </p>
         * This is a convenience that creates an instance of the {@link LineageConfiguration.Builder} avoiding the need
         * to create one manually via {@link LineageConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link LineageConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #lineageConfiguration(LineageConfiguration)}.
         * 
         * @param lineageConfiguration
         *        a consumer that will call methods on {@link LineageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineageConfiguration(LineageConfiguration)
         */
        default Builder lineageConfiguration(Consumer<LineageConfiguration.Builder> lineageConfiguration) {
            return lineageConfiguration(LineageConfiguration.builder().applyMutation(lineageConfiguration).build());
        }

        /**
         * <p>
         * Crawler configuration information. This versioned JSON string allows users to specify aspects of a crawler's
         * behavior. For more information, see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html">Configuring a Crawler</a>.
         * </p>
         * 
         * @param configuration
         *        Crawler configuration information. This versioned JSON string allows users to specify aspects of a
         *        crawler's behavior. For more information, see <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html">Configuring a
         *        Crawler</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(String configuration);

        /**
         * <p>
         * The name of the <code>SecurityConfiguration</code> structure to be used by this crawler.
         * </p>
         * 
         * @param crawlerSecurityConfiguration
         *        The name of the <code>SecurityConfiguration</code> structure to be used by this crawler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlerSecurityConfiguration(String crawlerSecurityConfiguration);

        /**
         * <p>
         * The tags to use with this crawler request. You may use tags to limit access to the crawler. For more
         * information about tags in AWS Glue, see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a> in the developer
         * guide.
         * </p>
         * 
         * @param tags
         *        The tags to use with this crawler request. You may use tags to limit access to the crawler. For more
         *        information about tags in AWS Glue, see <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a> in the
         *        developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String name;

        private String role;

        private String databaseName;

        private String description;

        private CrawlerTargets targets;

        private String schedule;

        private List<String> classifiers = DefaultSdkAutoConstructList.getInstance();

        private String tablePrefix;

        private SchemaChangePolicy schemaChangePolicy;

        private RecrawlPolicy recrawlPolicy;

        private LineageConfiguration lineageConfiguration;

        private String configuration;

        private String crawlerSecurityConfiguration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCrawlerRequest model) {
            super(model);
            name(model.name);
            role(model.role);
            databaseName(model.databaseName);
            description(model.description);
            targets(model.targets);
            schedule(model.schedule);
            classifiers(model.classifiers);
            tablePrefix(model.tablePrefix);
            schemaChangePolicy(model.schemaChangePolicy);
            recrawlPolicy(model.recrawlPolicy);
            lineageConfiguration(model.lineageConfiguration);
            configuration(model.configuration);
            crawlerSecurityConfiguration(model.crawlerSecurityConfiguration);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final CrawlerTargets.Builder getTargets() {
            return targets != null ? targets.toBuilder() : null;
        }

        @Override
        public final Builder targets(CrawlerTargets targets) {
            this.targets = targets;
            return this;
        }

        public final void setTargets(CrawlerTargets.BuilderImpl targets) {
            this.targets = targets != null ? targets.build() : null;
        }

        public final String getSchedule() {
            return schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public final Collection<String> getClassifiers() {
            if (classifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return classifiers;
        }

        @Override
        public final Builder classifiers(Collection<String> classifiers) {
            this.classifiers = ClassifierNameListCopier.copy(classifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classifiers(String... classifiers) {
            classifiers(Arrays.asList(classifiers));
            return this;
        }

        public final void setClassifiers(Collection<String> classifiers) {
            this.classifiers = ClassifierNameListCopier.copy(classifiers);
        }

        public final String getTablePrefix() {
            return tablePrefix;
        }

        @Override
        public final Builder tablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
            return this;
        }

        public final void setTablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
        }

        public final SchemaChangePolicy.Builder getSchemaChangePolicy() {
            return schemaChangePolicy != null ? schemaChangePolicy.toBuilder() : null;
        }

        @Override
        public final Builder schemaChangePolicy(SchemaChangePolicy schemaChangePolicy) {
            this.schemaChangePolicy = schemaChangePolicy;
            return this;
        }

        public final void setSchemaChangePolicy(SchemaChangePolicy.BuilderImpl schemaChangePolicy) {
            this.schemaChangePolicy = schemaChangePolicy != null ? schemaChangePolicy.build() : null;
        }

        public final RecrawlPolicy.Builder getRecrawlPolicy() {
            return recrawlPolicy != null ? recrawlPolicy.toBuilder() : null;
        }

        @Override
        public final Builder recrawlPolicy(RecrawlPolicy recrawlPolicy) {
            this.recrawlPolicy = recrawlPolicy;
            return this;
        }

        public final void setRecrawlPolicy(RecrawlPolicy.BuilderImpl recrawlPolicy) {
            this.recrawlPolicy = recrawlPolicy != null ? recrawlPolicy.build() : null;
        }

        public final LineageConfiguration.Builder getLineageConfiguration() {
            return lineageConfiguration != null ? lineageConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder lineageConfiguration(LineageConfiguration lineageConfiguration) {
            this.lineageConfiguration = lineageConfiguration;
            return this;
        }

        public final void setLineageConfiguration(LineageConfiguration.BuilderImpl lineageConfiguration) {
            this.lineageConfiguration = lineageConfiguration != null ? lineageConfiguration.build() : null;
        }

        public final String getConfiguration() {
            return configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        public final String getCrawlerSecurityConfiguration() {
            return crawlerSecurityConfiguration;
        }

        @Override
        public final Builder crawlerSecurityConfiguration(String crawlerSecurityConfiguration) {
            this.crawlerSecurityConfiguration = crawlerSecurityConfiguration;
            return this;
        }

        public final void setCrawlerSecurityConfiguration(String crawlerSecurityConfiguration) {
            this.crawlerSecurityConfiguration = crawlerSecurityConfiguration;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCrawlerRequest build() {
            return new CreateCrawlerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
