/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an XML classifier for <code>CreateClassifier</code> to create.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateXMLClassifierRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateXMLClassifierRequest.Builder, CreateXMLClassifierRequest> {
    private static final SdkField<String> CLASSIFICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Classification").getter(getter(CreateXMLClassifierRequest::classification))
            .setter(setter(Builder::classification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classification").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateXMLClassifierRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ROW_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RowTag")
            .getter(getter(CreateXMLClassifierRequest::rowTag)).setter(setter(Builder::rowTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowTag").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLASSIFICATION_FIELD,
            NAME_FIELD, ROW_TAG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String classification;

    private final String name;

    private final String rowTag;

    private CreateXMLClassifierRequest(BuilderImpl builder) {
        this.classification = builder.classification;
        this.name = builder.name;
        this.rowTag = builder.rowTag;
    }

    /**
     * <p>
     * An identifier of the data format that the classifier matches.
     * </p>
     * 
     * @return An identifier of the data format that the classifier matches.
     */
    public final String classification() {
        return classification;
    }

    /**
     * <p>
     * The name of the classifier.
     * </p>
     * 
     * @return The name of the classifier.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The XML tag designating the element that contains each record in an XML document being parsed. This can't
     * identify a self-closing element (closed by <code>/&gt;</code>). An empty row element that contains only
     * attributes can be parsed as long as it ends with a closing tag (for example,
     * <code>&lt;row item_a="A" item_b="B"&gt;&lt;/row&gt;</code> is okay, but
     * <code>&lt;row item_a="A" item_b="B" /&gt;</code> is not).
     * </p>
     * 
     * @return The XML tag designating the element that contains each record in an XML document being parsed. This can't
     *         identify a self-closing element (closed by <code>/&gt;</code>). An empty row element that contains only
     *         attributes can be parsed as long as it ends with a closing tag (for example,
     *         <code>&lt;row item_a="A" item_b="B"&gt;&lt;/row&gt;</code> is okay, but
     *         <code>&lt;row item_a="A" item_b="B" /&gt;</code> is not).
     */
    public final String rowTag() {
        return rowTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(classification());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(rowTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateXMLClassifierRequest)) {
            return false;
        }
        CreateXMLClassifierRequest other = (CreateXMLClassifierRequest) obj;
        return Objects.equals(classification(), other.classification()) && Objects.equals(name(), other.name())
                && Objects.equals(rowTag(), other.rowTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateXMLClassifierRequest").add("Classification", classification()).add("Name", name())
                .add("RowTag", rowTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Classification":
            return Optional.ofNullable(clazz.cast(classification()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RowTag":
            return Optional.ofNullable(clazz.cast(rowTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateXMLClassifierRequest, T> g) {
        return obj -> g.apply((CreateXMLClassifierRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateXMLClassifierRequest> {
        /**
         * <p>
         * An identifier of the data format that the classifier matches.
         * </p>
         * 
         * @param classification
         *        An identifier of the data format that the classifier matches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classification(String classification);

        /**
         * <p>
         * The name of the classifier.
         * </p>
         * 
         * @param name
         *        The name of the classifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The XML tag designating the element that contains each record in an XML document being parsed. This can't
         * identify a self-closing element (closed by <code>/&gt;</code>). An empty row element that contains only
         * attributes can be parsed as long as it ends with a closing tag (for example,
         * <code>&lt;row item_a="A" item_b="B"&gt;&lt;/row&gt;</code> is okay, but
         * <code>&lt;row item_a="A" item_b="B" /&gt;</code> is not).
         * </p>
         * 
         * @param rowTag
         *        The XML tag designating the element that contains each record in an XML document being parsed. This
         *        can't identify a self-closing element (closed by <code>/&gt;</code>). An empty row element that
         *        contains only attributes can be parsed as long as it ends with a closing tag (for example,
         *        <code>&lt;row item_a="A" item_b="B"&gt;&lt;/row&gt;</code> is okay, but
         *        <code>&lt;row item_a="A" item_b="B" /&gt;</code> is not).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowTag(String rowTag);
    }

    static final class BuilderImpl implements Builder {
        private String classification;

        private String name;

        private String rowTag;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateXMLClassifierRequest model) {
            classification(model.classification);
            name(model.name);
            rowTag(model.rowTag);
        }

        public final String getClassification() {
            return classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRowTag() {
            return rowTag;
        }

        @Override
        public final Builder rowTag(String rowTag) {
            this.rowTag = rowTag;
            return this;
        }

        public final void setRowTag(String rowTag) {
            this.rowTag = rowTag;
        }

        @Override
        public CreateXMLClassifierRequest build() {
            return new CreateXMLClassifierRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
