/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a numeric value in decimal format.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DecimalNumber implements SdkPojo, Serializable, ToCopyableBuilder<DecimalNumber.Builder, DecimalNumber> {
    private static final SdkField<SdkBytes> UNSCALED_VALUE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("UnscaledValue").getter(getter(DecimalNumber::unscaledValue)).setter(setter(Builder::unscaledValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnscaledValue").build()).build();

    private static final SdkField<Integer> SCALE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Scale")
            .getter(getter(DecimalNumber::scale)).setter(setter(Builder::scale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scale").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNSCALED_VALUE_FIELD,
            SCALE_FIELD));

    private static final long serialVersionUID = 1L;

    private final SdkBytes unscaledValue;

    private final Integer scale;

    private DecimalNumber(BuilderImpl builder) {
        this.unscaledValue = builder.unscaledValue;
        this.scale = builder.scale;
    }

    /**
     * <p>
     * The unscaled numeric value.
     * </p>
     * 
     * @return The unscaled numeric value.
     */
    public final SdkBytes unscaledValue() {
        return unscaledValue;
    }

    /**
     * <p>
     * The scale that determines where the decimal point falls in the unscaled value.
     * </p>
     * 
     * @return The scale that determines where the decimal point falls in the unscaled value.
     */
    public final Integer scale() {
        return scale;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unscaledValue());
        hashCode = 31 * hashCode + Objects.hashCode(scale());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecimalNumber)) {
            return false;
        }
        DecimalNumber other = (DecimalNumber) obj;
        return Objects.equals(unscaledValue(), other.unscaledValue()) && Objects.equals(scale(), other.scale());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DecimalNumber").add("UnscaledValue", unscaledValue()).add("Scale", scale()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UnscaledValue":
            return Optional.ofNullable(clazz.cast(unscaledValue()));
        case "Scale":
            return Optional.ofNullable(clazz.cast(scale()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DecimalNumber, T> g) {
        return obj -> g.apply((DecimalNumber) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DecimalNumber> {
        /**
         * <p>
         * The unscaled numeric value.
         * </p>
         * 
         * @param unscaledValue
         *        The unscaled numeric value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unscaledValue(SdkBytes unscaledValue);

        /**
         * <p>
         * The scale that determines where the decimal point falls in the unscaled value.
         * </p>
         * 
         * @param scale
         *        The scale that determines where the decimal point falls in the unscaled value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scale(Integer scale);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes unscaledValue;

        private Integer scale;

        private BuilderImpl() {
        }

        private BuilderImpl(DecimalNumber model) {
            unscaledValue(model.unscaledValue);
            scale(model.scale);
        }

        public final ByteBuffer getUnscaledValue() {
            return unscaledValue == null ? null : unscaledValue.asByteBuffer();
        }

        @Override
        public final Builder unscaledValue(SdkBytes unscaledValue) {
            this.unscaledValue = unscaledValue;
            return this;
        }

        public final void setUnscaledValue(ByteBuffer unscaledValue) {
            unscaledValue(unscaledValue == null ? null : SdkBytes.fromByteBuffer(unscaledValue));
        }

        public final Integer getScale() {
            return scale;
        }

        @Override
        public final Builder scale(Integer scale) {
            this.scale = scale;
            return this;
        }

        public final void setScale(Integer scale) {
            this.scale = scale;
        }

        @Override
        public DecimalNumber build() {
            return new DecimalNumber(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
