/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Evaluation metrics provide an estimate of the quality of your machine learning transform.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationMetrics.Builder, EvaluationMetrics> {
    private static final SdkField<String> TRANSFORM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransformType").getter(getter(EvaluationMetrics::transformTypeAsString))
            .setter(setter(Builder::transformType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformType").build()).build();

    private static final SdkField<FindMatchesMetrics> FIND_MATCHES_METRICS_FIELD = SdkField
            .<FindMatchesMetrics> builder(MarshallingType.SDK_POJO).memberName("FindMatchesMetrics")
            .getter(getter(EvaluationMetrics::findMatchesMetrics)).setter(setter(Builder::findMatchesMetrics))
            .constructor(FindMatchesMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindMatchesMetrics").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_TYPE_FIELD,
            FIND_MATCHES_METRICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transformType;

    private final FindMatchesMetrics findMatchesMetrics;

    private EvaluationMetrics(BuilderImpl builder) {
        this.transformType = builder.transformType;
        this.findMatchesMetrics = builder.findMatchesMetrics;
    }

    /**
     * <p>
     * The type of machine learning transform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transformType}
     * will return {@link TransformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #transformTypeAsString}.
     * </p>
     * 
     * @return The type of machine learning transform.
     * @see TransformType
     */
    public final TransformType transformType() {
        return TransformType.fromValue(transformType);
    }

    /**
     * <p>
     * The type of machine learning transform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transformType}
     * will return {@link TransformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #transformTypeAsString}.
     * </p>
     * 
     * @return The type of machine learning transform.
     * @see TransformType
     */
    public final String transformTypeAsString() {
        return transformType;
    }

    /**
     * <p>
     * The evaluation metrics for the find matches algorithm.
     * </p>
     * 
     * @return The evaluation metrics for the find matches algorithm.
     */
    public final FindMatchesMetrics findMatchesMetrics() {
        return findMatchesMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transformTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(findMatchesMetrics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationMetrics)) {
            return false;
        }
        EvaluationMetrics other = (EvaluationMetrics) obj;
        return Objects.equals(transformTypeAsString(), other.transformTypeAsString())
                && Objects.equals(findMatchesMetrics(), other.findMatchesMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationMetrics").add("TransformType", transformTypeAsString())
                .add("FindMatchesMetrics", findMatchesMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransformType":
            return Optional.ofNullable(clazz.cast(transformTypeAsString()));
        case "FindMatchesMetrics":
            return Optional.ofNullable(clazz.cast(findMatchesMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationMetrics, T> g) {
        return obj -> g.apply((EvaluationMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationMetrics> {
        /**
         * <p>
         * The type of machine learning transform.
         * </p>
         * 
         * @param transformType
         *        The type of machine learning transform.
         * @see TransformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformType
         */
        Builder transformType(String transformType);

        /**
         * <p>
         * The type of machine learning transform.
         * </p>
         * 
         * @param transformType
         *        The type of machine learning transform.
         * @see TransformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformType
         */
        Builder transformType(TransformType transformType);

        /**
         * <p>
         * The evaluation metrics for the find matches algorithm.
         * </p>
         * 
         * @param findMatchesMetrics
         *        The evaluation metrics for the find matches algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findMatchesMetrics(FindMatchesMetrics findMatchesMetrics);

        /**
         * <p>
         * The evaluation metrics for the find matches algorithm.
         * </p>
         * This is a convenience that creates an instance of the {@link FindMatchesMetrics.Builder} avoiding the need to
         * create one manually via {@link FindMatchesMetrics#builder()}.
         *
         * When the {@link Consumer} completes, {@link FindMatchesMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #findMatchesMetrics(FindMatchesMetrics)}.
         * 
         * @param findMatchesMetrics
         *        a consumer that will call methods on {@link FindMatchesMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findMatchesMetrics(FindMatchesMetrics)
         */
        default Builder findMatchesMetrics(Consumer<FindMatchesMetrics.Builder> findMatchesMetrics) {
            return findMatchesMetrics(FindMatchesMetrics.builder().applyMutation(findMatchesMetrics).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String transformType;

        private FindMatchesMetrics findMatchesMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationMetrics model) {
            transformType(model.transformType);
            findMatchesMetrics(model.findMatchesMetrics);
        }

        public final String getTransformType() {
            return transformType;
        }

        @Override
        public final Builder transformType(String transformType) {
            this.transformType = transformType;
            return this;
        }

        @Override
        public final Builder transformType(TransformType transformType) {
            this.transformType(transformType == null ? null : transformType.toString());
            return this;
        }

        public final void setTransformType(String transformType) {
            this.transformType = transformType;
        }

        public final FindMatchesMetrics.Builder getFindMatchesMetrics() {
            return findMatchesMetrics != null ? findMatchesMetrics.toBuilder() : null;
        }

        @Override
        public final Builder findMatchesMetrics(FindMatchesMetrics findMatchesMetrics) {
            this.findMatchesMetrics = findMatchesMetrics;
            return this;
        }

        public final void setFindMatchesMetrics(FindMatchesMetrics.BuilderImpl findMatchesMetrics) {
            this.findMatchesMetrics = findMatchesMetrics != null ? findMatchesMetrics.build() : null;
        }

        @Override
        public EvaluationMetrics build() {
            return new EvaluationMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
